/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software; 
 * 
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpimageview.h"
#include "common_image.h"

extern CxpImageView *cxpimageview;

extern ImageCache image_cache;

static void filemenu_response ();
static void helpmenu_response ();

extern int readPathInfoFunc ();
extern int cxpimagehelpfunc_help ();

#define FILEIACT_CLOSE          0x0101
#define HELPIACT_HELP           0x0901

#define FILEMENU_BASE           "/ե"
#define FILEMENU_CLOSE          "/ե/λ"
#define HELPMENU_BASE           "/إ"
#define HELPMENU_HELP           "/إ/CxpimageˤĤ"

static GtkItemFactoryEntry menu_items[] = {
	{FILEMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{FILEMENU_CLOSE, "<control>Q", filemenu_response, FILEIACT_CLOSE,
	 NULL},
	{HELPMENU_BASE, NULL, NULL, 0, "<LastBranch>"},
	{HELPMENU_HELP, NULL, helpmenu_response, HELPIACT_HELP, NULL},
};

static char *imagetitle[1] = { "᡼ե"
};

static int cxpimagefilefunc_close ()
{
	gtk_widget_hide (cxpimageview->window);
	gtk_widget_destroy (cxpimageview->window);

	gtk_main_quit ();
}

static void filemenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case FILEIACT_CLOSE:
		cxpimagefilefunc_close ();
		break;
	}
}

static void helpmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case HELPIACT_HELP:
		cxpimagehelpfunc_help ();
		break;
	}
}

static void pathEntryCallback (GtkWidget * widget, GtkWidget * entry)
{
	readPathInfoFunc ();
}

static int listselection (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
	if (column < 0 || row < 0)
		return (0);

#ifdef	DEBUG8
	fprintf (stdout, "listselection row -> %d\n", row);
#endif

	cxpimageview->selectrow = row;

	cxpimage_imageview ();

	return (0);
}

static int listunselection (GtkWidget * clist, gint row, gint column,
			    GdkEventButton * event, gpointer data)
{
	if (column < 0 || row < 0)
		return (0);

#ifdef	DEBUG8
	fprintf (stdout, "listunselection row -> %d\n", row);
#endif

	cxpimageview->selectrow = -1;

	return (0);
}

cxpimage_start ()
{
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *label1;
	GtkWidget *hpaned;
	GtkWidget *hbox2;
	GtkWidget *vbox2;
	GtkWidget *swin;
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	int nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);


	cxpimageview->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (cxpimageview->window), "window",
			     cxpimageview->window);
	gtk_window_set_title (GTK_WINDOW (cxpimageview->window), "Cxpimage");
	gtk_widget_set_usize (cxpimageview->window, 100, 100);
	gtk_window_set_default_size (GTK_WINDOW (cxpimageview->window), 600,
				     400);
	gtk_signal_connect (GTK_OBJECT (cxpimageview->window), "destroy",
			    GTK_SIGNAL_FUNC (cxpimagefilefunc_close), NULL);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxpimageview->window), "vbox1",
				  vbox1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (cxpimageview->window), vbox1);

	accel_group = gtk_accel_group_new ();

	item_factory =
		gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				      accel_group);

	gtk_item_factory_create_items (item_factory, nmenu_items, menu_items,
				       NULL);

	gtk_accel_group_attach (accel_group,
				GTK_OBJECT (cxpimageview->window));

	cxpimageview->menubar =
		gtk_item_factory_get_widget (item_factory, "<main>");
	gtk_box_pack_start (GTK_BOX (vbox1), cxpimageview->menubar, FALSE,
			    FALSE, 0);
	gtk_widget_show (cxpimageview->menubar);


	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxpimageview->window), "hbox1",
				  hbox1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 3);

	label1 = gtk_label_new ("ǥ쥯ȥꡧ");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (cxpimageview->window), "label1",
				  label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 5);

	cxpimageview->pathEntry = gtk_entry_new ();
	gtk_widget_ref (cxpimageview->pathEntry);
	gtk_object_set_data_full (GTK_OBJECT (cxpimageview->window),
				  "pathEntry", cxpimageview->pathEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpimageview->pathEntry);
	gtk_box_pack_start (GTK_BOX (hbox1), cxpimageview->pathEntry, TRUE,
			    TRUE, 3);

	gtk_signal_connect (GTK_OBJECT (cxpimageview->pathEntry), "activate",
			    GTK_SIGNAL_FUNC (pathEntryCallback),
			    cxpimageview->pathEntry);

	cxpimageview->readBtn =
		gtk_button_new_with_label (" Υǥ쥯ȥ꤫鸡 ");
	gtk_widget_ref (cxpimageview->readBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpimageview->window),
				  "readBtn", cxpimageview->readBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpimageview->readBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), cxpimageview->readBtn, FALSE,
			    FALSE, 0);

	hpaned = gtk_hpaned_new ();
	gtk_widget_ref (hpaned);
	gtk_object_set_data_full (GTK_OBJECT (cxpimageview->window), "hpaned",
				  hpaned,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hpaned);
	gtk_box_pack_start (GTK_BOX (vbox1), hpaned, TRUE, TRUE, 0);
	gtk_paned_set_position (GTK_PANED (hpaned), 130);

	swin = gtk_scrolled_window_new (NULL, NULL);

	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_show (swin);

	cxpimageview->imageList = gtk_clist_new_with_titles (1, imagetitle);
	gtk_widget_set_usize (cxpimageview->imageList, 130, 150);
	gtk_clist_set_selection_mode (GTK_CLIST (cxpimageview->imageList),
				      GTK_SELECTION_BROWSE);

	gtk_signal_connect (GTK_OBJECT (cxpimageview->imageList),
			    "select_row", GTK_SIGNAL_FUNC (listselection),
			    NULL);
	gtk_signal_connect (GTK_OBJECT (cxpimageview->imageList),
			    "unselect_row", GTK_SIGNAL_FUNC (listunselection),
			    NULL);

	gtk_clist_column_title_passive (GTK_CLIST (cxpimageview->imageList),
					0);

	gtk_container_add (GTK_CONTAINER (swin), cxpimageview->imageList);
	gtk_widget_show (cxpimageview->imageList);

	gtk_paned_pack1 (GTK_PANED (hpaned), swin, FALSE, TRUE);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (cxpimageview->window), "hbox2",
				  hbox2, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_paned_pack2 (GTK_PANED (hpaned), hbox2, TRUE, TRUE);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (cxpimageview->window), "vbox2",
				  vbox2, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox2), vbox2, TRUE, TRUE, 0);

	cxpimageview->preview = gtk_preview_new (GTK_PREVIEW_COLOR);
	gtk_widget_ref (cxpimageview->preview);
	gtk_object_set_data_full (GTK_OBJECT (cxpimageview->window),
				  "preview", cxpimageview->preview,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpimageview->preview);
	gtk_preview_set_expand (GTK_PREVIEW (cxpimageview->preview), TRUE);
	gtk_box_pack_start (GTK_BOX (vbox2), cxpimageview->preview, TRUE,
			    TRUE, 0);

	/* ܥ󥤥٥ */
	gtk_signal_connect_object (GTK_OBJECT (cxpimageview->readBtn),
				   "clicked",
				   (GtkSignalFunc) readPathInfoFunc,
				   GTK_OBJECT (cxpimageview->window));

	gtk_widget_show (cxpimageview->window);
}
