/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "common_image.h"
#include "cxpimageview.h"

extern CxpImageView *cxpimageview;
extern ImageCache image_cache;

int cxpimage_imageview ()
{
	int imageType, imageWidth, imageHeight;
	gchar *d;
	char filename[1024];
	double nscale, nscale_w, nscale_h;
	int width, height;
	int preview_width, preview_height;

	if (cxpimageview->selectrow < 0)
	{
#ifdef	DEBUG8
		fprintf (stdout, "cxpimageview->selectrow -> %d\n",
			 cxpimageview->selectrow);
		fprintf (stdout, "return ...\n");
#endif
		return (0);
	}

	sprintf (filename, "%s/%s",
		 cxpimageview->path,
		 cxpimageview->image[cxpimageview->selectrow].name);

	/* ᡼פå */
	imageType = common_image_check (filename, &imageWidth, &imageHeight);
	if (imageType == CXP_IMAGE_NONE)
	{
#ifdef	DEBUG8
		fprintf (stdout, "imageType is NONE (%s)\n", filename);
		fprintf (stdout, "return ...\n");
#endif
		return (0);
	}

	gtk_preview_size (GTK_PREVIEW (cxpimageview->preview), imageWidth,
			  imageHeight);
	gtk_widget_queue_resize (cxpimageview->preview);

	if (image_cache.buffer != NULL)
		g_free (image_cache.buffer);

	image_cache.buffer = g_malloc (imageWidth * 3 * imageHeight);
	image_cache.buffer_width = imageWidth;
	image_cache.buffer_height = imageHeight;

	switch (imageType)
	{
	case CXP_IMAGE_GIF:
		d = gif_load (filename, cxpimageview->preview, imageWidth,
			      imageHeight);
		break;
	case CXP_IMAGE_JPEG:
		jpeg_load (filename, cxpimageview->preview, imageWidth,
			   imageHeight);
		break;
	case CXP_IMAGE_TIFF:
		tiff_load (filename, cxpimageview->preview, imageWidth,
			   imageHeight);
		break;
	case CXP_IMAGE_BMP:
		bmp_load (filename, cxpimageview->preview, imageWidth,
			  imageHeight);
		break;
	case CXP_IMAGE_PNG:
		png_load (filename, cxpimageview->preview, imageWidth,
			  imageHeight);
		break;
	case CXP_IMAGE_PSD:
		d = psd_load (filename, cxpimageview->preview, imageWidth,
			      imageHeight);
		break;
	default:
		break;
	}

	return (0);
}
