/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpimageview.h"

extern CxpImageView *cxpimageview;

#define	CXPIMG_SEARCH_START	0
#define	CXPIMG_SEARCH_STOP	1
static int searchStopFlag;

static int nextSearchDirectory (char *dirname, int *kensu)
{
	DIR *dfd;
	struct dirent *dp;
	struct stat fileinfo;
	char pathname[1024];
	char workbuff[1024];
	int i, w, h, type;
	int length;

    /*-- ǥ쥯ȥΥץ --*/
	if ((dfd = opendir (dirname)) == NULL)
	{
		return (-1);
	}

	for (i = 0; (dp = readdir (dfd)) != NULL; i++)
	{
		if (!strcmp (dp->d_name, ".") || !strcmp (dp->d_name, ".."))
			continue;

		if (strcmp (dirname, "/") == 0)
			sprintf (pathname, "%s%s", dirname, dp->d_name);
		else
			sprintf (pathname, "%s/%s", dirname, dp->d_name);
		stat (pathname, &fileinfo);

		if (!S_ISDIR (fileinfo.st_mode))
		{
			type = common_image_check (pathname, &w, &h);
			if (type == CXP_IMAGE_NONE)
				continue;

			length = strlen (cxpimageview->path);
			sprintf (workbuff, "%s", &pathname[length]);

			if ((*kensu) + 1 >= MAX_IMAGEVIEW_NUM)
				break;

			cxpimageview->image[(*kensu)].name =
				g_strdup (workbuff);
			(*kensu)++;
			cxpimageview->image_kensu = (*kensu);

			/* 鹹 */
			cxpimage_filelistview_append ((*kensu) - 1);

			/* ٥Ƚ */
			while (gtk_events_pending ())
				gtk_main_iteration ();

			/* ߤξȴ */
			if (searchStopFlag == CXPIMG_SEARCH_STOP)
				break;

		}
		else
		{
			/* ٥Ƚ */
			while (gtk_events_pending ())
				gtk_main_iteration ();

			nextSearchDirectory (pathname, kensu);
		}
		/* ߤξȴ */
		if (searchStopFlag == CXPIMG_SEARCH_STOP)
			break;

		if ((*kensu) + 1 >= MAX_IMAGEVIEW_NUM)
			break;
	}

	closedir (dfd);

	return (0);
}

int readPathInfoFunc ()
{
	DIR *dfd;
	struct dirent *dp;
	char *dirname;
	char pathname[1024];
	struct stat fileinfo;
	int i, w, h, type, kensu;

	searchStopFlag = CXPIMG_SEARCH_START;

	dirname = gtk_entry_get_text (GTK_ENTRY (cxpimageview->pathEntry));
	if (dirname == (char *) NULL)
	{
		/* ENTRYΥѥꤹ */
		gtk_entry_set_text (GTK_ENTRY (cxpimageview->pathEntry),
				    cxpimageview->path);
		return (-1);
	}
	if (strlen (dirname) <= 0)
	{
		/* ENTRYΥѥꤹ */
		gtk_entry_set_text (GTK_ENTRY (cxpimageview->pathEntry),
				    cxpimageview->path);
		return (-1);
	}

    /*-- ǥ쥯ȥΥץ --*/
	if ((dfd = opendir (dirname)) == NULL)
	{
		/* ENTRYΥѥꤹ */
		gtk_entry_set_text (GTK_ENTRY (cxpimageview->pathEntry),
				    cxpimageview->path);
		return (-1);
	}

	strcpy (cxpimageview->path, dirname);

	/* ꥹȹ */
	cxpimage_filelistview_start ();

	/* ɥɽ */
	cxpimage_stopWindow ();
	while (gtk_events_pending ())
		gtk_main_iteration ();

	kensu = 0;
	for (i = 0; (dp = readdir (dfd)) != NULL; i++)
	{
		if (!strcmp (dp->d_name, ".") || !strcmp (dp->d_name, ".."))
			continue;

		if (strcmp (dirname, "/") == 0)
			sprintf (pathname, "%s%s", dirname, dp->d_name);
		else
			sprintf (pathname, "%s/%s", dirname, dp->d_name);
		stat (pathname, &fileinfo);

		if (!S_ISDIR (fileinfo.st_mode))
		{
			type = common_image_check (pathname, &w, &h);
			if (type == CXP_IMAGE_NONE)
				continue;

			cxpimageview->image[kensu].name =
				g_strdup (dp->d_name);
			kensu++;
			cxpimageview->image_kensu = kensu;

			/* ꥹȹ */
			cxpimage_filelistview_append (kensu - 1);

			/* ٥Ƚ */
			while (gtk_events_pending ())
				gtk_main_iteration ();

			/* ߤξȴ */
			if (searchStopFlag == CXPIMG_SEARCH_STOP)
				break;

		}
		else
		{
			nextSearchDirectory (pathname, &kensu);
		}
		/* ߤξȴ */
		if (searchStopFlag == CXPIMG_SEARCH_STOP)
			break;
	}

	cxpimageview->image_kensu = kensu;

	closedir (dfd);

	/* եꥹȤ򹹿 */
	cxpimage_filelistview ();

	if (searchStopFlag == CXPIMG_SEARCH_START)
		stopSearchFunc ();

	return (0);
}

int stopSearchFunc ()
{
	searchStopFlag = CXPIMG_SEARCH_STOP;

	gtk_widget_hide (cxpimageview->stopWindow);
	gtk_widget_destroy (cxpimageview->stopWindow);
}
