/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

CxpMgr    *cxpmgr;

extern char *getdataTitle() ;
extern char *getdataVersion() ;
extern char *getdataEmail() ;
extern char *getdataUrl() ;
extern char *getdataCopyright() ;
extern int  getApplicationConfig() ;

int exitfunc()
{
    int x,y,w,h ;
    int xymode,whmode;

    getGeometryInfo( CXPLORER_MODE, &xymode, &whmode, &x, &y, &w, &h );
    if ( xymode == 0 ) /* ΰ */
    {
	x = cxpmgr->window->allocation.x ;
	y = cxpmgr->window->allocation.y ;
    }
    if ( whmode == 0 ) /* Υ */
    {
	w = cxpmgr->window->allocation.width  ;
	h = cxpmgr->window->allocation.height ;
    }
    setGeometryInfo( CXPLORER_MODE, xymode, whmode, x, y, w, h );

    gtk_main_quit();
}

static void HelpMessage()
{
    fprintf(stdout,"\n");
    fprintf(stdout,"%s\n", getdataTitle() );
    fprintf(stdout,"%s\n", getdataVersion() );
    fprintf(stdout,"%s\n", getdataEmail() );
    fprintf(stdout,"%s\n", getdataUrl() );
    fprintf(stdout,"%s\n", getdataCopyright() );
    fprintf(stdout,"Thank you ... \n");

    fprintf(stdout,"\n") ;

    fprintf(stdout,"usage: cxplorer [option]\n") ;
    fprintf(stdout," [option]\n") ;
    fprintf(stdout,"     -dir [directory] : initial directory\n") ;
    fprintf(stdout,"\n") ;

    exit(0);
}

static gint cxpmgr_event (GtkWidget *widget, GdkEvent *event)
{
    GdkEventButton  *bevent = (GdkEventButton *) event;
    GdkEventKey     *kevent = (GdkEventKey *) event;
    static int KeyPressCntl = 0;
    char command[1024] ;
    int i ;

    if (event->type == GDK_KEY_PRESS)
    {
	if ( kevent->keyval == GDK_Control_L
	||   kevent->keyval == GDK_Control_R )
		KeyPressCntl = 1 ;

	if ( KeyPressCntl == 1 )
	{
	    /* CNTLե󥯥ϿƤ뤫? */
	    for(i=0;i<cxpmgr->function.maxCNum;i++)
	    {
		if ( kevent->keyval == cxpmgr->function.cTable[i].keycode )
		{
		    if ( cxpmgr->function.cTable[i].execFunc != (char *)NULL )
		    {
			if ( strlen(cxpmgr->function.cTable[i].execFunc) > 0 )
			{
			    /* ¹Ԥ */
			    sprintf(command, "cd \"%s\" ; %s &",
				cxpmgr->pwdbuff,
				cxpmgr->function.cTable[i].execFunc );
			    system(command);
			}
		    }
		}
	    }
	}

	/* FNե󥯥ϿƤ뤫? */
	for(i=0;i<cxpmgr->function.maxFNum;i++)
	{
	    if ( kevent->keyval == cxpmgr->function.fTable[i].keycode )
	    {
		if ( cxpmgr->function.fTable[i].execFunc != (char *)NULL )
		{
		    if ( strlen(cxpmgr->function.fTable[i].execFunc) > 0 )
		    {
			    /* ¹Ԥ */
			    sprintf(command, "cd \"%s\" ; %s &",
				cxpmgr->pwdbuff,
				cxpmgr->function.fTable[i].execFunc );
			    system(command);
		    }
		}
	    }
	}

    }
    if (event->type == GDK_KEY_RELEASE)
    {
	if ( kevent->keyval == GDK_Control_L
	||   kevent->keyval == GDK_Control_R )
		KeyPressCntl = 0 ;
    }

    /* ٥ȤΤ */
    return(FALSE);
}

void cxp_init()
{
  GtkWidget	*hpaned;
  GtkWidget	*vbox;
  GtkWidget	*subitem ;
  int		row ;
  char		*pwdbuff ;
  int		x,y,w,h ;
  int		xymode, whmode;

  /* ưɣĤμ */
  cxpmgr->uid = getuid();
  cxpmgr->gid = getgid();

  /* ν */
  memset( &(cxpmgr->select), 0x00, sizeof(SELECTINFO) );

  /* ɽ */
  cxpmgr->viewMode     = VIEW_LIST ;
  cxpmgr->viewModeBack = VIEW_LIST ;

  /* ȼ */
  cxpmgr->sortno = 0 ;

  /* 쥯 */
  cxpmgr->clist1_selection = -1 ;

  /* μ */
  getGeometryInfo( CXPLORER_MODE, &xymode, &whmode, &x, &y, &w, &h );

  /* ߤΥǥ쥯ȥ֤ */
  if ( strlen(cxpmgr->pwdbuff) <= 0 )
  {
	if ( !getcwd( cxpmgr->pwdbuff, MAX_DIR_LENGTH ) )
	    strcpy( cxpmgr->pwdbuff, "/" );
  }

#ifdef	DEBUG119
fprintf(stdout,"cxp_init pwdbuff [%s]\n",  cxpmgr->pwdbuff );
fflush(stdout);
#endif

  /* ١ɤ߹ */
  getBaseConfig( &cxpmgr->base ) ;

  /* Cxplorer Infomation */
  getCxplorerInfo( &cxpmgr->cinf );

  /* եɤ߹ */
  getStyleConfig( &(cxpmgr->styleIndex), &(cxpmgr->style) ) ;

#ifdef	DEBUG11
fprintf(stdout,"styleIndex sett ==> %d\n", cxpmgr->cinf.styleIndex );
#endif
  cxpmgr->styleIndex = cxpmgr->cinf.styleIndex ;

  /* Ϣեץꥱɤ߹ */
  getApplicationConfig( &(cxpmgr->appli_kensu), &(cxpmgr->appli) );

  /* Ͽץꥱɤ߹ */
  getApplicationName( &(cxpmgr->aplication) );

  /* Ͽե󥯥ɤ߹ */
  getFunctionInfo( &(cxpmgr->function) );

  /* ١Υɥ */
  cxpmgr->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect(GTK_OBJECT(cxpmgr->window), "destroy",
		     GTK_SIGNAL_FUNC(exitfunc), NULL);
  gtk_window_set_title(GTK_WINDOW(cxpmgr->window), "Cxplorer" );
  gtk_widget_set_usize(cxpmgr->window, 200, 200);
  gtk_window_set_default_size(GTK_WINDOW(cxpmgr->window),540,420);

  gtk_signal_connect(GTK_OBJECT(cxpmgr->window), "event",
		GTK_SIGNAL_FUNC(cxpmgr_event), NULL);

  if (( xymode == 0 ) || ( xymode == 1 ))
  {
	if ( x != -1 && y != -1 )
	{
	    /* ΰ */
	    if ( x >= gdk_root_parent.width )
		x = gdk_root_parent.width / 2 ;
	    if ( y >= gdk_root_parent.height )
		y = gdk_root_parent.height / 2 ;

	    gtk_widget_set_uposition(cxpmgr->window, x, y );
	}
  }

  if (( whmode == 0 ) || ( whmode == 1 ))
  {
	if ( w != -1 && h != -1 )
	{
	    if ( w >= gdk_root_parent.width )
		w = gdk_root_parent.width ;
	    if ( h >= gdk_root_parent.height )
		h = gdk_root_parent.height ;
 
	    gtk_window_set_default_size (GTK_WINDOW(cxpmgr->window), w, h );
	}
  }


  /* VBOX */
  cxpmgr->vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(cxpmgr->window), cxpmgr->vbox);
  gtk_widget_show(cxpmgr->vbox);

  /* ˥塼 */
  cxp_menu_init() ;

  /* ȥåץޥɤ */
  cxp_topcmd_init() ;

  /* ɥ쥹 */
  cxp_address_init() ;

  /* ĥ꡼ */
  cxp_list_init() ;

  /* ǥ쥯ȥκ */
  getDirectoryInfo( "/", &cxpmgr->fsInfo.root ) ;

  pwdbuff = g_strdup(cxpmgr->pwdbuff) ;

  /* ǥ쥯ȥ󤫤ɽѺ */
  cxpmgr->totalCount = 0 ;
  printDirectory( &cxpmgr->fsInfo.root, -1, &cxpmgr->totalCount ) ;

  /* ե̾ɽңϣװ֤򻻽 */
  row = 0 ;
  getDirectoryInfoName( &cxpmgr->fsInfo.root, pwdbuff, &row );

#ifdef DEBUG5
fprintf(stdout,"get row -> %d [%s]\n", row, cxpmgr->pwdbuff );
fflush(stdout);
#endif

  /* ɽιߥե饰 */
  cxpmgr->currentViewFlag = 0 ;

  gtk_clist_select_row( GTK_CLIST(cxpmgr->clist1), row, 0 );

  /*  */
  gtk_clist_moveto( GTK_CLIST(cxpmgr->clist1),
			row, 0,
			(gfloat)0.5,
			(gfloat)0.0 );

  /* եκ */
  gtk_clist_clear( GTK_CLIST(cxpmgr->clist2) );
  if ( getFileInfoByName( &cxpmgr->fsView, cxpmgr->pwdbuff ) )
  {
	printFileInfo( &cxpmgr->fsView );
  }

  /* ɥɽ */
  gtk_widget_show(cxpmgr->window);

  return;
}

int main(int argc, char *argv[])
{
	int	i ;

	CxpBasePathInit();

	/* ޥ͡㵯ư */
	cxp_manager_start();

	cxpmgr = (CxpMgr *)g_malloc(sizeof(CxpMgr));

	for(i=1;i<argc;i++)
	{
		if ( strcmp(argv[i], "-help") == 0
		||   strcmp(argv[i], "-h"   ) == 0 )
		{
			HelpMessage() ;
		}
		if ( strcmp(argv[i], "-directory") == 0
		||   strcmp(argv[i], "-dir"      ) == 0
		||   strcmp(argv[i], "-d"        ) == 0 )
		{
			if ( (i+1) >= argc )
			{
			    HelpMessage() ;
			}
			strcpy(cxpmgr->pwdbuff,argv[i+1] );
		}
	}

	gtk_set_locale();
	gtk_init(&argc, &argv);
  
	cxp_init();

	gtk_main();
	exit(0);
}
