/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpMgr	*cxpmgr ;

static GtkWidget *appWindow;
static GtkWidget *NameEntry;
static GtkWidget *PathEntry;
static GtkWidget *addBtn;
static GtkWidget *modBtn;
static GtkWidget *delBtn;
static GtkWidget *appList;
static GtkWidget *setBtn;
static GtkWidget *canBtn;

static int app_allselect ;

static APLICATION _aplication ;

static char *applist_title[2] =
{
	"Ͽץꥱ̾",
	" "
};

static void applist_selection(GtkWidget *clist, gint row, gint column,
	GdkEventButton *event, gpointer data )
{
	if ( row < 0 ) return ;

	app_allselect = row ;

	/* 򤷤ǡɽ */
	gtk_entry_set_text(GTK_ENTRY(NameEntry),
		_aplication.item[app_allselect].name ) ;
	gtk_entry_set_text(GTK_ENTRY(PathEntry),
		_aplication.item[app_allselect].path ) ;

	/* 򤷤ѹסֺפ򲡤褦 */
	gtk_widget_set_sensitive( addBtn, FALSE );
	gtk_widget_set_sensitive( modBtn, TRUE );
	gtk_widget_set_sensitive( delBtn, TRUE );
}

static void applist_unselection(GtkWidget *clist, gint row, gint column,
	GdkEventButton *event, gpointer data )
{
	if ( row < 0 ) return ;

	app_allselect = -1 ;

	/* ˤ */
	gtk_entry_set_text(GTK_ENTRY(NameEntry), "" );
	gtk_entry_set_text(GTK_ENTRY(PathEntry), "" );

	/* 줿ɲáפ򲡤褦 */
	/* ѹסֺפ򲡤ʤ褦ꤹ롣 */
	gtk_widget_set_sensitive( addBtn, TRUE );
	gtk_widget_set_sensitive( modBtn, FALSE );
	gtk_widget_set_sensitive( delBtn, FALSE );

}

/* ǡå */
int appWinCheckData()
{
	char *data ;
	int check ;
	int status ;

	status = 0 ;
	if ((data = gtk_entry_get_text(GTK_ENTRY(NameEntry))) == NULL )
		status = 1 ;
	else
	if ( strlen(data) <= 0 )
		status = 1 ;

	if ((data = gtk_entry_get_text(GTK_ENTRY(PathEntry))) == NULL )
		status = 1 ;
	else
	if ( strlen(data) <= 0 )
		status = 1 ;

	return(status);
}

/* ɲ */
static void addCallBack(GtkWidget *widget, GtkWidget *win )
{
	char	*data ;
	int	status ;
	int	i ;
	char  *viewdata[2];


	if ( _aplication.num + 1 > MAX_APLICATION_NUM )
	{
		create_messageWin( appWindow,
			"ϿǤ륢ץꥱϣޤǤǤ");
		return;
	}

	status = appWinCheckData();
	if ( status != 0 )
	{
		create_messageWin( appWindow,
			"ϤƤʤս꤬١ɲäǤޤ" );
		return ;
	}

	i = _aplication.num ;

	/* ɲä */
	if ((data = gtk_entry_get_text(GTK_ENTRY(NameEntry))) == NULL )
		_aplication.item[i].name = (char *)NULL ;
	else
		_aplication.item[i].name = g_strdup(data);
	if ((data = gtk_entry_get_text(GTK_ENTRY(PathEntry))) == NULL )
		_aplication.item[i].path = (char *)NULL ;
	else
		_aplication.item[i].path = g_strdup(data);

	/* ꥹȤɲ */
	viewdata[0] = g_strdup( _aplication.item[i].name );
        gtk_clist_append( GTK_CLIST(appList), viewdata );
	gtk_clist_select_row( GTK_CLIST(appList), i, 0 );

	_aplication.num ++;

	return;
}
/* ѹ */
static void modCallBack(GtkWidget *widget, GtkWidget *win )
{
	char *data ;
	int i ;
	int status ;

	status = appWinCheckData();
	if ( status != 0 )
	{
		create_messageWin( appWindow,
			"ϤƤʤս꤬١ѹǤޤ" );
		return ;
	}

	i = app_allselect ;

	/* ѹ */
	if ((data = gtk_entry_get_text(GTK_ENTRY(NameEntry))) == NULL )
		_aplication.item[i].name = (char *)NULL ;
	else
		_aplication.item[i].name = g_strdup(data);
	if ((data = gtk_entry_get_text(GTK_ENTRY(PathEntry))) == NULL )
		_aplication.item[i].path = (char *)NULL ;
	else
		_aplication.item[i].path = g_strdup(data);

	/* ꥹȤѹ */
	gtk_clist_set_text( GTK_CLIST(appList), i, 0,
			_aplication.item[i].name );
	gtk_clist_select_row( GTK_CLIST(appList), i, 0 );

}
/*  */
static void delCallBack(GtkWidget *widget, GtkWidget *win )
{
	int	i, k ;

	i = app_allselect ;

	if ( app_allselect < 0 )
	{
		create_messageWin( appWindow,
		    "٤ˤϿץꥱ򤷤Ʋ" );
		return ;
	}

	for(k=i;k<_aplication.num-1; k++)
	{
	    _aplication.item[k].name = g_strdup(_aplication.item[k+1].name);
	    _aplication.item[k].path = g_strdup(_aplication.item[k+1].path);
	}
	_aplication.item[k].name = (char *)NULL ;
	_aplication.item[k].path = (char *)NULL ;

	_aplication.num --;
	if ( _aplication.num < 0 )
		_aplication.num = 0 ;

	gtk_clist_remove( GTK_CLIST(appList), app_allselect );

	return;

}

/*  */
static void setCallBack(GtkWidget *widget, gpointer data )
{
	int i ;

	for(i=0;i<_aplication.num; i++)
	{
	    cxpmgr->aplication.item[i].name
			= g_strdup(_aplication.item[i].name);
	    cxpmgr->aplication.item[i].path
			= g_strdup(_aplication.item[i].path);
	}

	cxpmgr->aplication.num = _aplication.num ;

	/* ǡǥ¸ */
	setApplicationName( &(cxpmgr->aplication) );

	/* ɥĤ */
	gtk_widget_destroy(appWindow);
}

/*  */
static void cancelCallBack(GtkWidget *widget, gpointer data )
{
	/* ɥĤ */
	gtk_widget_destroy(appWindow);
}

int create_appWindow()
{
  GtkWidget *vbox3;
  GtkWidget *label1;
  GtkWidget *hbox3;
  GtkWidget *hbox5;
  GtkWidget *vbox5;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *swin;
  GtkWidget *vbox6;
  GtkWidget *vbox4;
  GtkWidget *hbox4;
  int x,y,w,h ;
  int i ;
  char  *viewdata[2];

  app_allselect = 0 ;

  memset( &_aplication, 0x00, sizeof(APLICATION) );
  
  w = gdk_screen_width();
  h = gdk_screen_height();
  x = w * 0.5;
  y = h * 0.5;

  appWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (appWindow), "appWindow", appWindow);
  gtk_window_set_title (GTK_WINDOW (appWindow), "ץꥱϿ");
  gtk_widget_set_usize(appWindow, 100, 100);
  gtk_window_set_default_size(GTK_WINDOW(appWindow),600,200);
  gtk_widget_set_uposition(appWindow, (x - 600*0.5), (y - 200*0.5) );
  gtk_widget_show(appWindow);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox3);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "vbox3", vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (appWindow), vbox3);

  label1 = gtk_label_new ("ץꥱϿ");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox3), label1, FALSE, FALSE, 8);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox3, TRUE, TRUE, 0);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox5);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "hbox5", hbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (hbox3), hbox5, FALSE, TRUE, 0);

  vbox5 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox5);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "vbox5", vbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox5);
  gtk_box_pack_start (GTK_BOX (hbox5), vbox5, FALSE, TRUE, 5);

  label2 = gtk_label_new ("ץꥱ̾");
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox5), label2, FALSE, FALSE, 0);

  label3 = gtk_label_new ("¹ԥץࡧ");
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (vbox5), label3, FALSE, FALSE, 0);

  vbox6 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox6);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "vbox6", vbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox6);
  gtk_box_pack_start (GTK_BOX (hbox5), vbox6, FALSE, TRUE, 5);

  NameEntry = gtk_entry_new ();
  gtk_widget_ref (NameEntry);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "NameEntry", NameEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (NameEntry);
  gtk_box_pack_start (GTK_BOX (vbox6), NameEntry, FALSE, FALSE, 0);
  gtk_widget_set_usize (NameEntry, 155, -2);

  PathEntry = gtk_entry_new ();
  gtk_widget_ref (PathEntry);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "PathEntry", PathEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PathEntry);
  gtk_box_pack_start (GTK_BOX (vbox6), PathEntry, FALSE, FALSE, 0);
  gtk_widget_set_usize (PathEntry, 155, -2);

  vbox4 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox4);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "vbox4", vbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox4);
  gtk_box_pack_start (GTK_BOX (hbox3), vbox4, FALSE, TRUE, 8);

  addBtn = gtk_button_new_with_label (" ɲ ");
  gtk_widget_ref (addBtn);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "addBtn", addBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (addBtn);
  gtk_box_pack_start (GTK_BOX (vbox4), addBtn, FALSE, FALSE, 0);

  modBtn = gtk_button_new_with_label (" ѹ ");
  gtk_widget_ref (modBtn);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "modBtn", modBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (modBtn);
  gtk_box_pack_start (GTK_BOX (vbox4), modBtn, FALSE, FALSE, 0);

  delBtn = gtk_button_new_with_label ("  ");
  gtk_widget_ref (delBtn);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "delBtn", delBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (delBtn);
  gtk_box_pack_start (GTK_BOX (vbox4), delBtn, FALSE, FALSE, 0);

  swin = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start(GTK_BOX(hbox3), swin, TRUE, TRUE, 0);
  gtk_widget_show(swin);

  appList = gtk_clist_new_with_titles( 1, applist_title );
  gtk_clist_set_selection_mode(GTK_CLIST(appList),
			GTK_SELECTION_SINGLE);
  gtk_signal_connect(GTK_OBJECT(appList), "select_row",
			GTK_SIGNAL_FUNC(applist_selection), NULL);
  gtk_signal_connect(GTK_OBJECT(appList), "unselect_row",
			GTK_SIGNAL_FUNC(applist_unselection), NULL);
  gtk_container_add(GTK_CONTAINER(swin), appList);
  gtk_widget_show(appList);

  hbox4 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox4);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "hbox4", hbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox4, FALSE, TRUE, 8);

  setBtn = gtk_button_new_with_label ("  ");
  gtk_widget_ref (setBtn);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "setBtn", setBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (setBtn);
  gtk_box_pack_start (GTK_BOX (hbox4), setBtn, FALSE, FALSE, 0);

  canBtn = gtk_button_new_with_label ("  ");
  gtk_widget_ref (canBtn);
  gtk_object_set_data_full (GTK_OBJECT (appWindow), "canBtn", canBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (canBtn);
  gtk_box_pack_start (GTK_BOX (hbox4), canBtn, FALSE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (addBtn), "clicked",
		(GtkSignalFunc) addCallBack, NULL );
  gtk_signal_connect (GTK_OBJECT (modBtn), "clicked",
		(GtkSignalFunc) modCallBack, NULL );
  gtk_signal_connect (GTK_OBJECT (delBtn), "clicked",
		(GtkSignalFunc) delCallBack, NULL );
  gtk_signal_connect (GTK_OBJECT (setBtn), "clicked",
		(GtkSignalFunc) setCallBack, NULL );
  gtk_signal_connect (GTK_OBJECT (canBtn), "clicked",
		(GtkSignalFunc) cancelCallBack, NULL );

  memset( &_aplication,0x00, sizeof(APLICATION) );

  /* ǡꥹȤɲä */
  for(i=0;i<cxpmgr->aplication.num; i++)
  {
	_aplication.item[i].name = g_strdup(cxpmgr->aplication.item[i].name);
	_aplication.item[i].path = g_strdup(cxpmgr->aplication.item[i].path);
	viewdata[0] = g_strdup( _aplication.item[i].name );
        gtk_clist_append( GTK_CLIST(appList), viewdata );
  }
  _aplication.num = cxpmgr->aplication.num;

  /* ɲáפ򲡤褦ˡѹסֺפ򲡤ʤ褦 */
  gtk_widget_set_sensitive( addBtn, TRUE );
  gtk_widget_set_sensitive( modBtn, FALSE );
  gtk_widget_set_sensitive( delBtn, FALSE );


}

