/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern	CxpMgr    *cxpmgr;
extern  void messageView ();

static void (*_local_function)() ;
static GtkWidget *newfiletext ;
static GtkWidget *renametext ;
static char *_local_data1 ;
static char *_local_data2 ;

void messnewfile_ok(GtkWidget *widget, gpointer data)
{
  DINFO	*dinfo ;
  int	status ;
  int	icnt ;
  char	*entry_text ;
  char	workbuff[1024] ;
  char	checkname[1024] ;
  char	*ptr ;

  /* ե̾Τ */
  entry_text = gtk_entry_get_text(GTK_ENTRY(newfiletext));

  if ( strlen(entry_text) > 0 )
  {
	dinfo = (DINFO *)malloc( sizeof(DINFO) );
	memset( dinfo, 0x00, sizeof(dinfo) );
	dinfo->count = 0 ;
	if ( getFileInfoByName( dinfo, cxpmgr->pwdbuff ) < 0 )
	{
		/* ɥϥɤ */
		gtk_grab_remove ( widget );
		gtk_widget_hide( widget );

		/* ǥ쥯ȥ꤬ץǤʤϥڡȤʤ */
		messageView(
			"ե顼", "", "Ĥ",
			"ǥ쥯ȥμ˼Ԥޤ",
			cxpmgr->pwdbuff, NULL );

		free(dinfo);

		return ;
	}

	/* Ʊե̾뤫å */
	status = 0 ;
	for(icnt=0;icnt<dinfo->count; icnt++)
	{
		strcpy( workbuff, dinfo->finfo[icnt]->fname );
		ptr = strrchr( workbuff, '/' );
		if ( ptr == NULL )
			sprintf( checkname, "%s", workbuff );
		else
			sprintf( checkname, "%s", ptr+1 );

		if ( strcmp( entry_text, checkname) == 0 )
		{
			status = 1 ;
			break;
		}
	}
	free(dinfo);

	/* Ʊ̾Υե뤬¸ߤ */
	if ( status == 1 )
	{
		gtk_grab_remove ( widget );

		messageView(
			"ե顼", "", "Ĥ",
			"Ʊ̾Υե뤬¸ߤޤ",
			entry_text, NULL );
		return ;
	}

	/* ؿ¹ */
	(*_local_function)(entry_text) ;

	/* ɥϥɤ */
	gtk_grab_remove ( widget );
	gtk_widget_hide( widget );
  }else{
	gtk_grab_remove ( widget );

	messageView(
		"ե顼", "", "Ĥ",
		"ե̾ϤƤ",
		"", NULL );
  }
}

void messrename_ok(GtkWidget *widget, gpointer data)
{
  DINFO	*dinfo ;
  int	status ;
  int	icnt ;
  char	*entry_text ;
  char	workbuff[1024] ;
  char	checkname[1024] ;
  char	*ptr ;

  /* ե̾Τ */
  entry_text = gtk_entry_get_text(GTK_ENTRY(renametext));

  if ( strlen(entry_text) > 0 )
  {
	dinfo = (DINFO *)malloc( sizeof(DINFO) );
	memset( dinfo, 0x00, sizeof(dinfo) );
	dinfo->count = 0 ;
	if ( getFileInfoByName( dinfo, cxpmgr->pwdbuff ) < 0 )
	{
		/* ɥϥɤ */
		gtk_grab_remove ( widget );
		gtk_widget_hide( widget );

		/* ǥ쥯ȥ꤬ץǤʤϥڡȤʤ */
		messageView(
			"̾ѹ顼","","Ĥ",
			"ǥ쥯ȥμ˼Ԥޤ",
			cxpmgr->pwdbuff, NULL );

		free(dinfo);

		return ;
	}

	/* Ʊե̾뤫å */
	status = 0 ;
	for(icnt=0;icnt<dinfo->count; icnt++)
	{
		strcpy( workbuff, dinfo->finfo[icnt]->fname );
		ptr = strrchr( workbuff, '/' );
		if ( ptr == NULL )
			sprintf( checkname, "%s", workbuff );
		else
			sprintf( checkname, "%s", ptr+1 );

		if ( strcmp( entry_text, checkname) == 0 )
		{
			status = 1 ;
			break;
		}
	}
	free(dinfo);

	/* Ʊ̾Υե뤬¸ߤ */
	if ( status == 1 )
	{
		gtk_grab_remove ( widget );

		messageView(
			"̾ѹ顼","","Ĥ",
			"Ʊ̾Υե뤬¸ߤޤ",
			entry_text, NULL );
		return ;
	}

	/* ؿ¹ */
	(*_local_function)(entry_text) ;

	/* ɥϥɤ */
	gtk_grab_remove ( widget );
	gtk_widget_hide( widget );
  }else{
	gtk_grab_remove ( widget );

	messageView(
		"̾ѹ顼", "", "Ĥ",
		"ե̾ϤƤ",
		"", NULL );
  }
}

void messpasteover_ok(GtkWidget *widget, gpointer data)
{
  gtk_grab_remove ( widget );

  /* ؿ¹ */
  (*_local_function)(_local_data1, _local_data2) ;

  /* ɥϥɤ */
  gtk_widget_hide( widget );
}

void messdialog_ok(GtkWidget *widget, gpointer data)
{
  gtk_grab_remove ( widget );

  /* ؿ¹ */
  (*_local_function)() ;

  /* ɥϥɤ */
  gtk_widget_hide( widget );
}

void messdialog_cancel(GtkWidget *widget, gpointer data)
{
  /* ɥϥɤ */
  gtk_grab_remove ( widget );
  gtk_widget_hide( widget );
}

/* åɽ */
void messageView ( title, ok, can, list1, list2, function )
char	*title ;
char	*ok ;
char	*can ;
char	*list1 ;
char	*list2 ;
void	(*function)() ;
{
  GtkWidget *dialog ;
  GtkWidget *label[5] ;
  GtkWidget *button1 ;
  GtkWidget *button2 ;
  int x,y,w,h ;

  gdk_window_get_origin(cxpmgr->window->window, &x, &y);
  gdk_window_get_size  (cxpmgr->window->window, &w, &h);

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), title );
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_widget_set_usize(dialog, 320, 130);
  gtk_widget_set_uposition(dialog, (x+(w/2)) - (300/2), (y+(h/2)) - (100/2));
  gtk_grab_add (dialog);
  gtk_widget_show (dialog);


  if ( strlen(list2) > 0 )
  {
	label[0] = gtk_label_new( list1 );
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label[0], FALSE, TRUE, 10);
	gtk_widget_show (label[0]);

  	label[1] = gtk_label_new( list2   );
  	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label[1], FALSE, TRUE, 10);
  	gtk_widget_show (label[1]);

  }else{

	label[0] = gtk_label_new( list1 );
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label[0], FALSE, TRUE, 40);
	gtk_widget_show (label[0]);
  }

  if ( strlen(ok) > 0 )
  {
  	button1 = gtk_button_new_with_label (ok);
  	gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
			(GtkSignalFunc) messdialog_ok,
			GTK_OBJECT (dialog));

	_local_function = function ;

  	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button1, FALSE, TRUE, 20);
  	gtk_widget_show (button1);
  }

  button2 = gtk_button_new_with_label (can);
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			(GtkSignalFunc) messdialog_cancel,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button2, FALSE, TRUE, 20);
  gtk_widget_show (button2);

}

/* ե */
void messageNewFile ( title, ok, can, list1, function )
char	*title ;
char	*ok ;
char	*can ;
char	*list1 ;
void	(*function)() ;
{
  GtkWidget *dialog ;
  GtkWidget *hbox ;
  GtkWidget *label ;
  GtkWidget *button1 ;
  GtkWidget *button2 ;
  int x,y,w,h ;

  gdk_window_get_origin(cxpmgr->window->window, &x, &y);
  gdk_window_get_size  (cxpmgr->window->window, &w, &h);

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), title );
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_widget_set_usize(dialog, 300, 140);
  gtk_widget_set_uposition(dialog, (x+(w/2)) - (300/2), (y+(h/2)) - (100/2));
  gtk_grab_add (dialog);
  gtk_widget_show (dialog);


  label = gtk_label_new( list1 );
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label, TRUE, TRUE, 10);
  gtk_widget_show (label);

  hbox = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		hbox, TRUE, TRUE, 10);
  gtk_widget_show(hbox);

  newfiletext = gtk_entry_new_with_max_length( 256 );
  gtk_box_pack_start (GTK_BOX (hbox),
		newfiletext, TRUE, TRUE, 20);
  gtk_widget_show (newfiletext);

  _local_function = function ;

  button1 = gtk_button_new_with_label (ok);
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
			(GtkSignalFunc) messnewfile_ok,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button1, FALSE, TRUE, 20);
  gtk_widget_show (button1);

  button2 = gtk_button_new_with_label (can);
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			(GtkSignalFunc) messdialog_cancel,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button2, FALSE, TRUE, 20);
  gtk_widget_show (button2);
}

/* ̾ѹ */
void messageRename ( title, ok, can, list1, name, function )
char	*title ;
char	*ok ;
char	*can ;
char	*list1 ;
char	*name ;
void	(*function)() ;
{
  GtkWidget *dialog ;
  GtkWidget *hbox ;
  GtkWidget *label ;
  GtkWidget *button1 ;
  GtkWidget *button2 ;
  int x,y,w,h ;

  gdk_window_get_origin(cxpmgr->window->window, &x, &y);
  gdk_window_get_size  (cxpmgr->window->window, &w, &h);

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), title );
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_widget_set_usize(dialog, 300, 140);
  gtk_widget_set_uposition(dialog, (x+(w/2)) - (300/2), (y+(h/2)) - (140/2));
  gtk_grab_add (dialog);
  gtk_widget_show (dialog);


  label = gtk_label_new( list1 );
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label, TRUE, TRUE, 10);
  gtk_widget_show (label);


  hbox = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);


  renametext = gtk_entry_new_with_max_length( 256 );
  gtk_box_pack_start (GTK_BOX (hbox),
		renametext, TRUE, TRUE, 20);
  gtk_widget_show (renametext);

  gtk_entry_set_text( GTK_ENTRY(renametext), name );

  _local_function = function ;

  button1 = gtk_button_new_with_label (ok);
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
			(GtkSignalFunc) messrename_ok,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button1, FALSE, TRUE, 20);
  gtk_widget_show (button1);

  button2 = gtk_button_new_with_label (can);
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			(GtkSignalFunc) messdialog_cancel,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button2, FALSE, TRUE, 20);
  gtk_widget_show (button2);
}

/* Žդ */
void messagePasteOver ( title, ok, can, list1, list2, fname, bname, function )
char	*title ;
char	*ok ;
char	*can ;
char	*list1 ;
char	*list2 ;
char	*fname ;
char	*bname ;
void	(*function)() ;
{
  GtkWidget *dialog ;
  GtkWidget *hbox ;
  GtkWidget *label[2] ;
  GtkWidget *button1 ;
  GtkWidget *button2 ;
  int x,y,w,h ;

  gdk_window_get_origin(cxpmgr->window->window, &x, &y);
  gdk_window_get_size  (cxpmgr->window->window, &w, &h);

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), title );
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_widget_set_usize(dialog, 300, 140);
  gtk_widget_set_uposition(dialog, (x+(w/2)) - (300/2), (y+(h/2)) - (140/2));
  gtk_grab_add (dialog);
  gtk_widget_show (dialog);


  label[0] = gtk_label_new( list1 );
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
	label[0], TRUE, TRUE, 10);
  gtk_widget_show (label[0]);

  label[1] = gtk_label_new( list2   );
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
	label[1], TRUE, TRUE, 0);
  gtk_widget_show (label[1]);

  _local_function = function ;
  _local_data1    = g_strdup(fname) ;
  _local_data2    = g_strdup(bname) ;

  button1 = gtk_button_new_with_label (ok);
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
			(GtkSignalFunc) messpasteover_ok,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button1, FALSE, TRUE, 20);
  gtk_widget_show (button1);

  button2 = gtk_button_new_with_label (can);
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			(GtkSignalFunc) messdialog_cancel,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button2, FALSE, TRUE, 20);
  gtk_widget_show (button2);
}
