/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpMgr    *cxpmgr;

int checkDirectoryInfo( dirname )
char *dirname ;
{
        DIR     *dfd;
        struct dirent *dp ;
        char    pathname[256] ;
        int     i, k ;
        struct stat fileinfo ;

        /*-- ǥ쥯ȥΥץ --*/
        if ( (dfd = opendir(dirname)) == NULL )
                return(-1);

        /*-- ǥ쥯ȥɤ߹ --*/
        k = 0 ;
        for(i=0; (dp = readdir(dfd)) != NULL; i++)
        {
                if ( !strcmp( dp->d_name, "." ) || !strcmp( dp->d_name, "..") )
                        continue ;

		/* ɥåȥեɽʤ꤫? */
		if ( cxpmgr->cinf.dotFlag == 0 )
		{
		    /* ɥåȥե뤫? */
		    if ( strmatch( ".*", dp->d_name ) == 0 )
			continue ;
		}

                if ( strcmp( dirname,"/" ) == 0 )
                        sprintf( pathname,"%s%s", dirname, dp->d_name );
                else
                        sprintf( pathname,"%s/%s", dirname, dp->d_name );
                stat( pathname, &fileinfo );

                /* ǥ쥯ȥǤʤϽʤ */
                if ( !S_ISDIR( fileinfo.st_mode ) )
                        continue ;

		k++;
	}

        /*-- ǥ쥯ȥΥ --*/
        closedir(dfd);

        return(k);
}

static int __getDirectoryInfo( dirname, dinfo )
char *dirname ;
DINFO   *dinfo ;
{
        DIR     *dfd;
        struct dirent *dp ;
        char    pathname[1024] ;
        char    checkname[1024] ;
        int     i, status ;
        struct stat fileinfo ;

        /*-- ǥ쥯ȥΥץ --*/
        if ( (dfd = opendir(dirname)) == NULL )
	{
		fprintf(stderr,"Directory open error : [%s]\n", dirname);
                return(-1);
	}

        /*-- ǥ쥯ȥɤ߹ --*/
        dinfo->count = 0 ;
        for(i=0; (dp = readdir(dfd)) != NULL; i++)
        {
                if ( !strcmp( dp->d_name, "." ) || !strcmp( dp->d_name, "..") )
                        continue ;

		/* ɥåȥեɽʤ꤫? */
		if ( cxpmgr->cinf.dotFlag == 0 )
		{
		    /* ɥåȥե뤫? */
		    if ( strmatch( ".*", dp->d_name ) == 0 )
			continue ;
		}

                if ( strcmp( dirname,"/" ) == 0 )
                        sprintf( pathname,"%s%s", dirname, dp->d_name );
                else
                        sprintf( pathname,"%s/%s", dirname, dp->d_name );
                stat( pathname, &fileinfo );

                /* ǥ쥯ȥǤʤϽʤ */
                if ( !S_ISDIR( fileinfo.st_mode ) )
                        continue ;

                /* ǥ쥯ȥμ */
		if ( dinfo->finfo[dinfo->count] == (FINFO *)NULL )
		{
		    dinfo->finfo[dinfo->count] = (FINFO *)malloc( sizeof(FINFO) );
		    memset( dinfo->finfo[dinfo->count], 0x00, sizeof(FINFO) );
		}
                strcpy( dinfo->finfo[dinfo->count]->fname, pathname );
                dinfo->finfo[dinfo->count]->kind  = 1 ;
                dinfo->finfo[dinfo->count]->uid   = fileinfo.st_uid ;
                dinfo->finfo[dinfo->count]->gid   = fileinfo.st_gid ;
                dinfo->finfo[dinfo->count]->time  = fileinfo.st_mtime ;
                dinfo->finfo[dinfo->count]->ctime = fileinfo.st_ctime ;
                dinfo->finfo[dinfo->count]->atime = fileinfo.st_atime ;
                dinfo->finfo[dinfo->count]->mode  = fileinfo.st_mode ;
                dinfo->finfo[dinfo->count]->size  = fileinfo.st_size ;
                (dinfo->count)++;

		sprintf( checkname, "%s/*", pathname );
                if ( strmatch( checkname, cxpmgr->pwdbuff ) == 0
                ||   strmatch( pathname,  cxpmgr->pwdbuff ) == 0 )
                {
		    status = checkDirectoryInfo( pathname );
		    if ( status > 0 )
		    {
			if ( dinfo->finfo[(dinfo->count)-1]->next == NULL )
			{
			    dinfo->finfo[(dinfo->count)-1]->next
				= (DINFO *)malloc( sizeof(DINFO) );
			    memset( dinfo->finfo[(dinfo->count)-1]->next,0x00,
				sizeof(DINFO) );
			}
			dinfo->finfo[(dinfo->count)-1]->view = DIR_VIEW_ON ;
			__getDirectoryInfo( pathname,
				dinfo->finfo[(dinfo->count)-1]->next );
		    }else{
			if ( dinfo->finfo[(dinfo->count)-1]->next != NULL )
				free( dinfo->finfo[(dinfo->count)-1]->next );
			dinfo->finfo[(dinfo->count)-1]->view = DIR_VIEW_NONE ;
			dinfo->finfo[(dinfo->count)-1]->next = NULL ;
		    }
                }else{
		    status = checkDirectoryInfo( pathname );
		    if ( status > 0 )
		    {
			if ( dinfo->finfo[(dinfo->count)-1]->next == NULL )
			{
			    dinfo->finfo[(dinfo->count)-1]->next
				= (DINFO *)malloc( sizeof(DINFO) );
			    memset(dinfo->finfo[(dinfo->count)-1]->next,
				0x00, sizeof(DINFO) );
#if 0
			}
			if (dinfo->finfo[(dinfo->count)-1]->view != DIR_VIEW_ON)
			    dinfo->finfo[(dinfo->count)-1]->view = DIR_VIEW_OFF;
#else
			    dinfo->finfo[(dinfo->count)-1]->view = DIR_VIEW_OFF;
			}
#endif
		    }else{
			if ( dinfo->finfo[(dinfo->count)-1]->next != NULL )
                        {
				free( dinfo->finfo[(dinfo->count)-1]->next );
                        }
			dinfo->finfo[(dinfo->count)-1]->view = DIR_VIEW_NONE ;
			dinfo->finfo[(dinfo->count)-1]->next = NULL ;
		    }
		}
        }

        /*-- ǥ쥯ȥΥ --*/
        closedir(dfd);

        return(0);
}

static void fileAllocFree( dinfo )
DINFO *dinfo ;
{
    int i ;

    for( i=0; i<dinfo->count; i++ )
    {
        if ( dinfo->finfo[i]->next != NULL )
        {
	    DINFO *winfo ;

	    winfo = (DINFO *)dinfo->finfo[i]->next ;

            fileAllocFree( winfo );
            free( dinfo->finfo[i]->next );
        }
    }
}

int getDirectoryInfo( dirname, dinfo )
char *dirname ;
DINFO   *dinfo ;
{
	int	status ;
	char	pathname[1024] ;
	struct stat fileinfo ;

	if ( strcmp(dirname,"/") == 0 )
	{
		sprintf( pathname, "/" );

		stat( pathname, &fileinfo );

#if 0
		if ( dinfo->count > 0 )
		{
#ifdef	DEBUG120
fprintf(stdout,"fileAllocFree Function ...\n");
fflush(stdout);
#endif
		    fileAllocFree( dinfo );
		}
#endif

		/* 롼ȥǥ쥯ȥμ */
		(dinfo->count) = 0 ;

		if ( dinfo->finfo[dinfo->count] == (FINFO *)NULL )
		{
		    dinfo->finfo[dinfo->count] = (FINFO *)malloc( sizeof(FINFO) );
		    memset( dinfo->finfo[dinfo->count], 0x00, sizeof(FINFO) );
		}
		strcpy( dinfo->finfo[dinfo->count]->fname, pathname );
		dinfo->finfo[dinfo->count]->kind  = 1 ;
		dinfo->finfo[dinfo->count]->uid   = fileinfo.st_uid ;
		dinfo->finfo[dinfo->count]->gid   = fileinfo.st_gid ;
		dinfo->finfo[dinfo->count]->time  = fileinfo.st_mtime ;
		dinfo->finfo[dinfo->count]->ctime = fileinfo.st_ctime ;
		dinfo->finfo[dinfo->count]->atime = fileinfo.st_atime ;
		dinfo->finfo[dinfo->count]->mode  = fileinfo.st_mode ;
		dinfo->finfo[dinfo->count]->size  = fileinfo.st_size ;
		(dinfo->count)++;

		if ( dinfo->finfo[(dinfo->count)-1]->next == NULL )
		{
			dinfo->finfo[(dinfo->count)-1]->next
				= (DINFO *)malloc( sizeof(DINFO) );
			memset( dinfo->finfo[(dinfo->count)-1]->next,0x00,
				sizeof(DINFO));
		}
		dinfo->finfo[(dinfo->count)-1]->view = DIR_VIEW_ON ;
		status = __getDirectoryInfo( pathname,
				dinfo->finfo[(dinfo->count)-1]->next );
	}else{

		status = __getDirectoryInfo( dirname, dinfo ) ;
	}

	return(status);
}

printDirectory( dinfo, next, totalcount )
DINFO		*dinfo ;
int		next ;
int		*totalcount ;
{
	GdkPixmap	*pixmap ;
	GdkBitmap	*mask;
	GtkStyle	*style;
	char	*pixname ;
	char	buffname[256], setname[256] ;
	char	*dirname[2];
	char	*ptr ;
        int     i, k ;
        int     nx = next + 1;

#ifdef DEBUG
fprintf(stdout,"dinfo->count [%d]\n", dinfo->count);
fflush(stdout);
#endif
        for(i=0;i<dinfo->count;i++)
        {
		strcpy( buffname, dinfo->finfo[i]->fname );
		ptr = strrchr( buffname, '/' );
		if ( strcmp( buffname, "/" ) == 0 )
			ptr = NULL ;
		if ( ptr == NULL )
			sprintf( setname, "%s", buffname );
		else
			sprintf( setname, "%s", ptr+1 );

		dirname[0] = g_strdup( setname );

#ifdef DEBUG
fprintf(stdout,"[%3d] view [%d] next [%s] name [%s]\n",
*totalcount, dinfo->finfo[i]->view,
(dinfo->finfo[i]->next == NULL ? "ʤ" : "ͭ"),
dinfo->finfo[i]->fname );
fflush(stdout);
#endif

		gtk_clist_append( GTK_CLIST(cxpmgr->clist1), dirname );

		style = gtk_widget_get_style( cxpmgr->window );

		if ( dinfo->finfo[i]->view == DIR_VIEW_ON )
			pixname = cxpmgr->style[cxpmgr->styleIndex].treexpm3 ;
		else
		if ( dinfo->finfo[i]->view == DIR_VIEW_OFF )
			pixname = cxpmgr->style[cxpmgr->styleIndex].treexpm2 ;
		else
			pixname = cxpmgr->style[cxpmgr->styleIndex].treexpm1 ;

		pixmap = gdk_pixmap_create_from_xpm_d(
			cxpmgr->window->window,
			&mask, &style->bg[GTK_STATE_NORMAL],
			(gchar **)MakeXPMdata(pixname, nx ) );

		gtk_clist_set_pixtext( GTK_CLIST(cxpmgr->clist1),
			(*totalcount),	/* row    */
			0,		/* collum */
			setname,	/* text   */
			2,		/* spacing size */
			pixmap,		/* pixmap */
			mask );		/* mask */

		dinfo->finfo[i]->row = (*totalcount) ;
		(*totalcount)++;

		if ( dinfo->finfo[i]->view == DIR_VIEW_ON )
		{
                    if ( dinfo->finfo[i]->next != NULL )
		    {
                        printDirectory( (DINFO *)dinfo->finfo[i]->next, nx,
				totalcount );
		    }else{
			;
		    }
		}
        }
}

printDirectoryLight( dinfo, next, totalcount, viewrow )
DINFO		*dinfo ;
int		next ;
int		*totalcount ;
int		viewrow ;
{
	GdkPixmap	*pixmap ;
	GdkBitmap	*mask;
	GtkStyle	*style;
	char	*pixname ;
	char	buffname[256], setname[256] ;
	char	*dirname[2];
	char	*ptr ;
        int     i, k, m ;
        int     nx = next + 1;

#ifdef DEBUG
fprintf(stdout,"dinfo->count [%d]\n", dinfo->count);
fflush(stdout);
#endif
        for(i=0;i<dinfo->count;i++)
        {
	    if ( viewrow < *totalcount )
	    {
		strcpy( buffname, dinfo->finfo[i]->fname );
		ptr = strrchr( buffname, '/' );
		if ( strcmp( buffname, "/" ) == 0 )
			ptr = NULL ;
		if ( ptr == NULL )
			sprintf( setname, "%s", buffname );
		else
			sprintf( setname, "%s", ptr+1 );

		dirname[0] = g_strdup( setname );

#ifdef DEBUG
fprintf(stdout,"[%3d] view [%d] next [%s] name [%s]\n",
*totalcount, dinfo->finfo[i]->view,
(dinfo->finfo[i]->next == NULL ? "ʤ" : "ͭ"),
dinfo->finfo[i]->fname );
fflush(stdout);
#endif

		gtk_clist_append( GTK_CLIST(cxpmgr->clist1), dirname );

		style = gtk_widget_get_style( cxpmgr->window );

		if ( dinfo->finfo[i]->view == DIR_VIEW_ON )
			pixname = cxpmgr->style[cxpmgr->styleIndex].treexpm3 ;
		else
		if ( dinfo->finfo[i]->view == DIR_VIEW_OFF )
			pixname = cxpmgr->style[cxpmgr->styleIndex].treexpm2 ;
		else
			pixname = cxpmgr->style[cxpmgr->styleIndex].treexpm1 ;

		pixmap = gdk_pixmap_create_from_xpm_d(
			cxpmgr->window->window,
			&mask, &style->bg[GTK_STATE_NORMAL],
			(gchar **)MakeXPMdata(pixname, nx ) );

		gtk_clist_set_pixtext( GTK_CLIST(cxpmgr->clist1),
			(*totalcount),	/* row    */
			0,		/* collum */
			setname,	/* text   */
			2,		/* spacing size */
			pixmap,		/* pixmap */
			mask );		/* mask */

		dinfo->finfo[i]->row = (*totalcount) ;
	    }else
	    if ( viewrow == *totalcount )
	    {
		for(m=cxpmgr->totalCount-1;m>viewrow;m--)
		{
		    gtk_clist_remove( GTK_CLIST(cxpmgr->clist1), m );
		}
	    }

	    (*totalcount)++;

	    if ( dinfo->finfo[i]->view == DIR_VIEW_ON )
	    {
		if ( dinfo->finfo[i]->next != NULL )
		{
		    printDirectoryLight(
			(DINFO *)dinfo->finfo[i]->next, nx,
			totalcount, viewrow );
		}else{
		    ;
		}
	    }
        }
}

FINFO *getDirectoryInfoRow( dinfo, row )
DINFO		*dinfo ;
int		row ;
{
        int     i, k ;

        for(i=0;i<dinfo->count;i++)
        {
#ifdef DEBUG
fprintf(stdout,"cr [%d] row [%d] view [%d] fname [%s]\n",
row, dinfo->finfo[i]->row, dinfo->finfo[i]->view, dinfo->finfo[i]->fname );
#endif
		if ( dinfo->finfo[i]->row == row )
			return( (FINFO *)dinfo->finfo[i] ) ;

		if ( dinfo->finfo[i]->view == DIR_VIEW_ON )
		{
                    if ( dinfo->finfo[i]->next != NULL )
		    {
			FINFO *finfo ;

			finfo = (FINFO *)getDirectoryInfoRow(
				(DINFO *)dinfo->finfo[i]->next, row);
			if ( finfo != (FINFO *)NULL )
				return(finfo);
		    }
		}
        }
	return( (FINFO *)NULL );
}

FINFO *getDirectoryInfoName( dinfo, fname, row )
DINFO		*dinfo ;
char		*fname ;
int		*row ;
{
        int     i, k ;

        for(i=0;i<dinfo->count;i++)
        {
		if ( strcmp(dinfo->finfo[i]->fname,fname) == 0 )
		{
			*row = dinfo->finfo[i]->row ;
			return( (FINFO *)&dinfo->finfo[i] ) ;
		}

		if ( dinfo->finfo[i]->view == DIR_VIEW_ON )
		{
                    if ( dinfo->finfo[i]->next != NULL )
		    {
			FINFO *finfo ;

			finfo = (FINFO *)getDirectoryInfoName(
				(DINFO *)dinfo->finfo[i]->next, fname, row);
			if ( finfo != NULL )
				return(finfo);
		    }
		}
        }
	return( (FINFO *)NULL );
}

void DirectoryRemove( dinfo, row )
DINFO	*dinfo ;
int	row ;
{
	gtk_clist_clear( GTK_CLIST(cxpmgr->clist1) );
}
