/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern	CxpMgr    *cxpmgr;

void editfunc_copy()
{
  char filename[2048];
  FINFO	*finfo ;
  FILE	*fp ;
  int   i , k ;

  k=0;
  for(i=0;i<cxpmgr->fsView.count;i++)
  {
      if ( cxpmgr->select.row[i] == 0 )
	  continue ;
      k++;
  }

  if ( cxpmgr->cutbuff.count > 0 )
  {
	for(i=0;i<cxpmgr->cutbuff.count;i++)
	{
	    if ( (FINFO *)cxpmgr->cutbuff.finfo[i] != NULL )
	    {
                free( cxpmgr->cutbuff.finfo[i] );
                cxpmgr->cutbuff.finfo[i] = (FINFO *)NULL ;
	    }
	}
   }

  if ( k > 0 )
  {

	k=0;
	for(i=0;i<cxpmgr->fsView.count;i++)
	{
	    if ( cxpmgr->select.row[i] == 0 )
		continue ;

	    finfo = (FINFO *)getFileInfoRow( &cxpmgr->fsView, i );
	    if ( finfo == (FINFO *)NULL )
		continue ;

            cxpmgr->cutbuff.finfo[k] = (FINFO *)malloc( sizeof(FINFO) );
	    memcpy( cxpmgr->cutbuff.finfo[k], finfo, sizeof(FINFO) );
	    k++;
	}
	cxpmgr->cutbuff.count = k ;

	if ( k <= 0 )
	{
	    /* ԡʤ򥻥å */
	    cxpmgr->cutbuff.flag = CUTBUFF_OFF ;
	}else{
	    /* ԡ󤢤򥻥å */
	    cxpmgr->cutbuff.flag = CUTBUFF_ON ;
	}

  }else{
	/* ԡʤ򥻥å */
	cxpmgr->cutbuff.flag = CUTBUFF_OFF ;
	cxpmgr->cutbuff.count = 0 ;
  }

  /* ԡե¸ */
  sprintf( filename, "%s-%d", CUTBUFF_FILENAME, cxpmgr->uid );
  fp = fopen( filename, "w" );
  if ( fp == NULL )
  {
	/* ԡǽưʤ */
	return ;
  }


  fwrite( &cxpmgr->cutbuff.flag,  sizeof(cxpmgr->cutbuff.flag),  1, fp);
  fwrite( &cxpmgr->cutbuff.count, sizeof(cxpmgr->cutbuff.count), 1, fp);
  for( i=0; i<cxpmgr->cutbuff.count; i++)
      fwrite( cxpmgr->cutbuff.finfo[i], sizeof(FINFO),1,fp);
  fclose(fp);

}

static int pastefile( pathname, motoname, basename )
char	*pathname ;	/* ŽդΥե̾ */
char	*motoname ;	/* ŽդȤΥե̾ */
char	*basename ;	/* ŽդȤΥ١̾ */
{
    int    status ;
    int    old, new, n ;
    char   buff[1025] ;
    char   rfilename[1024] ;
    char   wfilename[1024] ;
    struct stat fileinfo ;

    if ( strcmp(cxpmgr->pwdbuff,"/") == 0 )
	sprintf(wfilename,"%s%s", cxpmgr->pwdbuff, pathname );
    else
	sprintf(wfilename,"%s/%s", cxpmgr->pwdbuff, pathname );

    if ( strcmp(basename,"/") == 0 )
	sprintf(rfilename,"%s%s", basename, motoname );
    else
	sprintf(rfilename,"%s/%s", basename, motoname );

    /* ե */
    stat( rfilename, &fileinfo );

    /* ե򥪡ץ */
    if ( (old = open( rfilename, 0 )) < 0 )
    {
	return(-1);
    }

    /* Žդե⡼ɤǥץ */
    if ( (new = creat( wfilename, fileinfo.st_mode)) < 0 )
    {
	close(old);
	return(-2);
    }

    /* 񤭹 */
    while( (n=read(old, buff, 1024)) > 0 )
    {
	if ( write(new,buff,n) != n)
	{
	    close(old);
	    close(new);
	    return(-3);
	}
	if ( n < 0 ){
	    close(new);
	    close(old);
	    return(-4);
	}
    }

    close(old);
    close(new);

    return(0);
}

static int _pasteNextFile( char *dptr, char *bptr )
{
    char	pathname[1024] ;
    char	pathname2[1024] ;
    char	workbuff[1024] ;
    char	work2buff[1024] ;
    int		i, k ;
    int		errstatus, status ;
    mode_t	chmode ;
    struct stat fileinfo ;
    DINFO	*dinfo ;

#ifdef DEBUG
fprintf(stdout,"dirname  [%s]\n", dptr );
fprintf(stdout,"basename [%s]\n", bptr );
fflush(stdout);
#endif

    /*-- ǥ쥯ȥΥץ --*/
    if ( strcmp(bptr,"/")==0 )
	sprintf( workbuff,"%s%s", bptr, dptr );
    else
	sprintf( workbuff,"%s/%s", bptr, dptr );

    dinfo = malloc( sizeof(DINFO) );
    memset( dinfo, 0x00, sizeof(DINFO) );
    dinfo->count = 0 ;
    if ( getFileInfoByNameOnlyName( dinfo, workbuff ) < 0 )
    {
	free(dinfo);
	return(-1);
    }

    if ( strcmp(cxpmgr->pwdbuff,"/") == 0 )
	sprintf(work2buff,"%s%s", cxpmgr->pwdbuff, dptr );
    else
	sprintf(work2buff,"%s/%s", cxpmgr->pwdbuff, dptr );
    if ( access( work2buff, F_OK ) )
    {
	stat( workbuff, &fileinfo );
#if 0
	status = mkdir ( work2buff, fileinfo.st_mode );
#else
	chmode = S_IRUSR | S_IWUSR | S_IXUSR | S_IRGRP | S_IWGRP | S_IXGRP | S_IROTH | S_IWOTH | S_IXOTH ;
	status = mkdir ( work2buff, chmode );
#endif
	if ( status != 0 )
	{
		free(dinfo);
		return(-1);
	}
    }

    /*-- ǥ쥯ȥɤ߹ --*/
    k = 0 ;
    errstatus = 0 ;

    for(i=0; i<dinfo->count; i++)
    {
	if ( strcmp( dptr,"/" ) == 0 )
	{
		sprintf( pathname2, "%s%s", dptr, dinfo->finfo[i]->fname );
		sprintf( pathname,  "%s%s", dptr, dinfo->finfo[i]->fname );
	}else{
		sprintf( pathname2,"%s/%s/%s", bptr, dptr,
						dinfo->finfo[i]->fname );
		sprintf( pathname, "%s/%s", dptr, dinfo->finfo[i]->fname );
	}

	stat( pathname2, &fileinfo );

	/* ǥ쥯ȥǤʤϤΤޤŽդ */
	if ( !S_ISDIR( fileinfo.st_mode ) )
	{
#ifdef DEBUG
fprintf(stdout,"    file paste [%s]\n", pathname);
#endif
		status = pastefile( pathname, pathname, bptr );
		if ( status != 0 )
			errstatus = -1 ;
	}else{
#ifdef DEBUG
fprintf(stdout,"    dir  paste [%s]\n", pathname);
#endif
		/* ǥ쥯ȥξ˥ǥ쥯ȥ */
		if ( strcmp(cxpmgr->pwdbuff,"/") == 0 )
		    sprintf(workbuff,"%s%s", cxpmgr->pwdbuff, pathname );
		else
		    sprintf(workbuff,"%s/%s", cxpmgr->pwdbuff, pathname );

		status = _pasteNextFile( &pathname[0], bptr );
		if ( status != 0 )
			errstatus = -1 ;
	}
    }

    free(dinfo);

    return(errstatus);
}

void pasteOverfunc ( filename, basename )
char	*filename ;
char	*basename ;
{
	int	status ;
	char	workbuff[1024] ;

	status = _pasteNextFile( filename, basename );
	if ( status != 0 )
	{
	    if ( strcmp( basename,"/") == 0 )
		sprintf( workbuff, "%s%s", basename, filename );
	    else
		sprintf( workbuff, "%s/%s", basename, filename );

	    messageView(
		"Žդ顼", "", "Ĥ",
		"ǥ쥯ȥŽդ˼Ԥޤ",
		workbuff, NULL );
	    return ;
	}else{
	    /* ɽ򹹿 */
#if 0
	    CxpDirView( "" );
#else
	    CxpDirView( cxpmgr->pwdbuff );
#endif
	}
}

void editfunc_paste()
{
  DINFO	*dinfo ;
  FILE	*fp ;
  int	status ;
  int	icnt , i, k;
  char	workbuff[2048] ;
  char	filename[2048] ;
  char	motoname[2048] ;
  char	basename[2048] ;
  char	destname[2048] ;
  char	checkname[2048] ;
  char	pastename[2048] ;
  char	*ptr ;

  /* ԡե뤫ɤ߹ */
  sprintf( filename, "%s-%d", CUTBUFF_FILENAME, cxpmgr->uid );
  fp = fopen( filename, "r" );
  if ( fp == NULL )
  {
	/* ԡʤ */
	return ;
  }

  for( i=0; i<cxpmgr->cutbuff.count; i++)
  {
      if ( (FINFO *)cxpmgr->cutbuff.finfo[i] != (FINFO *)NULL )
      {
          free ( (char *)cxpmgr->cutbuff.finfo[i] );
          cxpmgr->cutbuff.finfo[i] = (FINFO *)NULL ;
      }
  }

  fread( &cxpmgr->cutbuff.flag,  sizeof(cxpmgr->cutbuff.flag), 1,fp);
  fread( &cxpmgr->cutbuff.count, sizeof(cxpmgr->cutbuff.count),1,fp);
  for( i=0; i<cxpmgr->cutbuff.count; i++)
  {
      cxpmgr->cutbuff.finfo[i] = (FINFO *)malloc( sizeof(FINFO) );
      fread( cxpmgr->cutbuff.finfo[i], sizeof(FINFO),1,fp);
  }

  fclose(fp);

  memset( filename, 0x00, sizeof(filename));
  memset( basename, 0x00, sizeof(basename));

  if ( cxpmgr->cutbuff.flag == CUTBUFF_ON )
  {
	/* ǽ񤭹߲ǽѡߥåå */
	status = checkPermission( cxpmgr->pwdbuff, cxpmgr->uid, cxpmgr->gid ) ;
	if ( status )
	{
		messageView(
			"Žդ顼", "", "Ĥ",
			"񤭹ߵĤޤ",
			"", NULL );
		return ;
	}

	for(i=0;i<cxpmgr->cutbuff.count;i++)
	{
	  strcpy( workbuff, cxpmgr->cutbuff.finfo[i]->fname );

	  ptr = strrchr( workbuff, '/' );
	  if ( ptr == NULL )
	  {
		strcpy( filename, workbuff );
		strcpy( motoname, workbuff );
		strcpy( basename, "/" );
	  }else{
		strcpy( filename, ptr+1 );
		strcpy( motoname, ptr+1 );
		*ptr = 0x00 ;
		strcpy( basename, workbuff );
	  }

	  if ( S_ISDIR( cxpmgr->cutbuff.finfo[i]->mode ) )
	  {
	    /* ǥ쥯ȥŽդ */
	    if ( strcmp( cxpmgr->pwdbuff,"/")==0)
	    	sprintf( workbuff,"%s%s", cxpmgr->pwdbuff, motoname );
	    else
	    	sprintf( workbuff,"%s/%s",cxpmgr->pwdbuff, motoname );

	    if ( access ( workbuff, F_OK ) )
	    {

		/* ǥ쥯ȥ꤬¸ߤʤϤΤޤŽդ */
		status = _pasteNextFile( &filename[0], &basename[0] );
		if ( status != 0 )
		{
		    messageView(
			"Žդ顼", "", "Ĥ",
			"ǥ쥯ȥŽդ˼Ԥޤ",
			workbuff, NULL );
		    return ;
		}else{
		    /* ɽ򹹿 */
#if 0
		    CxpDirView( "" );
#else
		    CxpDirView( cxpmgr->pwdbuff );
#endif
		}
	    }else{
		/* ǥ쥯ȥ꤬¸ߤϳǧå */
		messagePasteOver(
			"Žդǧ", "", "",
			"˥ǥ쥯ȥ꤬¸ߤޤ",
			"񤭤ŽդƤǤ",
			filename, basename, pasteOverfunc );
		return ;
	    }

	  }else{
	    /* եŽդ */
	    /* եŽդƱ̾ξ */
	    /* ƬcpĤ */

	    dinfo = malloc( sizeof(DINFO) );
	    memset( dinfo, 0x00, sizeof(DINFO) );
            dinfo->count = 0 ;

	    /* ڡȤ֤Υե */
	    if ( getFileInfoByName( dinfo, cxpmgr->pwdbuff ) < 0 )
	    {
		free(dinfo);
		/* ǥ쥯ȥ꤬ץǤʤϥڡȤʤ */
		messageView(
			"Žդ顼", "", "Ĥ",
			"ǥ쥯ȥμ˼Ԥޤ",
			cxpmgr->pwdbuff, NULL );
		return ;
	    }

	    /* Ʊ̾뤫å */
	    status = 1 ;
	    for(; status != 0 ;){
		status = 0 ;
		for(icnt=0;icnt<dinfo->count; icnt++)
		{
		    strcpy( workbuff, dinfo->finfo[icnt]->fname );
		    ptr = strrchr( workbuff, '/' );
		    if ( ptr == NULL )
			sprintf( checkname, "%s", workbuff );
		    else
			sprintf( checkname, "%s", ptr+1 );

		    if ( strcmp( filename, checkname) == 0 )
		    {
			status = 1 ;
			break;
		    }
		}
		/* Ʊ̾ */
		if ( status == 1 )
		{
		    if ( strlen(filename) >= 255 - 4  )
		    {
			free(dinfo);
			/* ̾255ʸۤϽʤ */
			messageView(
			    "Žդ顼", "", "Ĥ",
			    "ե̾ʸۤƤޤޤ",
			    filename, NULL );
			return ;
		    }
		    strcpy( workbuff, filename );
		    sprintf( filename, "%s%s", "cp_", workbuff );
		}
	    }
	    free(dinfo);

	    /* Žդե̾ */
	    status = pastefile( filename, motoname, basename ) ;
	    if ( status != 0 )
	    {
		messageView(
			"Žդ顼", "", "Ĥ",
			"Žդ˼Ԥޤ",
			"", NULL );
	    }else{
		/* ɽ򹹿 */
#if 0
		CxpDirView( "" );
#else
		CxpDirView( cxpmgr->pwdbuff );
#endif
	    }
	  }
	}
  }else{
	messageView(
		"Žդ顼", "", "Ĥ",
		"Žդե뤬ޤ",
		"", NULL );
  }
}
