/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern	CxpMgr    *cxpmgr;

void newfilefunc( filename )
char	*filename ;
{
	FILE	*fp ;
	char	workbuff[1024] ;

	sprintf( workbuff, "%s/%s", cxpmgr->pwdbuff, filename );

	/* ե */
	fp = fopen( workbuff, "w" );
	fclose(fp);

	/* ɽ */
	CxpDirView( "" );
}

void renamefunc( filename )
char	*filename ;
{
    FILE	*fp ;
    FINFO	*finfo ;
    char	workbuff[1024] ;
    int		status ;
    int		i ;

    for(i=0;i<cxpmgr->fsView.count;i++)
    {
	if ( cxpmgr->select.row[i] == 0 )
		continue ;

	/* ̾ѹ¹ */
	finfo = (FINFO *)getFileInfoRow( &cxpmgr->fsView, i );
	if ( finfo != (FINFO *)NULL )
	{
#ifdef	DEBUG
	    fprintf(stdout,"basename [%s]\n", finfo->fname );
	    fprintf(stdout,"filename [%s]\n", filename );
#endif

	    /* ̾ѹ */
	    status = rename ( finfo->fname, filename );
	    if ( status != 0 )
	    {
		/* ̾ѹ˼ */
		messageView(
			"̾ѹ顼","","Ĥ",
			"̾ѹ˼Ԥޤ",
			strerror(errno), NULL );
	    }
	}
    }

    /* ɽ */
    CxpDirView( "" );
}

void newdirfunc( dirname )
char	*dirname ;
{
	FILE	*fp ;
	char	workbuff[1024] ;
	int	status ;

	sprintf( workbuff, "%s/%s", cxpmgr->pwdbuff, dirname );

	/* ǥ쥯ȥ */
	status = mkdir ( workbuff, 0755 );
	if ( status != 0 )
	{
	    /* ǥ쥯ȥκ˼ */
	    messageView(
			"ǥ쥯ȥ顼","","Ĥ",
			"ǥ쥯ȥκ˼Ԥޤ",
			strerror(errno), NULL );
	}

	/* ɽ */
	CxpDirView( "" );
}

void filefunc_newcxp( dirname)
char	*dirname ;
{
	chdir( dirname );
	system("cxplorer &");
}
void filefunc_newfile()
{
    int	status ;

    status = checkPermission( cxpmgr->pwdbuff,cxpmgr->uid,cxpmgr->gid );
    if ( status != 0 )
    {
	/* 񤭹ߵĤʤ */
	messageView(
		"ե顼", "", "Ĥ",
		"񤭹ߵĤޤ",
		"", NULL );
	return ;
    }

    messageNewFile(
	"ե", "", "",
	"ե̾ϤƤ",
	newfilefunc );
}
void filefunc_newdir()
{
    int	status ;

    status = checkPermission( cxpmgr->pwdbuff,cxpmgr->uid,cxpmgr->gid );
    if ( status != 0 )
    {
	/* 񤭹ߵĤʤ */
	messageView(
		"ǥ쥯ȥ顼","","Ĥ",
		"񤭹ߵĤޤ",
		"", NULL );
	return ;
    }

    messageNewFile(
	"ǥ쥯ȥ", "", "",
	"ǥ쥯ȥ̾ϤƤ",
	newdirfunc );
}

int deleteNextFile( dirname )
char *dirname ;
{
    DIR		*dfd;
    struct dirent *dp ;
    char	pathname[1024] ;
    int		i, k ;
    int		errstatus, status ;
    struct stat fileinfo ;

    /*-- ǥ쥯ȥΥץ --*/
    if ( (dfd = opendir(dirname)) == NULL )
	return(-1);

    /*-- ǥ쥯ȥɤ߹ --*/
    k = 0 ;
    errstatus = 0 ;
    for(i=0; (dp = readdir(dfd)) != NULL; i++)
    {
	if ( !strcmp( dp->d_name, "." ) || !strcmp( dp->d_name, "..") )
		continue ;

	if ( strcmp( dirname,"/" ) == 0 )
		sprintf( pathname,"%s%s", dirname, dp->d_name );
	else
		sprintf( pathname,"%s/%s", dirname, dp->d_name );
	stat( pathname, &fileinfo );

	/* ǥ쥯ȥǤʤϺ */
	if ( !S_ISDIR( fileinfo.st_mode ) )
	{
#ifdef DEBUG
fprintf(stdout,"    file delete [%s]\n", pathname);
#endif
		status = remove( pathname );
		if ( status != 0 )
			errstatus = -1 ;
	}else{
		/* ǥ쥯ȥξΥե˺ */
		status = deleteNextFile( pathname );
		if ( status < 0 )
		{
			/* 顼ξϥǥ쥯ȥʤ */
			errstatus = -1 ;
		}else{
			/* եǥ쥯ȥ */
#ifdef DEBUG
fprintf(stdout,"    dir  delete [%s]\n", pathname);
#endif
			status = remove( pathname );
			if ( status != 0 )
				errstatus = -1 ;
		}
	}
    }

    /*-- ǥ쥯ȥΥ --*/
    closedir(dfd);

    return(errstatus);
}

void deletefunc()
{
    FINFO *finfo ;
    int	status ;
    int i ;


#ifdef	DEBUG
fprintf(stdout,"cxpmgr->fsView.count -> [%d]\n",cxpmgr->fsView.count);
#endif

    for(i=0;i<cxpmgr->fsView.count;i++)
    {
#ifdef	DEBUG
fprintf(stdout,"cxpmgr->select.row[%d]  -> [%d]\n", i, cxpmgr->select.row[i]);
fflush(stdout);
#endif

	if ( cxpmgr->select.row[i] == 0 )
		continue ;

	/* ¹ */
	finfo = (FINFO *)getFileInfoRow( &cxpmgr->fsView, i );
	if ( finfo != (FINFO *)NULL )
	{
	    if ( !S_ISDIR( finfo->mode ) )
	    {
#ifdef DEBUG
fprintf(stdout,"file delete .... [%s] \n", finfo->fname );
#endif
		/* ե */
		status = remove( finfo->fname );
		if ( status != 0 )
		{
    		    /* ɽ򹹿 */
		    viewfunc_update();

		    /* ˼Ԥޤ */
		    messageView(
			"顼", "", "Ĥ",
			"˼Ԥޤ",
			"", NULL );
		    return ;
		}
	    }else{
#ifdef DEBUG
fprintf(stdout,"directory delete .... [%s] \n", finfo->fname );
#endif
		/* ǥ쥯ȥ */
		status = deleteNextFile( finfo->fname );
		if ( status == 0 )
		status = remove( finfo->fname );
		if ( status != 0 )
		{
    		    /* ɽ򹹿 */
		    viewfunc_update();

		    /* ˼Ԥޤ */
		    messageView(
			"顼", "", "Ĥ",
			"Ǥʤե뤬ޤ",
			"", NULL );
		    return ;
		}
	    }
	}
    }
    /* ɽ򹹿 */
    viewfunc_update();
}

void filefunc_delete()
{
  FINFO	*finfo ;
  int	status ;
  int	i , k;

  k=0;
  for(i=0;i<cxpmgr->fsView.count;i++)
  {
	if ( cxpmgr->select.row[i] == 0 )
		continue ;
	k++;
  }

  if ( k > 0 )
  {
	status = checkPermission( cxpmgr->pwdbuff,cxpmgr->uid,cxpmgr->gid );
	if ( status != 0 )
	{
		/* 񤭹ߵĤʤ */
		messageView(
			"顼", "", "Ĥ",
			"񤭹ߵĤޤ",
			"", NULL );
		return ;
	}

	if ( k <= 0 )
	{
		/* Τޤ */
		messageView(
			"顼", "", "Ĥ",
			"ե뤬ޤ",
			"", NULL );
		return ;
	}

	if ( k == 1 )
	{
		/* ǧɽ */
		messageView(
			"ǧ", "", "",
			"Υեޤ",
			"", deletefunc );
	}else{
		char kensu[128] ;

		sprintf(kensu,"%dΥեޤ", k );
		/* ǧɽ */
		messageView(
			"ǧ", "", "",
			kensu,
			"", deletefunc );
	}

  }else{
	messageView(
		"顼", "", "Ĥ",
		"ե뤬ޤ",
		"", NULL );
  }
}
void filefunc_rename()
{
  FINFO	*finfo ;
  int	status ;
  int	i , k;

  k=0;
  for(i=0;i<cxpmgr->fsView.count;i++)
  {
	if ( cxpmgr->select.row[i] == 0 )
		continue ;
	k++;
  }

  if ( k == 1 )
  {
	status = checkPermission( cxpmgr->pwdbuff,cxpmgr->uid,cxpmgr->gid );
	if ( status != 0 )
	{
		/* 񤭹ߵĤʤ */
		messageView(
			"̾ѹ顼","","Ĥ",
			"񤭹ߵĤޤ",
			"", NULL );
		return ;
	}

	for(i=0;i<cxpmgr->fsView.count;i++)
	{
		if ( cxpmgr->select.row[i] == 0 )
			continue ;

		break ;
	}
	finfo = (FINFO *)getFileInfoRow( &cxpmgr->fsView, i );
	if ( finfo == (FINFO *)NULL )
	{
		/* ̾ѹե뤬ʤ */
		messageView(
			"̾ѹ顼","","Ĥ",
			"̾ѹե뤬ޤ",
			"", NULL );
		return ;
	}

	/* ̾ѹɽ */
	messageRename(
		"̾ѹ", "ѹ","",
		"̾ѹƤ",
		finfo->fname, renamefunc );

  }else{
	if ( k == 0 )
	{
	    messageView(
		"̾ѹ顼","","Ĥ",
		"̾ѹե뤬򤵤Ƥޤ",
		"", NULL );
	}else{
	    messageView(
		"̾ѹ顼","","Ĥ",
		"ʣ̾ϰ٤ѹǤޤ",
		"", NULL );
	}
  }
}
void filefunc_propaty()
{
    FINFO	*finfo ;
    int		i ;

    for(i=0;i<cxpmgr->fsView.count;i++)
    {
#ifdef	DEBUG
fprintf(stdout,"cxpmgr->select.row[%d] --> [%d]\n",
i,cxpmgr->select.row[i]);
fflush(stdout);
#endif

	if ( cxpmgr->select.row[i] == 0 )
		continue ;

	finfo = (FINFO *)getFileInfoRow( &cxpmgr->fsView, i );
	if ( finfo != (FINFO *)NULL )
	{
	    propatyView (
		"ե",
		"",  "Ĥ",
		finfo );
	}
    }
}
void filefunc_close()
{
    int gx,gy,gw,gh ;
    int x,y,w,h ;
    int xymode, whmode ;

    getGeometryInfo( CXPLORER_MODE, &xymode, &whmode, &x, &y, &w, &h );

    gdk_window_get_position( cxpmgr->window->window, &gx, &gy );
    gdk_window_get_size( cxpmgr->window->window, &gw, &gh );

    if ( xymode == 0 ) /* ΰ */
    {
	x = gx ;
	y = gy ;
    }
    if ( whmode == 0 ) /* Υ */
    {
	w = gw ;
	h = gh ;
    }
   
    setGeometryInfo( CXPLORER_MODE, xymode, whmode, x, y, w, h );

    gtk_main_quit();
}
