/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpMgr    *cxpmgr;

/*
 * filename sort function
 */
static void quicksort_fname ( FINFO *dat[], int first, int last )
{
	int   i, j ;
	FINFO x, t ;

	memcpy( &x, dat[(first + last)/2], sizeof(FINFO) );
	i = first ;
	j = last ;
	for(;;)
	{
	    if ( cxpmgr->sortno == 0 )
	    {
		while( strcmp( x.fname, dat[i]->fname ) > 0 ) i++;
		while( strcmp( dat[j]->fname, x.fname ) > 0 ) j--;
	    }else{
		while( strcmp( x.fname, dat[i]->fname ) < 0 ) i++;
		while( strcmp( dat[j]->fname, x.fname ) < 0 ) j--;
	    }
	    if ( i >= j ) break ;
	    memcpy( &t, dat[i], sizeof(FINFO) );
	    memcpy( dat[i], dat[j], sizeof(FINFO) );
	    memcpy( dat[j], &t, sizeof(FINFO) );
	    i++;
	    j--;
	}

	if ( first < i - 1 ) quicksort_fname( dat, first, i - 1 );
	if ( j + 1 < last  ) quicksort_fname( dat, j + 1, last );
}

/*
 * size sort function
 */
static void quicksort_size ( FINFO *dat[], int first, int last )
{
	int   i, j ;
	FINFO x, t ;

	memcpy( &x, dat[(first + last)/2], sizeof(FINFO) );
	i = first ;
	j = last ;
	for(;;)
	{
	    if ( cxpmgr->sortno == 2 )
	    {
		while( dat[i]->size < x.size ) i++;
		while( x.size < dat[j]->size ) j--;
	    }else{
		while( dat[i]->size > x.size ) i++;
		while( x.size > dat[j]->size ) j--;
	    }
	    if ( i >= j ) break ;
	    memcpy( &t, dat[i], sizeof(FINFO) );
	    memcpy( dat[i], dat[j], sizeof(FINFO) );
	    memcpy( dat[j], &t, sizeof(FINFO) );
	    i++;
	    j--;
	}

	if ( first < i - 1 ) quicksort_size( dat, first, i - 1 );
	if ( j + 1 < last  ) quicksort_size( dat, j + 1, last );
}

/*
 * date sort function
 */
static void quicksort_date ( FINFO *dat[], int first, int last )
{
	int   i, j ;
	FINFO x, t ;

	memcpy( &x, dat[(first + last)/2], sizeof(FINFO) );
	i = first ;
	j = last ;
	for(;;)
	{
	    if ( cxpmgr->sortno == 6 )
	    {
		while( dat[i]->time < x.time ) i++;
		while( x.time < dat[j]->time ) j--;
	    }else{
		while( dat[i]->time > x.time ) i++;
		while( x.time > dat[j]->time ) j--;
	    }
	    if ( i >= j ) break ;
	    memcpy( &t, dat[i], sizeof(FINFO) );
	    memcpy( dat[i], dat[j], sizeof(FINFO) );
	    memcpy( dat[j], &t, sizeof(FINFO) );
	    i++;
	    j--;
	}

	if ( first < i - 1 ) quicksort_date( dat, first, i - 1 );
	if ( j + 1 < last  ) quicksort_date( dat, j + 1, last );
}

/*
 * sort function
 *     sort by quick sort.
 *
 * sortno : 0 : filename sort abc...
 *          1 : filename sort zyx...
 *          2 : size sort 1,2,3,...
 *          3 : size sort 10,9,8,...
 *          4 : kind sort abc...
 *          5 : kind sort zyx...
 *          6 : date sort 1999,2000,...
 *          7 : date sort 2000,1999,...
 *
 */
int sortFileInfo( dinfo, sortno )
DINFO		*dinfo ;
int		sortno ;
{
	int	i ;

#ifdef	DEBUG119
fprintf(stdout,"sortFileInfo .... sortno (%d)\n", sortno );
fflush(stdout);
        for(i=0;i<dinfo->count;i++)
	{
fprintf(stdout,"dinfo->fname[%d] %s\n", i, dinfo->finfo[i]->fname);
fflush(stdout);
	}
#endif

	if ( dinfo->count <= 0 )
	{
#ifdef	DEBUG119
fprintf(stdout,"sortFileInfo error .... count is zero\n");
fflush(stdout);
#endif
		return(0);
	}

#ifdef	DEBUG119
fprintf(stdout,"dinfo->count -> %d\n", dinfo->count );
fflush(stdout);
#endif

	if ( dinfo->count <= 1 )
		return(0) ;

	switch( sortno )
	{
	case 0 : /* filename sort abc...     */
	case 1 : /* filename sort zyx...     */
		quicksort_fname ( dinfo->finfo, 0, dinfo->count - 1 );
		break ;
	case 2 : /* size sort 1,2,3,...      */
	case 3 : /* size sort 10,9,8,...     */
		quicksort_size ( dinfo->finfo, 0, dinfo->count - 1 );
		break ;
	case 4 : /* kind sort abc...         */
	case 5 : /* kind sort zyx...         */
		/* un supported */
		break ;
	case 6 : /* date sort 1999,2000,...  */
	case 7 : /* date sort 2000,1999,...  */
		quicksort_date ( dinfo->finfo, 0, dinfo->count - 1 );
		break ;
	default :
		return(-1) ;
	}

        for(i=0;i<dinfo->count;i++)
	    dinfo->finfo[i]->row = i ;
#ifdef	DEBUG119
        for(i=0;i<dinfo->count;i++)
	{
fprintf(stdout,"dinfo->fname[%d] %s\n", i, dinfo->finfo[i]->fname);
fflush(stdout);
	}
#endif

	return(0);
}
