/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpMgr    *cxpmgr;

int getFileInfoByName( dinfo, dirname )
DINFO	*dinfo ;
char	*dirname ;
{
        DIR     *dfd;
        struct dirent *dp ;
        char    pathname[1024] ;
        char    checkname[1024] ;
        int     i, status ;
        struct stat fileinfo ;

#ifdef	DEBUG119
fprintf(stdout,"getFileInfoByName dirname [%s]\n", dirname );
fflush(stdout);
#endif

        /*-- ǥ쥯ȥΥץ --*/
        if ( (dfd = opendir(dirname)) == NULL )
                return( -1 );

        /*-- ǥ쥯ȥɤ߹ --*/
	if ( dinfo->count > 0 )
        {
            for(i=0;i<dinfo->count;i++)
	    {
		if ( dinfo->finfo[i] != (FINFO *)NULL )
		    free( dinfo->finfo[i] );
		dinfo->finfo[i] = (FINFO *)NULL ;
	    }
        }
        dinfo->count = 0 ;
        for(i=0; (dp = readdir(dfd)) != NULL; i++)
        {
		if ( !strcmp( dp->d_name, "." ) || !strcmp( dp->d_name, ".."))
			continue ;

		if ( cxpmgr->cinf.dotFlag == 0 )
		{
		    if ( strmatch( ".*", dp->d_name ) == 0 )
			continue ;
		}

		if ( strcmp( dirname,"/" ) == 0 )
			sprintf( pathname,"%s%s", dirname, dp->d_name );
                else
                        sprintf( pathname,"%s/%s", dirname, dp->d_name );
                stat( pathname, &fileinfo );

                /* ǥ쥯ȥμ */
                dinfo->finfo[dinfo->count] = (FINFO *)malloc( sizeof(FINFO) );
                strcpy( dinfo->finfo[dinfo->count]->fname, pathname );

		/* ե̤ˤ̤ */
                dinfo->finfo[dinfo->count]->kind  = 1 ;

                dinfo->finfo[dinfo->count]->uid   = fileinfo.st_uid ;
                dinfo->finfo[dinfo->count]->gid   = fileinfo.st_gid ;
                dinfo->finfo[dinfo->count]->time  = fileinfo.st_mtime ;
                dinfo->finfo[dinfo->count]->ctime = fileinfo.st_ctime ;
                dinfo->finfo[dinfo->count]->atime = fileinfo.st_atime ;
                dinfo->finfo[dinfo->count]->mode  = fileinfo.st_mode ;
                dinfo->finfo[dinfo->count]->size  = fileinfo.st_size ;

#ifdef	DEBUG120
fprintf(stdout,"dinfo->finfo[%d]->uid   -> %d\n",
dinfo->count, dinfo->finfo[dinfo->count]->uid );
fprintf(stdout,"dinfo->finfo[%d]->gid   -> %d\n",
dinfo->count, dinfo->finfo[dinfo->count]->gid );
fprintf(stdout,"dinfo->finfo[%d]->time  -> %d\n",
dinfo->count, dinfo->finfo[dinfo->count]->time );
fprintf(stdout,"dinfo->finfo[%d]->ctime -> %d\n",
dinfo->count, dinfo->finfo[dinfo->count]->ctime );
fprintf(stdout,"dinfo->finfo[%d]->atime -> %d\n",
dinfo->count, dinfo->finfo[dinfo->count]->atime );
fprintf(stdout,"dinfo->finfo[%d]->mode  -> %d\n",
dinfo->count, dinfo->finfo[dinfo->count]->mode );
fprintf(stdout,"dinfo->finfo[%d]->size  -> %d\n",
dinfo->count, dinfo->finfo[dinfo->count]->size );
#endif

                (dinfo->count)++;
        }

        /*-- ǥ쥯ȥΥ --*/
        closedir(dfd);

	return( dinfo->count );
}

int getFileInfoByNameOnlyName( dinfo, dirname )
DINFO	*dinfo ;
char	*dirname ;
{
        DIR     *dfd;
        struct dirent *dp ;
        char    pathname[1024] ;
        char    checkname[1024] ;
        int     i, status ;
        struct stat fileinfo ;


        /*-- ǥ쥯ȥΥץ --*/
        if ( (dfd = opendir(dirname)) == NULL )
                return( -1 );

        /*-- ǥ쥯ȥɤ߹ --*/
	if ( dinfo->count > 0 )
        {
            for(i=0;i<dinfo->count;i++)
	    {
		if ( dinfo->finfo[i] != (FINFO *)NULL )
		    free( dinfo->finfo[i] );
		dinfo->finfo[i] = (FINFO *)NULL;
	    }
        }
        dinfo->count = 0 ;
        for(i=0; (dp = readdir(dfd)) != NULL; i++)
        {
		if ( !strcmp( dp->d_name, "." ) || !strcmp( dp->d_name, ".."))
			continue ;

		if ( cxpmgr->cinf.dotFlag == 0 )
		{
		    if ( strmatch( ".*", dp->d_name ) == 0 )
			continue ;
		}

		if ( strcmp( dirname,"/" ) == 0 )
			sprintf( pathname,"%s%s", dirname, dp->d_name );
                else
                        sprintf( pathname,"%s/%s", dirname, dp->d_name );
                stat( pathname, &fileinfo );

                /* ǥ쥯ȥμ */
                dinfo->finfo[dinfo->count] = (FINFO *)malloc( sizeof(FINFO) );
                strcpy( dinfo->finfo[dinfo->count]->fname, dp->d_name );

		/* ե̤ˤ̤ */
                dinfo->finfo[dinfo->count]->kind  = 1 ;

                dinfo->finfo[dinfo->count]->uid   = fileinfo.st_uid ;
                dinfo->finfo[dinfo->count]->gid   = fileinfo.st_gid ;
                dinfo->finfo[dinfo->count]->time  = fileinfo.st_mtime ;
                dinfo->finfo[dinfo->count]->ctime = fileinfo.st_ctime ;
                dinfo->finfo[dinfo->count]->atime = fileinfo.st_atime ;
                dinfo->finfo[dinfo->count]->mode  = fileinfo.st_mode ;
                dinfo->finfo[dinfo->count]->size  = fileinfo.st_size ;
                (dinfo->count)++;
        }

        /*-- ǥ쥯ȥΥ --*/
        closedir(dfd);

	return( dinfo->count );
}

FINFO *getFileInfoRow( dinfo, row )
DINFO	*dinfo ;
int	row ;
{
	int	i ;

	for( i=0; i<dinfo->count; i++)
	{
		if ( dinfo->finfo[i]->row == row )
		{
			return( (FINFO *)dinfo->finfo[i] );
		}
	}

	return( (FINFO *)NULL );
}

int printFileInfo( dinfo )
DINFO		*dinfo ;
{
	GdkPixmap	*pixmap ;
	GdkBitmap	*mask;
	GtkStyle	*style;

	char	buffname[1024] ;
	char	pixname[1024] ;
	char	setname[1024] ;
	char	sizename[256] ;
	char	kindname[256] ;
	char	datename[256] ;
	char	*dirname[6];
	char	*ptr ;
	int	size ;
        int     i, k ;

	sortFileInfo( dinfo, cxpmgr->sortno );

        for(i=0;i<dinfo->count;i++)
        {
		cxpmgr->clist2_timeout_start[i] = 0 ;

		strcpy( buffname, dinfo->finfo[i]->fname );
		ptr = strrchr( buffname, '/' );
		if ( ptr == NULL )
			sprintf( setname, "%s", buffname );
		else
			sprintf( setname, "%s", ptr+1 );

		strcpy( kindname,
			(char *)getFileConfigKindName( dinfo->finfo[i] ));

		sprintf( sizename, "%s", getFileConfigSize(dinfo->finfo[i]));

		strcpy( datename,
			(char *)getFileConfigMtime( dinfo->finfo[i] ));

		strcpy( pixname,
			(char *)getFileConfigSPixmapName(dinfo->finfo[i]));

		dirname[0] = g_strdup( setname );
		dirname[1] = g_strdup( sizename );
		dirname[2] = g_strdup( kindname );
		dirname[3] = g_strdup( datename );

		gtk_clist_append( GTK_CLIST(cxpmgr->clist2), dirname );

		style = gtk_widget_get_style( cxpmgr->window );

		pixmap = gdk_pixmap_create_from_xpm_d(
			cxpmgr->window->window,
			&mask, &style->bg[GTK_STATE_NORMAL],
			(gchar **)MakeXPMdata(pixname, 0 ) );

		gtk_clist_set_pixtext( GTK_CLIST(cxpmgr->clist2),
			i,		/* row    */
			0,		/* collum */
			setname,	/* text   */
			2,		/* spacing size */
			pixmap,		/* pixmap */
			mask );		/* mask */

		dinfo->finfo[i]->row = i ;
        }
}

