/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpMgr	*cxpmgr ;


static GtkWidget *funcWin;
static GtkWidget *cList;
static GtkWidget *selCLabel;
static GtkWidget *execCEntry;
static GtkWidget *fList;
static GtkWidget *selFLabel;
static GtkWidget *execFEntry;
static GtkWidget *setBtn;
static GtkWidget *canBtn;

static FUNCTION	function ;
static int clist_select ;
static int flist_select ;

static char *clist_title[2] =
{
	"CNTL-X",
	"¹ԥޥ"
};

static char *flist_title[2] =
{
	"FN-X",
	"¹ԥޥ"
};

static char *getCListName( uint keycode )
{
    switch( keycode )
    {
	case GDK_a : return("CNTL+A");
	case GDK_b : return("CNTL+B");
	case GDK_c : return("CNTL+C");
	case GDK_d : return("CNTL+D");
	case GDK_e : return("CNTL+E");
	case GDK_f : return("CNTL+F");
	case GDK_g : return("CNTL+G");
	case GDK_h : return("CNTL+H");
	case GDK_i : return("CNTL+I");
	case GDK_j : return("CNTL+J");
	case GDK_k : return("CNTL+K");
	case GDK_l : return("CNTL+L");
	case GDK_m : return("CNTL+M");
	case GDK_n : return("CNTL+N");
	case GDK_o : return("CNTL+O");
	case GDK_p : return("CNTL+P");
	case GDK_q : return("CNTL+Q");
	case GDK_r : return("CNTL+R");
	case GDK_s : return("CNTL+S");
	case GDK_t : return("CNTL+T");
	case GDK_u : return("CNTL+U");
	case GDK_v : return("CNTL+V");
	case GDK_w : return("CNTL+W");
	case GDK_x : return("CNTL+X");
	case GDK_y : return("CNTL+Y");
	case GDK_z : return("CNTL+Z");
	default : return("Unknown");
    }
}

static char *getFListName( uint keycode )
{
    switch( keycode )
    {
	case GDK_F1  : return("F1");
	case GDK_F2  : return("F2");
	case GDK_F3  : return("F3");
	case GDK_F4  : return("F4");
	case GDK_F5  : return("F5");
	case GDK_F6  : return("F6");
	case GDK_F7  : return("F7");
	case GDK_F8  : return("F8");
	case GDK_F9  : return("F9");
	case GDK_F10 : return("F10");
	case GDK_F11 : return("F11");
	case GDK_F12 : return("F12");
	default : return("Unknown");
    }
}

static void clist_selection(GtkWidget *clist, gint row, gint column,
		GdkEventButton *event, gpointer data )
{
    if ( row < 0 ) return ;

    clist_select = row;

    /* 򤷤ǡɽ */
    gtk_entry_set_text(GTK_ENTRY(execCEntry), function.cTable[row].execFunc );
    gtk_label_set_text(GTK_LABEL(selCLabel),  getCListName( function.cTable[row].keycode ) );
}
static void clist_unselection(GtkWidget *clist, gint row, gint column,
		GdkEventButton *event, gpointer data )
{
    char	*endat ;

    clist_select = -1 ;

    /* ǡ򹹿 */
    if ( row >= 0 )
    {
	if ((endat = gtk_entry_get_text(GTK_ENTRY(execCEntry))) == NULL )
	{
	    function.cTable[row].execFunc = (char *)"" ;
	}else{
	    function.cTable[row].execFunc = g_strdup(endat) ;
	}
	gtk_clist_set_text( GTK_CLIST(cList), row, 1, function.cTable[row].execFunc );
    }

    /* ˤ */
    gtk_entry_set_text(GTK_ENTRY(execCEntry), "" );
    gtk_label_set_text(GTK_LABEL(selCLabel),  "" );
}
static void flist_selection(GtkWidget *clist, gint row, gint column,
		GdkEventButton *event, gpointer data )
{
    if ( row < 0 ) return ;

    flist_select = row;

    /* 򤷤ǡɽ */
    gtk_entry_set_text(GTK_ENTRY(execFEntry), function.fTable[row].execFunc );
    gtk_label_set_text(GTK_LABEL(selFLabel),  getFListName( function.fTable[row].keycode ) );
}
static void flist_unselection(GtkWidget *clist, gint row, gint column,
		GdkEventButton *event, gpointer data )
{
    char	*endat ;

    flist_select = -1 ;

    /* ǡ򹹿 */
    if ( row >= 0 )
    {
	if ((endat = gtk_entry_get_text(GTK_ENTRY(execFEntry))) == NULL )
	{
	    function.fTable[row].execFunc = (char *)"" ;
	}else{
	    function.fTable[row].execFunc = g_strdup(endat) ;
	}
	gtk_clist_set_text( GTK_CLIST(fList), row, 1, function.fTable[row].execFunc );
    }

    /* ˤ */
    gtk_entry_set_text(GTK_ENTRY(execFEntry), "" );
    gtk_label_set_text(GTK_LABEL(selFLabel),  "" );
}

static void setCallBack(GtkWidget *widget, gpointer data )
{
    int i ;

    cxpmgr->function.maxFNum = function.maxFNum;
    cxpmgr->function.maxCNum = function.maxCNum;

    for(i=0;i<function.maxCNum;i++)
    {
	cxpmgr->function.cTable[i].keycode = function.cTable[i].keycode ;
	cxpmgr->function.cTable[i].execFunc = g_strdup(function.cTable[i].execFunc) ;
    }
    for(i=0;i<function.maxFNum;i++)
    {
	cxpmgr->function.fTable[i].keycode = function.fTable[i].keycode ;
	cxpmgr->function.fTable[i].execFunc = g_strdup(function.fTable[i].execFunc) ;
    }

    setFunctionInfo( &cxpmgr->function );

    gtk_widget_destroy(funcWin);
}

static void canCallBack(GtkWidget *widget, gpointer data )
{
    gtk_widget_destroy(funcWin);
}



int create_funcWin()
{
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *hbox1;
  GtkWidget *vbox3;
  GtkWidget *label3;
  GtkWidget *hbox4;
  GtkWidget *vbox5;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *vbox6;
  GtkWidget *vbox2;
  GtkWidget *label2;
  GtkWidget *hbox5;
  GtkWidget *vbox7;
  GtkWidget *label8;
  GtkWidget *label10;
  GtkWidget *vbox8;
  GtkWidget *hseparator1;
  GtkWidget *hbox2;
  GtkWidget *swinc;
  GtkWidget *swinf;
  int x,y,w,h ;
  char *viewcdata[2] ;
  char *viewfdata[2] ;
  int i ;

  w = gdk_screen_width();
  h = gdk_screen_height();
  x = w * 0.5;
  y = h * 0.5;


  funcWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (funcWin), "funcWin", funcWin);
  gtk_window_set_title (GTK_WINDOW (funcWin), "ե󥯥Ͽ");
  gtk_widget_set_usize(funcWin, 100, 100);
  gtk_window_set_default_size(GTK_WINDOW(funcWin),640,300);
  gtk_widget_set_uposition(funcWin, (x - 640*0.5), (y - 300*0.5) );
  gtk_widget_show(funcWin);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (funcWin), vbox1);

  label1 = gtk_label_new ("ե󥯥Ͽ");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 6);

  hbox1 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox3);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "vbox3", vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox3, TRUE, TRUE, 0);

  label3 = gtk_label_new ("Cntlե󥯥ꥹ");
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (vbox3), label3, FALSE, FALSE, 5);

#if 0
  cList = gtk_list_new ();
  gtk_widget_ref (cList);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "cList", cList,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cList);
  gtk_box_pack_start (GTK_BOX (vbox3), cList, TRUE, TRUE, 0);
#else
  swinc = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swinc),
                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start(GTK_BOX(vbox3), swinc, TRUE, TRUE, 0);
  gtk_widget_show(swinc);
  
  cList = gtk_clist_new_with_titles( 2, clist_title );
  gtk_clist_set_selection_mode(GTK_CLIST(cList),
                        GTK_SELECTION_SINGLE);
  gtk_signal_connect(GTK_OBJECT(cList), "select_row",
                        GTK_SIGNAL_FUNC(clist_selection), NULL); 
  gtk_signal_connect(GTK_OBJECT(cList), "unselect_row",
                        GTK_SIGNAL_FUNC(clist_unselection), NULL);
  gtk_clist_set_column_width(GTK_CLIST(cList), 0, 60);
  gtk_container_add(GTK_CONTAINER(swinc), cList);
  gtk_widget_show(cList);
#endif

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox4);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "hbox4", hbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox4, FALSE, TRUE, 5);

  vbox5 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox5);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "vbox5", vbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox5);
  gtk_box_pack_start (GTK_BOX (hbox4), vbox5, TRUE, TRUE, 0);

  label5 = gtk_label_new ("ե󥯥");
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (vbox5), label5, FALSE, FALSE, 0);

  label6 = gtk_label_new ("ưץࡧ");
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_box_pack_start (GTK_BOX (vbox5), label6, FALSE, FALSE, 0);

  vbox6 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox6);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "vbox6", vbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox6);
  gtk_box_pack_start (GTK_BOX (hbox4), vbox6, TRUE, TRUE, 0);

  selCLabel = gtk_label_new (" ");
  gtk_widget_ref (selCLabel);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "selCLabel", selCLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (selCLabel);
  gtk_box_pack_start (GTK_BOX (vbox6), selCLabel, FALSE, FALSE, 0);

  execCEntry = gtk_entry_new ();
  gtk_widget_ref (execCEntry);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "execCEntry", execCEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (execCEntry);
  gtk_box_pack_start (GTK_BOX (vbox6), execCEntry, FALSE, FALSE, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox2, TRUE, TRUE, 10);

  label2 = gtk_label_new ("Fե󥯥ꥹ");
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox2), label2, FALSE, FALSE, 5);

#if 0
  fList = gtk_list_new ();
  gtk_widget_ref (fList);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "fList", fList,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fList);
  gtk_box_pack_start (GTK_BOX (vbox2), fList, TRUE, TRUE, 0);
#else
  swinf = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swinf),
                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start(GTK_BOX(vbox2), swinf, TRUE, TRUE, 0);
  gtk_widget_show(swinf);
  
  fList = gtk_clist_new_with_titles( 2, flist_title );
  gtk_clist_set_selection_mode(GTK_CLIST(fList),
                        GTK_SELECTION_SINGLE);
  gtk_signal_connect(GTK_OBJECT(fList), "select_row",
                        GTK_SIGNAL_FUNC(flist_selection), NULL); 
  gtk_signal_connect(GTK_OBJECT(fList), "unselect_row",
                        GTK_SIGNAL_FUNC(flist_unselection), NULL);
  gtk_clist_set_column_width(GTK_CLIST(fList), 0, 40);
  gtk_container_add(GTK_CONTAINER(swinf), fList);
  gtk_widget_show(fList);
#endif

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox5);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "hbox5", hbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox5, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox5), 5);

  vbox7 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox7);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "vbox7", vbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox7);
  gtk_box_pack_start (GTK_BOX (hbox5), vbox7, TRUE, TRUE, 0);

  label8 = gtk_label_new ("ե󥯥");
  gtk_widget_ref (label8);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "label8", label8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label8);
  gtk_box_pack_start (GTK_BOX (vbox7), label8, FALSE, FALSE, 0);

  label10 = gtk_label_new ("ưץࡧ");
  gtk_widget_ref (label10);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "label10", label10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10);
  gtk_box_pack_start (GTK_BOX (vbox7), label10, FALSE, FALSE, 0);

  vbox8 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox8);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "vbox8", vbox8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox8);
  gtk_box_pack_start (GTK_BOX (hbox5), vbox8, TRUE, TRUE, 0);

  selFLabel = gtk_label_new (" ");
  gtk_widget_ref (selFLabel);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "selFLabel", selFLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (selFLabel);
  gtk_box_pack_start (GTK_BOX (vbox8), selFLabel, FALSE, FALSE, 0);

  execFEntry = gtk_entry_new ();
  gtk_widget_ref (execFEntry);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "execFEntry", execFEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (execFEntry);
  gtk_box_pack_start (GTK_BOX (vbox8), execFEntry, FALSE, FALSE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator1);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "hseparator1", hseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 5);

  hbox2 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 5);

  setBtn = gtk_button_new_with_label ("  ");
  gtk_widget_ref (setBtn);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "setBtn", setBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (setBtn);
  gtk_box_pack_start (GTK_BOX (hbox2), setBtn, FALSE, FALSE, 0);

  canBtn = gtk_button_new_with_label ("  ");
  gtk_widget_ref (canBtn);
  gtk_object_set_data_full (GTK_OBJECT (funcWin), "canBtn", canBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (canBtn);
  gtk_box_pack_start (GTK_BOX (hbox2), canBtn, FALSE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (setBtn), "clicked",
                (GtkSignalFunc) setCallBack, NULL );
  gtk_signal_connect (GTK_OBJECT (canBtn), "clicked",
                (GtkSignalFunc) canCallBack, NULL );

  memset( &function, 0x00, sizeof(FUNCTION) );

  for(i=0;i<cxpmgr->function.maxCNum;i++)
  {
	function.cTable[i].keycode = cxpmgr->function.cTable[i].keycode ;
	function.cTable[i].execFunc = g_strdup(cxpmgr->function.cTable[i].execFunc) ;

	viewcdata[0] = (char *)getCListName(function.cTable[i].keycode);
	if (function.cTable[i].execFunc == (char *)NULL )
	    viewcdata[1] = (char *)"" ;
	else
	    viewcdata[1] = g_strdup(function.cTable[i].execFunc);

	gtk_clist_append( GTK_CLIST(cList), viewcdata );
  }

  for(i=0;i<cxpmgr->function.maxFNum;i++)
  {
	function.fTable[i].keycode = cxpmgr->function.fTable[i].keycode ;
	function.fTable[i].execFunc = g_strdup(cxpmgr->function.fTable[i].execFunc) ;

	viewfdata[0] = (char *)getFListName(function.fTable[i].keycode);
	if (function.fTable[i].execFunc == (char *)NULL )
	    viewfdata[1] = (char *)"" ;
	else
	    viewfdata[1] = g_strdup(function.fTable[i].execFunc);

	gtk_clist_append( GTK_CLIST(fList), viewfdata );
  }

  function.maxFNum = cxpmgr->function.maxFNum;
  function.maxCNum = cxpmgr->function.maxCNum;

  return(0);
}

