/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpMgr *cxpmgr ;

static char *getFileConfigManager( finfo, mode )
FINFO	*finfo ;
int	mode ;
{
	char	*ptr ;
	int	i ;

	ptr = strrchr( finfo->fname, '.' );

	if ( ptr == NULL )
	{
	   ptr = finfo->fname ;
	}

	for( i=0; i<cxpmgr->appli_kensu; i++ )
	{
		if ( !strcmp( ptr, cxpmgr->appli[i].kakucho ) )
		{
			/* ⡼ɤˤꤵ줿Τ֤ */
			switch( mode )
			{
			case 0 :
				if ( S_ISDIR( finfo->mode ) )
					return( "ǥ쥯ȥ" );
				else
					return( cxpmgr->appli[i].info );
			case 1 :
				return( cxpmgr->appli[i].xpm_small );
			case 2 :
				return( cxpmgr->appli[i].command );
			}
		}
	}

	/* ¸ߤΤʤϥǥեȤ֤ */
	switch( mode )
	{
	case 0 :
		/* ե̤Υå */
		if ( S_ISDIR( finfo->mode ) )
		{
			return( "ǥ쥯ȥ" );
		}else
		if ( S_ISREG( finfo->mode ) )
		{
			if( finfo->mode & S_IEXEC )
				return( "¹ԥե" );
			else
				return( "̤Υե" );
		}else{
			return( "üե" );
		}
	case 1 :
		if ( S_ISDIR( finfo->mode ) )
			return( cxpmgr->style[cxpmgr->styleIndex].filexpm );
		else
			return( cxpmgr->style[cxpmgr->styleIndex].unknown );
	case 2 :
		return( NULL );
	}
}


char *getFileConfigKindName( finfo )
FINFO	*finfo ;
{
	return( (char *)getFileConfigManager( finfo, 0) );
}

char *getFileConfigSPixmapName( finfo )
FINFO	*finfo ;
{
	return( (char *)getFileConfigManager( finfo, 1) );
}

char *getFileConfigApplication( finfo )
FINFO	*finfo ;
{
	return( (char *)getFileConfigManager( finfo, 2) );
}

static char *getFileConfigTimeManager( finfo, ftime, mode )
FINFO	*finfo ;
time_t	ftime ;
int	mode ;
{
	static char youbi[7][3] = { "","","","","","","" };
	struct tm wtm ;
	static char bufftime[256] ;

	memcpy( &wtm, localtime( &ftime ), sizeof(struct tm));

	if ( mode == 0 )
	{
	    sprintf( bufftime,
		"%04d/%02d/%02d(%2.2s) %02d:%02d:%02d ",
		wtm.tm_year + 1900, (wtm.tm_mon+1),
		wtm.tm_mday, youbi[wtm.tm_wday],
		wtm.tm_hour, wtm.tm_min, wtm.tm_sec);
	}else{
	    sprintf( bufftime,
		"%04dǯ%2d%2d(%2.2s) %2d%2dʬ%2d",
		wtm.tm_year + 1900, (wtm.tm_mon+1),
		wtm.tm_mday, youbi[wtm.tm_wday],
		wtm.tm_hour, wtm.tm_min, wtm.tm_sec);
	}

	return( bufftime );
}

char *getFileConfigMtime( finfo )
FINFO	*finfo ;
{
	return( getFileConfigTimeManager( finfo, finfo->time, 0 ) );
}
char *getFileConfigCtime( finfo )
FINFO	*finfo ;
{
	return( getFileConfigTimeManager( finfo, finfo->ctime, 0 ) );
}
char *getFileConfigAtime( finfo )
FINFO	*finfo ;
{
	return( getFileConfigTimeManager( finfo, finfo->atime, 0 ) );
}

char *getFileConfigMtimeJ( finfo )
FINFO	*finfo ;
{
	return( getFileConfigTimeManager( finfo, finfo->time, 1 ) );
}
char *getFileConfigCtimeJ( finfo )
FINFO	*finfo ;
{
	return( getFileConfigTimeManager( finfo, finfo->ctime, 1 ) );
}
char *getFileConfigAtimeJ( finfo )
FINFO	*finfo ;
{
	return( getFileConfigTimeManager( finfo, finfo->atime, 1 ) );
}

char *getFileConfigSize( finfo )
FINFO	*finfo ;
{
	static char sizename[256] ;
	int	size ;


	size = finfo->size ;
	if ( finfo->size >= 1000 * 1000 * 1000 )
	{
	    sprintf( sizename, "%d,%3.03d,%3.03d,%3.03d M",
				(size/(1000*1000*1000))%1000,
				(size/(1000*1000))%1000,
				(size/(1000)%1000),
				(size%1000)  ) ;
	}else
	if ( finfo->size >= 1000 * 1000 )
	{
	    sprintf( sizename, "%d,%3.03d,%3.03d bytes",
				(size/(1000*1000))%1000,
				(size/(1000))%1000,
				(size%1000)  ) ;
	}else
	if ( finfo->size >= 1000 )
	{
	    sprintf( sizename, "%d,%03.3d bytes",
				(size/(1000)),
				(size%1000)  ) ;
	}else
	{
	    sprintf( sizename, "%d bytes", size );
	}

	return( sizename );
}

char *getFileConfigUidName( finfo )
FINFO	*finfo ;
{
	struct passwd	*pwdinfo ;
	static char	uidname[256] ;

	pwdinfo = getpwuid( finfo->uid );
	if ( pwdinfo != NULL )
	{
		sprintf( uidname, "%s", pwdinfo->pw_name );
	}else{
		sprintf( uidname, "Ǥ" );
	}

	return(uidname);
}

char *getFileConfigGidName( finfo )
FINFO	*finfo ;
{
	struct group	*grpinfo ;
	static char	gidname[256] ;

	grpinfo = getgrgid( finfo->gid );
	if ( grpinfo != NULL )
	{
		sprintf(gidname, "%s", grpinfo->gr_name );
	}else{
		sprintf(gidname, "Ǥ" );
	}

	return(gidname);
}

void getFileConfigModeUser( finfo, mode )
FINFO	*finfo ;
int	*mode ;
{
	*(mode+0) = 0 ;
	*(mode+1) = 0 ;
	*(mode+2) = 0 ;

	if ( finfo->mode & 0x0100 ) *(mode+0) = 1 ;
	if ( finfo->mode & 0x0080 ) *(mode+1) = 1 ;
	if ( finfo->mode & 0x0040 ) *(mode+2) = 1 ;
}

void getFileConfigModeGroup( finfo, mode )
FINFO	*finfo ;
int	*mode ;
{
	*(mode+0) = 0 ;
	*(mode+1) = 0 ;
	*(mode+2) = 0 ;

	if ( finfo->mode & 0x0020 ) *(mode+0) = 1 ;
	if ( finfo->mode & 0x0010 ) *(mode+1) = 1 ;
	if ( finfo->mode & 0x0008 ) *(mode+2) = 1 ;
}

void getFileConfigModeOther( finfo, mode )
FINFO	*finfo ;
int	*mode ;
{
	*(mode+0) = 0 ;
	*(mode+1) = 0 ;
	*(mode+2) = 0 ;

	if ( finfo->mode & 0x0004 ) *(mode+0) = 1 ;
	if ( finfo->mode & 0x0002 ) *(mode+1) = 1 ;
	if ( finfo->mode & 0x0001 ) *(mode+2) = 1 ;
}
