/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpMgr    *cxpmgr;

static char *clist1_title[2] = { "ǥ쥯ȥ", };

static char *clist2_title[4] =
{
	"̾",
	"",
	"",
	""
};

#define	SUBMENU_SEND		"ץꥱ"
#define	SUBMENU_NEWFILE		"ե"
#define	SUBMENU_NEWDIR		"ǥ쥯ȥ"
#define	SUBMENU_RENAME		"̾ѹ"
#define	SUBMENU_COPY		"ԡ"
#define	SUBMENU_PASTE		"Žդ"
#define	SUBMENU_DELETE		""
#define	SUBMENU_INFO		"ɽ"

static void titleFnameCallback (GtkWidget *widget, gpointer data )
{
#ifdef	DEBUG119
fprintf(stdout,"titleFnameCallback ... \n" );
fflush(stdout);
#endif

	if ( cxpmgr->sortno == 0 )
	    cxpmgr->sortno = 1 ;
	else
	    cxpmgr->sortno = 0 ;

	CxpDirView( "" ) ;
}
static gint titleSizeCallback (GtkWidget *widget, gpointer data )
{
#ifdef	DEBUG119
fprintf(stdout,"titleSizeCallback ...\n");
fflush(stdout);
#endif

	if ( cxpmgr->sortno == 2 )
	    cxpmgr->sortno = 3 ;
	else
	    cxpmgr->sortno = 2 ;

	CxpDirView( "" ) ;
}
static gint titleDateCallback (GtkWidget *widget, gpointer data )
{
#ifdef	DEBUG119
fprintf(stdout,"titleDateCallback ...\n");
fflush(stdout);
#endif
	if ( cxpmgr->sortno == 6 )
	    cxpmgr->sortno = 7 ;
	else
	    cxpmgr->sortno = 6 ;

	CxpDirView( "" ) ;
}

static void submenu_sendapp (gchar *string)
{
	FINFO	*finfo ;
	char	comm[8192];
	char	buff[8192];
	int	i ;
	int	kensu ;

	memset(buff,0x00,sizeof(buff));
	memset(comm,0x00,sizeof(comm));
	kensu = 0 ;
	for(i=0;i<cxpmgr->fsView.count;i++)
	{
	    if ( cxpmgr->select.row[i] == 0 )
		continue ;
	    kensu++;

	    finfo = (FINFO *)getFileInfoRow( &cxpmgr->fsView, i );
	    if ( finfo == (FINFO *)NULL )
		continue ;

	    strcat(buff, " \"" );
	    strcat(buff, finfo->fname );
	    strcat(buff, "\"" );

	}

	sprintf( comm, "%s %s &", string, buff );

	system( comm );

	return;
}

static void submenu_response (gchar *string)
{
	if ( strcmp( string, SUBMENU_NEWFILE ) == 0 )
	{
		filefunc_newfile();
	}else
	if ( strcmp( string, SUBMENU_NEWDIR ) == 0 )
	{
		filefunc_newdir();
	}else
	if ( strcmp( string, SUBMENU_RENAME ) == 0 )
	{
		filefunc_rename();
	}else
	if ( strcmp( string, SUBMENU_COPY ) == 0 )
	{
		editfunc_copy();
	}else
	if ( strcmp( string, SUBMENU_PASTE ) == 0 )
	{
		editfunc_paste();
	}else
	if ( strcmp( string, SUBMENU_INFO ) == 0 )
	{
		filefunc_propaty();
	}else
	if ( strcmp( string, SUBMENU_DELETE ) == 0 )
	{
		filefunc_delete();
	}
}

static gint clist1_timeout_startfunc( gpointer data )
{
	int	i ;
#ifdef	DEBUG2
fprintf(stdout,"clist_timeout_startfunc start ...\n");
fflush(stdout);
#endif

	if ( (int)*((int *)data) != 0 )
		gtk_timeout_remove( (int)*((int *)data) );
	(int)*((int *)data) = 0 ;
	for(i=0;i<cxpmgr->totalCount;i++)
	{
	    if ( cxpmgr->clist1_timeout_start[i] != 0 )
		gtk_timeout_remove( cxpmgr->clist1_timeout_start[i] );
	}
	return(0);
}
static gint clist2_timeout_startfunc( gpointer data )
{
	int	i ;

	if ( (int)*((int *)data) != 0 )
		gtk_timeout_remove( (int)*((int *)data) );
	(int)*((int *)data) = 0 ;
	for(i=0;i<cxpmgr->fsView.count;i++)
	{
	    if ( cxpmgr->clist2_timeout_start[i] != 0 )
		gtk_timeout_remove( cxpmgr->clist2_timeout_start[i] );
	}
	return(0);
}

static int clist1_selection( clist, row, column, event, data )
GtkWidget      *clist ;
gint            row ;
gint            column ;
GdkEventButton *event ;
gpointer        data ;
{
	static char	*backAddress = NULL ;
	FINFO		*finfo ;
	GdkPixmap	*pixmap ;
	GdkBitmap	*mask;
	gchar		*text;
	guint8		spacing ;
	int		dirViewFlag ;
	int		i ;

#ifdef DEBUG5
fprintf(stdout,"clist1_selection row [%d] pwd [%s]\n",
row, cxpmgr->pwdbuff );
fflush(stdout);
#endif

	/* ɽιߤꤵƤϹʤ */
	if ( cxpmgr->currentViewFlag == 1 )
	    return(0);

	if ( row < 0 )
	    return(0) ;

#ifdef	DEBUG2
fprintf(stdout,"cxpmgr->clist1_timeout_start[%d] -> [%d]\n",
	row,cxpmgr->clist1_timeout_start[row] );
fflush(stdout);
#endif

	cxpmgr->clist1_selection = row ;

	finfo = (FINFO *)getDirectoryInfoRow(
			&cxpmgr->fsInfo.root, row );
	strcpy( cxpmgr->pwdbuff, finfo->fname );
#ifdef DEBUG5
fprintf(stdout,"clist1_selection step1 row [%d] pwdbuff [%s]\n",
row, cxpmgr->pwdbuff );
fflush(stdout);
#endif

	dirViewFlag = 0 ;
	if ( backAddress != NULL )
	{
	    if ( strcmp( backAddress, cxpmgr->pwdbuff ) != 0 )
		dirViewFlag = 1 ;
	}else{
		dirViewFlag = 1 ;
	}

	if ( dirViewFlag )
	{
	    /* ɥ쥹˸ߤɽ֤򥻥å */
	    gtk_entry_set_text( GTK_ENTRY(cxpmgr->address),
			cxpmgr->pwdbuff );

	    /* ¸ */
	    backAddress = (char *)g_strdup(cxpmgr->pwdbuff);

	    /* ɽ */
	    gtk_clist_freeze( GTK_CLIST(cxpmgr->clist2) );

	    /* եκ */
	    memset( &(cxpmgr->select),0x00,sizeof(SELECTINFO));
	    gtk_clist_clear( GTK_CLIST(cxpmgr->clist2) );
	    if ( getFileInfoByName( &cxpmgr->fsView, cxpmgr->pwdbuff ) )
	    {
		printFileInfo( &cxpmgr->fsView );
	    }
	    /* ɽ */
	    gtk_clist_thaw( GTK_CLIST(cxpmgr->clist2) );
	}

	return(0);
}

static void clist2_unselection( clist, row, column, event, data )
GtkWidget      *clist ;
gint            row ;
gint            column ;
GdkEventButton *event ;
gpointer        data ;
{

#ifdef	DEBUG4
fprintf(stdout,"clist2_unselection [%d]\n", row );
fflush(stdout);
#endif

	/* 򥯥ꥢ */
	cxpmgr->select.row[row] = 0 ;
}

static void clist2_selection( clist, row, column, event, data )
GtkWidget      *clist ;
gint            row ;
gint            column ;
GdkEventButton *event ;
gpointer        data ;
{
	FINFO		*finfo ;
	GdkPixmap	*pixmap ;
	GdkBitmap	*mask;
	gchar		*text;
	guint8		spacing ;
	int		i ;
	int		itnew ;

#ifdef	DEBUG
fprintf(stdout,"clist2_selection [%d](%d)\n", row,cxpmgr->currentViewFlag2 );
fflush(stdout);
#endif

	/* ˥å */
	if ( cxpmgr->select.row[row] != 1 )
	{
		itnew = 1 ;
		cxpmgr->select.row[row] = 1 ;
	}else{
		itnew = 0 ;
	}

	if ( cxpmgr->currentViewFlag2 )
	{
		cxpmgr->currentViewFlag2 = 0 ;
		return ;
	}

	if ( row < 0 )
		return ;

#ifdef	DEBUG4
fprintf(stdout,"cxpmgr->clist2_timeout_start[%d] -> [%d]\n",
row,cxpmgr->clist2_timeout_start[row] );
fflush(stdout);
#endif

	/* ॢȤ */
	if ( cxpmgr->clist2_timeout_start[row] == 0 )
	{
		cxpmgr->clist2_timeout_start[row] = gtk_timeout_add( 200,
			clist2_timeout_startfunc,
			&cxpmgr->clist2_timeout_start[row] );

#ifdef	DEBUG4
fprintf(stdout,"set cxpmgr->clist2_timeout_start[%d] -> [%d]\n",
row,cxpmgr->clist2_timeout_start[row] );
fflush(stdout);
#endif
		return ;
	}

#ifdef	DEBUG4
fprintf(stdout,"cxpmgr->clist2_timeout_start[%d] ---> [%d]\n",
row,cxpmgr->clist2_timeout_start[row]);
#endif

	if ( itnew == 1 )
		return ;

	finfo = (FINFO *)getFileInfoRow( &cxpmgr->fsView, row );
	if ( finfo == (FINFO *)NULL )
		return ;

#ifdef	DEBUG120
fprintf(stdout,"file mode -> 0x%04x\n", finfo->mode );
fflush(stdout);
#endif

	/* ǥ쥯ȥξ */
	if ( S_ISDIR( finfo->mode ) )
	{
#ifdef	DEBUG120
fprintf(stdout,"file is Directory ...\n");
fflush(stdout);
#endif
		/* ɽ򹹿 */
		cxpmgr->currentViewFlag2 = 1 ;
		CxpDirView( finfo->fname );
	}else
	/* եξб륢ץꥱư */
	{
		char	*appcmd ;
		char	commands[1024] ;

#ifdef	DEBUG120
fprintf(stdout,"file is no Directory ...\n");
fflush(stdout);
#endif

		/* ϢդƤ륢ץꥱμ */
		appcmd = (char *)getFileConfigApplication( finfo );
		if ( appcmd != NULL )
		{
			sprintf( commands,"%s \"%s\" &",
				appcmd,
				finfo->fname );
			system( commands );
		}else{
			/* бƤΤʤ硢⤷Υե */
			/* ˼¹ԸϤΤޤ޵ư */
#if 0
			system( finfo->fname );
#else
			sprintf( commands, "\"%s\" &", finfo->fname );
			system( finfo->fname );
#endif
		}
	}

	cxpmgr->currentViewFlag2 = 1 ;		/* ver 1.1.5 add */

	return;
}

static gint clist1_buttonpress (GtkWidget *widget, GdkEvent *event)
{
    FINFO		*finfo, *cfinfo ;
    GdkEventButton	*bevent = (GdkEventButton *) event;
    GdkEventKey 	*kevent = (GdkEventKey *) event;
    int			row, column ;
    int			totalcount ;
    char		workbuff[1024] ;
    char		*ptr, *ptr2 ;
    time_t		checkTime ;
    static time_t	oldTime = (time_t)0 ;
    static char		*oldName = (char *)"" ;

    if (event->type == GDK_KEY_PRESS)
    {
	row = cxpmgr->clist1_selection ;
    }

    if (event->type == GDK_BUTTON_PRESS)
    {
	gtk_clist_get_selection_info( GTK_CLIST(cxpmgr->clist1),
	    bevent->x, bevent->y, &row, &column );
    }

    if ( row < 0 || row >= cxpmgr->totalCount )
    {
	/* ٥Ȥ̲ᤵ */
	return FALSE ;
    }

    finfo = (FINFO *)getDirectoryInfoRow( &cxpmgr->fsInfo.root, row );
    if ( finfo == (FINFO *)NULL )
    {
	/* ٥Ȥ̲ᤵ */
	return FALSE ;
    }


    /* 줿ν */
    if (event->type == GDK_KEY_PRESS)
    {
	/* ꥿󥭡  ޤ ->  */
	if ( kevent->keyval == GDK_Return || kevent->keyval == GDK_Right )
	{
	    /* ؤ˥ǥ쥯ȥ꤬Ÿ */
	    if ( finfo->view == DIR_VIEW_OFF )
	    {
		/* ɥ쥹˸ߤɽ֤򥻥å */
		strcpy( cxpmgr->pwdbuff, finfo->fname );
#ifdef DEBUG5
fprintf(stdout,"clist1_buttonpress step1 pwdbuff [%s]\n",
cxpmgr->pwdbuff );
fflush(stdout);
#endif
		gtk_entry_set_text( GTK_ENTRY(cxpmgr->address),
				cxpmgr->pwdbuff );

		/* ǥ쥯ȥκ */
		getDirectoryInfo( "/", &cxpmgr->fsInfo.root ) ;

		/* ɽ */
		gtk_clist_freeze( GTK_CLIST(cxpmgr->clist1) );

		/* ꥢ */
		gtk_clist_clear( GTK_CLIST(cxpmgr->clist1) );

		/* ɽιߥե饰 */
		cxpmgr->currentViewFlag = 1 ;

		/* ǥ쥯ȥ󤫤ɽѺ */
		cxpmgr->totalCount = 0 ;
		printDirectory( &cxpmgr->fsInfo.root, -1, &cxpmgr->totalCount ) ;

		/* ɽιߥե饰 */
		cxpmgr->currentViewFlag = 0 ;

		/* ɽ֤򸽺ߤξ˺ */
		getDirectoryInfoName(
			&cxpmgr->fsInfo.root, finfo->fname, &row );
		gtk_clist_select_row(
			GTK_CLIST(cxpmgr->clist1), row, 0 );
		cxpmgr->clist1_selection = row ;

		/* ɽ */
		gtk_clist_thaw( GTK_CLIST(cxpmgr->clist1) );
	    }

	    /* ɽ濴 */
	    gtk_clist_moveto( GTK_CLIST(cxpmgr->clist1),
			row, 0, (gfloat)0.5, (gfloat)0.0 );
	    return(TRUE);
	}

	/* <-  */
	if ( kevent->keyval == GDK_Left )
	{
	    /* ؤŸƤи᤹ */
	    if ( finfo->view == DIR_VIEW_ON )
	    {
		/* ǥ쥯ȥɽ˴ */
		DirectoryRemove( &cxpmgr->fsInfo.root, row ) ;

		finfo->view = DIR_VIEW_OFF ;

		/* ɽ */
		gtk_clist_freeze( GTK_CLIST(cxpmgr->clist1) );

		/* ꥢ */
		gtk_clist_clear( GTK_CLIST(cxpmgr->clist1) );

		/* ɽιߥե饰 */
		cxpmgr->currentViewFlag = 1 ;

		/* ǥ쥯ȥ󤫤ɽѺ */
		cxpmgr->totalCount = 0 ;
		printDirectory( &cxpmgr->fsInfo.root, -1, &cxpmgr->totalCount ) ;

		/* ɽιߥե饰 */
		cxpmgr->currentViewFlag = 0 ;

		/* ɽ֤򸽺ߤξ˺ */
		gtk_clist_select_row(
			GTK_CLIST(cxpmgr->clist1), row, 0 );
		cxpmgr->clist1_selection = row ;

		/* ɽ */
		gtk_clist_thaw( GTK_CLIST(cxpmgr->clist1) );

	    }else
	    /* ؤŸƤʤаľذư */
	    if ( finfo->view == DIR_VIEW_ON )
	    {
		/* ľΥǥ쥯ȥذư */
		strcpy( workbuff, cxpmgr->pwdbuff );
		if ( strcmp( workbuff,"/") != 0 )
		{
		    if ( strmatch( "/*/*", workbuff ) == 0 )
		    {
			ptr = strrchr( workbuff,'/' );
			*ptr = 0x00 ;
		    }else{
			strcpy( workbuff, "/" );
		    }
		}
		CxpDirView( workbuff );
	    }

	    /* ɽ濴 */
	    gtk_clist_moveto( GTK_CLIST(cxpmgr->clist1),
			row, 0, (gfloat)0.5, (gfloat)0.0 );
	    return(TRUE);
	}

	/*  */
	if ( kevent->keyval == GDK_Up )
	{
	    if ( cxpmgr->clist1_selection > 0 )
	    {
		cxpmgr->clist1_selection -- ;
		row = cxpmgr->clist1_selection ;
		/* ɽ֤򸽺ߤξ˺ */
		gtk_clist_select_row(
			GTK_CLIST(cxpmgr->clist1), row, 0 );

		/* ɽ濴 */
		gtk_clist_moveto( GTK_CLIST(cxpmgr->clist1),
			row, 0, (gfloat)0.5, (gfloat)0.0 );

		return(TRUE);
	    }
	}

	/*  */
	if ( kevent->keyval == GDK_Down )
	{
	    if ( cxpmgr->clist1_selection + 1 < cxpmgr->totalCount )
	    {
		cxpmgr->clist1_selection ++;
		row = cxpmgr->clist1_selection ;
		/* ɽ֤򸽺ߤξ˺ */
		gtk_clist_select_row(
			GTK_CLIST(cxpmgr->clist1), row, 0 );

		/* ɽ濴 */
		gtk_clist_moveto( GTK_CLIST(cxpmgr->clist1),
			row, 0, (gfloat)0.5, (gfloat)0.0 );

		return(TRUE);
	    }
	}

	/* TAB  */
	if ( kevent->keyval == GDK_Tab )
	{
	    /* TAB 줿եեꥹȤذư */
		;
		;
		;
	    /* ǽ */
		;
		;
		;
	}
    }

    if (event->type == GDK_BUTTON_PRESS)
    {
	if ( bevent->button != 3 )
	{
	    /* ܥξ */
	    if (  bevent->button == 1 )
	    {

		/* ֤ */
		checkTime = time(0);


		/* ֤Ʊǥե̾ƱŸ */
		if ( checkTime == oldTime && strcmp(finfo->fname, oldName) == 0 )
		{
		    /* ɽ */
		    gtk_clist_freeze( GTK_CLIST(cxpmgr->clist1) );
#ifdef	DEBUG8
fprintf(stdout,"Event Button1 checkTime same ...\n");
#endif

		    /* ؤ˥ǥ쥯ȥ꤬Ÿ */
		    if ( finfo->view == DIR_VIEW_OFF )
		    {
#ifdef	DEBUG8
fprintf(stdout,"              OFF -> ON ...\n");
#endif

			if ( finfo->view == DIR_VIEW_OFF )
			    finfo->view = DIR_VIEW_ON ;

			/* ɥ쥹˸ߤɽ֤򥻥å */
			strcpy( cxpmgr->pwdbuff, finfo->fname );

			gtk_entry_set_text( GTK_ENTRY(cxpmgr->address),
				cxpmgr->pwdbuff );

#if 0
			if ( finfo->next == NULL )
			{
				finfo->next = (DINFO *)malloc( sizeof(DINFO) );
				memset( finfo->next,0x00, sizeof(DINFO) );
			}
			getDirectoryInfo( finfo->fname, finfo->next ) ;
#else
			getDirectoryInfo( "/", &cxpmgr->fsInfo.root ) ;
#endif

#ifdef	DEBUG8
fprintf(stdout,"              Lignt Print start ...\n");
#endif
			totalcount = 0 ;
			printDirectoryLight( &cxpmgr->fsInfo.root, -1, &totalcount, row ) ;
			cxpmgr->totalCount = totalcount ;
#ifdef	DEBUG8
fprintf(stdout,"              Lignt Print end ...\n");
#endif

		    }else
		    /* ؤ˥ǥ쥯ȥ꤬ʤĤ */
		    if ( finfo->view == DIR_VIEW_ON )
		    {
#ifdef	DEBUG8
fprintf(stdout,"              ON  -> OFF ...\n");
#endif
			if ( finfo->view == DIR_VIEW_ON )
			    finfo->view = DIR_VIEW_OFF ;

#ifdef	DEBUG8
fprintf(stdout,"              Lignt Print start ...\n");
#endif
			totalcount = 0 ;
			printDirectoryLight( &cxpmgr->fsInfo.root, -1, &totalcount, row ) ;
			cxpmgr->totalCount = totalcount ;
#ifdef	DEBUG8
fprintf(stdout,"              Lignt Print end ...\n");
#endif
		    }

		    /* ɽ */
		    gtk_clist_thaw( GTK_CLIST(cxpmgr->clist1) );
		}

#ifdef	DEBUG8
fprintf(stdout,"Event Button1 ...\n");
#endif

		if ( strcmp( cxpmgr->pwdbuff, finfo->fname ) != 0 )
			cxpmgr->currentViewFlag = 1 ;
		else
			cxpmgr->currentViewFlag = 0 ;

		gtk_clist_select_row(
			GTK_CLIST(cxpmgr->clist1), row, 0 );

		strcpy( cxpmgr->pwdbuff, finfo->fname );
#ifdef DEBUG5
fprintf(stdout,"clist1_buttonpress step3 pwdbuff [%s]\n",
cxpmgr->pwdbuff );
fflush(stdout);
#endif



		/* ɥ쥹˸ߤɽ֤򥻥å */
		gtk_entry_set_text( GTK_ENTRY(cxpmgr->address),
				cxpmgr->pwdbuff );

		/* ɽ */
		gtk_clist_freeze( GTK_CLIST(cxpmgr->clist2) );

		/* եκ */
		memset( &(cxpmgr->select),0x00,sizeof(SELECTINFO));
		gtk_clist_clear( GTK_CLIST(cxpmgr->clist2) );
		if ( getFileInfoByName( &cxpmgr->fsView, cxpmgr->pwdbuff ))
		{
			cxpmgr->currentViewFlag2 = 1 ;
			printFileInfo( &cxpmgr->fsView );
		}
		/* ɽ */
		gtk_clist_thaw( GTK_CLIST(cxpmgr->clist2) );

		/* ͤȤ¸ */
		oldTime = checkTime ;
		oldName = g_strdup(finfo->fname) ;
	    }
	}
	/* ٥Ȥ̲ᤵ */
	return FALSE ;
    }

    /* ٥Ȥ̲ᤵ */
    return FALSE;
}

static gint clist2_buttonpress (GtkWidget *widget, GdkEvent *event)
{
	GdkEventButton	*bevent = (GdkEventButton *) event;
	GdkEventKey 	*kevent = (GdkEventKey *) event;
	GtkWidget	*lmenubar ;
	GtkWidget	*lmenu ;
	GtkWidget	*lmenuitem ;
	GtkWidget	*smenu ;
	GtkWidget	*smenuitem ;
	static int	KeyPressCntl  = 0 ;
	static int	KeyPressShift = 0 ;
	int i, kensu ;

	if (event->type == GDK_KEY_PRESS){
#ifdef	DEBUG4
fprintf(stdout,"GDK_KEY_PRESS ...[0x%04x]\n", kevent->keyval);
fflush(stdout);
#endif
		if ( kevent->keyval == GDK_Control_L
		||   kevent->keyval == GDK_Control_R )
			KeyPressCntl = 1 ;
		if ( kevent->keyval == GDK_Shift_L
		||   kevent->keyval == GDK_Shift_R )
			KeyPressShift = 1 ;


		/* ꥿󥳡ɤ줿鵯ư */
		if ( kevent->keyval == GDK_Return )
		{
		    FINFO *finfo ;
		    char *appcmd ;
		    char commands[1024] ;

		    /* ϢդƤ륢ץꥱμ */
		    for(i=0;i<cxpmgr->fsView.count;i++)
		    {
			if( cxpmgr->select.row[i] != 1 )
			    continue ;

			finfo = (FINFO *)getFileInfoRow( &cxpmgr->fsView, i );
			if ( finfo == (FINFO *)NULL )
			    continue ;

			appcmd = (char *)getFileConfigApplication( finfo );
			if ( appcmd != NULL )
			{
			    sprintf( commands,"%s \"%s\" &",
				appcmd,
				finfo->fname );
			    system( commands );
			}else{
			    /* бƤΤʤ硢⤷Υե */
			    /* ˼¹ԸϤΤޤ޵ư */
#if 0
			    system( finfo->fname );
#else
			    sprintf( commands,"\"%s\" &", finfo->fname );
			    system( commands );
#endif
			}
		    }

		    /* ٥Τʤ */
		    return(FALSE);
		}
	}

	if (event->type == GDK_KEY_RELEASE){
#ifdef	DEBUG4
fprintf(stdout,"GDK_KEY_RELEASE ...\n");
fflush(stdout);
#endif
		if ( kevent->keyval == GDK_Control_L
		||   kevent->keyval == GDK_Control_R )
			KeyPressCntl = 0 ;
		if ( kevent->keyval == GDK_Shift_L
		||   kevent->keyval == GDK_Shift_R )
			KeyPressShift = 0 ;
	}

	if (event->type == GDK_BUTTON_PRESS){
#ifdef	DEBUG7
fprintf(stdout,"clist2_buttonpress ....\n");
fflush(stdout);
#endif
		if ( bevent->button != 3 )
		{
			/* ܥξ */
			if (  bevent->button == 1 )
			{
				int	row, column ;

				/* Ctrl/Shift */
				if ( KeyPressCntl  == 1 || KeyPressShift == 1 )
				{
					return FALSE ;
				}

#ifdef	DEBUG7
fprintf(stdout,"button 1 pushed ...\n");
fflush(stdout);
#endif

				gtk_clist_get_selection_info(
						GTK_CLIST(cxpmgr->clist2),
						bevent->x, bevent->y,
						&row, &column );
#ifdef	DEBUG7
fprintf(stdout,"    row [%d] cxpmgr->fsView.count [%d]\n",
row, cxpmgr->fsView.count );
fflush(stdout);
#endif
				if ( row >= 0 && row < cxpmgr->fsView.count )
				{
				    cxpmgr->currentViewFlag = 1 ;

				    gtk_clist_select_row(
					GTK_CLIST(cxpmgr->clist2), row, 0 );
				}

				return FALSE;
			}

			/* ٥Ȥ̲ᤵ */
			return FALSE ;
		}

#ifdef	DEBUG7
		fprintf(stdout,"GDK_BUTTON_PRESS [%d] x[%.1lf] y[%.1lf]...\n",
				bevent->button,
				bevent->x,
				bevent->y );
#endif

		/* ˥塼 */
		lmenu = gtk_menu_new();


		lmenuitem = gtk_menu_item_new_with_label(SUBMENU_NEWFILE);
		gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
		gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
				GTK_SIGNAL_FUNC(submenu_response),
				(gpointer)g_strdup(SUBMENU_NEWFILE));
		gtk_widget_show(lmenuitem);

		lmenuitem = gtk_menu_item_new_with_label(SUBMENU_NEWDIR);
		gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
		gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
				GTK_SIGNAL_FUNC(submenu_response),
				(gpointer)g_strdup(SUBMENU_NEWDIR));
		gtk_widget_show(lmenuitem);


		/* 򤵤Ƥե򻻽Ф */
		kensu = 0 ;
		for(i=0;i<cxpmgr->fsView.count;i++)
		{
		    if ( cxpmgr->select.row[i] == 0 )
			continue ;
		    kensu++;
		}

		if ( cxpmgr->aplication.num > 0 && kensu > 0 )
		{
		    /* ֥˥塼 */
  		    smenu = gtk_menu_new ();

		    for(i=0;i<cxpmgr->aplication.num;i++)
		    {

			smenuitem = gtk_menu_item_new_with_label(
					cxpmgr->aplication.item[i].name );
			gtk_menu_append(GTK_MENU (smenu), smenuitem);
			gtk_signal_connect_object(GTK_OBJECT(smenuitem),
			  "activate",
			  GTK_SIGNAL_FUNC(submenu_sendapp),
			  (gpointer)g_strdup(cxpmgr->aplication.item[i].path));
			gtk_widget_show(smenuitem);

		    }

		    lmenuitem = gtk_menu_item_new_with_label(SUBMENU_SEND);
		    gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
		    gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
				GTK_SIGNAL_FUNC(submenu_response),
				(gpointer)g_strdup(SUBMENU_SEND));
		    gtk_widget_show(lmenuitem);

		    gtk_menu_item_set_submenu(GTK_MENU_ITEM(lmenuitem),smenu);
		}


		lmenuitem = gtk_menu_item_new_with_label(SUBMENU_RENAME);
		gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
		gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
				GTK_SIGNAL_FUNC(submenu_response),
				(gpointer)g_strdup(SUBMENU_RENAME));
		gtk_widget_show(lmenuitem);

		lmenuitem = gtk_menu_item_new_with_label(SUBMENU_COPY);
		gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
		gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
				GTK_SIGNAL_FUNC(submenu_response),
				(gpointer)g_strdup(SUBMENU_COPY));
		gtk_widget_show(lmenuitem);

		lmenuitem = gtk_menu_item_new_with_label(SUBMENU_PASTE);
		gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
		gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
				GTK_SIGNAL_FUNC(submenu_response),
				(gpointer)g_strdup(SUBMENU_PASTE));
		gtk_widget_show(lmenuitem);

		lmenuitem = gtk_menu_item_new_with_label(SUBMENU_DELETE);
		gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
		gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
				GTK_SIGNAL_FUNC(submenu_response),
				(gpointer)g_strdup(SUBMENU_DELETE));
		gtk_widget_show(lmenuitem);

		lmenuitem = gtk_menu_item_new_with_label(SUBMENU_INFO);
		gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
		gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
				GTK_SIGNAL_FUNC(submenu_response),
				(gpointer)g_strdup(SUBMENU_INFO));
		gtk_widget_show(lmenuitem);


		/* ˥塼ݥåץå */
		gtk_menu_popup (GTK_MENU(lmenu), NULL, NULL, NULL, NULL,
				bevent->button, bevent->time);

		return TRUE ;

	}

	/* ٥Ȥ̲ᤵ */
	return FALSE;
}

static void makeFileList2()
{
  GtkWidget	*titlewid1;
  GtkWidget	*titlewid2;
  GtkWidget	*titlewid3;
  GtkWidget	*titlewid4;
  GtkWidget	*basewid1;
  GtkWidget	*basewid2;
  GtkWidget	*basewid3;
  GtkWidget	*basewid4;
  GtkWidget	*hpaned;
  int		i ;

  cxpmgr->clist2 = gtk_clist_new_with_titles( 4, clist2_title );

  gtk_widget_set_usize(cxpmgr->clist2, 440, -1);
  gtk_clist_set_selection_mode(GTK_CLIST(cxpmgr->clist2),
				GTK_SELECTION_EXTENDED);

  gtk_signal_connect(GTK_OBJECT(cxpmgr->clist2),
		"select_row", GTK_SIGNAL_FUNC(clist2_selection), NULL);

  gtk_signal_connect(GTK_OBJECT(cxpmgr->clist2),
		"unselect_row", GTK_SIGNAL_FUNC(clist2_unselection), NULL);

  gtk_signal_connect_object(GTK_OBJECT(cxpmgr->clist2),
		"event", GTK_SIGNAL_FUNC(clist2_buttonpress), NULL);

  /* ȥܥ */
  gtk_clist_column_title_active  ( GTK_CLIST(cxpmgr->clist2), 0 );
  gtk_clist_column_title_active  ( GTK_CLIST(cxpmgr->clist2), 1 );
  gtk_clist_column_title_passive ( GTK_CLIST(cxpmgr->clist2), 2 );
  gtk_clist_column_title_active  ( GTK_CLIST(cxpmgr->clist2), 3 );

  gtk_signal_connect ( GTK_OBJECT(GTK_CLIST(cxpmgr->clist2)->column[0].button), "clicked",
	GTK_SIGNAL_FUNC (titleFnameCallback), (gpointer)0 );
  gtk_signal_connect ( GTK_OBJECT(GTK_CLIST(cxpmgr->clist2)->column[1].button), "clicked",
	GTK_SIGNAL_FUNC (titleSizeCallback), (gpointer)0 );
  gtk_signal_connect ( GTK_OBJECT(GTK_CLIST(cxpmgr->clist2)->column[3].button), "clicked",
	GTK_SIGNAL_FUNC (titleDateCallback), (gpointer)0 );

  gtk_clist_set_column_width(GTK_CLIST(cxpmgr->clist2), 0, 150);
  gtk_clist_set_column_width(GTK_CLIST(cxpmgr->clist2), 1,  90);
  gtk_clist_set_column_width(GTK_CLIST(cxpmgr->clist2), 2, 140);
  gtk_clist_set_column_width(GTK_CLIST(cxpmgr->clist2), 3, 120);
  gtk_clist_set_column_justification(
	GTK_CLIST(cxpmgr->clist2),1, GTK_JUSTIFY_RIGHT );

  gtk_container_add(GTK_CONTAINER(cxpmgr->swin2), cxpmgr->clist2);
  gtk_widget_show(cxpmgr->clist2);

}

void cxp_list_init()
{
  GtkWidget	*hpaned;
  int		i ;

  /* ʬǡ礭򤤤 */
  hpaned = gtk_hpaned_new();
  gtk_container_set_border_width(GTK_CONTAINER(hpaned), 2);
  gtk_box_pack_start(GTK_BOX(cxpmgr->vbox), hpaned, TRUE, TRUE, 1);
  gtk_widget_show(hpaned);



  /* Clist Τ뤿Υɥɥ */
  cxpmgr->swin1 = gtk_scrolled_window_new(NULL, NULL);

  /* ʿӿľΥСɽ褦 */
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(cxpmgr->swin1), 
	 	GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(cxpmgr->swin1);

  /* ǥ쥯ȥɽѤΥꥹȤ */
  cxpmgr->clist1 = gtk_clist_new_with_titles(1, clist1_title );
  gtk_widget_set_usize(cxpmgr->clist1, 200, -1);
  gtk_clist_set_selection_mode( GTK_CLIST(cxpmgr->clist1),
				GTK_SELECTION_BROWSE );

  gtk_signal_connect(GTK_OBJECT(cxpmgr->clist1), "select_row",
		GTK_SIGNAL_FUNC(clist1_selection), NULL);

  gtk_signal_connect(GTK_OBJECT(cxpmgr->clist1), "event",
		GTK_SIGNAL_FUNC(clist1_buttonpress), NULL);

  /* ȥܥȤʤ褦ˤ롣*/
  gtk_clist_column_titles_passive(GTK_CLIST(cxpmgr->clist1));

  gtk_container_add(GTK_CONTAINER(cxpmgr->swin1), cxpmgr->clist1);
  gtk_widget_show(cxpmgr->clist1);



  /* Clist Τ뤿Υɥɥ */
  cxpmgr->swin2 = gtk_scrolled_window_new(NULL, NULL);

  /* ʿӿľΥСɽ褦 */
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(cxpmgr->swin2), 
	 	GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(cxpmgr->swin2);


  makeFileList2() ;


  /* ʬ䤵줿¦˥ǥ쥯ȥΥܥåΤ */
  gtk_paned_add1(GTK_PANED(hpaned), cxpmgr->swin1);
  gtk_widget_show(cxpmgr->swin1);

  /* ʬ䤵줿¦˥եΥܥåΤ */
  gtk_paned_add2(GTK_PANED(hpaned), cxpmgr->swin2);
  gtk_widget_show(cxpmgr->swin2);

}
