/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern	CxpMgr    *cxpmgr;

static void filemenu_response () ;
static void editmenu_response () ;
static void movemenu_response () ;
static void settmenu_response () ;
static void toolmenu_response () ;
static void viewmenu_response () ;
static void helpmenu_response () ;

#define	FILEIACT_NEWCXP		0x0101
#define	FILEIACT_NEWFILE	0x0102
#define	FILEIACT_NEWDIR		0x0103
#define	FILEIACT_DELETE		0x0104
#define	FILEIACT_RENAME		0x0105
#define	FILEIACT_PROP		0x0106
#define	FILEIACT_CLOSE		0x0107
#define	EDITIACT_COPY		0x0201
#define	EDITIACT_PASTE		0x0202
#define	MOVEIACT_HOME		0x0301
#define	MOVEIACT_UP		0x0302
#define	MOVEIACT_ROOT		0x0303
#define	SETTIACT_SETT		0x0401
#define	SETTIACT_APPADD		0x0402
#define	SETTIACT_FUNCADD	0x0403
#define	SETTIACT_SETVIEW	0x0404
#define	TOOLIACT_SYSINFO	0x0501
#define	TOOLIACT_APP		0x0502
#define	TOOLIACT_STYLE		0x0503
#define	TOOLIACT_BG		0x0504
#define	TOOLIACT_ADDR		0x0505
#define	TOOLIACT_CALEN		0x0506
#define	TOOLIACT_CALC		0x0507
#define	TOOLIACT_MAIL		0x0508
#define	TOOLIACT_IMAGE		0x0509
#define	TOOLIACT_BACKUP		0x0510
#define	TOOLIACT_RESTORE	0x0511
#define	TOOLIACT_DEVICE		0x0512
#define	VIEWIACT_LIST		0x0601
#define	VIEWIACT_LISTFILE	0x0602
#define	VIEWIACT_SMALL		0x0603
#define	VIEWIACT_BIG		0x0604
#define	VIEWIACT_UPDATE		0x0605
#define	HELPIACT_ABOUT		0x0901

#define	FILEMENU_BASE		"/ե"
#define	FILEMENU_NEWCXP		"/ե/Cxplorer"
#define	FILEMENU_NEWFILE	"/ե/ե"
#define	FILEMENU_NEWDIR		"/ե/ǥ쥯ȥ"
#define FILEMENU_SEP1		"/ե/sep1"
#define	FILEMENU_DELETE		"/ե/"
#define	FILEMENU_RENAME		"/ե/̾ѹ"
#define FILEMENU_SEP2		"/ե/sep2"
#define	FILEMENU_PROP		"/ե/ɽ"
#define FILEMENU_SEP3		"/ե/sep3"
#define	FILEMENU_CLOSE		"/ե/Ĥ"

#define	EDITMENU_BASE		"/Խ"
#define	EDITMENU_COPY		"/Խ/ԡ"
#define	EDITMENU_PASTE		"/Խ/Žդ"

#define	MOVEMENU_BASE		"/ư"
#define	MOVEMENU_HOME		"/ư/ۡ"
#define	MOVEMENU_UP		"/ư/ľ"
#define	MOVEMENU_ROOT		"/ư/롼Ȥ"

#define	SETTMENU_BASE		"/"
#define	SETTMENU_SETT		"//ɽ"
#define	SETTMENU_APPADD		"//ץꥱϿ"
#define	SETTMENU_FUNCADD	"//ե󥯥Ͽ"
#define	SETTMENU_SETVIEW	"//ɽ֡"

#define	TOOLMENU_BASE		"/ġ"
#define	TOOLMENU_BASE_INTERNET	"/ġ/󥿡ͥåȥġ"
#define	TOOLMENU_MAIL		"/ġ/󥿡ͥåȥġ/Cxp᡼顼"
#define	TOOLMENU_ADDR		"/ġ/󥿡ͥåȥġ/Cxpɥ쥹"
#define	TOOLMENU_BASE_IMAGE	"/ġ/᡼ġ"
#define	TOOLMENU_IMAGE		"/ġ/᡼ġ/Cxp᡼ӥ塼"
#define	TOOLMENU_BASE_DATA	"/ġ/Хååץġ"
#define	TOOLMENU_BACKUP		"/ġ/Хååץġ/CxpХåå"
#define	TOOLMENU_RESTORE	"/ġ/Хååץġ/Cxpꥹȥ"
#define	TOOLMENU_DEVICE		"/ġ/Хååץġ/CxpǥХ"
#define	TOOLMENU_BASE_CXPLORER	"/ġ/ġ"
#define	TOOLMENU_STYLE		"/ġ/ġ/Cxpѹ"
#define	TOOLMENU_APP		"/ġ/ġ/CxpץꥱϢդ"
#define	TOOLMENU_BASE_OTHER	"/ġ/¾Υġ"
#define	TOOLMENU_SYSINFO	"/ġ/¾Υġ/Cxpƥɽ"
#define	TOOLMENU_CALEN		"/ġ/¾Υġ/Cxp"
#define	TOOLMENU_CALC		"/ġ/¾Υġ/Cxp׻"
#define	TOOLMENU_BG		"/ġ/¾Υġ/Cxpطʥ᡼ѹ"

#define	VIEWMENU_BASE		"/ɽ"
#define	VIEWMENU_LIST		"/ɽ/ܺ"
#if 0
#define	VIEWMENU_LISTFILE	"/ɽ/̤ǽ"
#define	VIEWMENU_SMALL		"/ɽ/̤ǽ"
#define	VIEWMENU_BIG		"/ɽ/礭̤ǽ"
#endif
#define VIEWMENU_SEP1		"/ɽ/sep"
#define	VIEWMENU_UPDATE		"/ɽ/ǿξ֤˹"

#define	HELPMENU_BASE		"/إ"
#define	HELPMENU_ABOUT		"/إ/CxplorerˤĤ"


static GtkItemFactoryEntry menu_items[] = {
 { FILEMENU_BASE,    NULL, NULL,   0, "<Branch>" },
 { FILEMENU_NEWCXP,  "<control>N", filemenu_response,  FILEIACT_NEWCXP, NULL },
 { FILEMENU_NEWFILE, NULL, filemenu_response,  FILEIACT_NEWFILE, NULL },
 { FILEMENU_NEWDIR,  "<control>M", filemenu_response,  FILEIACT_NEWDIR, NULL },
 { FILEMENU_SEP1,    NULL, NULL,   0, "<Separator>" },
 { FILEMENU_DELETE,  "<control>D", filemenu_response, FILEIACT_DELETE, NULL },
 { FILEMENU_RENAME,  NULL, filemenu_response,  FILEIACT_RENAME, NULL },
 { FILEMENU_SEP2,    NULL, NULL,   0, "<Separator>" },
 { FILEMENU_PROP,    "<control>I", filemenu_response,  FILEIACT_PROP, NULL },
 { FILEMENU_SEP3,    NULL, NULL,   0, "<Separator>" },
 { FILEMENU_CLOSE,   "<control>Q", filemenu_response,  FILEIACT_CLOSE, NULL },
 { EDITMENU_BASE,    NULL, NULL,   0, "<Branch>" },
 { EDITMENU_COPY,    "<control>C", editmenu_response,  EDITIACT_COPY, NULL },
 { EDITMENU_PASTE,   "<control>V", editmenu_response,  EDITIACT_PASTE, NULL },
 { MOVEMENU_BASE,    NULL, NULL,   0, "<Branch>" },
 { MOVEMENU_HOME,    "<control>H", movemenu_response,  MOVEIACT_HOME, NULL },
 { MOVEMENU_UP,      "<control>B", movemenu_response,  MOVEIACT_UP, NULL },
 { MOVEMENU_ROOT,    "<control>R", movemenu_response,  MOVEIACT_ROOT, NULL },
 { SETTMENU_BASE,    NULL, NULL,   0, "<Branch>" },
 { SETTMENU_SETT,    "<control>S", settmenu_response,  SETTIACT_SETT, NULL },
 { SETTMENU_APPADD,  "<control>A", settmenu_response,  SETTIACT_APPADD, NULL },
 { SETTMENU_FUNCADD, "<control>F", settmenu_response,  SETTIACT_FUNCADD, NULL },
 { SETTMENU_SETVIEW, NULL,         settmenu_response,  SETTIACT_SETVIEW, NULL },

#if 0
 { TOOLMENU_BASE,    NULL, NULL,   0, "<Branch>" },
 { TOOLMENU_MAIL,    NULL, toolmenu_response,  TOOLIACT_MAIL, NULL },
 { TOOLMENU_IMAGE,   NULL, toolmenu_response,  TOOLIACT_IMAGE, NULL },
 { TOOLMENU_SYSINFO, NULL, toolmenu_response,  TOOLIACT_SYSINFO, NULL },
 { TOOLMENU_APP,     NULL, toolmenu_response,  TOOLIACT_APP, NULL },
 { TOOLMENU_STYLE,   NULL, toolmenu_response,  TOOLIACT_STYLE, NULL },
 { TOOLMENU_BG,      NULL, toolmenu_response,  TOOLIACT_BG, NULL },
 { TOOLMENU_ADDR,    NULL, toolmenu_response,  TOOLIACT_ADDR, NULL },
 { TOOLMENU_CALEN,   NULL, toolmenu_response,  TOOLIACT_CALEN, NULL },
 { TOOLMENU_CALC,    NULL, toolmenu_response,  TOOLIACT_CALC, NULL },

#else

 { TOOLMENU_BASE,     NULL, NULL, 0, "<Branch>" },
 { TOOLMENU_BASE_INTERNET, NULL, NULL, 0, "<Branch>" },
 { TOOLMENU_MAIL,     NULL, toolmenu_response,  TOOLIACT_MAIL, NULL },
 { TOOLMENU_ADDR,     NULL, toolmenu_response,  TOOLIACT_ADDR, NULL },
 { TOOLMENU_BASE_IMAGE, NULL, NULL, 0, "<Branch>" },
 { TOOLMENU_IMAGE,    NULL, toolmenu_response,  TOOLIACT_IMAGE, NULL },
 { TOOLMENU_BASE_DATA, NULL, NULL, 0, "<Branch>" },
 { TOOLMENU_BACKUP,   NULL, toolmenu_response,  TOOLIACT_BACKUP, NULL },
 { TOOLMENU_RESTORE,  NULL, toolmenu_response,  TOOLIACT_RESTORE, NULL },
 { TOOLMENU_DEVICE,   NULL, toolmenu_response,  TOOLIACT_DEVICE, NULL },
 { TOOLMENU_BASE_CXPLORER, NULL, NULL, 0, "<Branch>" },
 { TOOLMENU_STYLE,    NULL, toolmenu_response,  TOOLIACT_STYLE, NULL },
 { TOOLMENU_APP,      NULL, toolmenu_response,  TOOLIACT_APP, NULL },
 { TOOLMENU_BASE_OTHER, NULL, NULL, 0, "<Branch>" },
 { TOOLMENU_SYSINFO,  NULL, toolmenu_response,  TOOLIACT_SYSINFO, NULL },
 { TOOLMENU_CALEN,    NULL, toolmenu_response,  TOOLIACT_CALEN, NULL },
 { TOOLMENU_CALC,     NULL, toolmenu_response,  TOOLIACT_CALC, NULL },
 { TOOLMENU_BG,       NULL, toolmenu_response,  TOOLIACT_BG, NULL },

#endif

 { VIEWMENU_BASE,    NULL, NULL,   0, "<Branch>" },
 { VIEWMENU_LIST,    NULL, viewmenu_response,  VIEWIACT_LIST, NULL },
#if 0
 { VIEWMENU_LISTFILE,NULL, viewmenu_response,  VIEWIACT_LISTFILE, NULL },
 { VIEWMENU_SMALL,   NULL, viewmenu_response,  VIEWIACT_SMALL, NULL },
 { VIEWMENU_BIG,     NULL, viewmenu_response,  VIEWIACT_BIG, NULL },
#endif
 { VIEWMENU_SEP1,    NULL, NULL,   0, "<Separator>" },
 { VIEWMENU_UPDATE,  "<control>U", viewmenu_response,  VIEWIACT_UPDATE, NULL },
 { HELPMENU_BASE,    NULL, NULL,   0, "<LastBranch>" },
 { HELPMENU_ABOUT,   NULL, helpmenu_response,  HELPIACT_ABOUT, NULL },
};


static void filemenu_response (GtkWidget *w, gpointer data)
{
	switch( (int)data )
	{
	case FILEIACT_NEWCXP :
		filefunc_newcxp( cxpmgr->pwdbuff );
		break;
	case FILEIACT_NEWFILE :
		filefunc_newfile();
		break;
	case FILEIACT_NEWDIR :
		filefunc_newdir();
		break ;
	case FILEIACT_DELETE :
		filefunc_delete();
		break ;
	case FILEIACT_RENAME :
		filefunc_rename();
		break ;
	case FILEIACT_PROP :
		filefunc_propaty();
		break ;
	case FILEIACT_CLOSE :
		filefunc_close();
		break ;
	}
}

static void editmenu_response (GtkWidget *w, gpointer data)
{
	switch( (int)data )
	{
	case EDITIACT_COPY :
		editfunc_copy();
		break ;
	case EDITIACT_PASTE :
		editfunc_paste();
		break ;
	}
}

static void movemenu_response (GtkWidget *w, gpointer data)
{
	switch( (int)data )
	{
	case MOVEIACT_HOME :
		movefunc_home();
		break ;
	case MOVEIACT_UP :
		movefunc_up();
		break ;
	case MOVEIACT_ROOT :
		movefunc_root();
		break ;
	}
}
static void settmenu_response (GtkWidget *w, gpointer data)
{
	switch( (int)data )
	{
	case SETTIACT_SETT :
		settfunc_sett();
		break ;
	case SETTIACT_APPADD :
		settfunc_appadd();
		break ;
	case SETTIACT_FUNCADD :
		settfunc_funcadd();
		break ;
	case SETTIACT_SETVIEW :
		settfunc_setview();
		break ;
	}
}
static void toolmenu_response (GtkWidget *w, gpointer data)
{
	switch( (int)data )
	{
	case TOOLIACT_MAIL :
		toolfunc_mail();
		break ;
	case TOOLIACT_IMAGE :
		toolfunc_image();
		break ;
	case TOOLIACT_SYSINFO :
		toolfunc_sysinfo();
		break ;
	case TOOLIACT_APP :
		toolfunc_app();
		break ;
	case TOOLIACT_STYLE :
		toolfunc_style();
		break ;
	case TOOLIACT_BG :
		toolfunc_bg();
		break ;
	case TOOLIACT_ADDR :
		toolfunc_address();
		break ;
	case TOOLIACT_CALEN :
		toolfunc_calendar();
		break ;
	case TOOLIACT_CALC :
		toolfunc_calc();
		break ;
	case TOOLIACT_BACKUP :
		toolfunc_backup();
		break ;
	case TOOLIACT_RESTORE :
		toolfunc_restore();
		break ;
	case TOOLIACT_DEVICE :
		toolfunc_device();
		break ;
	}
}
static void viewmenu_response (GtkWidget *w, gpointer data)
{
	switch( (int)data )
	{
	case VIEWIACT_LIST :
		viewfunc_list();
		break ;
	case VIEWIACT_LISTFILE :
		viewfunc_listfile();
		break ;
	case VIEWIACT_SMALL :
		viewfunc_small();
		break ;
	case VIEWIACT_BIG :
		viewfunc_big();
		break ;
	case VIEWIACT_UPDATE :
		viewfunc_update();
		break ;
	}
}
static void helpmenu_response (GtkWidget *w, gpointer data)
{
	switch( (int)data )
	{
	case HELPIACT_ABOUT :
		helpfunc_about();
		break;
	}
}


void cxp_menu_init()
{
  GtkWidget	*handle_box ;
  GtkWidget	*subitem ;
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  int		nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);

  handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX(cxpmgr->vbox), handle_box, FALSE, FALSE, 0 );
  gtk_widget_show (handle_box);

  accel_group = gtk_accel_group_new();

  item_factory = gtk_item_factory_new(
		GTK_TYPE_MENU_BAR, "<main>", accel_group);

  gtk_item_factory_create_items(item_factory, nmenu_items, menu_items, NULL);

  gtk_accel_group_attach (accel_group, GTK_OBJECT (cxpmgr->window));

  cxpmgr->menubar = gtk_item_factory_get_widget(item_factory, "<main>");
  gtk_container_add ( GTK_CONTAINER ( handle_box ) , cxpmgr->menubar );
  gtk_widget_show(cxpmgr->menubar);

}
