/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern	CxpMgr    *cxpmgr;

static	int	modeUserOnOff[3] ;
static	int	modeGroupOnOff[3] ;
static	int	modeOtherOnOff[3] ;
static	GtkWidget *checkUser[3] ;
static	GtkWidget *checkGroup[3] ;
static	GtkWidget *checkOther[3] ;
static	FINFO	*_localFileInfo ;

void propatydlg_cancel(GtkWidget *widget, gpointer data)
{
  /* ɥϥɤ */
  gtk_widget_hide( widget );
}

static GtkWidget *make_prof_label( title, name )
char	*title ;
char	*name ;
{
	GtkWidget *label1 ;
	GtkWidget *label2 ;
	GtkWidget *hbox ;

	hbox = gtk_hbox_new(FALSE, 2);

	label1 = gtk_label_new( title );
	gtk_box_pack_start (GTK_BOX (hbox), label1, FALSE, FALSE, 10);
	gtk_widget_show (label1);

	label2 = gtk_label_new( name );
	gtk_box_pack_start (GTK_BOX (hbox), label2, FALSE, FALSE, 10);
	gtk_widget_show (label2);

	return(hbox);
}

void profModeChangeFunc(GtkWidget *widget, gpointer data)
{
	int	icnt ;
	int	status ;
	mode_t	modedata ;

#if 0
S_IRUSR (S_IREAD)  00400 ͭ(owner)ˤɤ߼(read)
S_IWUSR (S_IWRITE) 00200 ͭԤˤ񤭹(write)
S_IXUSR (S_IEXEC)  00100 ͭԤˤ¹(execute)/(search)
S_IRGRP            00040 롼פˤɤ߼
S_IWGRP            00020 롼פˤ񤭹
S_IXGRP            00010 롼פˤ¹/
S_IROTH            00004 ¾(others)ˤɤ߼
S_IWOTH            00002 ¾ͤˤ񤭹
S_IXOTH            00001 ¾ͤˤ¹/
#endif

	modedata = 0 ;

	if (GTK_TOGGLE_BUTTON (checkUser[0])->active)
		modedata |= S_IRUSR ;
	if (GTK_TOGGLE_BUTTON (checkUser[1])->active)
		modedata |= S_IWUSR ;
	if (GTK_TOGGLE_BUTTON (checkUser[2])->active)
		modedata |= S_IXUSR ;

	if (GTK_TOGGLE_BUTTON (checkGroup[0])->active)
		modedata |= S_IRGRP ;
	if (GTK_TOGGLE_BUTTON (checkGroup[1])->active)
		modedata |= S_IWGRP ;
	if (GTK_TOGGLE_BUTTON (checkGroup[2])->active)
		modedata |= S_IXGRP ;

	if (GTK_TOGGLE_BUTTON (checkOther[0])->active)
		modedata |= S_IROTH ;
	if (GTK_TOGGLE_BUTTON (checkOther[1])->active)
		modedata |= S_IWOTH ;
	if (GTK_TOGGLE_BUTTON (checkOther[2])->active)
		modedata |= S_IXOTH ;

	status = chmod( _localFileInfo->fname, modedata );
	if ( status != 0 )
	{
		/* ⡼ɤѹǤʤ */
		messageView(
			"顼","","Ĥ",
			"˼Ԥޤ",
                        "",NULL );
	}else{
		/* λ */
		messageView(
			"","","Ĥ",
			"˹ޤ",
                        "",NULL );
	}
}

static GtkWidget *make_prof_check( title, name1, name2, name3, mode )
char	*title ;
char	*name1 ;
char	*name2 ;
char	*name3 ;
int	mode ;
{
	GtkWidget *label ;
	GtkWidget *hbox ;
	GtkWidget *setbtn ;
	int	  *onoff ;
	int	  icnt ;

	if ( mode == 0 )
	{
	    onoff = modeUserOnOff ;
	}else
	if ( mode == 1 )
	{
	    onoff = modeGroupOnOff ;
	}else
	if ( mode == 2 )
	{
	    onoff = modeOtherOnOff ;
	}

	hbox = gtk_hbox_new(FALSE, 2);

	label = gtk_label_new( title );
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 10);
	gtk_widget_show (label);

	for(icnt=0;icnt<3;icnt++)
	{
	    if ( mode == 0 )
	    {
		if ( icnt == 0 )
		    checkUser[icnt] = gtk_check_button_new_with_label( name1 );
		else if ( icnt == 1 )
		    checkUser[icnt] = gtk_check_button_new_with_label( name2 );
		else
		    checkUser[icnt] = gtk_check_button_new_with_label( name3 );
		gtk_widget_set_usize(checkUser[icnt], 50, -1);
		if ( onoff[icnt] == 0 )
		    gtk_toggle_button_set_state(
			GTK_TOGGLE_BUTTON(checkUser[icnt]), FALSE);
		else
		    gtk_toggle_button_set_state(
			GTK_TOGGLE_BUTTON(checkUser[icnt]), TRUE);
		gtk_box_pack_start (GTK_BOX (hbox),
			checkUser[icnt], FALSE, FALSE, 5);
		gtk_widget_show (checkUser[icnt]);
	    }else
	    if ( mode == 1 )
	    {
		if ( icnt == 0 )
		    checkGroup[icnt] = gtk_check_button_new_with_label( name1 );
		else if ( icnt == 1 )
		    checkGroup[icnt] = gtk_check_button_new_with_label( name2 );
		else
		    checkGroup[icnt] = gtk_check_button_new_with_label( name3 );
		gtk_widget_set_usize(checkGroup[icnt], 50, -1);
		if ( onoff[icnt] == 0 )
		    gtk_toggle_button_set_state(
			GTK_TOGGLE_BUTTON(checkGroup[icnt]), FALSE);
		else
		    gtk_toggle_button_set_state(
			GTK_TOGGLE_BUTTON(checkGroup[icnt]), TRUE);
		gtk_box_pack_start (GTK_BOX (hbox),
			checkGroup[icnt], FALSE,FALSE, 5);
		gtk_widget_show (checkGroup[icnt]);
	    }else
	    if ( mode == 2 )
	    {
		if ( icnt == 0 )
		    checkOther[icnt] = gtk_check_button_new_with_label( name1 );
		else if ( icnt == 1 )
		    checkOther[icnt] = gtk_check_button_new_with_label( name2 );
		else
		    checkOther[icnt] = gtk_check_button_new_with_label( name3 );
		gtk_widget_set_usize(checkOther[icnt], 50, -1);
		if ( onoff[icnt] == 0 )
		    gtk_toggle_button_set_state(
			GTK_TOGGLE_BUTTON(checkOther[icnt]), FALSE);
		else
		    gtk_toggle_button_set_state(
			GTK_TOGGLE_BUTTON(checkOther[icnt]), TRUE);
		gtk_box_pack_start (GTK_BOX (hbox),
			checkOther[icnt], FALSE, FALSE, 5);
		gtk_widget_show (checkOther[icnt]);
	    }

	}

	if ( mode == 2 )
	{
	    setbtn = gtk_button_new_with_label ( "" );
	    gtk_signal_connect_object (GTK_OBJECT (setbtn), "clicked",
			(GtkSignalFunc) profModeChangeFunc, NULL );
	    gtk_box_pack_start (GTK_BOX (hbox), setbtn, FALSE, FALSE, 10);
	    gtk_widget_show (setbtn);
	}

	return(hbox);
}


/* ץѥƥɽ */
void propatyView ( title, ok, can, finfo )
char	*title ;
char	*ok ;
char	*can ;
FINFO	*finfo ;
{
  GtkWidget *dialog ;
  GtkWidget *hbox[20] ;
  GtkWidget *vbox[20] ;
  GtkWidget *label[10] ;
  GtkWidget *frame[10] ;
  GtkWidget *button1 ;
  GtkWidget *button2 ;
  GtkWidget *sepa ;
  int x,y,w,h ;
  char	*ptr ;
  char	name[256] ;
  char	basyo[1024] ;

  gdk_window_get_origin(cxpmgr->window->window, &x, &y);
  gdk_window_get_size  (cxpmgr->window->window, &w, &h);

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), title );
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_widget_set_usize(dialog, 420, 440);
  gtk_widget_set_uposition(dialog, (x+(w/2)) - (420/2), (y+(h/2)) - (440/2));
  gtk_widget_show (dialog);


  strcpy( basyo, finfo->fname );

  if ( strmatch( "/*/*", basyo ) == 0 )
  {
  	ptr = strrchr( basyo, '/' );
  	*ptr = 0x00 ;
  	if ( strlen(basyo) <= 0 )
		strcpy(basyo,"/" );
  	strcpy( name, ptr+1 );
  }else{
  	ptr = strrchr( basyo, '/' );
  	strcpy( name, ptr+1 );
  	strcpy( basyo, "/" );
  }


  frame[0]=gtk_frame_new( "ܾ" );
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),frame[0],TRUE,FALSE,0);
  gtk_container_border_width(GTK_CONTAINER(frame[0]), 5);
/******
  gtk_frame_set_shadow_type(GTK_FRAME(frame[0]), GTK_SHADOW_IN);
********/
  gtk_widget_show (frame[0]);

  vbox[0] = gtk_vbox_new(FALSE, 2);
  gtk_container_add(GTK_CONTAINER(frame[0]), vbox[0]);
  gtk_widget_show (vbox[0]);

  hbox[0] = make_prof_label( "ե̾", name );
  gtk_box_pack_start(GTK_BOX(vbox[0]),hbox[0],FALSE,FALSE,3);
  gtk_widget_show (hbox[0]);

  hbox[1] = make_prof_label( "ꡡ", basyo );
  gtk_box_pack_start(GTK_BOX(vbox[0]),hbox[1],FALSE,FALSE,3);
  gtk_widget_show (hbox[1]);

  hbox[2] = make_prof_label( "ࡡ", getFileConfigKindName(finfo) );
  gtk_box_pack_start(GTK_BOX(vbox[0]),hbox[2],FALSE,FALSE,3);
  gtk_widget_show (hbox[2]);

  hbox[3] = make_prof_label( "", getFileConfigSize(finfo) );
  gtk_box_pack_start(GTK_BOX(vbox[0]),hbox[3],FALSE,FALSE,3);
  gtk_widget_show (hbox[3]);

  hbox[4] = make_prof_label( "ͭ̾", getFileConfigUidName(finfo) );
  gtk_box_pack_start(GTK_BOX(vbox[0]),hbox[4],FALSE,FALSE,3);
  gtk_widget_show (hbox[4]);

  hbox[5] = make_prof_label( "롼̾", getFileConfigGidName(finfo) );
  gtk_box_pack_start(GTK_BOX(vbox[0]),hbox[5],FALSE,FALSE,3);
  gtk_widget_show (hbox[5]);

  frame[1]=gtk_frame_new( "" );
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),frame[1],TRUE,FALSE,0);
  gtk_container_border_width(GTK_CONTAINER(frame[1]), 5);
/**********
  gtk_frame_set_shadow_type(GTK_FRAME(frame[1]), GTK_SHADOW_IN);
***********/
  gtk_widget_show (frame[1]);

  vbox[1] = gtk_vbox_new(FALSE, 2);
  gtk_container_add(GTK_CONTAINER(frame[1]), vbox[1]);
  gtk_widget_show (vbox[1]);

  hbox[6] = make_prof_label( "ե",getFileConfigCtimeJ(finfo));
  gtk_box_pack_start(GTK_BOX(vbox[1]),hbox[6],FALSE,FALSE,3);
  gtk_widget_show (hbox[6]);

  hbox[7] = make_prof_label( "ǤǶѹ",getFileConfigMtimeJ(finfo));
  gtk_box_pack_start(GTK_BOX(vbox[1]),hbox[7],FALSE,FALSE,3);
  gtk_widget_show (hbox[7]);

  hbox[8] = make_prof_label( "ǤǶΥ",getFileConfigAtimeJ(finfo));
  gtk_box_pack_start(GTK_BOX(vbox[1]),hbox[8],FALSE,FALSE,3);
  gtk_widget_show (hbox[8]);

  frame[2]=gtk_frame_new( "" );
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),frame[2],TRUE,FALSE,0);
  gtk_container_border_width(GTK_CONTAINER(frame[2]), 5);
/*******
  gtk_frame_set_shadow_type(GTK_FRAME(frame[2]), GTK_SHADOW_IN);
*******/
  gtk_widget_show (frame[2]);

  vbox[2] = gtk_vbox_new(FALSE, 2);
  gtk_container_add(GTK_CONTAINER(frame[2]), vbox[2]);
  gtk_widget_show (vbox[2]);

  getFileConfigModeUser( finfo, modeUserOnOff );
  getFileConfigModeGroup( finfo, modeGroupOnOff );
  getFileConfigModeOther( finfo, modeOtherOnOff );

  hbox[9] = make_prof_check( "ͭԡ","ɹ","","¹", 0);
  gtk_box_pack_start(GTK_BOX(vbox[2]),hbox[9],FALSE,FALSE,3);
  gtk_widget_show (hbox[9]);

  hbox[10] = make_prof_check( "롼ס","ɹ","","¹",1);
  gtk_box_pack_start(GTK_BOX(vbox[2]),hbox[10],FALSE,FALSE,3);
  gtk_widget_show (hbox[10]);

  hbox[11] = make_prof_check( "¾","ɹ","","¹",2);
  gtk_box_pack_start(GTK_BOX(vbox[2]),hbox[11],FALSE,FALSE,3);
  gtk_widget_show (hbox[11]);

  _localFileInfo = finfo ;

  button2 = gtk_button_new_with_label (can);
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			(GtkSignalFunc) propatydlg_cancel,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button2, FALSE, TRUE, 10);
  gtk_widget_show (button2);

}
