/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern	CxpMgr    *cxpmgr;
extern  void messageView ();

static char *styleclist_title[2] = { "Ͽ", };

static GtkWidget *styleClist ;
static int _localStyleSelectIndex ;

static void styleChangeOk(GtkWidget *widget, gpointer data)
{
  int i, k, status ;

  k = 0 ;
  status = 0  ;
  for(i=0;i<MAX_STYLE_NUM;i++)
  {
    if ( cxpmgr->style[i].flag == 1 )
    {
	if ( _localStyleSelectIndex == k )
	{
	    cxpmgr->styleIndex = i ;
            status = 1 ;
	    break ;
	}
	k++;
    }
  }

#ifdef DEBUG11
fprintf(stdout,"cxpmgr->styleIndex -> [%d]\n",cxpmgr->styleIndex);
fflush(stdout);
#endif

  if ( !status )
  {
	messageView(
	    "ѹ顼","","Ĥ",
		"ե뤬¸ߤޤ",
		"",NULL );
  }else{
      /* ɽΤȯԤ */
      CxpDirView( "" );

      /* ꤷ¸ */
      getCxplorerInfo( &cxpmgr->cinf );
      cxpmgr->cinf.styleIndex = cxpmgr->styleIndex ;
      setCxplorerInfo( &cxpmgr->cinf );

      /* ɥϥɤ */
      gtk_widget_hide( widget );
  }

}

static void styleChangeCancel(GtkWidget *widget, gpointer data)
{
  /* ɥϥɤ */
  gtk_grab_remove ( widget );
  gtk_widget_hide( widget );
}

static void styleClistSelection( clist, row, column, event, data )
GtkWidget      *clist ;
gint            row ;
gint            column ;
GdkEventButton *event ;
gpointer        data ;
{
	_localStyleSelectIndex = row ;
}

/* ѹ */
void styleChangeDialog ( title, ok, can )
char	*title ;
char	*ok ;
char	*can ;
{
  GtkWidget *dialog ;
  GtkWidget *label ;
  GtkWidget *hbox ;
  GtkWidget *swin ;
  GtkWidget *button1 ;
  GtkWidget *button2 ;
  GdkPixmap *pixmap ;
  GdkBitmap *mask;
  GtkStyle  *style;
  char *namebuff[2] ;
  int x,y,w,h ;
  int i, k ;

  gdk_window_get_origin(cxpmgr->window->window, &x, &y);
  gdk_window_get_size  (cxpmgr->window->window, &w, &h);

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), title );
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_widget_set_usize(dialog, 300, 300);
  gtk_widget_set_uposition(dialog, (x+(w/2)) - (300/2), (y+(h/2)) - (300/2));
  gtk_widget_show (dialog);


  label = gtk_label_new( "ѹ" );
  gtk_widget_show(label );
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label, FALSE, TRUE, 3);


  /* ClistΤ뤿Υ륦ɥ */
  swin = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swin);

  /* ǥ쥯ȥɽѤΥꥹȤ */
  styleClist = gtk_clist_new_with_titles(1, styleclist_title );
  gtk_widget_set_usize(styleClist, 200, -1);
  gtk_clist_set_selection_mode( GTK_CLIST(styleClist),
                                GTK_SELECTION_BROWSE );

  gtk_signal_connect(GTK_OBJECT(styleClist), "select_row",
                GTK_SIGNAL_FUNC(styleClistSelection), NULL);

  /* ȥܥȤʤ褦ˤ롣*/
  gtk_clist_column_titles_passive(GTK_CLIST(styleClist));

  gtk_container_add(GTK_CONTAINER(swin), styleClist);
  gtk_widget_show(styleClist);

#if 0
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		swin, TRUE, TRUE, 5);
#else
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
                hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);

  gtk_box_pack_start (GTK_BOX (hbox), swin, TRUE, TRUE, 20);

#endif

  /* ɽ */
  gtk_clist_freeze( GTK_CLIST(styleClist) );
  gtk_clist_clear( GTK_CLIST(styleClist) );

  k = 0 ;

  style = gtk_widget_get_style( cxpmgr->window );

  for(i=0;i<MAX_STYLE_NUM;i++)
  {
	if ( cxpmgr->style[i].flag == 1 )
	{
#ifdef	DEBUG11
fprintf(stdout,"style [%d] name -> [%s]\n", i, cxpmgr->style[i].name );
#endif
	    namebuff[0] = g_strdup(cxpmgr->style[i].name);
	    gtk_clist_append( GTK_CLIST(styleClist), namebuff);

	    pixmap = gdk_pixmap_create_from_xpm(
		    cxpmgr->window->window,
		    &mask, &style->bg[GTK_STATE_NORMAL],
		    cxpmgr->style[i].treexpm1 );

	    gtk_clist_set_pixtext( GTK_CLIST(styleClist),
		k,			/* row */
		0,              	/* collum */
		cxpmgr->style[i].name,	/* text   */
		2,			/* spacing size */
		pixmap,			/* pixmap */
		mask );			/* mask */
	    k++;
	}
  }

  /* ɽ */
  gtk_clist_thaw( GTK_CLIST(styleClist) );



  button1 = gtk_button_new_with_label (ok);
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
			(GtkSignalFunc) styleChangeOk,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button1, FALSE, TRUE, 20);
  gtk_widget_show (button1);

  button2 = gtk_button_new_with_label (can);
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			(GtkSignalFunc) styleChangeCancel,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button2, FALSE, TRUE, 20);
  gtk_widget_show (button2);


  /* ߤΥ֤Ȥ */
  gtk_clist_select_row( GTK_CLIST(styleClist), cxpmgr->styleIndex, 0 );

}
