/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern	CxpMgr    *cxpmgr;

static char *toolbar_title[12] = {
#ifdef	CXP_ENGLISH
	"Up",
	"Home",
	"New",
	"Copy",
	"Paste",
	"Delete",
	"Update",
	"Info",
	"View",
#else
	"",
	"ۡ",
	"",
	"ԡ",
	"Ž",
	"",
	"",
	"",
	"ɽ",
#endif
};

static char *toolbar_tooltip[12] = {
#ifdef	CXP_ENGLISH
	"Go Up Directory",
	"Go Home Directory",
	"New file",
	"Copy file",
	"Paste file",
	"Delete file",
	"Update View",
	"File Infomation",
	"View Change",
#else
	"ľΥǥ쥯ȥذưޤ",
	"ۡǥ쥯ȥذưޤ",
	"եޤ",
	"ե򥳥ԡޤ",
	"ԡ줿եŽդޤ",
	"եޤ",
	"ߤɽ֤򹹿ޤ",
	"եɽޤ",
	"ɽѹޤ",
#endif
};

static void toolbar_function0 (GtkWidget *widget, gpointer data)
{
	/* ľΥǥ쥯ȥذư */
	movefunc_up();
}
static void toolbar_function1 (GtkWidget *widget, gpointer data)
{
	/* ۡǥ쥯ȥذư */
	movefunc_home();
}
static void toolbar_function2 (GtkWidget *widget, gpointer data)
{
	/* ե */
	filefunc_newfile();
}
static void toolbar_function3 (GtkWidget *widget, gpointer data)
{
	/* 򤵤Ƥե򥳥ԡ */
	editfunc_copy();
}
static void toolbar_function4 (GtkWidget *widget, gpointer data)
{
	/* ԡեŽդ */
	editfunc_paste();
}
static void toolbar_function5 (GtkWidget *widget, gpointer data)
{
	/* 򤵤Ƥե */
	filefunc_delete();
}
static void toolbar_function6 (GtkWidget *widget, gpointer data)
{
	/* ߤɽ򹹿 */
	CxpDirView( "" );
}
static void toolbar_function7 (GtkWidget *widget, gpointer data)
{
	/* 򤵤Ƥեɽ */
	filefunc_propaty();
}
static void toolbar_function8 (GtkWidget *widget, gpointer data)
{
	/* ɽѹ */

#if 0
	switch( cxpmgr->viewMode )
	{
	case VIEW_LIST :
		cxpmgr->viewMode = VIEW_LISTFILE ;
		break ;
	case VIEW_LISTFILE :
		cxpmgr->viewMode = VIEW_BIGICON ;
		break ;
	case VIEW_BIGICON :
		cxpmgr->viewMode = VIEW_LIST ;
		break ;
	}
#endif

	/* ɽ򹹿 */
	CxpDirView( "" );
}


void cxp_topcmd_init()
{
  GtkWidget     *handle_box ;
  GtkWidget     *vbox ;
  GtkWidget	*toolbar;
  GtkWidget	*pixmapwid;
  GtkWidget	*item ;
  GtkWidget	*separator ;
  GdkPixmap	*pixmap ;
  GdkBitmap	*mask;
  GtkStyle	*style;

  int		i ;

  handle_box = gtk_handle_box_new ();
#if 0
  gtk_box_pack_start (GTK_BOX(cxpmgr->vbox), handle_box, FALSE, FALSE, 0 );
#else
  gtk_box_pack_start (GTK_BOX(cxpmgr->vbox), handle_box, FALSE, TRUE, 0 );
#endif
  gtk_widget_show (handle_box);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(handle_box), vbox );
  gtk_widget_show(vbox);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show(separator);

  toolbar = gtk_toolbar_new ( GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  gtk_box_pack_start (GTK_BOX(vbox), toolbar, FALSE, FALSE, 0 );
  gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_NONE);
  gtk_widget_show(toolbar);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show(separator);

  style = gtk_widget_get_style( cxpmgr->window );
  for(i=0;i<9;i++)
  {
	pixmap = gdk_pixmap_create_from_xpm(
		cxpmgr->window->window,
		&mask, &style->bg[GTK_STATE_NORMAL],
		cxpmgr->base.topcmd[i] );
	pixmapwid = gtk_pixmap_new (pixmap, mask);

	switch(i)
	{
	case 0 :
		item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			toolbar_title[i], toolbar_tooltip[i], NULL,
			pixmapwid, toolbar_function0, (gpointer)NULL );
		break ;
	case 1 :
		item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			toolbar_title[i], toolbar_tooltip[i], NULL,
			pixmapwid, toolbar_function1, (gpointer)NULL );
		break ;
	case 2 :
		item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			toolbar_title[i], toolbar_tooltip[i], NULL,
			pixmapwid, toolbar_function2, (gpointer)NULL );
		break ;
	case 3 :
		item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			toolbar_title[i], toolbar_tooltip[i], NULL,
			pixmapwid, toolbar_function3, (gpointer)NULL );
		break ;
	case 4 :
		item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			toolbar_title[i], toolbar_tooltip[i], NULL,
			pixmapwid, toolbar_function4, (gpointer)NULL );
		break ;
	case 5 :
		item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			toolbar_title[i], toolbar_tooltip[i], NULL,
			pixmapwid, toolbar_function5, (gpointer)NULL );
		break ;
	case 6 :
		item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			toolbar_title[i], toolbar_tooltip[i], NULL,
			pixmapwid, toolbar_function6, (gpointer)NULL );
		break ;
	case 7 :
		item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			toolbar_title[i], toolbar_tooltip[i], NULL,
			pixmapwid, toolbar_function7, (gpointer)NULL );
		break ;
	case 8 :
		item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			toolbar_title[i], toolbar_tooltip[i], NULL,
			pixmapwid, toolbar_function8, (gpointer)NULL );
		break ;
	}
  }
}
