/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern	CxpMgr    *cxpmgr;

void CxpDirView( pathname )
char	*pathname ;
{
	FINFO	*finfo ;
	int	row ;
	char	*ptr ;
	char	workbuff[1024] ;
	struct stat fileinfo ;

#ifdef DEBUG6
fprintf(stdout,"CxpDirView end pathname [%s] pwdbuff[%s]\n", pathname,cxpmgr->pwdbuff);
fflush(stdout);
#endif

	if ( strlen( pathname ) <= 0 )
		strcpy( workbuff, cxpmgr->pwdbuff );
	else
		strcpy( workbuff, pathname );
	if ( strcmp( workbuff, "/" ) != 0 )
	{
	    if ( strmatch( "*/", workbuff) == 0 )
	    {
		ptr = strrchr( workbuff, '/' );
		*ptr = 0x00 ;
	    }
	}

	if ( access( workbuff, F_OK ) )
	{
		gtk_entry_set_text( GTK_ENTRY(cxpmgr->address),
					cxpmgr->pwdbuff );
		return ;
	}else{
		stat( workbuff, &fileinfo );
		if ( !S_ISDIR( fileinfo.st_mode ) )
		{
		    gtk_entry_set_text( GTK_ENTRY(cxpmgr->address),
					cxpmgr->pwdbuff );
		    return ;
		}

		memset( &(cxpmgr->select), 0x00, sizeof(SELECTINFO) );

		strcpy( cxpmgr->pwdbuff , workbuff );
		gtk_entry_set_text( GTK_ENTRY(cxpmgr->address),
					cxpmgr->pwdbuff );

		finfo = (FINFO *)getDirectoryInfoName(
			&cxpmgr->fsInfo.root, cxpmgr->pwdbuff, &row );

		/* ɽ */
		gtk_clist_freeze( GTK_CLIST(cxpmgr->clist1) );

		gtk_clist_clear( GTK_CLIST(cxpmgr->clist1) );

		if ( finfo == (FINFO *)NULL )
		{
			/* бǥ쥯ȥ󤬤ʤϺ */
			getDirectoryInfo( "/", &cxpmgr->fsInfo.root ) ;

			cxpmgr->totalCount = 0 ;
			cxpmgr->currentViewFlag = 1 ;
			printDirectory( &cxpmgr->fsInfo.root, -1,
					&cxpmgr->totalCount);

			finfo = (FINFO *)getDirectoryInfoName(
				&cxpmgr->fsInfo.root, cxpmgr->pwdbuff, &row );
		}

		/* ǥ쥯ȥɽ˴ */
		DirectoryRemove( &cxpmgr->fsInfo.root, row ) ;

		/* ǥ쥯ȥ󤫤ɽѺ */
		cxpmgr->totalCount = 0 ;
		cxpmgr->currentViewFlag = 1 ;
		printDirectory( &cxpmgr->fsInfo.root, -1, &cxpmgr->totalCount);

		/* ɽ */
		cxpmgr->currentViewFlag = 1 ;
		gtk_clist_select_row( GTK_CLIST(cxpmgr->clist1), row, 0 );

		/* ɽ֤ι */
		gtk_clist_moveto( GTK_CLIST(cxpmgr->clist1),
				row, 0,
				(gfloat)0.5,
				(gfloat)0.0 );

		/* ɽ */
		gtk_clist_thaw( GTK_CLIST(cxpmgr->clist1) );

		/* ɽ */
		gtk_clist_freeze( GTK_CLIST(cxpmgr->clist2) );

		/* եκ */
		gtk_clist_clear( GTK_CLIST(cxpmgr->clist2) );
		if ( getFileInfoByName( &cxpmgr->fsView, cxpmgr->pwdbuff ) )
		{
			cxpmgr->currentViewFlag2 = 1 ;
			printFileInfo( &cxpmgr->fsView );
		}
		/* ɽ */
		gtk_clist_thaw( GTK_CLIST(cxpmgr->clist2) );
	}

#ifdef DEBUG6
fprintf(stdout,"CxpDirView end pwdbuff[%s]\n", cxpmgr->pwdbuff);
fflush(stdout);
#endif

}

void viewfunc_big()
{
	CxpDirView( "" ) ;
}
void viewfunc_small()
{
	CxpDirView( "" ) ;
}
void viewfunc_list()
{
	CxpDirView( "" ) ;
}
void viewfunc_listfile()
{
	CxpDirView( "" ) ;
}
void viewfunc_update()
{
	CxpDirView( "" ) ;
}
