/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

CxpMail *cxpmail;

int exitfunc ()
{
	int x, y, w, h;
	int xymode, whmode;

	getGeometryInfo (CXPMAIL_MODE, &xymode, &whmode, &x, &y, &w, &h);
	if (xymode == 0)	/* ΰ */
	{
		x = cxpmail->window->allocation.x;
		y = cxpmail->window->allocation.y;
	}
	if (whmode == 0)	/* Υ */
	{
		w = cxpmail->window->allocation.width;
		h = cxpmail->window->allocation.height;
	}
	setGeometryInfo (CXPMAIL_MODE, xymode, whmode, x, y, w, h);

	gtk_main_quit ();
}


static int cxpmailMailTimer (gpointer data)
{
	char *messPtr;

	if (cxpmail->view == 1)
	{
		/*  */
		cxpmail_base_view ();
		cxpmail_title_view ();
		cxpmail_view_view ();

		cxpmail->view = 0;
	}

	if (cxpmail->messEvent != 0)
	{
		messPtr = (char *) NULL;
		/* åɽ */
		switch (cxpmail->messEvent)
		{
		case MSID_SOCK_OPEN_ERR:
			messPtr = MESS_SOCK_OPEN_ERR;
			break;
		case MSID_SMTP_CNCT_ERR:
			messPtr = MESS_SMTP_CNCT_ERR;
			break;
		case MSID_SMTP_START_ERR:
			messPtr = MESS_SMTP_START_ERR;
			break;
		case MSID_SMTP_ANSWER_ERR:
			messPtr = MESS_SMTP_ANSWER_ERR;
			break;
		case MSID_FROM_ADDR_NG:
			messPtr = MESS_FROM_ADDR_NG;
			break;
		case MSID_FROM_ADDR_ANSERR:
			messPtr = MESS_FROM_ADDR_ANSERR;
			break;
		case MSID_TO_ADDR_NULL:
			messPtr = MESS_TO_ADDR_NULL;
			break;
		case MSID_TO_ADDR_ERR:
			messPtr = MESS_TO_ADDR_ERR;
			break;
		case MSID_TO_ADDR_ANSERR:
			messPtr = MESS_TO_ADDR_ANSERR;
			break;
		case MSID_DATA_START_ERR:
			messPtr = MESS_DATA_START_ERR;
			break;
		case MSID_DATA_START_ANSERR:
			messPtr = MESS_DATA_START_ANSERR;
			break;
		case MSID_DATA_SEND_ERR:
			messPtr = MESS_DATA_SEND_ERR;
			break;
		case MSID_DATA_END_ERR:
			messPtr = MESS_DATA_END_ERR;
			break;
		case MSID_DATA_END_ANSERR:
			messPtr = MESS_DATA_END_ANSERR;
			break;
		case MSID_SMTP_CLOSE_ERR:
			messPtr = MESS_SMTP_CLOSE_ERR;
			break;
		case MSID_SMTP_CLOSE_ANSERR:
			messPtr = MESS_SMTP_CLOSE_ANSERR;
			break;
		case MSID_SOCK_CLOSE_ERR:
			messPtr = MESS_SOCK_CLOSE_ERR;
			break;
		case MSID_SOUSIN_MOVE_ERR:
			messPtr = MESS_SOUSIN_MOVE_ERR;
			break;
		case MSID_POP3_CNCT_ERR:
			messPtr = MESS_POP3_CNCT_ERR;
			break;
		case MSID_POP3_USER_ERR:
			messPtr = MESS_POP3_USER_ERR;
			break;
		case MSID_POP3_USER_ANSERR:
			messPtr = MESS_POP3_USER_ANSERR;
			break;
		case MSID_POP3_PASS_ERR:
			messPtr = MESS_POP3_PASS_ERR;
			break;
		case MSID_POP3_PASS_ANSERR:
			messPtr = MESS_POP3_PASS_ANSERR;
			break;
		case MSID_INFO_GET_ERR:
			messPtr = MESS_INFO_GET_ERR;
			break;
		case MSID_INFO_GET_ANSERR:
			messPtr = MESS_INFO_GET_ANSERR;
			break;
		case MSID_INFO_AREA_ERR:
			messPtr = MESS_INFO_AREA_ERR;
			break;
		case MSID_DATA_GET_ERR:
			messPtr = MESS_DATA_GET_ERR;
			break;
		case MSID_DATA_GET_ANSERR:
			messPtr = MESS_DATA_GET_ANSERR;
			break;
		case MSID_DATA_RETR_ERR:
			messPtr = MESS_DATA_RETR_ERR;
			break;
		case MSID_DATA_AREA_ERR:
			messPtr = MESS_DATA_AREA_ERR;
			break;
		case MSID_DELE_ERR:
			messPtr = MESS_DELE_ERR;
			break;
		case MSID_DELE_ANSERR:
			messPtr = MESS_DELE_ANSERR;
			break;
		case MSID_POP3_CLOSE_ERR:
			messPtr = MESS_POP3_CLOSE_ERR;
			break;
		case MSID_POP3_CLOSE_ANSERR:
			messPtr = MESS_POP3_CLOSE_ANSERR;
			break;
		case MSID_UNKNOWN_ERR:
			messPtr = MESS_UNKNOWN_ERR;
			break;
		default:
			messPtr = (char *) NULL;
			break;
		}

		if (messPtr != (char *) NULL)
		{
			create_messageWin (cxpmail->window, messPtr);
		}

		cxpmail->messEvent = 0;
	}
}

static int cxpmail_init ()
{
	char fontbuff[1024];
	int cxpmailTimer;
	GdkColor col;
	int x, y, w, h;
	int xymode, whmode;

	getBaseConfig (&cxpmail->base);

	getNetConfig (&cxpmail->cinfoMaxNum, &cxpmail->cinfo, &cxpmail->my);

	/* μ */
	getGeometryInfo (CXPMAIL_MODE, &xymode, &whmode, &x, &y, &w, &h);

	cxpmail->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (cxpmail->window), "destroy",
			    GTK_SIGNAL_FUNC (exitfunc), NULL);
	gtk_window_set_title (GTK_WINDOW (cxpmail->window), "Cxpmail");
	gtk_widget_set_usize (cxpmail->window, 100, 100);
	gtk_window_set_default_size (GTK_WINDOW (cxpmail->window), 700, 500);

	if ((xymode == 0) || (xymode == 1))
	{
		if (x != -1 && y != -1)
		{
			/* ΰ */
			if (x >= gdk_root_parent.width)
				x = gdk_root_parent.width / 2;
			if (y >= gdk_root_parent.height)
				y = gdk_root_parent.height / 2;

			gtk_widget_set_uposition (cxpmail->window, x, y);
		}
	}

	if ((whmode == 0) || (whmode == 1))
	{
		if (w != -1 && h != -1)
		{
			if (w >= gdk_root_parent.width)
				w = gdk_root_parent.width;
			if (h >= gdk_root_parent.height)
				h = gdk_root_parent.height;

			gtk_window_set_default_size (GTK_WINDOW
						     (cxpmail->window), w, h);
		}
	}

	cxpmail->vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (cxpmail->window), cxpmail->vbox);
	gtk_widget_show (cxpmail->vbox);

	/* ˥塼κ */
	cxpmail_menu_init ();

	cxpmail_tool_init ();

	/* ʬǡ礭򤤤 */
	cxpmail->hpanel = gtk_hpaned_new ();
	gtk_container_set_border_width (GTK_CONTAINER (cxpmail->hpanel), 2);
	gtk_box_pack_start (GTK_BOX (cxpmail->vbox), cxpmail->hpanel, TRUE,
			    TRUE, 1);
	gtk_widget_show (cxpmail->hpanel);

	/* ʬǡ礭򤤤 */
	cxpmail->vpanel = gtk_vpaned_new ();
	gtk_container_set_border_width (GTK_CONTAINER (cxpmail->vpanel), 2);
	gtk_paned_add2 (GTK_PANED (cxpmail->hpanel), cxpmail->vpanel);
	gtk_widget_show (cxpmail->vpanel);


#if 0
	cxpmail->fontIndex = -1;
	sprintf (fontbuff, "%s,%s,%s",
		 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-iso8859-1",
		 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-jisx0208.1983-0",
		 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-jisx0201.1976-0");
	cxpmail->font = gdk_fontset_load (fontbuff);
#else

	sprintf (fontbuff, "%s,%s,%s",
		 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-iso8859-1",
		 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-jisx0208.1983-0",
		 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-jisx0201.1976-0");

	/* ̾Υե */
	cxpmail->styleNormal = gtk_style_new ();
	gdk_font_unref (cxpmail->styleNormal->font);
	cxpmail->styleNormal->font = gdk_fontset_load (fontbuff);

	/* ̤ɤΥե */
	cxpmail->styleBold = gtk_style_new ();
#if 0
	col.red = 0;
	col.green = 0;
	col.blue = 56000;
	cxpmail->styleBold->fg[GTK_STATE_NORMAL] = col;
#endif
	gdk_font_unref (cxpmail->styleBold->font);
	cxpmail->styleBold->font = gdk_fontset_load (fontbuff);

	/* ɽѤΥե */
	cxpmail->fontIndex = -1;
	cxpmail->font = gdk_fontset_load (fontbuff);
#endif

	/* CxpmailΤΥޡ */
	cxpmail->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	cxpmailTimer =
		gtk_timeout_add (200, (GtkFunction) cxpmailMailTimer,
				 cxpmail->window);


	cxpmail_base_init ();
	cxpmail_title_init ();
	cxpmail_view_init ();

	/* ս˥ */
	cxpmail->sortno = 7;

	cxpmail_base_view ();
	cxpmail_title_view ();
	cxpmail_view_view ();

	gtk_widget_show (cxpmail->window);
}

int main (int argc, char *argv[])
{
	int i, count;
	struct stat fileinfo;

	CxpBasePathInit ();

	/* ޥ͡㵯ư */
	cxp_manager_start ();

	cxpmail = (CxpMail *) g_malloc (sizeof (CxpMail));

	/* ꥢ */
	memset (cxpmail, 0x00, sizeof (CxpMail));

	/* BOX */
	getMailBoxInfo (&(cxpmail->minfo));

	/* إå */
	for (i = 0; i < MAX_BOX_NUM; i++)
	{
		if (cxpmail->minfo.box[i] != (BoxInfo *) NULL)
		{
			if (cxpmail->minfo.box[i]->boxName != NULL)
			{
				if (strlen (cxpmail->minfo.box[i]->boxName) >
				    0)
				{
					getMailHeader (cxpmail->minfo.box[i]);

#ifdef DEBUG3
					fprintf (stdout,
						 "NAME [%s] HEADER [%s] count %d \n",
						 cxpmail->minfo.box[i]->
						 boxName,
						 cxpmail->minfo.box[i]->
						 boxHeader,
						 cxpmail->minfo.box[i]->
						 count);
#endif
				}
			}
		}
	}

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	cxpmail_init ();

	gtk_main ();
	exit (0);
}
