/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static GtkWidget *addBoxWin;
static GtkWidget *boxNameEntry;
static GtkWidget *setBtn;
static GtkWidget *canBtn;

static int setFunction (GtkWidget * widget, GtkWidget * win)
{
	char *boxName;
	char buff[1024];
	int count, i;

	boxName = gtk_entry_get_text (GTK_ENTRY (boxNameEntry));
	if (boxName == (char *) NULL)
	{
		create_messageWin (cxpmail->window,
				   "ܥå̾ϤƲ");
		return (0);
	}

	if (strlen (boxName) <= 0)
	{
		create_messageWin (cxpmail->window,
				   "ܥå̾ϤƲ");
		return (0);
	}

	count = 0;
	for (i = 0; i < MAX_BOX_NUM; i++)
	{
		if (cxpmail->minfo.box[i] != (BoxInfo *) NULL)
		{
			if (cxpmail->minfo.box[i]->boxName != NULL)
			{
				count++;
			}
		}
	}

	sprintf (buff, "%s.idx", boxName);

	if (cxpmail->minfo.box[count] == (BoxInfo *) NULL)
	{
		cxpmail->minfo.box[count] = malloc (sizeof (BoxInfo));
		memset (cxpmail->minfo.box[count], 0x00, sizeof (BoxInfo));
	}

	cxpmail->minfo.box[count]->count = 0;
	cxpmail->minfo.box[count]->boxName = g_strdup (boxName);
	cxpmail->minfo.box[count]->boxHeader = g_strdup (buff);

	/* ǡ򹹿 */
	setMailBoxInfo (&cxpmail->minfo);

	/* ǡɽ */
	cxpmail_base_view ();

	gtk_widget_destroy (win);
}

static int cancelFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (win);
}

int create_addBoxWin ()
{
	GtkWidget *hbox1;
	GtkWidget *vbox2;
	GtkWidget *label1;
	GtkWidget *hbox3;
	GtkWidget *label2;
	GtkWidget *hbox2;
	int x, y, w, h;
	int i, count;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w * 0.5;
	y = h * 0.5;

	count = 0;
	for (i = 0; i < MAX_BOX_NUM; i++)
	{
		if (cxpmail->minfo.box[i] != (BoxInfo *) NULL)
		{
			if (cxpmail->minfo.box[i]->boxName != NULL)
			{
				count++;
			}
		}
	}

	if (count >= MAX_BOX_NUM)
	{
		create_messageWin (cxpmail->window,
				   "ʾΥܥåϺǤޤ");
		return (0);
	}

	addBoxWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (addBoxWin), "addBoxWin", addBoxWin);
	gtk_window_set_title (GTK_WINDOW (addBoxWin), "ܥåɲ");
	gtk_widget_set_usize (addBoxWin, 100, 100);
	gtk_window_set_default_size (GTK_WINDOW (addBoxWin), 300, 130);
	gtk_widget_set_uposition (addBoxWin, (x - 250 * 0.5),
				  (y - 130 * 0.5));
	gtk_widget_show (addBoxWin);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (addBoxWin), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_container_add (GTK_CONTAINER (addBoxWin), hbox1);
	gtk_container_set_border_width (GTK_CONTAINER (hbox1), 8);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (addBoxWin), "vbox2", vbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox2, TRUE, TRUE, 0);

	label1 = gtk_label_new ("ܥå̾ϤƲ");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (addBoxWin), "label1", label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox2), label1, FALSE, FALSE, 0);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (addBoxWin), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox3, TRUE, TRUE, 0);

	label2 = gtk_label_new ("ܥå̾");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (addBoxWin), "label2", label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (hbox3), label2, FALSE, FALSE, 0);

	boxNameEntry = gtk_entry_new ();
	gtk_widget_ref (boxNameEntry);
	gtk_object_set_data_full (GTK_OBJECT (addBoxWin), "boxNameEntry",
				  boxNameEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (boxNameEntry);
	gtk_box_pack_start (GTK_BOX (hbox3), boxNameEntry, TRUE, TRUE, 0);

	hbox2 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (addBoxWin), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, TRUE, 10);

	setBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (setBtn);
	gtk_object_set_data_full (GTK_OBJECT (addBoxWin), "setBtn", setBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (setBtn);
	gtk_box_pack_start (GTK_BOX (hbox2), setBtn, FALSE, FALSE, 0);

	canBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (canBtn);
	gtk_object_set_data_full (GTK_OBJECT (addBoxWin), "canBtn", canBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (canBtn);
	gtk_box_pack_start (GTK_BOX (hbox2), canBtn, FALSE, FALSE, 0);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (setBtn), "clicked",
			    (GtkSignalFunc) setFunction, addBoxWin);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (canBtn), "clicked",
			    (GtkSignalFunc) cancelFunction, addBoxWin);


	return (0);
}
