/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

typedef struct
{
	GtkWidget *addrwin;
	GtkWidget *addr_alllist;
	GtkWidget *addr_atenalist;
	GtkWidget *addr_cclist;

	int sendNum;
	CxpSendAddr send[MAX_SENDMAIL_NUM];
	int ccNum;
	CxpSendAddr cc[MAX_SENDMAIL_NUM];

	CxpMailClient *client;
} CxpMailAddrInfo;

static GtkWidget *newAtenaWindow;
static GtkWidget *nameEntry;
static GtkWidget *emailEntry;
static GtkWidget *ateneCheckBtn;
static GtkWidget *ccCheckBtn;
static GtkWidget *newAtenaAddBtn;
static GtkWidget *newAtenaCanBtn;

static CxpMailAddrInfo ainfo;

static int cxpmail_addr_allview ();
static int cxpmail_addr_atenaview ();
static int cxpmail_addr_ccview ();

static int addr_allselect;
static int addr_atenaselect;
static int addr_ccselect;

static char *alllist_title[2] = {
	"̾",
	"Żҥ᡼"
};
static char *atenalist_title[2] = {
	"̾",
	"Żҥ᡼"
};
static char *cclist_title[2] = {
	"̾",
	"Żҥ᡼"
};


/* ̾ */
static void newaddrCallBack (GtkWidget * widget, gpointer data)
{
	create_newAtenaWindow ();
}

/* ̾ɽ */
static void propaddrCallBack (GtkWidget * widget, gpointer data)
{
	int i;

	if (addr_allselect > 0)
	{
		i = addr_allselect - 1;

		create_atenaInfoWindow (&cxpmail->addr[i]);
	}
	else
	{
		create_messageWin (cxpmail->window,
				   "̾򤵤Ƥޤ");
	}
}

/* ̾ */
static void atenasetCallBack (GtkWidget * widget, gpointer data)
{
	char *viewdata[8];
	int i, k, check;

	if (addr_allselect > 0)
	{
		i = addr_allselect - 1;

		/* ϿƤ뤫å */
		check = 0;
		for (k = 0; k < ainfo.sendNum; k++)
		{
			if (strcmp (cxpmail->addr[i].name, ainfo.send[k].name)
			    == 0)
				check = 1;
		}
		if (check == 0)
		{
			ainfo.send[ainfo.sendNum].name =
				g_strdup (cxpmail->addr[i].name);
			ainfo.send[ainfo.sendNum].email =
				g_strdup (cxpmail->addr[i].email);

			viewdata[0] =
				g_strdup (ainfo.send[ainfo.sendNum].name);
			viewdata[1] =
				g_strdup (ainfo.send[ainfo.sendNum].email);
			gtk_clist_append (GTK_CLIST (ainfo.addr_atenalist),
					  viewdata);

			ainfo.sendNum++;
		}
		cxpmail_addr_atenaview ();
	}
}

/* ̾ */
static void atenadelCallBack (GtkWidget * widget, gpointer data)
{
	int i, k;

	if (addr_atenaselect > 0)
	{
		i = addr_atenaselect - 1;

		if (ainfo.sendNum > i)
		{
			for (k = i; k < ainfo.sendNum - 1; k++)
			{
				ainfo.send[k].name =
					g_strdup (ainfo.send[k + 1].name);
				ainfo.send[k].email =
					g_strdup (ainfo.send[k + 1].email);
			}
			ainfo.sendNum--;
			if (ainfo.sendNum < 0)
				ainfo.sendNum = 0;
		}
		cxpmail_addr_atenaview ();
	}
}

/* ãä */
static void ccsetCallBack (GtkWidget * widget, gpointer data)
{
	char *viewdata[8];
	int i, k, check;

	if (addr_allselect > 0)
	{
		i = addr_allselect - 1;

		/* ϿƤ뤫å */
		check = 0;
		for (k = 0; k < ainfo.ccNum; k++)
		{
			if (strcmp (cxpmail->addr[i].name, ainfo.cc[k].name)
			    == 0)
				check = 1;
		}
		if (check == 0)
		{
			ainfo.cc[ainfo.ccNum].name =
				g_strdup (cxpmail->addr[i].name);
			ainfo.cc[ainfo.ccNum].email =
				g_strdup (cxpmail->addr[i].email);

			viewdata[0] = g_strdup (ainfo.cc[ainfo.ccNum].name);
			viewdata[1] = g_strdup (ainfo.cc[ainfo.ccNum].email);
			gtk_clist_append (GTK_CLIST (ainfo.addr_cclist),
					  viewdata);

			ainfo.ccNum++;
		}
		cxpmail_addr_ccview ();
	}
}

/* ãä */
static void ccdelCallBack (GtkWidget * widget, gpointer data)
{
	int i, k;

	if (addr_ccselect > 0)
	{
		i = addr_ccselect - 1;

		if (ainfo.ccNum > i)
		{
			for (k = i; k < ainfo.ccNum - 1; k++)
			{
				ainfo.cc[k].name =
					g_strdup (ainfo.cc[k + 1].name);
				ainfo.cc[k].email =
					g_strdup (ainfo.cc[k + 1].email);
			}
			ainfo.ccNum--;
			if (ainfo.ccNum < 0)
				ainfo.ccNum = 0;
		}
		cxpmail_addr_ccview ();
	}
}

/*  */
static void setCallBack (GtkWidget * widget, gpointer data)
{
	char sendBuff[4096];
	char ccBuff[4096];
	char buff[1024];
	int i;

	memset (sendBuff, 0x00, sizeof (sendBuff));
	memset (ccBuff, 0x00, sizeof (ccBuff));

	ainfo.client->sendNum = ainfo.sendNum;
	ainfo.client->ccNum = ainfo.ccNum;

	for (i = 0; i < ainfo.sendNum; i++)
	{
		ainfo.client->send[i].name = g_strdup (ainfo.send[i].name);
		ainfo.client->send[i].email = g_strdup (ainfo.send[i].email);
		if (i == 0)
			sprintf (buff, "%s", ainfo.client->send[i].email);
		else
			sprintf (buff, ";%s", ainfo.client->send[i].email);
		strcat (sendBuff, buff);
	}
	for (i = 0; i < ainfo.ccNum; i++)
	{
		ainfo.client->cc[i].name = g_strdup (ainfo.cc[i].name);
		ainfo.client->cc[i].email = g_strdup (ainfo.cc[i].email);
		if (i == 0)
			sprintf (buff, "%s", ainfo.client->cc[i].email);
		else
			sprintf (buff, ";%s", ainfo.client->cc[i].email);
		strcat (ccBuff, buff);
	}

	/* ᥤإǡ */
	gtk_entry_set_text (GTK_ENTRY (ainfo.client->send_entry), sendBuff);
	gtk_entry_set_text (GTK_ENTRY (ainfo.client->cc_entry), ccBuff);

	gtk_widget_destroy (ainfo.addrwin);
}

/*  */
static void cancelCallBack (GtkWidget * widget, gpointer data)
{
	gtk_widget_destroy (ainfo.addrwin);
}



static void alllist_selection (GtkWidget * clist, gint row, gint column,
			       GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return;
	addr_allselect = row + 1;
}
static void atenalist_selection (GtkWidget * clist, gint row, gint column,
				 GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return;
	addr_atenaselect = row + 1;
}
static void cclist_selection (GtkWidget * clist, gint row, gint column,
			      GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return;
	addr_ccselect = row + 1;
}

int cxpmail_addrselwin (CxpMailClient * client)
{
	GtkWidget *vboxbase;
	GtkWidget *hbox2;
	GtkWidget *vbox2;
	GtkWidget *label1;
	GtkWidget *hbox3;
	GtkWidget *newaddrbtn;
	GtkWidget *propaddrbtn;
	GtkWidget *vbox3;
	GtkWidget *atenasetbtn;
	GtkWidget *atenadelbtn;
	GtkWidget *ccsetbtn;
	GtkWidget *ccdelbtn;
	GtkWidget *vbox4;
	GtkWidget *label2;
	GtkWidget *label3;
	GtkWidget *hbox4;
	GtkWidget *swin1;
	GtkWidget *swin2;
	GtkWidget *swin3;
	GtkWidget *setbtn;
	GtkWidget *cancelbtn;
	int x, y, w, h;
	int i;

	memset (&ainfo, 0x00, sizeof (CxpMailAddrInfo));
	ainfo.client = client;

	addr_allselect = 0;
	addr_atenaselect = 0;
	addr_ccselect = 0;

	/* ɥ쥹ɤ߹ */
	getAddressData (&(cxpmail->addrkensu), &(cxpmail->addr));

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	ainfo.addrwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (ainfo.addrwin), "addrwin",
			     ainfo.addrwin);
	gtk_widget_set_usize (ainfo.addrwin, 600, 350);
	gtk_window_set_title (GTK_WINDOW (ainfo.addrwin), "̾");
	gtk_widget_set_uposition (ainfo.addrwin, (x - 600 * 0.5),
				  (y - 350 * 0.5));
	gtk_widget_show (ainfo.addrwin);

	vboxbase = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vboxbase);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "vboxbase",
				  vboxbase,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vboxbase);
	gtk_container_add (GTK_CONTAINER (ainfo.addrwin), vboxbase);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vboxbase), hbox2, TRUE, TRUE, 0);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "vbox2", vbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox2), vbox2, TRUE, TRUE, 0);

	label1 = gtk_label_new ("̾");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "label1",
				  label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox2), label1, FALSE, FALSE, 0);

	/* ̾ꥹ */
	swin1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin1),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (vbox2), swin1, TRUE, TRUE, 0);
	gtk_widget_show (swin1);

	ainfo.addr_alllist = gtk_clist_new_with_titles (2, alllist_title);
	gtk_widget_set_usize (ainfo.addr_alllist, 250, -1);
	gtk_clist_set_selection_mode (GTK_CLIST (ainfo.addr_alllist),
				      GTK_SELECTION_BROWSE);
	gtk_clist_set_column_width (GTK_CLIST (ainfo.addr_alllist), 0, 120);
	gtk_clist_set_column_width (GTK_CLIST (ainfo.addr_alllist), 1, 200);
	gtk_signal_connect (GTK_OBJECT (ainfo.addr_alllist), "select_row",
			    GTK_SIGNAL_FUNC (alllist_selection), NULL);
	gtk_container_add (GTK_CONTAINER (swin1), ainfo.addr_alllist);
	gtk_widget_show (ainfo.addr_alllist);

	hbox3 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox3, FALSE, TRUE, 5);


	/* ̾ܥ */
	newaddrbtn = gtk_button_new_with_label ("̾");
	gtk_widget_ref (newaddrbtn);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin),
				  "newaddrbtn", newaddrbtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect (GTK_OBJECT (newaddrbtn), "clicked",
			    (GtkSignalFunc) newaddrCallBack, NULL);
	gtk_widget_show (newaddrbtn);
	gtk_box_pack_start (GTK_BOX (hbox3), newaddrbtn, FALSE, FALSE, 0);

	/* ̾ܥ */
	propaddrbtn = gtk_button_new_with_label ("̾");
	gtk_widget_ref (propaddrbtn);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin),
				  "propaddrbtn", propaddrbtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect (GTK_OBJECT (propaddrbtn), "clicked",
			    (GtkSignalFunc) propaddrCallBack, NULL);
	gtk_widget_show (propaddrbtn);
	gtk_box_pack_start (GTK_BOX (hbox3), propaddrbtn, FALSE, FALSE, 0);

	vbox3 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox3);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "vbox3", vbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox3);
	gtk_box_pack_start (GTK_BOX (hbox2), vbox3, FALSE, TRUE, 0);

	/* ̾ܥ */
	atenasetbtn = gtk_button_new_with_label ("");
	gtk_widget_ref (atenasetbtn);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin),
				  "atenasetbtn", atenasetbtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect (GTK_OBJECT (atenasetbtn), "clicked",
			    (GtkSignalFunc) atenasetCallBack, NULL);
	gtk_widget_show (atenasetbtn);
	gtk_box_pack_start (GTK_BOX (vbox3), atenasetbtn, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (atenasetbtn), 10);

	/* ̾ܥ */
	atenadelbtn = gtk_button_new_with_label ("");
	gtk_widget_ref (atenadelbtn);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin),
				  "atenadelbtn", atenadelbtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect (GTK_OBJECT (atenadelbtn), "clicked",
			    (GtkSignalFunc) atenadelCallBack, NULL);
	gtk_widget_show (atenadelbtn);
	gtk_box_pack_start (GTK_BOX (vbox3), atenadelbtn, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (atenadelbtn), 10);

	/* ãܥ */
	ccsetbtn = gtk_button_new_with_label ("ãä");
	gtk_widget_ref (ccsetbtn);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin),
				  "ccsetbtn", ccsetbtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect (GTK_OBJECT (ccsetbtn), "clicked",
			    (GtkSignalFunc) ccsetCallBack, NULL);
	gtk_widget_show (ccsetbtn);
	gtk_box_pack_start (GTK_BOX (vbox3), ccsetbtn, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (ccsetbtn), 10);

	/* ãúܥ */
	ccdelbtn = gtk_button_new_with_label ("ãú");
	gtk_widget_ref (ccdelbtn);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin),
				  "ccdelbtn", ccdelbtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect (GTK_OBJECT (ccdelbtn), "clicked",
			    (GtkSignalFunc) ccdelCallBack, NULL);
	gtk_widget_show (ccdelbtn);
	gtk_box_pack_start (GTK_BOX (vbox3), ccdelbtn, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (ccdelbtn), 10);

	vbox4 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox4);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "vbox4", vbox4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox4);
	gtk_box_pack_start (GTK_BOX (hbox2), vbox4, TRUE, TRUE, 0);

	label2 = gtk_label_new ("");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "label2",
				  label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox4), label2, FALSE, FALSE, 0);

	/* ꥹ */
	swin2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin2),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (vbox4), swin2, TRUE, TRUE, 0);
	gtk_widget_show (swin2);

	ainfo.addr_atenalist = gtk_clist_new_with_titles (2, atenalist_title);
	gtk_widget_set_usize (ainfo.addr_atenalist, 250, -1);
	gtk_clist_set_selection_mode (GTK_CLIST (ainfo.addr_atenalist),
				      GTK_SELECTION_BROWSE);
	gtk_clist_set_column_width (GTK_CLIST (ainfo.addr_atenalist), 0, 120);
	gtk_clist_set_column_width (GTK_CLIST (ainfo.addr_atenalist), 1, 200);
	gtk_signal_connect (GTK_OBJECT (ainfo.addr_atenalist), "select_row",
			    GTK_SIGNAL_FUNC (atenalist_selection), NULL);
	gtk_container_add (GTK_CONTAINER (swin2), ainfo.addr_atenalist);
	gtk_widget_show (ainfo.addr_atenalist);

	label3 = gtk_label_new ("ã");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "label3",
				  label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (vbox4), label3, FALSE, FALSE, 0);

	swin3 = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin3),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (vbox4), swin3, TRUE, TRUE, 0);
	gtk_widget_show (swin3);

	ainfo.addr_cclist = gtk_clist_new_with_titles (2, cclist_title);
	gtk_widget_set_usize (ainfo.addr_atenalist, 250, -1);
	gtk_clist_set_selection_mode (GTK_CLIST (ainfo.addr_cclist),
				      GTK_SELECTION_BROWSE);
	gtk_clist_set_column_width (GTK_CLIST (ainfo.addr_cclist), 0, 120);
	gtk_clist_set_column_width (GTK_CLIST (ainfo.addr_cclist), 1, 200);
	gtk_signal_connect (GTK_OBJECT (ainfo.addr_cclist), "select_row",
			    GTK_SIGNAL_FUNC (cclist_selection), NULL);
	gtk_container_add (GTK_CONTAINER (swin3), ainfo.addr_cclist);
	gtk_widget_show (ainfo.addr_cclist);

	hbox4 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox4);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "hbox4", hbox4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox4);
	gtk_box_pack_start (GTK_BOX (vboxbase), hbox4, FALSE, FALSE, 10);

	setbtn = gtk_button_new_with_label ("ꡡ");
	gtk_widget_ref (setbtn);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "setbtn",
				  setbtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect (GTK_OBJECT (setbtn), "clicked",
			    (GtkSignalFunc) setCallBack, NULL);
	gtk_widget_show (setbtn);
	gtk_box_pack_start (GTK_BOX (hbox4), setbtn, FALSE, FALSE, 0);

	cancelbtn = gtk_button_new_with_label ("á");
	gtk_widget_ref (cancelbtn);
	gtk_object_set_data_full (GTK_OBJECT (ainfo.addrwin), "cancelbtn",
				  cancelbtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect (GTK_OBJECT (cancelbtn), "clicked",
			    (GtkSignalFunc) cancelCallBack, NULL);
	gtk_widget_show (cancelbtn);
	gtk_box_pack_start (GTK_BOX (hbox4), cancelbtn, FALSE, FALSE, 0);

    /*-- ̾ʣ --*/
	ainfo.sendNum = client->sendNum;
	ainfo.ccNum = client->ccNum;

#ifdef DEBUG
	fprintf (stdout, "ainfo.sendNum ==> %d\n", ainfo.sendNum);
	fprintf (stdout, "ainfo.ccNum   ==> %d\n", ainfo.ccNum);
#endif

	for (i = 0; i < ainfo.sendNum; i++)
	{
		ainfo.send[i].name = g_strdup (client->send[i].name);
		ainfo.send[i].email = g_strdup (client->send[i].email);
	}
	for (i = 0; i < ainfo.ccNum; i++)
	{
		ainfo.cc[i].name = g_strdup (client->cc[i].name);
		ainfo.cc[i].email = g_strdup (client->cc[i].email);
	}

	cxpmail_addr_allview ();
	cxpmail_addr_atenaview ();
	cxpmail_addr_ccview ();

}

static int cxpmail_addr_allview ()
{
	char *viewdata[8];
	int i;

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (ainfo.addr_alllist));
	gtk_clist_clear (GTK_CLIST (ainfo.addr_alllist));

	for (i = 0; i < cxpmail->addrkensu; i++)
	{
		viewdata[0] = g_strdup (cxpmail->addr[i].name);
		viewdata[1] = g_strdup (cxpmail->addr[i].email);
		gtk_clist_append (GTK_CLIST (ainfo.addr_alllist), viewdata);
	}
	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (ainfo.addr_alllist));

}

static int cxpmail_addr_atenaview ()
{
	char *viewdata[8];
	int i;

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (ainfo.addr_atenalist));
	gtk_clist_clear (GTK_CLIST (ainfo.addr_atenalist));

	for (i = 0; i < ainfo.sendNum; i++)
	{
		viewdata[0] = g_strdup (ainfo.send[i].name);
		viewdata[1] = g_strdup (ainfo.send[i].email);
		gtk_clist_append (GTK_CLIST (ainfo.addr_atenalist), viewdata);
	}
	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (ainfo.addr_atenalist));

}

static int cxpmail_addr_ccview ()
{
	char *viewdata[8];
	int i;

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (ainfo.addr_cclist));
	gtk_clist_clear (GTK_CLIST (ainfo.addr_cclist));

	for (i = 0; i < ainfo.ccNum; i++)
	{
		viewdata[0] = g_strdup (ainfo.cc[i].name);
		viewdata[1] = g_strdup (ainfo.cc[i].email);
		gtk_clist_append (GTK_CLIST (ainfo.addr_cclist), viewdata);
	}
	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (ainfo.addr_cclist));

}

/*------------ ̾ѽ -------------------------------------*/

/* ɲ */
static void newAtenaAddCallBack (GtkWidget * widget, gpointer data)
{
	char *nameData, *emailData;
	char *viewdata[8];
	int i;

	if ((nameData = gtk_entry_get_text (GTK_ENTRY (nameEntry))) == NULL)
	{
		create_messageWin (newAtenaWindow,
				   "̾μ˼Ԥޤ");
		return;
	}
	else if (strlen (nameData) <= 0)
	{
		create_messageWin (newAtenaWindow,
				   "̾ϤƤޤ");
		return;
	}

	if ((emailData = gtk_entry_get_text (GTK_ENTRY (emailEntry))) == NULL)
	{
		create_messageWin (newAtenaWindow,
				   "Żҥ᡼μ˼Ԥޤ");
		return;
	}
	else if (strlen (emailData) <= 0)
	{
		create_messageWin (newAtenaWindow,
				   "Żҥ᡼뤬ϤƤޤ");
		return;
	}

	/* Ϥ줿򥢥ɥ쥹Ģɲä롣 */
	i = cxpmail->addrkensu;
	if (i + 1 >= MAX_ADDR_NUM)
	{
		create_messageWin (newAtenaWindow,
				   "ʾΰ̾ϿǤޤ");
		return;
	}
	memset (&cxpmail->addr[i], 0x00, sizeof (ADDRINFO));
	cxpmail->addr[i].name = g_strdup (nameData);
	cxpmail->addr[i].email = g_strdup (emailData);
	cxpmail->addr[i].kana = g_strdup ("");
	cxpmail->addr[i].job = g_strdup ("");
	cxpmail->addr[i].jtel = g_strdup ("");
	cxpmail->addr[i].sex = g_strdup ("");
	cxpmail->addr[i].birth = g_strdup ("");
	cxpmail->addr[i].bload = g_strdup ("");
	cxpmail->addr[i].ybin = g_strdup ("");
	cxpmail->addr[i].addr = g_strdup ("");
	cxpmail->addr[i].tel = g_strdup ("");
	cxpmail->addr[i].fax = g_strdup ("");
	cxpmail->addr[i].website = g_strdup ("");
	cxpmail->addr[i].comment = g_strdup ("");

	cxpmail->addrkensu++;
	setAddressData (&(cxpmail->addrkensu), &(cxpmail->addr));

	/* ¸ɤ߹ߡɽ */
	getAddressData (&(cxpmail->addrkensu), &(cxpmail->addr));
	cxpmail_addr_allview ();

	if (GTK_TOGGLE_BUTTON (ateneCheckBtn)->active)
	{
		/* ̾ˤɲä */
		ainfo.send[ainfo.sendNum].name = g_strdup (nameData);
		ainfo.send[ainfo.sendNum].email = g_strdup (emailData);

		viewdata[0] = g_strdup (ainfo.send[ainfo.sendNum].name);
		viewdata[1] = g_strdup (ainfo.send[ainfo.sendNum].email);
		gtk_clist_append (GTK_CLIST (ainfo.addr_atenalist), viewdata);

		ainfo.sendNum++;
	}

	if (GTK_TOGGLE_BUTTON (ccCheckBtn)->active)
	{
		/* ãäˤɲä */
		ainfo.cc[ainfo.ccNum].name = g_strdup (nameData);
		ainfo.cc[ainfo.ccNum].email = g_strdup (emailData);

		viewdata[0] = g_strdup (ainfo.cc[ainfo.ccNum].name);
		viewdata[1] = g_strdup (ainfo.cc[ainfo.ccNum].email);
		gtk_clist_append (GTK_CLIST (ainfo.addr_cclist), viewdata);

		ainfo.ccNum++;
	}

	gtk_widget_destroy (newAtenaWindow);
}

/*  */
static void newAtenaCanCallBack (GtkWidget * widget, gpointer data)
{
	gtk_widget_destroy (newAtenaWindow);
}

/* ̾ꥦɥɽ */
int create_newAtenaWindow ()
{
	GtkWidget *vbox1;
	GtkWidget *label1;
	GtkWidget *hbox2;
	GtkWidget *vbox2;
	GtkWidget *label2;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *vbox3;
	GtkWidget *hbox3;
	GtkWidget *hbox1;
	int x, y, w, h;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	newAtenaWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (newAtenaWindow), "newAtenaWindow",
			     newAtenaWindow);
	gtk_window_set_title (GTK_WINDOW (newAtenaWindow), "̾");
	gtk_widget_set_usize (newAtenaWindow, 400, 170);
	gtk_widget_set_uposition (newAtenaWindow, (x - 400 * 0.5),
				  (y - 170 * 0.5));
	gtk_widget_show (newAtenaWindow);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (newAtenaWindow), vbox1);

	label1 = gtk_label_new ("̾ɲ");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "label1",
				  label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 5);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 6);

	vbox2 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "vbox2", vbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox2), vbox2, FALSE, TRUE, 5);

	label2 = gtk_label_new ("̾");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "label2",
				  label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox2), label2, FALSE, FALSE, 0);

	label3 = gtk_label_new ("Żҥ᡼롧");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "label3",
				  label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (vbox2), label3, FALSE, FALSE, 0);

	label4 = gtk_label_new ("    ");
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "label4",
				  label4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_box_pack_start (GTK_BOX (vbox2), label4, FALSE, FALSE, 0);

	vbox3 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox3);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "vbox3", vbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox3);
	gtk_box_pack_start (GTK_BOX (hbox2), vbox3, TRUE, TRUE, 9);

	nameEntry = gtk_entry_new ();
	gtk_widget_ref (nameEntry);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "nameEntry",
				  nameEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (nameEntry);
	gtk_box_pack_start (GTK_BOX (vbox3), nameEntry, FALSE, FALSE, 0);

	emailEntry = gtk_entry_new ();
	gtk_widget_ref (emailEntry);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "emailEntry",
				  emailEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (emailEntry);
	gtk_box_pack_start (GTK_BOX (vbox3), emailEntry, FALSE, FALSE, 0);

	hbox3 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox3, TRUE, TRUE, 0);

	ateneCheckBtn = gtk_check_button_new_with_label ("̾ˤɲä");
	gtk_widget_ref (ateneCheckBtn);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow),
				  "ateneCheckBtn", ateneCheckBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ateneCheckBtn);
	gtk_box_pack_start (GTK_BOX (hbox3), ateneCheckBtn, FALSE, FALSE, 0);

	ccCheckBtn = gtk_check_button_new_with_label ("CCˤɲä");
	gtk_widget_ref (ccCheckBtn);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "ccCheckBtn",
				  ccCheckBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ccCheckBtn);
	gtk_box_pack_start (GTK_BOX (hbox3), ccCheckBtn, FALSE, FALSE, 0);

	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);

	newAtenaAddBtn = gtk_button_new_with_label (" ɲ ");
	gtk_widget_ref (newAtenaAddBtn);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow),
				  "newAtenaAddBtn", newAtenaAddBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (newAtenaAddBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), newAtenaAddBtn, FALSE, FALSE, 0);

	newAtenaCanBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (newAtenaCanBtn);
	gtk_object_set_data_full (GTK_OBJECT (newAtenaWindow),
				  "newAtenaCanBtn", newAtenaCanBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (newAtenaCanBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), newAtenaCanBtn, FALSE, FALSE, 0);


	gtk_signal_connect (GTK_OBJECT (newAtenaAddBtn), "clicked",
			    (GtkSignalFunc) newAtenaAddCallBack, NULL);
	gtk_signal_connect (GTK_OBJECT (newAtenaCanBtn), "clicked",
			    (GtkSignalFunc) newAtenaCanCallBack, NULL);


}
