/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static char *basetitle[1] = { "ʬ"
};

#define SUBMENU_NEWBOX		"ܥå"
#define SUBMENU_RENBOX		"ܥå̾ѹ"
#define SUBMENU_DELBOX		"ܥå"

static void submenu_response (gchar * string)
{
	if (strcmp (string, SUBMENU_NEWBOX) == 0)
	{
		cxpmailfilefunc_newbox ();
	}
	else if (strcmp (string, SUBMENU_RENBOX) == 0)
	{
		cxpmailfilefunc_renamebox ();
	}
	else if (strcmp (string, SUBMENU_DELBOX) == 0)
	{
		cxpmailfilefunc_delbox ();
	}
}

static int listselection (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
	if (column < 0 || row < 0)
		return (0);

	cxpmail->minfo.viewPoint = row;
	cxpmail->select_title = 0;

	cxpmail_title_view ();
	cxpmail_view_view ();

	return (0);
}

static int listbuttonpress (GtkWidget * widget, GdkEvent * event)
{
	GdkEventButton *bevent = (GdkEventButton *) event;
	GdkEventKey *kevent = (GdkEventKey *) event;
	GtkWidget *lmenu;
	GtkWidget *lmenuitem;
	int index, maxCount;
	int row, column;

	if (event->type == GDK_KEY_PRESS)
	{

#ifdef DEBUG
		fprintf (stdout, "GDK_KEY_PRESS ... [0x%04x]\n",
			 kevent->keyval);
#endif

		if (kevent->keyval == GDK_Up)
		{
			index = cxpmail->minfo.viewPoint;
			if (index <= 0)
				return (0);
			if (cxpmail->minfo.box[index] == (BoxInfo *) NULL)
				return (0);
			if (cxpmail->minfo.box[index]->boxName == NULL)
				return (0);
			if (strlen (cxpmail->minfo.box[index]->boxName) <= 0)
				return (0);
			cxpmail->minfo.viewPoint--;
			cxpmail_title_view ();
			cxpmail_view_view ();
		}
		if (kevent->keyval == GDK_Down)
		{
			index = cxpmail->minfo.viewPoint;
			if (index + 1 > MAX_BOX_NUM)
				return (0);
			if (cxpmail->minfo.box[index + 1] == (BoxInfo *) NULL)
				return (0);
			if (cxpmail->minfo.box[index + 1]->boxName == NULL)
				return (0);
			if (strlen (cxpmail->minfo.box[index + 1]->boxName) <=
			    0)
				return (0);
			cxpmail->minfo.viewPoint++;
			cxpmail_title_view ();
			cxpmail_view_view ();
		}

		if (kevent->keyval == GDK_Delete)	/* DEL */
		{
			if (cxpmail->select_title > 0)
			{
				if ((cxpmail->keyPressStatus == 0)
				    || (((cxpmail->keyPressStatus + 1) % 10)
					== 0))
				{
					/* ¹ */
					cxpmaileditfunc_delmail ();
				}
			}
		}

		cxpmail->keyPressStatus++;
	}
	if (event->type == GDK_KEY_RELEASE)
	{
		cxpmail->keyPressStatus = 0;
	}

	if (event->type == GDK_BUTTON_PRESS)
	{
		if (bevent->button == 3)
		{
			index = cxpmail->minfo.viewPoint;
			gtk_clist_get_selection_info (GTK_CLIST
						      (cxpmail->list_base),
						      bevent->x, bevent->y,
						      &row, &column);

			/* ˥塼 */
			lmenu = gtk_menu_new ();

			lmenuitem =
				gtk_menu_item_new_with_label (SUBMENU_NEWBOX);
			gtk_menu_append (GTK_MENU (lmenu), lmenuitem);
			gtk_signal_connect_object (GTK_OBJECT (lmenuitem),
						   "activate",
						   GTK_SIGNAL_FUNC
						   (submenu_response),
						   (gpointer)
						   g_strdup (SUBMENU_NEWBOX));
			gtk_widget_show (lmenuitem);

			if (row >= 0 && row < maxCount)
			{
				cxpmail->minfo.viewPoint = row;
				gtk_clist_select_row (GTK_CLIST
						      (cxpmail->list_base),
						      row, 0);

				lmenuitem =
					gtk_menu_item_new_with_label
					(SUBMENU_RENBOX);
				gtk_menu_append (GTK_MENU (lmenu), lmenuitem);
				gtk_signal_connect_object (GTK_OBJECT
							   (lmenuitem),
							   "activate",
							   GTK_SIGNAL_FUNC
							   (submenu_response),
							   (gpointer)
							   g_strdup
							   (SUBMENU_RENBOX));
				gtk_widget_show (lmenuitem);

				lmenuitem =
					gtk_menu_item_new_with_label
					(SUBMENU_DELBOX);
				gtk_menu_append (GTK_MENU (lmenu), lmenuitem);
				gtk_signal_connect_object (GTK_OBJECT
							   (lmenuitem),
							   "activate",
							   GTK_SIGNAL_FUNC
							   (submenu_response),
							   (gpointer)
							   g_strdup
							   (SUBMENU_DELBOX));
				gtk_widget_show (lmenuitem);
			}

			/* ˥塼ݥåץå */
			gtk_menu_popup (GTK_MENU (lmenu), NULL, NULL, NULL,
					NULL, bevent->button, bevent->time);

		}
	}

	return (0);
}

int cxpmail_base_init ()
{

	/* Clist Τ뤿Υɥɥ */
	cxpmail->swin_base = gtk_scrolled_window_new (NULL, NULL);

	/* ʿӿľΥСɽ褦 */
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
					(cxpmail->swin_base),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_show (cxpmail->swin_base);

	cxpmail->list_base = gtk_clist_new_with_titles (1, basetitle);
	gtk_widget_set_usize (cxpmail->list_base, 130, 150);
	gtk_clist_set_selection_mode (GTK_CLIST (cxpmail->list_base),
				      GTK_SELECTION_BROWSE);

	gtk_signal_connect (GTK_OBJECT (cxpmail->list_base), "select_row",
			    GTK_SIGNAL_FUNC (listselection), NULL);

	gtk_signal_connect (GTK_OBJECT (cxpmail->list_base), "event",
			    GTK_SIGNAL_FUNC (listbuttonpress), NULL);

	gtk_clist_column_title_passive (GTK_CLIST (cxpmail->list_base), 0);

	gtk_container_add (GTK_CONTAINER (cxpmail->swin_base),
			   cxpmail->list_base);
	gtk_widget_show (cxpmail->list_base);

	gtk_paned_add1 (GTK_PANED (cxpmail->hpanel), cxpmail->swin_base);

}

int cxpmail_base_view ()
{
	char boxname[256];
	char *basename[2];
	int i;

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (cxpmail->list_base));

	gtk_clist_clear (GTK_CLIST (cxpmail->list_base));

	for (i = 0; i < MAX_BOX_NUM; i++)
	{
		if (cxpmail->minfo.box[i] != (BoxInfo *) NULL)
		{
			if (cxpmail->minfo.box[i]->boxName != NULL)
			{
				if (cxpmail->minfo.box[i]->count > 0)
					sprintf (boxname, "%s (%d)",
						 cxpmail->minfo.box[i]->
						 boxName,
						 cxpmail->minfo.box[i]->
						 count);
				else
					sprintf (boxname, "%s",
						 cxpmail->minfo.box[i]->
						 boxName);
				basename[0] = g_strdup (boxname);
				gtk_clist_append (GTK_CLIST
						  (cxpmail->list_base),
						  basename);

				gtk_clist_set_row_style (GTK_CLIST
							 (cxpmail->list_base),
							 i,
							 cxpmail->
							 styleNormal);
			}
		}
	}

	/* Ʊ֤ɽ */
	gtk_clist_select_row (GTK_CLIST (cxpmail->list_base),
			      cxpmail->minfo.viewPoint, 0);

	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (cxpmail->list_base));

	return (0);
}
