/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static GtkWidget *baseSetWin;
static GtkWidget *usernameEntry;
static GtkWidget *emailEntry;
static GtkWidget *checkMailDeleteBtn;
static GtkWidget *checkMailSameBtn;
static GtkWidget *checkMailNDayBtn;
static GtkWidget *ndayEntry;
static GtkWidget *setBtn;
static GtkWidget *canBtn;

static int setFunction (GtkWidget * widget, GtkWidget * win)
{
	char *data;

	if ((data = gtk_entry_get_text (GTK_ENTRY (usernameEntry))) == NULL)
		cxpmail->my.name = (char *) NULL;
	else
		cxpmail->my.name = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (emailEntry))) == NULL)
		cxpmail->my.email = (char *) NULL;
	else
		cxpmail->my.email = g_strdup (data);

	if (GTK_TOGGLE_BUTTON (checkMailDeleteBtn)->active)
		cxpmail->my.mailDelete = 0;
	else
		cxpmail->my.mailDelete = 1;

	if (GTK_TOGGLE_BUTTON (checkMailSameBtn)->active)
		cxpmail->my.sameMail = 1;
	else
		cxpmail->my.sameMail = 0;

	if (GTK_TOGGLE_BUTTON (checkMailNDayBtn)->active)
		cxpmail->my.ndayDelete = 1;
	else
		cxpmail->my.ndayDelete = 0;

	if ((data = gtk_entry_get_text (GTK_ENTRY (ndayEntry))) == NULL)
	{
		cxpmail->my.nday = 0;
	}
	else
	{
		cxpmail->my.nday = atoi (data);
	}

	setNetConfig (&cxpmail->cinfoMaxNum, &cxpmail->cinfo, &cxpmail->my);

	gtk_widget_destroy (win);
}

static int cancelFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (win);
}


int create_baseSetWin ()
{
	GtkWidget *vbox1;
	GtkWidget *vbox3;
	GtkWidget *label1;
	GtkWidget *label2;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *label5;
	GtkWidget *label6;
	GtkWidget *label7;
	GtkWidget *label8;
	GtkWidget *vbox4;
	GtkWidget *hbox1;
	GtkWidget *hbox2;
	GtkWidget *hbox3;
	GtkWidget *hbox4;
	GtkWidget *hbox5;
	char ndayData[256];
	int x, y, w, h;
	int i;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	baseSetWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (baseSetWin), "baseSetWin",
			     baseSetWin);
	gtk_window_set_title (GTK_WINDOW (baseSetWin), "");
	gtk_widget_set_usize (baseSetWin, 480, 240);
	gtk_window_set_default_size (GTK_WINDOW (baseSetWin), 480, 240);
	gtk_widget_set_uposition (baseSetWin, (x - 480 * 0.5),
				  (y - 240 * 0.5));

	gtk_widget_show (baseSetWin);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (baseSetWin), vbox1);

	label1 = gtk_label_new ("");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "label1", label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 10);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 0);

	vbox3 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox3);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "vbox3", vbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox3);
	gtk_box_pack_start (GTK_BOX (hbox2), vbox3, FALSE, TRUE, 8);


	label2 = gtk_label_new ("̾");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "label2", label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox3), label2, FALSE, FALSE, 0);


	label3 = gtk_label_new ("Żҥ᡼롧");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "label3", label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (vbox3), label3, FALSE, FALSE, 0);


	label4 = gtk_label_new ("᡼롧");
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "label4", label4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_box_pack_start (GTK_BOX (vbox3), label4, FALSE, FALSE, 0);


	label5 = gtk_label_new ("  ");
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "label5", label5,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_box_pack_start (GTK_BOX (vbox3), label5, FALSE, FALSE, 0);


	label6 = gtk_label_new ("  ");
	gtk_widget_ref (label6);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "label6", label6,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label6);
	gtk_box_pack_start (GTK_BOX (vbox3), label6, FALSE, FALSE, 0);



	vbox4 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox4);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "vbox4", vbox4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox4);
	gtk_box_pack_start (GTK_BOX (hbox2), vbox4, TRUE, TRUE, 10);

	usernameEntry = gtk_entry_new ();
	gtk_widget_ref (usernameEntry);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "usernameEntry",
				  usernameEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (usernameEntry);
	gtk_box_pack_start (GTK_BOX (vbox4), usernameEntry, FALSE, FALSE, 0);

	emailEntry = gtk_entry_new ();
	gtk_widget_ref (emailEntry);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "emailEntry",
				  emailEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (emailEntry);
	gtk_box_pack_start (GTK_BOX (vbox4), emailEntry, FALSE, FALSE, 0);



	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox3, FALSE, FALSE, 0);

	checkMailDeleteBtn =
		gtk_check_button_new_with_label
		("᡼ϥФ");
	gtk_widget_ref (checkMailDeleteBtn);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin),
				  "checkMailDeleteBtn", checkMailDeleteBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (checkMailDeleteBtn);
	gtk_box_pack_start (GTK_BOX (hbox3), checkMailDeleteBtn, FALSE, FALSE,
			    0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkMailDeleteBtn),
				      TRUE);



	hbox4 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox4);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "hbox4", hbox4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox4);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox4, FALSE, FALSE, 0);

	checkMailSameBtn =
		gtk_check_button_new_with_label ("Ʊ᡼ϼʤ");
	gtk_widget_ref (checkMailSameBtn);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "checkMailSameBtn",
				  checkMailSameBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (checkMailSameBtn);
	gtk_box_pack_start (GTK_BOX (hbox4), checkMailSameBtn, FALSE, FALSE,
			    0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkMailSameBtn),
				      TRUE);



	hbox5 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox5);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "hbox5", hbox5,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox5);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox5, FALSE, FALSE, 0);

	checkMailNDayBtn =
		gtk_check_button_new_with_label
		("ФˤΥ᡼Ϻ");
	gtk_widget_ref (checkMailNDayBtn);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "checkMailNDayBtn",
				  checkMailNDayBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (checkMailNDayBtn);
	gtk_box_pack_start (GTK_BOX (hbox5), checkMailNDayBtn, FALSE, FALSE,
			    0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkMailNDayBtn),
				      TRUE);

	label7 = gtk_label_new (" ");
	gtk_widget_ref (label7);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "label7", label7,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label7);
	gtk_box_pack_start (GTK_BOX (hbox5), label7, FALSE, FALSE, 0);

	ndayEntry = gtk_entry_new ();
	gtk_widget_ref (ndayEntry);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "ndayEntry",
				  ndayEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ndayEntry);
	gtk_widget_set_usize (ndayEntry, 40, -2);
	gtk_box_pack_start (GTK_BOX (hbox5), ndayEntry, FALSE, FALSE, 0);

	label8 = gtk_label_new ("");
	gtk_widget_ref (label8);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "label8", label8,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label8);
	gtk_box_pack_start (GTK_BOX (hbox5), label8, FALSE, FALSE, 0);




	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 8);

	setBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (setBtn);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "setBtn", setBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (setBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), setBtn, FALSE, FALSE, 0);

	canBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (canBtn);
	gtk_object_set_data_full (GTK_OBJECT (baseSetWin), "canBtn", canBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (canBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), canBtn, FALSE, FALSE, 0);

	/* ꥳХå */
	gtk_signal_connect (GTK_OBJECT (setBtn), "clicked",
			    (GtkSignalFunc) setFunction, baseSetWin);

	/* åХå */
	gtk_signal_connect (GTK_OBJECT (canBtn), "clicked",
			    (GtkSignalFunc) cancelFunction, baseSetWin);

	if (cxpmail->my.name == (char *) NULL)
	{
		gtk_entry_set_text (GTK_ENTRY (usernameEntry), "");
	}
	else
	{
		gtk_entry_set_text (GTK_ENTRY (usernameEntry),
				    cxpmail->my.name);
	}

	if (cxpmail->my.email == (char *) NULL)
	{
		gtk_entry_set_text (GTK_ENTRY (emailEntry), "");
	}
	else
	{
		gtk_entry_set_text (GTK_ENTRY (emailEntry),
				    cxpmail->my.email);
	}

	if (cxpmail->my.mailDelete == 0)
	{
		/*  */
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (checkMailDeleteBtn), 1);
	}
	else
	{
		/* ʤ */
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (checkMailDeleteBtn), 0);
	}


	if (cxpmail->my.sameMail != 0)
	{
		/* Ʊ᡼ */
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (checkMailSameBtn), 1);
	}
	else
	{
		/* Ʊ᡼ϼʤ */
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (checkMailSameBtn), 0);
	}


	if (cxpmail->my.ndayDelete != 0)
	{
		/* ФˤΥ᡼Ϻʤ */
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (checkMailNDayBtn), 1);
	}
	else
	{
		/* ФˤΥ᡼ */
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (checkMailNDayBtn), 0);
	}

	sprintf (ndayData, "%d", cxpmail->my.nday);
	gtk_entry_set_text (GTK_ENTRY (ndayEntry), ndayData);

}
