/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

extern int cxpmail_native_send ();
extern int cxpmail_native_recv ();

static int deleteMailOkFunc ();
static int deleteMailCanFunc ();
static int deleteBoxOkFunc ();
static int deleteBoxCanFunc ();

/*-- ܥå --*/
int cxpmailfilefunc_newbox ()
{
	create_addBoxWin ();
}

/*-- 򤵤Ƥܥå --*/
int cxpmailfilefunc_delbox ()
{
	char mess[1024];
	int index;

	index = cxpmail->minfo.viewPoint;

	if (index < 0)
	{
		create_messageWin (cxpmail->window,
				   "ܥå򤵤Ƥޤ");
		return (0);
	}

	if (index >= 0 && index <= 4)
	{
		create_messageWin (cxpmail->window,
				   "ΥܥåϺǤޤ");
		return (0);
	}

	if (cxpmail->minfo.box[index] == (BoxInfo *) NULL)
	{
		create_messageWin (cxpmail->window,
				   "ΥܥåѤǤޤ");
		return (0);
	}

	if (cxpmail->minfo.box[index]->count > 0)
	{
		sprintf (mess,
			 "Υܥå %d Υ᡼ޤǤ",
			 cxpmail->minfo.box[index]->count);
	}
	else
	{
		sprintf (mess,
			 "ΥܥåޤǤ");
	}

	create_messageWin2 (cxpmail->window,
			    mess, deleteBoxOkFunc, deleteBoxCanFunc);

	return (0);
}

/*-- 򤵤Ƥܥå̾ѹ --*/
int cxpmailfilefunc_renamebox ()
{
	create_modBoxWin ();
}

/*-- ᡼ǡ򥤥ݡȤ --*/
int cxpmailfilefunc_inport ()
{
	create_messageWin (cxpmail->window, "εǽϤޤޤ");
	;
	;
	;
}

/*-- ᡼ǡ򥨥ݡȤ --*/
int cxpmailfilefunc_export ()
{
	create_messageWin (cxpmail->window, "εǽϤޤޤ");
	;
	;
	;
}

/*-- Cxpmailλ --*/
int cxpmailfilefunc_close ()
{
	int x, y, w, h;
	int xymode, whmode;

	getGeometryInfo (CXPMAIL_MODE, &xymode, &whmode, &x, &y, &w, &h);

	if (xymode == 0)	/* ΰ */
	{
		x = cxpmail->window->allocation.x;
		y = cxpmail->window->allocation.y;
	}
	if (whmode == 0)	/* Υ */
	{
		w = cxpmail->window->allocation.width;
		h = cxpmail->window->allocation.height;
	}
	setGeometryInfo (CXPMAIL_MODE, xymode, whmode, x, y, w, h);

	gtk_main_quit ();
}

/*-- ᡼뤫鸡 --*/
int cxpmaileditfunc_search ()
{
	create_messageWin (cxpmail->window, "εǽϤޤޤ");
	;
	;
	;
}

/*-- 򤵤Ƥ᡼̤Υܥåذư --*/
int cxpmaileditfunc_movemail ()
{
	create_moveMailWin ();
}

/*-- 򤵤Ƥ᡼ --*/
int cxpmaileditfunc_delmail ()
{
	int i;
	int index;
	int number;
	int count, state;

	/* 򤷤Ƥ᡼ܥåȢξˤ˺ */
	/* ȢǤʤϺȢذư */

	index = cxpmail->minfo.viewPoint;
	number = cxpmail->select_title;
	if (number <= 0)
	{
		create_messageWin (cxpmail->window,
				   "᡼뤬򤵤Ƥޤ");
		return (0);
	}

	if (index == BOXID_SAKUJO)
	{
		/* Ȣξ˺뤫ǧƤ */
		create_messageWin2 (cxpmail->window,
				    "Υ᡼˺ޤ",
				    deleteMailOkFunc, deleteMailCanFunc);
	}
	else
	{
		if (cxpmail_movemail_withview
		    (index, BOXID_SAKUJO, number - 1) < 0)
		{
			create_messageWin (cxpmail->window,
					   "ȢذưǤޤǤ");
		}
	}
	return (0);
}

/*-- ǿξ˹ --*/
int cxpmailviewfunc_update ()
{
	cxpmail_base_view ();
	cxpmail_title_view ();
	cxpmail_view_view ();
	return (0);
}

/*-- ¤ؤ̤ɽ --*/
int cxpmailviewfunc_sort ()
{
	create_messageWin (cxpmail->window, "εǽϤޤޤ");
	;
	;
	;
}

/*-- 򤵤Ƥ᡼ǡΤΤɽ(cxpnote) --*/
int cxpmailviewfunc_syousai ()
{
	create_showWin ();
}

/*-- Ȣˤ᡼ --*/
int cxpmailtoolfunc_send ()
{
	char working[1024];
	int count;

	if (cxpmail->cinfoMaxNum <= 0)
	{
		create_messageWin (cxpmail->window,
				   "ȾꤵƤޤ");
		return (0);
	}

	count = cxpmail->minfo.box[BOXID_SOUSIN]->count;

	if (count <= 0)
	{
		/* ᡼ǡ̵ */
		return (0);
	}

	/* 󥰥ɽ */
	sprintf (working, "Ȣˤ %d Υ᡼ޤ", count);
	create_working (cxpmail->window, "᡼", working);

	/* ¹ */
	cxpmail_native_send ();

	return (count);
}

/*-- ᡼ --*/
int cxpmailtoolfunc_recv ()
{
	char working[1024];

	if (cxpmail->cinfoMaxNum <= 0)
	{
		create_messageWin (cxpmail->window,
				   "ȾꤵƤޤ");
		return (0);
	}

	/* 󥰥ɽ */
	sprintf (working, "᡼륵Ф᡼ޤ");
	create_working (cxpmail->window, "᡼", working);

	/* ¹ */
	cxpmail_native_recv ();

	return (0);
}

/*-- ᡼ --*/
int cxpmailtoolfunc_sendrecv ()
{
	if (cxpmail->cinfoMaxNum <= 0)
	{
		create_messageWin (cxpmail->window,
				   "ȾꤵƤޤ");
		return (0);
	}

	cxpmailtoolfunc_send ();

	sleep (1);

	cxpmailtoolfunc_recv ();
	return (0);
}

/*-- ʬ̤ɽ --*/
int cxpmailtoolfunc_furiwake ()
{
	create_furiwakeWin ();
}

/*-- ̤ɽ --*/
int cxpmailtoolfunc_userset ()
{
	/* ̤ɽ */
	create_userWin ();
	return (0);
}

/*-- ̤ɽ --*/
int cxpmailtoolfunc_mailset ()
{
	/* ̤ɽ */
	create_baseSetWin ();
	return (0);
}

/*-- ᡼ --*/
int cxpmailmessfunc_new ()
{
	cxpmail_new ();
	return (0);
}

/*-- 򤵤Ƥ᡼ֿ --*/
int cxpmailmessfunc_re ()
{
	int index;
	int number;

	index = cxpmail->minfo.viewPoint;
	number = cxpmail->select_title;
	if (number <= 0)
	{
		create_messageWin (cxpmail->window,
				   "᡼뤬򤵤Ƥޤ");
		return (0);
	}

	switch (index)
	{
	case BOXID_SOUSIN:	/* Ȣ */
		create_messageWin (cxpmail->window,
				   "ȢΥ᡼ǡֿǤޤ");
		return (0);
	case BOXID_SUMI:	/* Ѥ */
		create_messageWin (cxpmail->window,
				   "ѤߤΥ᡼ǡֿǤޤ");
		return (0);
	case BOXID_KAKIKAKE:	/* 񤭤 */
		create_messageWin (cxpmail->window,
				   "񤭤Υ᡼ǡֿǤޤ");
		return (0);
	case BOXID_SAKUJO:	/* Ȣ */
		create_messageWin (cxpmail->window,
				   "ȢΥ᡼ǡֿǤޤ");
		return (0);
	case BOXID_JYUSIN:	/* Ȣ */
	default:		/* ¾ */
		break;
	}

	/* ֿɥɽ */
	cxpmail_reply ();
	return (0);
}

/*-- 򤵤Ƥ᡼ž --*/
int cxpmailmessfunc_fw ()
{
	int index;
	int number;

	index = cxpmail->minfo.viewPoint;
	number = cxpmail->select_title;
	if (number <= 0)
	{
		create_messageWin (cxpmail->window,
				   "᡼뤬򤵤Ƥޤ");
		return (0);
	}

	switch (index)
	{
	case BOXID_SOUSIN:	/* Ȣ */
		create_messageWin (cxpmail->window,
				   "ȢΥ᡼ǡžǤޤ");
		return (0);
#if 0
	case BOXID_SUMI:	/* Ѥ */
		create_messageWin (cxpmail->window,
				   "ѤߤΥ᡼ǡžǤޤ");
		return (0);
#endif
	case BOXID_KAKIKAKE:	/* 񤭤 */
		create_messageWin (cxpmail->window,
				   "񤭤Υ᡼ǡžǤޤ");
		return (0);
	case BOXID_SAKUJO:	/* Ȣ */
		create_messageWin (cxpmail->window,
				   "ȢΥ᡼ǡžǤޤ");
		return (0);
	case BOXID_JYUSIN:	/* Ȣ */
	default:		/* ¾ */
		break;
	}

	/* žɥɽ */
	cxpmail_fw ();
	return (0);
}

/*-- إפɽ --*/
int cxpmailhelpfunc_help ()
{
	cxpmail_help_about ();
}

static int deleteMailOkFunc (GtkWidget * widget, GtkWidget * win)
{
	int index, number;

#ifdef DEBUG
	fprintf (stdout, "mail delete function start ...\n");
#endif

	index = cxpmail->minfo.viewPoint;
	number = cxpmail->select_title;

	/* ȢΥǡ */
	delMailData (&cxpmail->minfo.box[index],
		     cxpmail->minfo.box[index]->mail[number - 1]);

	/* ȢΥإå */
	cxpmail->minfo.box[index]->mail[number - 1]->no = 0;
	setMailHeader (index);

	/* ɤ߹ */
	getMailHeader (cxpmail->minfo.box[index]);

	/* ̤򹹿 */
	cxpmail_base_view ();
	cxpmail_title_view ();
	cxpmail_view_view ();

	/* ΰ֤᤹ */
	if (cxpmail->minfo.box[index]->count > number)
	{
		gtk_clist_select_row (GTK_CLIST (cxpmail->list_title),
				      number - 1, 0);
		gtk_clist_moveto (GTK_CLIST (cxpmail->list_title), number - 1,
				  0, (gfloat) 0.5, (gfloat) 0.0);
	}

	cxpmail->keyPressStatus = 0;
	gtk_widget_destroy (win);
}

static int deleteMailCanFunc (GtkWidget * widget, GtkWidget * win)
{
	cxpmail->keyPressStatus = 0;
	gtk_widget_destroy (win);
}

static int deleteBoxOkFunc (GtkWidget * widget, GtkWidget * win)
{
	DIR *dfd;
	struct dirent *dp;
	char dirname[2048];
	char filename[2048];
	int index;
	int count;
	int i, k, totalCount;

	index = cxpmail->minfo.viewPoint;
	if (cxpmail->minfo.box[index]->count > 0)
	{
		sprintf (dirname, "%s/.cxp/mail/%s",
			 getenv ("HOME"), cxpmail->minfo.box[index]->boxName);

		if ((dfd = opendir (dirname)) != NULL)
		{
			for (i = 0; (dp = readdir (dfd)) != NULL; i++)
			{
				if (!strcmp (dp->d_name, ".")
				    || !strcmp (dp->d_name, ".."))
					continue;

				sprintf (filename, "%s/%s", dirname,
					 dp->d_name);
				remove (filename);
			}
			closedir (dfd);
		}
		remove (dirname);
	}

	sprintf (filename, "%s/.cxp/mail/%s",
		 getenv ("HOME"), cxpmail->minfo.box[index]->boxHeader);
	remove (filename);

	count = cxpmail->minfo.box[index]->count;
	for (i = 0; i < count; i++)
	{
		if (cxpmail->minfo.box[index]->mail[i] != (MailInfo *) NULL)
		{
			if (cxpmail->minfo.box[index]->mail[i]->data !=
			    (char *) NULL)
				free (cxpmail->minfo.box[index]->mail[i]->
				      data);
			free (cxpmail->minfo.box[index]->mail[i]);
		}
	}

	cxpmail->minfo.box[index]->count = 0;
	cxpmail->minfo.box[index]->boxName = (char *) 0;
	cxpmail->minfo.box[index]->boxHeader = (char *) 0;


	/* ܥå硢ʬ⹹ */
	totalCount = cxpmail->fdata.count;
	for (i = 0; i < totalCount; i++)
	{
		/* 줿ܥå */
		if (cxpmail->fdata.furi[i].boxid == index)
		{
			for (k = i; k < (totalCount - 1); k++)
			{
				cxpmail->fdata.furi[k].state =
					cxpmail->fdata.furi[k + 1].state;
				cxpmail->fdata.furi[k].message =
					g_strdup (cxpmail->fdata.furi[k + 1].
						  message);
				cxpmail->fdata.furi[k].boxid =
					cxpmail->fdata.furi[k + 1].boxid;
			}
			i--;
			totalCount--;
		}
	}
	setFuriwakeData (&cxpmail->fdata);
	getFuriwakeData (&cxpmail->fdata);

	setMailBoxInfo (&cxpmail->minfo);

	cxpmail->minfo.viewPoint--;
	if (cxpmail->minfo.viewPoint <= 0)
		cxpmail->minfo.viewPoint = 0;

	cxpmail->select_title = -1;

	cxpmail_base_view ();
	cxpmail_title_view ();
	cxpmail_view_view ();

	gtk_widget_destroy (win);

	return (0);
}

static int deleteBoxCanFunc (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (win);
}
