/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static char *listtitle[2] = { "Ͽʬ",
	" "
};

static char *stateString[4] = { "Ԥ",
	"̾",
	" ",
	" "
};

typedef struct
{
	int selectFuriwakeNo;
	CxpFuriwake fdata;
} LowFuriInfo;

static LowFuriInfo lfinfo;

static GtkWidget *furiwakeWin;
static GtkWidget *furiwakeList;
static GtkWidget *addBtn;
static GtkWidget *modBtn;
static GtkWidget *delBtn;
static GtkWidget *setBtn;
static GtkWidget *canBtn;

static int listselection (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return (0);

	lfinfo.selectFuriwakeNo = row;
	return (0);
}

static int listunselection (GtkWidget * clist, gint row, gint column,
			    GdkEventButton * event, gpointer data)
{
	lfinfo.selectFuriwakeNo = -1;
	return (0);
}

static int addFunction (GtkWidget * widget, GtkWidget * win)
{
	if (lfinfo.fdata.count >= MAX_FURIWAKE_NUM)
	{
		create_messageWin (cxpmail->window,
				   "ʾοʬɲäǤޤ");
		return (0);
	}

	create_addFuriwakeWin (&lfinfo.fdata, -1);

	return (0);
}
static int modFunction (GtkWidget * widget, GtkWidget * win)
{

#ifdef	DEBUG3
	fprintf (stdout, "modFunction: selectFuriwakeNo -> (%d)\n",
		 lfinfo.selectFuriwakeNo);
#endif

	if (lfinfo.selectFuriwakeNo < 0)
	{
		create_messageWin (cxpmail->window,
				   "ϿƤ뿶ʬ򤵤Ƥޤ");
		return (0);
	}

	create_addFuriwakeWin (&lfinfo.fdata, lfinfo.selectFuriwakeNo);

	return (0);
}
static int delFunction (GtkWidget * widget, GtkWidget * win)
{
	int i;

	if (lfinfo.selectFuriwakeNo < 0)
	{
		create_messageWin (cxpmail->window,
				   "ϿƤ뿶ʬ򤵤Ƥޤ");
		return (0);
	}

	for (i = lfinfo.selectFuriwakeNo; i < (lfinfo.fdata.count - 1); i++)
	{
		lfinfo.fdata.furi[i].state = lfinfo.fdata.furi[i + 1].state;
		lfinfo.fdata.furi[i].message =
			g_strdup (lfinfo.fdata.furi[i + 1].message);
		lfinfo.fdata.furi[i].boxid = lfinfo.fdata.furi[i + 1].boxid;
	}
	lfinfo.fdata.count--;
	if (lfinfo.fdata.count < 0)
		lfinfo.fdata.count = 0;

	furibase_view ();

	return (0);
}
static int setFunction (GtkWidget * widget, GtkWidget * win)
{
	int i;

	for (i = 0; i < lfinfo.fdata.count; i++)
	{
		cxpmail->fdata.furi[i].state = lfinfo.fdata.furi[i].state;
		cxpmail->fdata.furi[i].message =
			g_strdup (lfinfo.fdata.furi[i].message);
		cxpmail->fdata.furi[i].boxid = lfinfo.fdata.furi[i].boxid;
	}
	cxpmail->fdata.count = lfinfo.fdata.count;
	setFuriwakeData (&cxpmail->fdata);
	getFuriwakeData (&cxpmail->fdata);

	gtk_widget_destroy (win);
}
static int canFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (win);
}

int create_furiwakeWin ()
{
	GtkWidget *swin;
	GtkWidget *hbox1;
	GtkWidget *vbox1;
	GtkWidget *hbox2;
	GtkWidget *hbox3;
	char *furiname[2];
	char buff[2048];
	int x, y, w, h;
	int i;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	lfinfo.selectFuriwakeNo = -1;

	furiwakeWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (furiwakeWin), "furiwakeWin",
			     furiwakeWin);
	gtk_window_set_title (GTK_WINDOW (furiwakeWin), "ʬ");
	gtk_widget_set_usize (furiwakeWin, 450, 400);
	gtk_window_set_default_size (GTK_WINDOW (furiwakeWin), 450, 400);
	gtk_widget_set_uposition (furiwakeWin, (x - 450 * 0.5),
				  (y - 400 * 0.5));
	gtk_widget_show (furiwakeWin);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (furiwakeWin), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_container_add (GTK_CONTAINER (furiwakeWin), hbox1);
	gtk_container_set_border_width (GTK_CONTAINER (hbox1), 5);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (furiwakeWin), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox1, TRUE, TRUE, 0);

#if 0
	furiwakeList = gtk_list_new ();
	gtk_widget_ref (furiwakeList);
	gtk_object_set_data_full (GTK_OBJECT (furiwakeWin), "furiwakeList",
				  furiwakeList,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (furiwakeList);
	gtk_box_pack_start (GTK_BOX (vbox1), furiwakeList, TRUE, TRUE, 5);

#else
	swin = gtk_scrolled_window_new (NULL, NULL);

	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_show (swin);

	furiwakeList = gtk_clist_new_with_titles (1, listtitle);
	gtk_widget_set_usize (furiwakeList, 350, 300);
	gtk_clist_set_selection_mode (GTK_CLIST (furiwakeList),
				      GTK_SELECTION_BROWSE);

	gtk_signal_connect (GTK_OBJECT (furiwakeList), "select_row",
			    GTK_SIGNAL_FUNC (listselection), NULL);
	gtk_signal_connect (GTK_OBJECT (furiwakeList), "unselect_row",
			    GTK_SIGNAL_FUNC (listunselection), NULL);

	gtk_container_add (GTK_CONTAINER (swin), furiwakeList);
	gtk_widget_show (furiwakeList);

	gtk_box_pack_start (GTK_BOX (vbox1), swin, FALSE, TRUE, 5);
#endif

	hbox2 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (furiwakeWin), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 5);

	addBtn = gtk_button_new_with_label (" ɲ ");
	gtk_widget_ref (addBtn);
	gtk_object_set_data_full (GTK_OBJECT (furiwakeWin), "addBtn", addBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (addBtn);
	gtk_box_pack_start (GTK_BOX (hbox2), addBtn, FALSE, FALSE, 0);

	modBtn = gtk_button_new_with_label (" ѹ ");
	gtk_widget_ref (modBtn);
	gtk_object_set_data_full (GTK_OBJECT (furiwakeWin), "modBtn", modBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (modBtn);
	gtk_box_pack_start (GTK_BOX (hbox2), modBtn, FALSE, FALSE, 0);

	delBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (delBtn);
	gtk_object_set_data_full (GTK_OBJECT (furiwakeWin), "delBtn", delBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (delBtn);
	gtk_box_pack_start (GTK_BOX (hbox2), delBtn, FALSE, FALSE, 0);

	hbox3 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (furiwakeWin), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, TRUE, 6);

	setBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (setBtn);
	gtk_object_set_data_full (GTK_OBJECT (furiwakeWin), "setBtn", setBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (setBtn);
	gtk_box_pack_start (GTK_BOX (hbox3), setBtn, FALSE, FALSE, 0);

	canBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (canBtn);
	gtk_object_set_data_full (GTK_OBJECT (furiwakeWin), "canBtn", canBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (canBtn);
	gtk_box_pack_start (GTK_BOX (hbox3), canBtn, FALSE, FALSE, 0);

	gtk_signal_connect (GTK_OBJECT (addBtn), "clicked",
			    (GtkSignalFunc) addFunction, furiwakeWin);
	gtk_signal_connect (GTK_OBJECT (modBtn), "clicked",
			    (GtkSignalFunc) modFunction, furiwakeWin);
	gtk_signal_connect (GTK_OBJECT (delBtn), "clicked",
			    (GtkSignalFunc) delFunction, furiwakeWin);
	gtk_signal_connect (GTK_OBJECT (setBtn), "clicked",
			    (GtkSignalFunc) setFunction, furiwakeWin);
	gtk_signal_connect (GTK_OBJECT (canBtn), "clicked",
			    (GtkSignalFunc) canFunction, furiwakeWin);


	memset (&lfinfo.fdata, 0x00, sizeof (CxpFuriwake));
	lfinfo.fdata.count = cxpmail->fdata.count;

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (furiwakeList));
	gtk_clist_clear (GTK_CLIST (furiwakeList));

	for (i = 0; i < lfinfo.fdata.count; i++)
	{
		lfinfo.fdata.furi[i].state = cxpmail->fdata.furi[i].state;
		lfinfo.fdata.furi[i].message =
			g_strdup (cxpmail->fdata.furi[i].message);
		lfinfo.fdata.furi[i].boxid = cxpmail->fdata.furi[i].boxid;

		memset (buff, 0x00, sizeof (buff));
		sprintf (buff, "%s\"%s\"ʸä%sذư",
			 stateString[lfinfo.fdata.furi[i].state],
			 lfinfo.fdata.furi[i].message,
			 cxpmail->minfo.box[lfinfo.fdata.furi[i].boxid]->
			 boxName);
		furiname[0] = g_strdup (buff);
		gtk_clist_append (GTK_CLIST (furiwakeList), furiname);
	}

	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (furiwakeList));


	return (0);
}

int furibase_view ()
{
	int i;
	char *furiname[2];
	char buff[2048];

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (furiwakeList));
	gtk_clist_clear (GTK_CLIST (furiwakeList));

	for (i = 0; i < lfinfo.fdata.count; i++)
	{
		if (cxpmail->minfo.box[lfinfo.fdata.furi[i].boxid] !=
		    (BoxInfo *) NULL)
		{
			memset (buff, 0x00, sizeof (buff));
			sprintf (buff, "%s\"%s\"ʸä%sذư",
				 stateString[lfinfo.fdata.furi[i].state],
				 lfinfo.fdata.furi[i].message,
				 cxpmail->minfo.box[lfinfo.fdata.furi[i].
						    boxid]->boxName);
			furiname[0] = g_strdup (buff);
			gtk_clist_append (GTK_CLIST (furiwakeList), furiname);
		}
	}

	if (lfinfo.fdata.count <= 0)
		lfinfo.selectFuriwakeNo = -1;
	else
	{
		if (lfinfo.fdata.count >= lfinfo.selectFuriwakeNo)
			lfinfo.selectFuriwakeNo--;

		if (lfinfo.selectFuriwakeNo < 0)
			lfinfo.selectFuriwakeNo = 0;

		gtk_clist_select_row (GTK_CLIST (furiwakeList),
				      lfinfo.selectFuriwakeNo, 0);
	}

	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (furiwakeList));
}
