/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static int selectFuriwakeNo;
static int selectState;
static int selectBoxid;
static CxpFuriwake *finfo;
static GtkWidget *addFuriwakeWin;
static GtkWidget *messageLabel;
static GtkWidget *stringEntry;
static GtkWidget *optMenuName;
static GtkWidget *optMenuBox;
static GtkWidget *setBtn;
static GtkWidget *canBtn;

static int stateFunction (GtkWidget * widget, int data)
{
#ifdef	DEBUG3
	fprintf (stdout, "stateFunction: data => (%d)\n", data);
#endif

	selectState = data;
}

static int boxidFunction (GtkWidget * widget, int data)
{
#ifdef	DEBUG3
	fprintf (stdout, "boxidFunction: data => (%d)\n", data);
#endif
	selectBoxid = data;
}

static int setFunction (GtkWidget * widget, GtkWidget * win)
{
	char *entry;
	int index;

	entry = gtk_entry_get_text (GTK_ENTRY (stringEntry));
	if (entry == (char *) NULL)
	{
		create_messageWin (cxpmail->window,
				   "ʬʸϤƤޤ");
		return (0);
	}
	if (strlen (entry) <= 0)
	{
		create_messageWin (cxpmail->window,
				   "ʬʸϤƤޤ");
		return (0);
	}

	if (selectFuriwakeNo < 0)
	{
		/* ɲ */
		index = finfo->count;
		finfo->count++;
	}
	else
	{
		/* ѹ */
		index = selectFuriwakeNo;
	}

	finfo->furi[index].state = selectState;
	finfo->furi[index].message = g_strdup (entry);
	finfo->furi[index].boxid = selectBoxid;

#ifdef	DEBUG3
	fprintf (stdout, "finfo->furi[%d].state   => (%d)\n",
		 index, finfo->furi[index].state);
	fprintf (stdout, "finfo->furi[%d].message => [%s]\n",
		 index, finfo->furi[index].message);
	fprintf (stdout, "finfo->furi[%d].boxid   => (%d)\n",
		 index, finfo->furi[index].boxid);
#endif

	furibase_view ();

	gtk_widget_destroy (win);
}
static int canFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (win);
}

int create_addFuriwakeWin (CxpFuriwake * _finfo, int number)
{
	GtkWidget *hbox1;
	GtkWidget *vbox1;
	GtkWidget *hbox3;
	GtkWidget *optMenuName_menu;
	GtkWidget *glade_menuitem;
	GtkWidget *label2;
	GtkWidget *optMenuBox_menu;
	GtkWidget *label3;
	GtkWidget *hbox2;
	int x, y, w, h;
	int i;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	selectFuriwakeNo = number;
	finfo = (CxpFuriwake *) _finfo;

	addFuriwakeWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (addFuriwakeWin), "addFuriwakeWin",
			     addFuriwakeWin);
	gtk_window_set_title (GTK_WINDOW (addFuriwakeWin), "ʬ");
	gtk_widget_set_usize (addFuriwakeWin, 600, 140);
	gtk_window_set_default_size (GTK_WINDOW (addFuriwakeWin), 600, 140);
	gtk_widget_set_uposition (addFuriwakeWin, (x - 600 * 0.5),
				  (y - 140 * 0.5));
	gtk_widget_show (addFuriwakeWin);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_container_add (GTK_CONTAINER (addFuriwakeWin), hbox1);
	gtk_container_set_border_width (GTK_CONTAINER (hbox1), 5);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox1, TRUE, TRUE, 0);

	if (number < 0)
		messageLabel =
			gtk_label_new ("ܤڤϤƲ");
	else
		messageLabel =
			gtk_label_new ("ܵڤӥǡѹƲ");

	gtk_widget_ref (messageLabel);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "messageLabel",
				  messageLabel,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (messageLabel);
	gtk_box_pack_start (GTK_BOX (vbox1), messageLabel, FALSE, FALSE, 9);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, TRUE, 8);

	optMenuName = gtk_option_menu_new ();
	gtk_widget_ref (optMenuName);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "optMenuName",
				  optMenuName,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (optMenuName);
	gtk_box_pack_start (GTK_BOX (hbox3), optMenuName, FALSE, FALSE, 0);
	optMenuName_menu = gtk_menu_new ();

	glade_menuitem = gtk_menu_item_new_with_label ("Ԥ");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (optMenuName_menu), glade_menuitem);
	gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
			    (GtkSignalFunc) stateFunction, (gpointer) 0);

	glade_menuitem = gtk_menu_item_new_with_label ("̾");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (optMenuName_menu), glade_menuitem);
	gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
			    (GtkSignalFunc) stateFunction, (gpointer) 1);

#if 0				/* Сˤб */
	glade_menuitem = gtk_menu_item_new_with_label ("ʸ");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (optMenuName_menu), glade_menuitem);
	gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
			    (GtkSignalFunc) stateFunction, (gpointer) 3);
#endif

	gtk_option_menu_set_menu (GTK_OPTION_MENU (optMenuName),
				  optMenuName_menu);

	stringEntry = gtk_entry_new ();
	gtk_widget_ref (stringEntry);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "stringEntry",
				  stringEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (stringEntry);
	gtk_box_pack_start (GTK_BOX (hbox3), stringEntry, TRUE, TRUE, 0);

	label2 = gtk_label_new ("ʸä");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "label2",
				  label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (hbox3), label2, FALSE, FALSE, 0);

	optMenuBox = gtk_option_menu_new ();
	gtk_widget_ref (optMenuBox);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "optMenuBox",
				  optMenuBox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (optMenuBox);
	gtk_box_pack_start (GTK_BOX (hbox3), optMenuBox, FALSE, FALSE, 0);
	optMenuBox_menu = gtk_menu_new ();

	glade_menuitem = gtk_menu_item_new_with_label ("Ȣ");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (optMenuBox_menu), glade_menuitem);
	gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
			    (GtkSignalFunc) boxidFunction, (gpointer) 0);

	glade_menuitem = gtk_menu_item_new_with_label ("Ȣ");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (optMenuBox_menu), glade_menuitem);
	gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
			    (GtkSignalFunc) boxidFunction, (gpointer) 3);

	for (i = 5; i < MAX_BOX_NUM; i++)
	{
		if (cxpmail->minfo.box[i] == (BoxInfo *) NULL)
			continue;
		if (cxpmail->minfo.box[i]->boxName == (char *) NULL)
			continue;
		if (strlen (cxpmail->minfo.box[i]->boxName) <= 0)
			continue;

		glade_menuitem =
			gtk_menu_item_new_with_label (cxpmail->minfo.box[i]->
						      boxName);
		gtk_widget_show (glade_menuitem);
		gtk_menu_append (GTK_MENU (optMenuBox_menu), glade_menuitem);
		gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
				    (GtkSignalFunc) boxidFunction,
				    (gpointer) i);
	}

	gtk_option_menu_set_menu (GTK_OPTION_MENU (optMenuBox),
				  optMenuBox_menu);


	label3 = gtk_label_new ("ذư");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "label3",
				  label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (hbox3), label3, FALSE, FALSE, 0);

	hbox2 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 5);

	setBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (setBtn);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "setBtn",
				  setBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (setBtn);
	gtk_box_pack_start (GTK_BOX (hbox2), setBtn, FALSE, FALSE, 0);

	canBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (canBtn);
	gtk_object_set_data_full (GTK_OBJECT (addFuriwakeWin), "canBtn",
				  canBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (canBtn);
	gtk_box_pack_start (GTK_BOX (hbox2), canBtn, FALSE, FALSE, 0);


	gtk_signal_connect (GTK_OBJECT (setBtn), "clicked",
			    (GtkSignalFunc) setFunction, addFuriwakeWin);

	gtk_signal_connect (GTK_OBJECT (canBtn), "clicked",
			    (GtkSignalFunc) canFunction, addFuriwakeWin);


	if (number >= 0)
	{
		/* ѹϥǡ򥻥å */
		gtk_entry_set_text (GTK_ENTRY (stringEntry),
				    finfo->furi[number].message);

		gtk_option_menu_set_history (GTK_OPTION_MENU (optMenuName),
					     finfo->furi[number].state);

		if (finfo->furi[number].boxid == 0)
		{
			gtk_option_menu_set_history (GTK_OPTION_MENU
						     (optMenuBox), 0);
		}
		else if (finfo->furi[number].boxid == 3)
		{
			gtk_option_menu_set_history (GTK_OPTION_MENU
						     (optMenuBox), 1);
		}
		else
		{
			gtk_option_menu_set_history (GTK_OPTION_MENU
						     (optMenuBox),
						     (finfo->furi[number].
						      boxid - 5) + 2);
		}
		selectBoxid = finfo->furi[number].boxid;
	}
	else
	{
		selectState = 0;
		selectBoxid = BOXID_JYUSIN;
	}

	return (0);
}
