/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

int getFuriwakeData (CxpFuriwake * fdata)
{
	FILE *fp;
	char cbuff[1024];
	char filename[1024];
	int count;

	count = 0;

	sprintf (filename, "%s/.cxp/mail/furiwake.cfg", getenv ("HOME"));
	if (access (filename, F_OK))
	{
		fdata->count = 0;
		return (0);
	}

	if ((fp = fopen ((char *) getPath (filename), "r")) == NULL)
	{
		fdata->count = 0;
		return (0);
	}

	memset (cbuff, 0x00, sizeof (cbuff));
	while (fgets (cbuff, sizeof (cbuff), fp) != 0)
	{
		if ((cbuff[0] == '#') || (cbuff[0] == '\n')
		    || (cbuff[0] == '\t') || (cbuff[0] == ' '))
			continue;

		getNumberData (cbuff, "STATE=", strlen ("STATE="),
			       &fdata->furi[count].state);
		getStringData (cbuff, "MESSAGE=", strlen ("MESSAGE="),
			       &fdata->furi[count].message);
		getNumberData (cbuff, "BOXID=", strlen ("BOXID="),
			       &fdata->furi[count].boxid);

		if (strmatch ("BOXID=*", cbuff) == 0)
			count++;
	}

	fdata->count = count;
	fclose (fp);

	return (0);
}

int setFuriwakeData (CxpFuriwake * fdata)
{
	FILE *fp;
	char cbuff[1024];
	char filename[1024];
	int i;

	sprintf (filename, "%s/.cxp", getenv ("HOME"));
	if (access (filename, F_OK))
	{
		/* ǥ쥯ȥ꤬ʤä */
		mkdir (filename, 0755);
	}

	sprintf (filename, "%s/.cxp/mail", getenv ("HOME"));
	if (access (filename, F_OK))
	{
		/* ǥ쥯ȥ꤬ʤä */
		mkdir (filename, 0755);
	}

	sprintf (filename, "%s/.cxp/mail/furiwake.cfg", getenv ("HOME"));
	if ((fp = fopen ((char *) getPath (filename), "w")) == NULL)
	{
		return (-1);
	}

	fprintf (fp, "#\n");
	fprintf (fp,
		 "# furiwake.cfg (Cxp Mail Furiwake Config File Version 1.00) \n");
	fprintf (fp, "# author: konta (hatakeda@mbm.sphere.ne.jp)\n");
	fprintf (fp, "#\n");
	fprintf (fp, "#\n");
	fprintf (fp, "\n");

	for (i = 0; i < (fdata->count); i++)
	{
		fprintf (fp, "STATE=%d\n", fdata->furi[i].state);
		fprintf (fp, "MESSAGE=%s\n", fdata->furi[i].message);
		fprintf (fp, "BOXID=%d\n", fdata->furi[i].boxid);
		fprintf (fp, "\n");
	}

	fclose (fp);
	return (0);
}
