/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;


int newMailBoxInfo (MessageInfo * mess)
{
	FILE *fp;
	char filename[1024];

	sprintf (filename, "%s/.cxp", getenv ("HOME"));
	if (access (filename, F_OK))
		mkdir (filename, 0755);

	sprintf (filename, "%s/.cxp/mail", getenv ("HOME"));
	if (access (filename, F_OK))
		mkdir (filename, 0755);

	sprintf (filename, "%s/.cxp/mail/box.inf", getenv ("HOME"));

#ifdef	DEBUG
	fprintf (stdout, "filename => [%s]\n", filename);
#endif

	if (access (filename, F_OK))
	{
		if ((fp = fopen (filename, "w")) == NULL)
		{
			return (-1);
		}
		fprintf (fp, "Ȣ\tȢ.idx\n");
		fprintf (fp, "Ȣ\tȢ.idx\n");
		fprintf (fp, "\t.idx\n");
		fprintf (fp, "Ȣ\tȢ.idx\n");
		fprintf (fp, "񤭤\t񤭤.idx\n");
		fclose (fp);

		if (mess->box[BOXID_JYUSIN] == (BoxInfo *) NULL)
		{
			mess->box[BOXID_JYUSIN] = malloc (sizeof (BoxInfo));
			memset (mess->box[BOXID_JYUSIN], 0x00,
				sizeof (BoxInfo));
		}
		if (mess->box[BOXID_SOUSIN] == (BoxInfo *) NULL)
		{
			mess->box[BOXID_SOUSIN] = malloc (sizeof (BoxInfo));
			memset (mess->box[BOXID_SOUSIN], 0x00,
				sizeof (BoxInfo));
		}
		if (mess->box[BOXID_SUMI] == (BoxInfo *) NULL)
		{
			mess->box[BOXID_SUMI] = malloc (sizeof (BoxInfo));
			memset (mess->box[BOXID_SUMI], 0x00,
				sizeof (BoxInfo));
		}
		if (mess->box[BOXID_SAKUJO] == (BoxInfo *) NULL)
		{
			mess->box[BOXID_SAKUJO] = malloc (sizeof (BoxInfo));
			memset (mess->box[BOXID_SAKUJO], 0x00,
				sizeof (BoxInfo));
		}
		if (mess->box[BOXID_KAKIKAKE] == (BoxInfo *) NULL)
		{
			mess->box[BOXID_KAKIKAKE] = malloc (sizeof (BoxInfo));
			memset (mess->box[BOXID_KAKIKAKE], 0x00,
				sizeof (BoxInfo));
		}

		mess->box[BOXID_JYUSIN]->count = 0;
		mess->box[BOXID_JYUSIN]->boxName = (char *) strdup ("Ȣ");
		mess->box[BOXID_JYUSIN]->boxHeader =
			(char *) strdup ("Ȣ.idx");
		mess->box[BOXID_SOUSIN]->count = 0;
		mess->box[BOXID_SOUSIN]->boxName = (char *) strdup ("Ȣ");
		mess->box[BOXID_SOUSIN]->boxHeader =
			(char *) strdup ("Ȣ.idx");
		mess->box[BOXID_SUMI]->count = 0;
		mess->box[BOXID_SUMI]->boxName = (char *) strdup ("");
		mess->box[BOXID_SUMI]->boxHeader =
			(char *) strdup (".idx");
		mess->box[BOXID_SAKUJO]->count = 0;
		mess->box[BOXID_SAKUJO]->boxName = (char *) strdup ("Ȣ");
		mess->box[BOXID_SAKUJO]->boxHeader =
			(char *) strdup ("Ȣ.idx");
		mess->box[BOXID_KAKIKAKE]->count = 0;
		mess->box[BOXID_KAKIKAKE]->boxName =
			(char *) strdup ("񤭤");
		mess->box[BOXID_KAKIKAKE]->boxHeader =
			(char *) strdup ("񤭤.idx");

	}
	return (0);
}

int getMailBoxInfo (MessageInfo * mess)
{
	FILE *fp;
	char cbuff[1024];
	char wbuff[1024];
	char filename[1024];
	char *ptr, *ptr2, *ptr3;
	int i;

	sprintf (filename, "%s/.cxp/mail/box.inf", getenv ("HOME"));

#ifdef	DEBUG3
	fprintf (stdout, "getMailBoxInfo: filename => [%s]\n", filename);
#endif

	/* BOX */
	for (i = 0; i < MAX_BOX_NUM; i++)
	{
		if (mess->box[i] != (BoxInfo *) NULL)
		{
			mess->box[i]->count = 0;
			mess->box[i]->boxName = (char *) NULL;
			mess->box[i]->boxHeader = (char *) NULL;
		}
	}


	if (access (filename, F_OK))
	{
		/* BOX󤬤ʤˤϿ */
		newMailBoxInfo (mess);

#ifdef	DEBUG
		fprintf (stdout, "BOXʤΰ١n");
#endif

		return (0);
	}

	if ((fp = fopen ((char *) filename, "r")) == NULL)
	{
#ifdef DEBUG
		fprintf (stdout, "boxinf open error\n");
#endif
		return (-1);
	}


	i = 0;
	memset (cbuff, 0x00, sizeof (cbuff));
	while (fgets (cbuff, sizeof (cbuff), fp) != 0)
	{

		if (mess->box[i] == (BoxInfo *) NULL)
		{
			mess->box[i] = malloc (sizeof (BoxInfo));
			memset (mess->box[i], 0x00, sizeof (BoxInfo));
		}

		if ((cbuff[0] == '#') || (cbuff[0] == '\n')
		    || (cbuff[0] == '\t') || (cbuff[0] == ' '))
			continue;

		strcpy (wbuff, cbuff);
		ptr = strchr (wbuff, '\t');
		if (ptr != NULL)
			*ptr = 0;
		mess->box[i]->boxName = g_strdup (wbuff);

		ptr2 = strchr (ptr + 1, '\n');
		if (ptr2 != NULL)
			*ptr2 = 0;
		mess->box[i]->boxHeader = g_strdup (ptr + 1);

#ifdef DEBUG3
		fprintf (stdout,
			 "getMailBoxInfo: box(%d) name[%s] header[%s]\n", i,
			 mess->box[i]->boxName, mess->box[i]->boxHeader);
#endif

		i++;

	}
	fclose (fp);
	return (0);
}

int setMailBoxInfo (MessageInfo * mess)
{
	FILE *fp;
	char filename[1024];
	int i;

	sprintf (filename, "%s/.cxp", getenv ("HOME"));
	if (access (filename, F_OK))
		mkdir (filename, 0755);

	sprintf (filename, "%s/.cxp/mail", getenv ("HOME"));
	if (access (filename, F_OK))
		mkdir (filename, 0755);

	sprintf (filename, "%s/.cxp/mail/box.inf", getenv ("HOME"));

#ifdef DEBUG
	fprintf (stdout, "filename => [%s]\n", filename);
#endif

	if ((fp = fopen (filename, "w")) == NULL)
	{
		return (-1);
	}

	for (i = 0; i < MAX_BOX_NUM; i++)
	{
		if (mess->box[i] == (BoxInfo *) NULL)
			continue;
		if (mess->box[i]->boxName == (char *) NULL)
			continue;

		if (strlen (mess->box[i]->boxName) <= 0)
			continue;

		fprintf (fp, "%s\t%s\n",
			 mess->box[i]->boxName, mess->box[i]->boxHeader);
	}
	fclose (fp);

	return (0);
}


int getMailHeader (BoxInfo * box)
{
	FILE *fp;
	char cbuff[1024];
	char filename[1024];
	int i;

	/* Υǡˤϥꥢ */
	for (i = 0; i < box->count; i++)
	{
		if (box->mail[i] != (MailInfo *) NULL)
		{
			if (box->mail[i]->data != (char *) NULL)
				free (box->mail[i]->data);

			free (box->mail[i]);
			box->mail[i] = (MailInfo *) NULL;
		}
	}

	box->count = 0;

#ifdef DEBUG3
	fprintf (stdout, "getMailHeader: box name[%s] header[%s]\n",
		 box->boxName, box->boxHeader);
#endif

	sprintf (filename, "%s/.cxp/mail/%s", getenv ("HOME"),
		 box->boxHeader);
	if (access (filename, F_OK))
	{
#ifdef DEBUG
		fprintf (stdout, "getMailHeader file not found [%s]\n",
			 filename);
#endif
		return (0);
	}

	if ((fp = fopen ((char *) filename, "r")) == NULL)
	{
#ifdef DEBUG
		fprintf (stdout, "getMailHeader file open error [%s]\n",
			 filename);
#endif
		return (-1);
	}

	memset (cbuff, 0x00, sizeof (cbuff));
	while (fgets (cbuff, sizeof (cbuff), fp) != 0)
	{
		if ((cbuff[0] == '#') || (cbuff[0] == '\n')
		    || (cbuff[0] == '\t') || (cbuff[0] == ' '))
			continue;

		if (box->mail[box->count] == NULL)
		{
			box->mail[box->count] =
				(MailInfo *) malloc (sizeof (MailInfo));
			memset (box->mail[box->count], 0x00,
				sizeof (MailInfo));
		}

		getNumberData (cbuff, "NO=", strlen ("NO="),
			       &(box->mail[box->count]->no));
		getNumberData (cbuff, "MODE=", strlen ("MODE="),
			       &(box->mail[box->count]->mode));
		getStringData (cbuff, "NAME=", strlen ("NAME="),
			       &(box->mail[box->count]->name));
		getStringData (cbuff, "TITLE=", strlen ("TITLE="),
			       &(box->mail[box->count]->title));
		getNumberData (cbuff, "SIZE=", strlen ("SIZE="),
			       &(box->mail[box->count]->size));
		getNumberData (cbuff, "TEMP=", strlen ("TEMP="),
			       &(box->mail[box->count]->temp));
		getNumberData (cbuff, "DATE=", strlen ("DATE="),
			       (int *) &(box->mail[box->count]->date));

		if (strncmp (cbuff, "DATE=", strlen ("DATE=")) == 0)
			box->count++;
	}
	fclose (fp);

#ifdef DEBUG
	fprintf (stdout, "getMailHeader header num (%d)\n", box->count);
#endif

	return (0);
}

int setMailHeader (int boxid)
{
	BoxInfo *box;
	FILE *fp;
	char filename[1024];
	char cbuff[2048];
	char *ptr;
	int i;

	box = cxpmail->minfo.box[boxid];

	sprintf (filename, "%s/.cxp", getenv ("HOME"));
	if (access (filename, F_OK))
	{
		/* ǥ쥯ȥ꤬ʤä */
		mkdir (filename, 0755);
	}
	sprintf (filename, "%s/.cxp/mail", getenv ("HOME"));
	if (access (filename, F_OK))
	{
		/* ǥ쥯ȥ꤬ʤä */
		mkdir (filename, 0755);
	}

#ifdef DEBUG3
	fprintf (stdout, "setMailHeader: box name[%s] header[%s]\n",
		 box->boxName, box->boxHeader);
#endif

	memset (filename, 0x00, sizeof (filename));
	sprintf (filename, "%s/.cxp/mail/%s", getenv ("HOME"),
		 box->boxHeader);

#ifdef DEBUG3
	fprintf (stdout, "setMailHeader, filename => [%s]\n", filename);
#endif

	if ((fp = fopen ((char *) filename, "w")) == NULL)
	{
		return (-1);
	}

	for (i = 0; i < box->count; i++)
	{
		if (box->mail[i]->no > 0)
		{
			fprintf (fp, "NO=%d\n", box->mail[i]->no);
			fprintf (fp, "MODE=%d\n", box->mail[i]->mode);

			strcpy (cbuff, box->mail[i]->name);
			if ((ptr = strchr (cbuff, '\n')) != 0)
				*ptr = 0;
			fprintf (fp, "NAME=%s\n", cbuff);

			if (box->mail[i]->title != (char *) NULL)
			{
				strcpy (cbuff, box->mail[i]->title);
				if ((ptr = strchr (cbuff, '\n')) != 0)
					*ptr = 0;
				fprintf (fp, "TITLE=%s\n", cbuff);
			}
			else
			{
				fprintf (fp, "TITLE= \n", cbuff);
			}

			fprintf (fp, "SIZE=%d\n", box->mail[i]->size);
			fprintf (fp, "TEMP=%d\n", box->mail[i]->temp);
			fprintf (fp, "DATE=%d\n", box->mail[i]->date);
		}
	}

	fclose (fp);

	return (0);
}

int getMailData (BoxInfo * box, MailInfo ** mail)
{
	FILE *fp;
	char filename[1024];
	struct stat fileinfo;
	int datasize, ss, nowsize, gsize;
	char *data;

	sprintf (filename, "%s/.cxp/mail/%s/mail%d.dat",
		 getenv ("HOME"), box->boxName, (*mail)->no);
	if (access (filename, F_OK))
	{
		if ((*mail)->data != (char *) NULL)
			free ((*mail)->data);
		(*mail)->data = (char *) NULL;
#ifdef DEBUG
		fprintf (stdout, "getMailData file not found [%s]...\n",
			 filename);
#endif
		return (0);
	}

	/* եɹ */
	stat (filename, &fileinfo);

	/* ᡼ǡץ */
	if ((fp = fopen ((char *) filename, "rb")) == NULL)
	{
		if ((*mail)->data != (char *) NULL)
			free ((*mail)->data);
		(*mail)->data = (char *) NULL;
#ifdef DEBUG
		fprintf (stdout, "getMailData file open error [%s]...\n",
			 filename);
#endif
		return (-1);
	}

	(*mail)->data = (char *) malloc (fileinfo.st_size);
	if ((*mail)->data == (char *) NULL)
	{
#ifdef DEBUG
		fprintf (stdout, "getMailData malloc error [%d]...\n",
			 fileinfo.st_size);
#endif
		return (-1);
	}

	fread ((*mail)->data, 1, fileinfo.st_size, fp);

	fclose (fp);

	/* ꤹ */
	(*mail)->size = fileinfo.st_size;

	return (0);
}


int setMailData (BoxInfo * box, MailInfo * mail)
{
	FILE *fp;
	char filename[1024];
	int ss, gsize, datasize, nowsize;
	char *data;

	sprintf (filename, "%s/.cxp", getenv ("HOME"));
	if (access (filename, F_OK))
	{
		/* ǥ쥯ȥ꤬ʤä */
		mkdir (filename, 0755);
	}
	sprintf (filename, "%s/.cxp/mail", getenv ("HOME"));
	if (access (filename, F_OK))
	{
		/* ǥ쥯ȥ꤬ʤä */
		mkdir (filename, 0755);
	}
	sprintf (filename, "%s/.cxp/mail/%s", getenv ("HOME"), box->boxName);
	if (access (filename, F_OK))
	{
		/* ǥ쥯ȥ꤬ʤä */
		mkdir (filename, 0755);
	}

	sprintf (filename, "%s/.cxp/mail/%s/mail%d.dat",
		 getenv ("HOME"), box->boxName, mail->no);

	if ((fp = fopen (filename, "wb")) == NULL)
	{
		return (-1);
	}

	fwrite (mail->data, 1, mail->size, fp);

	fclose (fp);
}

int delMailData (BoxInfo * box, MailInfo * mail)
{
	char filename[1024];

	sprintf (filename, "%s/.cxp", getenv ("HOME"));
	if (access (filename, F_OK))
	{
		/* ǥ쥯ȥ꤬ʤä */
		mkdir (filename, 0755);
	}
	sprintf (filename, "%s/.cxp/mail", getenv ("HOME"));
	if (access (filename, F_OK))
	{
		/* ǥ쥯ȥ꤬ʤä */
		mkdir (filename, 0755);
	}
	sprintf (filename, "%s/.cxp/mail/%s", getenv ("HOME"), box->boxName);
	if (access (filename, F_OK))
	{
		return (0);
	}

	sprintf (filename, "%s/.cxp/mail/%s/mail%d.dat",
		 getenv ("HOME"), box->boxName, mail->no);
	if (access (filename, F_OK))
	{
		return (0);
	}

	/* ᡼ǡ */
	remove (filename);

	return (0);
}

/* ᡼ǡƥȥǡΤߤ */
/*  multipart ξϺǽ˸Ĥä text/plain Τߤ */
char *getNativeMailData (int *dsize, char *src, int ssize)
{
	int i, k, step, mm, ww;
	char buffer[2048];
	char wbuff[2048];
	char check[1024];
	char *dst;
	int multipartMode;
	char *multipartData;
	char *ptr1, *ptr2;
	int type;

	dst = malloc (ssize);
	if (dst == (char *) NULL)
	{
		*dsize = 0;
		return ((char *) NULL);
	}

	type = 0;		/* 0:none 1:text 2:other */
	multipartMode = 0;	/* 0 : none 1: multipart */
	multipartData = (char *) NULL;

	memset (dst, 0x00, sizeof (ssize));

	i = 0;
	k = 0;
	mm = 0;
	step = 0;
	memset (buffer, 0x00, sizeof (buffer));
	while (1)
	{
		if (i >= ssize)
			break;

		if (src[i] == '\r')
		{
			i++;
			continue;
		}

		buffer[k] = src[i];
		k++;

		if (src[i] == '\n')
		{
#ifdef DEBUG2
			if (k > 0)
				fprintf (stdout, "DATA(%d:%d:%d):%s", type,
					 step, multipartMode, buffer);
#endif
			if (step == 0)
			{
				if (strmatch ("*boundary=*", buffer) == 0)
				{
					/* ޥѡȥ⡼ */
					multipartMode = 1;

					/* boundary */
					ptr2 = strrchr (buffer, '"');
					if (ptr2 != (char *) NULL)
						*ptr2 = (char) NULL;
					ptr1 = strrchr (buffer, '"');
					if (ptr1 != (char *) NULL)
					{
						multipartData =
							g_strdup (ptr1 + 1);
					}
					else
					{
						/* Ǥʤä̾⡼ɤ᤹ */
						multipartData = (char *) NULL;
						multipartMode = 0;
					}
				}
				else if (memcmp (buffer, "\r\n", 2) == 0)
					step = 1;
				else if (memcmp (buffer, "\n", 1) == 0)
					step = 1;
			}
			else
			{
				if (multipartMode == 0)
				{
					memcpy (dst + mm, buffer, k);
					mm += k;
				}
				else if (multipartMode == 2)
				{
					sprintf (check, "--%s*",
						 multipartData);
					if (strmatch (check, buffer) == 0)
						break;

					memcpy (dst + mm, buffer, k);
					mm += k;
				}
				else
				{
					sprintf (check, "--%s*",
						 multipartData);
#ifdef DEBUG2
					fprintf (stdout, "BOUNDAEY=[%s]\n",
						 check);
#endif
					if (strmatch (check, buffer) == 0)
					{
#ifdef DEBUG2
						fprintf (stdout,
							 "check ok ...\n");
#endif
						/* βԥ(ԤԤΤߡˤޤǤǥפĴ٤ */
						i++;
						ww = 0;
						memset (wbuff, 0x00,
							sizeof (wbuff));
						while (1)
						{
							if (i >= ssize)
								break;

							if (src[i] == '\r')
							{
								i++;
								continue;
							}

							wbuff[ww] = src[i];
							ww++;

#ifdef DEBUG2
							if (ww > 0)
								fprintf (stdout, "DATA:%s", wbuff);
#endif

							if (src[i] == '\n')
							{
								if ((memcmp
								     (wbuff,
								      "\r\n",
								      2) == 0)
								    ||
								    (memcmp
								     (wbuff,
								      "\n",
								      1) ==
								     0))
									break;

								if ((strmatch
								     ("Content-Type:*text/plain*",
								      wbuff)
								     == 0)
								    ||
								    (strmatch
								     ("Content-Type:*Text/Plain*",
								      wbuff)
								     == 0))
								{
									type = 1;
								}

								memset (wbuff,
									0x00,
									sizeof
									(wbuff));
								ww = 0;
							}
							i++;
						}

						/* פ text/plain ʳ⤷ϣܤ text/plain ä */
						/* ȴ */
						if (type != 1)
							break;
						else
						{
							multipartMode = 2;
							memset (buffer, 0x00,
								sizeof
								(buffer));
							k = 0;
						}
					}
				}
			}
			k = 0;
			memset (buffer, 0x00, sizeof (buffer));
		}
		i++;
	}
	if (k > 0 && multipartMode == 0)
	{
		memcpy (dst + mm, buffer, k);
		mm += k;
	}

	*dsize = mm;

	return ((char *) dst);
}

/* ᡼󤫤إåϤ */
int recvMailHeaderInfo (char *messageData, int messageSize,
			char **name, char **send, char **cc, char **title,
			char **inre, time_t * tim)
{
	int nn;
	int i, j, k, xx;
	char *ptr, *ptr2;
	int size, osize;
	char cbuff[4096];
	char wbuff[4096];
	char xbuff[4096];
	time_t timData;
	struct tm ltim;
	char week[32], mon[32], other[32];
	int day, year, hour, min, sec, xmon;

	(*name) = (char *) NULL;
	(*send) = (char *) NULL;
	(*cc) = (char *) NULL;
	(*title) = (char *) NULL;
	(*inre) = (char *) NULL;
	(*tim) = (time_t) 0;

	nn = 0;
	size = 0;
	ptr = messageData;
	memset (cbuff, 0x00, sizeof (cbuff));
	while (1)
	{
		if (size >= messageSize)
			break;

		if (((*ptr) == '\n') && ((*(ptr + 1)) == '\r')
		    && ((*(ptr + 2)) == '\n'))
			break;

		if (((*ptr) == '\n') && ((*(ptr + 1)) != '\t')
		    && ((*(ptr + 1)) != ' '))
		{
			if ((strmatch ("From:*", cbuff) == 0)
			    || (strmatch ("from:*", cbuff) == 0))
			{
				memset (wbuff, 0x00, sizeof (wbuff));
				cxpmail_recvdata_euc (cbuff, nn, &wbuff,
						      &osize);
				ptr2 = strchr (wbuff, '\r');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, '\n');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, ' ');
				if (ptr2 != (char *) NULL)
				{
					(*name) = strdup (ptr2 + 1);
				}
				else
				{
					(*name) = strdup (wbuff);
				}

				memset (cbuff, 0x00, sizeof (cbuff));
				nn = 0;
			}
			if ((strmatch ("To:*", cbuff) == 0)
			    || (strmatch ("to:*", cbuff) == 0))
			{
				memset (wbuff, 0x00, sizeof (wbuff));
				cxpmail_recvdata_euc (cbuff, nn, &wbuff,
						      &osize);
				ptr2 = strchr (wbuff, '\r');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, '\n');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, ' ');
				if (ptr2 != (char *) NULL)
				{
					(*send) = strdup (ptr2 + 1);
				}
				else
				{
					(*send) = strdup (wbuff);
				}

				memset (cbuff, 0x00, sizeof (cbuff));
				nn = 0;
			}
			if ((strmatch ("Reply-To:*", cbuff) == 0)
			    || (strmatch ("reply-to:*", cbuff) == 0))
			{
				memset (wbuff, 0x00, sizeof (wbuff));
				cxpmail_recvdata_euc (cbuff, nn, &wbuff,
						      &osize);
				ptr2 = strchr (wbuff, '\r');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, '\n');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, ' ');
				if (ptr2 != (char *) NULL)
				{
					(*inre) = strdup (ptr2 + 1);
				}
				else
				{
					(*inre) = strdup (wbuff);
				}

				memset (cbuff, 0x00, sizeof (cbuff));
				nn = 0;
			}
			if ((strmatch ("Cc:*", cbuff) == 0)
			    || (strmatch ("cc:*", cbuff) == 0))
			{
				memset (wbuff, 0x00, sizeof (wbuff));
				cxpmail_recvdata_euc (cbuff, nn, &wbuff,
						      &osize);
				ptr2 = strchr (wbuff, '\r');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, '\n');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, ' ');
				if (ptr2 != (char *) NULL)
				{
					(*cc) = strdup (ptr2 + 1);
				}
				else
				{
					(*cc) = strdup (wbuff);
				}

				memset (cbuff, 0x00, sizeof (cbuff));
				nn = 0;
			}
			if ((strmatch ("Date:*", cbuff) == 0)
			    || (strmatch ("date:*", cbuff) == 0))
			{
				if ((strmatch
				     ("Date: ???, * ??? ???? ??:??:??*",
				      cbuff) == 0)
				    ||
				    (strmatch
				     ("date: ???, * ??? ???? ??:??:??*",
				      cbuff) == 0)
				    ||
				    (strmatch
				     ("Date:  ???, * ??? ???? ??:??:??*",
				      cbuff) == 0)
				    ||
				    (strmatch
				     ("date:  ???, * ??? ???? ??:??:??*",
				      cbuff) == 0))
				{
					/* Mon, 17 Apr 2000 16:35:42 +0900 ̻äѴ */
#ifdef DEBUG
					fprintf (stdout,
						 "wbuff(time) -> %-50.50s\n",
						 cbuff);
#endif
					if (strmatch
					    ("Date: ???, * ??? ???? ??:??:??*",
					     cbuff) == 0)
						sscanf (cbuff,
							"Date: %3s, %2d %3s %4d %2d:%2d:%2d %s",
							&week, &day, &mon,
							&year, &hour, &min,
							&sec, &other);
					else if (strmatch
						 ("date: ???, * ??? ???? ??:??:??*",
						  cbuff) == 0)
						sscanf (cbuff,
							"Date: %3s, %2d %3s %4d %2d:%2d:%2d %s",
							&week, &day, &mon,
							&year, &hour, &min,
							&sec, &other);
					else if (strmatch
						 ("Date:  ???, * ??? ???? ??:??:??*",
						  cbuff) == 0)
						sscanf (cbuff,
							"Date:  %3s, %2d %3s %4d %2d:%2d:%2d %s",
							&week, &day, &mon,
							&year, &hour, &min,
							&sec, &other);
					else
						sscanf (cbuff,
							"date:  %3s, %2d %3s %4d %2d:%2d:%2d %s",
							&week, &day, &mon,
							&year, &hour, &min,
							&sec, &other);

					if (strcmp (mon, "Jan") == 0)
						xmon = 0;
					if (strcmp (mon, "Feb") == 0)
						xmon = 1;
					if (strcmp (mon, "Mar") == 0)
						xmon = 2;
					if (strcmp (mon, "Apr") == 0)
						xmon = 3;
					if (strcmp (mon, "May") == 0)
						xmon = 4;
					if (strcmp (mon, "Jun") == 0)
						xmon = 5;
					if (strcmp (mon, "Jul") == 0)
						xmon = 6;
					if (strcmp (mon, "Aug") == 0)
						xmon = 7;
					if (strcmp (mon, "Sep") == 0)
						xmon = 8;
					if (strcmp (mon, "Oct") == 0)
						xmon = 9;
					if (strcmp (mon, "Nov") == 0)
						xmon = 10;
					if (strcmp (mon, "Dec") == 0)
						xmon = 11;

					ltim.tm_year = year - 1900;
					ltim.tm_mon = xmon;
					ltim.tm_mday = day;
					ltim.tm_hour = hour;
					ltim.tm_min = min;
					ltim.tm_sec = sec;

					timData = (time_t) mktime (&ltim);
				}
				else if ((strmatch
					  ("Date: ?? ??? ?? ??:??:??*",
					   cbuff) == 0)
					 ||
					 (strmatch
					  ("date: ?? ??? ?? ??:??:??*",
					   cbuff) == 0)
					 ||
					 (strmatch
					  ("Date: ?? ??? ???? ??:??:??*",
					   cbuff) == 0)
					 ||
					 (strmatch
					  ("date: ?? ??? ???? ??:??:??*",
					   cbuff) == 0))
				{
					/* 09 Sep 99 08:43:27 ̻äѴ */
					/* 09 Sep 2000 08:43:27 ̻äѴ */

#ifdef DEBUG
					fprintf (stdout,
						 "wbuff(time) -> %-50.50s\n",
						 cbuff);
#endif

					if (strmatch
					    ("Date: ?? ??? ?? ??:??:??*",
					     cbuff) == 0)
						sscanf (cbuff,
							"Date: %2d %3s %d %2d:%2d:%2d",
							&day, &mon, &year,
							&hour, &min, &sec);
					else if (strmatch
						 ("date: ?? ??? ?? ??:??:??*",
						  cbuff) == 0)
						sscanf (cbuff,
							"date: %2d %3s %d %2d:%2d:%2d",
							&day, &mon, &year,
							&hour, &min, &sec);
					else if (strmatch
						 ("Date: ?? ??? ???? ??:??:??*",
						  cbuff) == 0)
					{
						sscanf (cbuff,
							"Date: %2d %3s %d %2d:%2d:%2d",
							&day, &mon, &year,
							&hour, &min, &sec);
						year -= 1900;
					}
					else
					{
						sscanf (cbuff,
							"date: %2d %3s %d %2d:%2d:%2d",
							&day, &mon, &year,
							&hour, &min, &sec);
						year -= 1900;
					}

					if (strcmp (mon, "Jan") == 0)
						xmon = 0;
					if (strcmp (mon, "Feb") == 0)
						xmon = 1;
					if (strcmp (mon, "Mar") == 0)
						xmon = 2;
					if (strcmp (mon, "Apr") == 0)
						xmon = 3;
					if (strcmp (mon, "May") == 0)
						xmon = 4;
					if (strcmp (mon, "Jun") == 0)
						xmon = 5;
					if (strcmp (mon, "Jul") == 0)
						xmon = 6;
					if (strcmp (mon, "Aug") == 0)
						xmon = 7;
					if (strcmp (mon, "Sep") == 0)
						xmon = 8;
					if (strcmp (mon, "Oct") == 0)
						xmon = 9;
					if (strcmp (mon, "Nov") == 0)
						xmon = 10;
					if (strcmp (mon, "Dec") == 0)
						xmon = 11;

					ltim.tm_year = year;
					ltim.tm_mon = xmon;
					ltim.tm_mday = day;
					ltim.tm_hour = hour;
					ltim.tm_min = min;
					ltim.tm_sec = sec;

					timData = (time_t) mktime (&ltim);
				}
				else
				{
					/* եޥåȤʤΤǸ߻ */
					timData = time (0);;
				}
				(*tim) = timData;
				memset (cbuff, 0x00, sizeof (cbuff));
				nn = 0;
			}
			if ((strmatch ("Subject:*", cbuff) == 0)
			    || (strmatch ("subject:*", cbuff) == 0))
			{
				memset (wbuff, 0x00, sizeof (wbuff));
				memset (xbuff, 0x00, sizeof (xbuff));
				xx = tabclear (cbuff, nn, &xbuff[0]);
				cxpmail_recvdata_euc (xbuff, xx, &wbuff,
						      &osize);
				ptr2 = strchr (wbuff, '\r');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, '\n');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, ' ');
				if (ptr2 != (char *) NULL)
				{
					(*title) = strdup (ptr2 + 1);
				}
				else
				{
					(*title) = strdup (wbuff);
				}

				memset (cbuff, 0x00, sizeof (cbuff));
				nn = 0;
			}

			memset (cbuff, 0x00, sizeof (cbuff));
			nn = 0;

			ptr++;
		}
		else if (((*ptr) == '\n')
			 || (((*(ptr + 1)) == '\t') && ((*(ptr + 1)) == ' ')))
		{
			/* ³Υǡˤ³Ƽ */
			ptr++;
			size++;
		}
		else
		{
			if ((*ptr) != '\n' && (*ptr) != '\r')
			{
				cbuff[nn] = (*ptr);
				nn++;
			}
			ptr++;
			size++;
		}
	}

	return (0);
}

/* ᡼󤫤إåϤ */
int recvMailHeaderInfo2 (char *messageData, int messageSize, char **messid,
			 char **reference)
{
	int nn;
	int i, j, k, xx;
	char *ptr, *ptr2;
	int size, osize;
	char cbuff[8192];
	char wbuff[8192];
	char xbuff[8192];
	time_t timData;
	struct tm ltim;
	char week[32], mon[32], other[32];
	int day, year, hour, min, sec, xmon;

	(*messid) = (char *) NULL;
	(*reference) = (char *) NULL;

	nn = 0;
	size = 0;
	ptr = messageData;
	memset (cbuff, 0x00, sizeof (cbuff));
	while (1)
	{
		if (size >= messageSize)
			break;

		if (((*ptr) == '\n') && ((*(ptr + 1)) == '\r')
		    && ((*(ptr + 2)) == '\n'))
			break;

		if (((*ptr) == '\n') && ((*(ptr + 1)) != '\t')
		    && ((*(ptr + 1)) != ' '))
		{
			if ((strmatch ("Message-Id:*", cbuff) == 0)
			    || (strmatch ("Message-ID:*", cbuff) == 0))
			{
				memset (wbuff, 0x00, sizeof (wbuff));
				cxpmail_recvdata_euc (cbuff, nn, &wbuff,
						      &osize);
				ptr2 = strchr (wbuff, '\r');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, '\n');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, ' ');
				if (ptr2 != (char *) NULL)
				{
					(*messid) = strdup (ptr2 + 1);
				}
				else
				{
					(*messid) = strdup (wbuff);
				}

				memset (cbuff, 0x00, sizeof (cbuff));
				nn = 0;
			}
			if ((strmatch ("References:*", cbuff) == 0)
			    || (strmatch ("references:*", cbuff) == 0))
			{
				memset (wbuff, 0x00, sizeof (wbuff));
				cxpmail_recvdata_euc (cbuff, nn, &wbuff,
						      &osize);
				ptr2 = strchr (wbuff, '\r');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, '\n');
				if (ptr2 != (char *) NULL)
					*ptr2 = 0;
				ptr2 = strchr (wbuff, ' ');
				if (ptr2 != (char *) NULL)
				{
					(*reference) = strdup (ptr2 + 1);
				}
				else
				{
					(*reference) = strdup (wbuff);
				}

				memset (cbuff, 0x00, sizeof (cbuff));
				nn = 0;
			}

			memset (cbuff, 0x00, sizeof (cbuff));
			nn = 0;

			ptr++;
		}
		else if (((*ptr) == '\n')
			 || (((*(ptr + 1)) == '\t') && ((*(ptr + 1)) == ' ')))
		{
			/* ³Υǡˤ³Ƽ */
			ptr++;
			size++;
		}
		else
		{
			if ((*ptr) != '\n' && (*ptr) != '\r')
			{
				cbuff[nn] = (*ptr);
				nn++;
			}
			ptr++;
			size++;
		}
	}

	return (0);
}
