/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

int checkEucCode (char code)
{
	if ((unsigned char) code >= 0xa1 && (unsigned char) code <= 0xfe)
		return (1);	/*  */
	else if ((unsigned char) code == 0x8e)
		return (2);	/* ̾ */
	else if ((unsigned char) code == 0x8f)
		return (3);	/*  */
	else
		return (0);	/* ASCII */
}


/* ᡼ֹȯԤ */
int getMailNo ()
{
	int mailNo;
	int i, k;

	mailNo = 0;
	for (i = 0; i < MAX_BOX_NUM; i++)
	{
		if (cxpmail->minfo.box[i] != (BoxInfo *) NULL)
		{
			for (k = 0; k < cxpmail->minfo.box[i]->count; k++)
			{
				if (mailNo <
				    cxpmail->minfo.box[i]->mail[k]->no)
					mailNo = cxpmail->minfo.box[i]->
						mail[k]->no;
			}
		}
	}

	return (mailNo + 1);
}

/* ᡼ǡ */
int make_maildata (CxpMailClient * client, char **dst,
		   char *sendName, char *title, char *src, int ssize)
{
	char buffer[8192];
	char work[8192];
	char work2[8192];
	int dsize;
	int i, nn, k, step;
	int status;
	char *ptr;
	struct tm *ltim;
	time_t tim;
	int index;
	int number;
	char *messId, *references;

#ifdef	DEBUG3
	fprintf (stdout, "make_maildata: client->mode (%d)\n", client->mode);
#endif

	memset (buffer, 0x00, sizeof (buffer));

    /*-- From:  --*/
	memset (work, 0x00, sizeof (work));
	if (cxpmail->my.name == (char *) NULL)
	{
		sprintf (work, "From: %s\r\n", cxpmail->my.name);
	}
	else if (strlen (cxpmail->my.name) <= 0)
	{
		sprintf (work, "From: %s\r\n", cxpmail->my.email);
	}
	else
	{
		sprintf (work, "From: %s <%s>\r\n",
			 cxpmail->my.name, cxpmail->my.email);
	}
	strcat (buffer, work);

    /*-- To:  --*/
	nn = 0;
	memset (work, 0x00, sizeof (work));
	memset (work2, 0x00, sizeof (work2));
	for (i = 0; i < strlen (sendName); i++)
	{
#if 0
		if (sendName[i] == ' ')
			continue;
#endif
		if (sendName[i] == '\0')
			continue;
		if (sendName[i] == ';')
		{
			work2[nn] = '\r';
			nn++;
			work2[nn] = '\n';
			nn++;
			work2[nn] = '\t';
			nn++;
		}
		else
		{
			work2[nn] = sendName[i];
			nn++;
		}
	}

	if (client->mode == MAIL_MOD_MODE)
	{
		if (strlen (work2) > 0)
		{
			sprintf (work, "To: %s\r\n", work2);
			strcat (buffer, work);
		}
	}
	else
	{
		if (strlen (work2) <= 0)
		{
			return (-1);
		}
		sprintf (work, "To: %s\r\n", work2);
		strcat (buffer, work);
	}

    /*-- Subject:  --*/
#if 0
	sprintf (work, "Subject: %s\r\n", title);
	strcat (buffer, work);
#else
	sprintf (work, "Subject: ");
	strcat (buffer, work);
	k = 0;
	step = 0;
	memset (work, 0x00, sizeof (work));
	for (i = 0; i < strlen (title); i++)
	{
		status = checkEucCode ((char) *(title + i));
		if (status > 0)
		{
			work[k] = *(title + i);
			k++;
			i++;
			work[k] = *(title + i);
		}
		else
		{
			work[k] = *(title + i);
		}
		k++;

#if 0
		if (k > 16)
#else
		if (k > 14)
#endif
		{
			if (step > 0)
				strcat (buffer, "\r\n\t");
			strcat (buffer, work);
			memset (work, 0x00, sizeof (work));
			k = 0;
			step++;
		}
	}

	if (k > 0)
	{
		if (step > 0)
			strcat (buffer, "\r\n\t");
		strcat (buffer, work);
		memset (work, 0x00, sizeof (work));
		k = 0;
		step++;
	}
	strcat (buffer, "\r\n");

#endif

    /*-- Date:  --*/
	memset (work2, 0x00, sizeof (work2));
	tim = time (0);
	ltim = (struct tm *) localtime (&tim);
	strftime (work2, sizeof (work2), "%a, %d %b %Y %X %z", ltim);
	sprintf (work, "Date: %s\r\n", work2);
	strcat (buffer, work);

    /*-- Message-Id:  --*/
	if (cxpmail->my.email == (char *) NULL)
		sprintf (work,
			 "Message-Id: <%04d%02d%02d%02d%02d%02d.%s>\r\n",
			 ltim->tm_year, ltim->tm_mon, ltim->tm_mday,
			 ltim->tm_hour, ltim->tm_min, ltim->tm_sec,
			 "Unknown");
	else
		sprintf (work,
			 "Message-Id: <%04d%02d%02d%02d%02d%02d.%s>\r\n",
			 ltim->tm_year, ltim->tm_mon, ltim->tm_mday,
			 ltim->tm_hour, ltim->tm_min, ltim->tm_sec,
			 cxpmail->my.email);
	strcat (buffer, work);

	/* ֿ⡼ɤ */
	if (client->mode == MAIL_RE_MODE)
	{
		index = cxpmail->minfo.viewPoint;
		number = cxpmail->select_title;

		recvMailHeaderInfo2 (cxpmail->minfo.box[index]->
				     mail[number - 1]->data,
				     cxpmail->minfo.box[index]->mail[number -
								     1]->size,
				     &messId, &references);

		if ((ptr = strchr (messId, '\n')) != (char *) NULL)
			*ptr = (char) NULL;

		if (messId != (char *) NULL)
		{
			/* Ȥ Message-Id:  Resent-Message-Id: Ȥ */
			sprintf (work, "Resent-Message-Id: %s\r\n", messId);
			strcat (buffer, work);
		}

		if (messId != (char *) NULL)
		{
			/* Ȥ Message-Id:  In-Reply-To: Ȥ */
			sprintf (work, "In-Reply-To: %s\r\n", messId);
			strcat (buffer, work);
		}

		if (references != (char *) NULL || messId != (char *) NULL)
		{
			/* Ȥ Message-Id:  References: Ȥ */
			sprintf (work, "References: %s %s\r\n", references,
				 messId);
			strcat (buffer, work);
		}
	}

    /*-- MIME-Version:  --*/
	sprintf (work, "MIME-Version: 1.0\r\n");
	strcat (buffer, work);

	/* ȤꤢźդϤʤ */
	if (1)
	{
		/* źեե̵ξ */
	/*-- Content-Type:  --*/
		sprintf (work,
			 "Content-Type: text/plain; charset=\"iso-2022-jp\"\r\n");
		strcat (buffer, work);
	}
	else
	{
		/* źեեͭξ */
		sprintf (work, "Content-Type: multipart/mixed; "
			 "boundary=\"----------%04d%02d%02d%02d%02d%02d\"\r\n",
			 ltim->tm_year, ltim->tm_mon, ltim->tm_mday,
			 ltim->tm_hour, ltim->tm_min, ltim->tm_sec);
		strcat (buffer, work);
	}

    /*-- Content-Transfer-Encoding:  --*/
	sprintf (work, "Content-Transfer-Encoding: 7bit\r\n");
	strcat (buffer, work);

    /*-- X-Priority:  --*/
	sprintf (work, "X-Priority: 3\r\n");
	strcat (buffer, work);

    /*-- X-Mailer:  --*/
	sprintf (work, "X-Mailer: %s\r\n", getdataVersion ());
	strcat (buffer, work);

    /*-- λ --*/
	sprintf (work, "\r\n");
	strcat (buffer, work);

#ifdef	DEBUG5
	fprintf (stdout, "buffer[%s]\n", buffer);
#endif

	dsize = strlen (buffer);

#ifdef DEBUG
	fprintf (stdout, "-- header ---\n");
#if 0
	for (i = 0; i < dsize; i++)
		fprintf (stdout, "%c", buffer[i]);
	fprintf (stdout, "\n");
#endif
#endif


#ifdef DEBUG
	fprintf (stdout, "dsize -> %d\n", dsize);
	fprintf (stdout, "ssize -> %d\n", ssize);
#endif

	(*dst) = (char *) malloc (dsize + ssize);
	if ((*dst) == (char *) NULL)
	{
		return (-2);
	}
	memcpy ((*dst), buffer, dsize);
	memcpy ((*dst) + dsize, src, ssize);

	return (dsize + ssize);

}
