/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static void filemenu_response ();
static void editmenu_response ();
static void viewmenu_response ();
static void settmenu_response ();
static void toolmenu_response ();
static void messmenu_response ();
static void helpmenu_response ();

#define	FILEIACT_NEWBOX		0x0101
#define	FILEIACT_DELBOX		0x0102
#define	FILEIACT_RENAMEBOX	0x0103
#define	FILEIACT_INPORT		0x0104
#define	FILEIACT_EXPORT		0x0105
#define	FILEIACT_CLOSE		0x0106
#define	EDITIACT_SEARCH		0x0201
#define	EDITIACT_MOVE		0x0202
#define	EDITIACT_DELETE		0x0203
#define	VIEWIACT_UPDATE		0x0301
#define	VIEWIACT_SORT		0x0302
#define	VIEWIACT_SYOUSAI	0x0303
#define	SETTIACT_BASE		0x0401
#define	SETTIACT_SETVIEW	0x0402
#define	SETTIACT_FURIWAKE	0x0403
#define	SETTIACT_USET		0x0404
#define	SETTIACT_BSET		0x0405
#define	TOOLIACT_SEND		0x0501
#define	TOOLIACT_RECV		0x0502
#define	TOOLIACT_SENDRECV	0x0503
#define MESSIACT_NEW		0x0601
#define MESSIACT_RE		0x0602
#define MESSIACT_FW		0x0603
#define HELPIACT_HELP		0x0901

#define	FILEMENU_BASE		"/ե"
#define	FILEMENU_NEWBOX		"/ե/ܥå"
#define	FILEMENU_DELBOX		"/ե/ܥå"
#define	FILEMENU_RENAMEBOX	"/ե/ܥå̾ѹ"
#define	FILEMENU_SEP1		"/ե/sep1"
#define	FILEMENU_INPORT		"/ե/ݡ"
#define	FILEMENU_EXPORT		"/ե/ݡ"
#define	FILEMENU_SEP2		"/ե/sep2"
#define	FILEMENU_CLOSE		"/ե/λ"
#define	EDITMENU_BASE		"/Խ"
#define	EDITMENU_SEARCH		"/Խ/"
#define	EDITMENU_MOVE		"/Խ/ܥåذư"
#define	EDITMENU_SEP1		"/Խ/sep1"
#define	EDITMENU_DELETE		"/Խ/᡼"
#define	VIEWMENU_BASE		"/ɽ"
#define	VIEWMENU_UPDATE		"/ɽ/ǿξ˹"
#define	VIEWMENU_SORT		"/ɽ/¤ؤ"
#define	VIEWMENU_SYOUSAI	"/ɽ/ܺɽ"
#define	SETTMENU_BASE		"/"
#define	SETTMENU_BSET		"//"
#define	SETTMENU_USET		"//"
#define	SETTMENU_FURIWAKE	"//ʬ"
#define	SETTMENU_SETVIEW	"//ɽ֡"
#define	TOOLMENU_BASE		"/ġ"
#define	TOOLMENU_SEND		"/ġ/᡼"
#define	TOOLMENU_RECV		"/ġ/᡼"
#define	TOOLMENU_SENDRECV	"/ġ/᡼"
#define MESSMENU_BASE		"/å"
#define MESSMENU_NEW		"/å/᡼"
#define MESSMENU_RE		"/å/ֿ"
#define MESSMENU_FW		"/å/ž"
#define HELPMENU_BASE		"/إ"
#define HELPMENU_HELP		"/إ/CxpmailˤĤ"


static GtkItemFactoryEntry menu_items[] = {
	{FILEMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{FILEMENU_NEWBOX, NULL, filemenu_response, FILEIACT_NEWBOX, NULL},
	{FILEMENU_DELBOX, NULL, filemenu_response, FILEIACT_DELBOX, NULL},
	{FILEMENU_RENAMEBOX, NULL, filemenu_response, FILEIACT_RENAMEBOX,
	 NULL},
	{FILEMENU_SEP1, NULL, NULL, 0, "<Separator>"},
	{FILEMENU_INPORT, "<control>I", filemenu_response, FILEIACT_INPORT,
	 NULL},
	{FILEMENU_EXPORT, "<control>E", filemenu_response, FILEIACT_EXPORT,
	 NULL},
	{FILEMENU_SEP2, NULL, NULL, 0, "<Separator>"},
	{FILEMENU_CLOSE, "<control>Q", filemenu_response, FILEIACT_CLOSE,
	 NULL},
	{EDITMENU_BASE, NULL, NULL, 0, "<Branch>"},
#if 0
	{EDITMENU_SEARCH, "<control>T", editmenu_response, EDITIACT_SEARCH,
	 NULL},
#endif
	{EDITMENU_MOVE, NULL, editmenu_response, EDITIACT_MOVE, NULL},
	{EDITMENU_SEP1, NULL, NULL, 0, "<Separator>"},
	{EDITMENU_DELETE, "<control>D", editmenu_response, EDITIACT_DELETE,
	 NULL},
	{VIEWMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{VIEWMENU_UPDATE, "<control>V", viewmenu_response, VIEWIACT_UPDATE,
	 NULL},
#if 0
	{VIEWMENU_SORT, NULL, viewmenu_response, VIEWIACT_SORT, NULL},
#endif
	{VIEWMENU_SYOUSAI, NULL, viewmenu_response, VIEWIACT_SYOUSAI, NULL},
	{SETTMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{SETTMENU_FURIWAKE, "<control>F", settmenu_response,
	 SETTIACT_FURIWAKE, NULL},
	{SETTMENU_USET, NULL, settmenu_response, SETTIACT_USET, NULL},
	{SETTMENU_BSET, NULL, settmenu_response, SETTIACT_BSET, NULL},
	{SETTMENU_SETVIEW, NULL, settmenu_response, SETTIACT_SETVIEW, NULL},
	{TOOLMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{TOOLMENU_SEND, NULL, toolmenu_response, TOOLIACT_SEND, NULL},
	{TOOLMENU_RECV, NULL, toolmenu_response, TOOLIACT_RECV, NULL},
	{TOOLMENU_SENDRECV, "<control>M", toolmenu_response,
	 TOOLIACT_SENDRECV, NULL},
	{MESSMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{MESSMENU_NEW, "<control>N", messmenu_response, MESSIACT_NEW, NULL},
	{MESSMENU_RE, "<control>R", messmenu_response, MESSIACT_RE, NULL},
	{MESSMENU_FW, "<control>F", messmenu_response, MESSIACT_FW, NULL},
	{HELPMENU_BASE, NULL, NULL, 0, "<LastBranch>"},
	{HELPMENU_HELP, NULL, helpmenu_response, HELPIACT_HELP, NULL},
};

static void filemenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case FILEIACT_NEWBOX:
		cxpmailfilefunc_newbox ();
		break;
	case FILEIACT_DELBOX:
		cxpmailfilefunc_delbox ();
		break;
	case FILEIACT_RENAMEBOX:
		cxpmailfilefunc_renamebox ();
		break;
	case FILEIACT_INPORT:
		cxpmailfilefunc_inport ();
		break;
	case FILEIACT_EXPORT:
		cxpmailfilefunc_export ();
		break;
	case FILEIACT_CLOSE:
		cxpmailfilefunc_close ();
		break;
	}
}

static void editmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case EDITIACT_SEARCH:
		cxpmaileditfunc_search ();
		break;
	case EDITIACT_MOVE:
		cxpmaileditfunc_movemail ();
		break;
	case EDITIACT_DELETE:
		cxpmaileditfunc_delmail ();
		break;
	}
}

static void viewmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case VIEWIACT_UPDATE:
		cxpmailviewfunc_update ();
		break;
	case VIEWIACT_SORT:
		cxpmailviewfunc_sort ();
		break;
	case VIEWIACT_SYOUSAI:
		cxpmailviewfunc_syousai ();
		break;
	}
}

static void settmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case SETTIACT_FURIWAKE:
		cxpmailtoolfunc_furiwake ();
		break;
	case SETTIACT_USET:
		cxpmailtoolfunc_userset ();
		break;
	case SETTIACT_BSET:
		cxpmailtoolfunc_mailset ();
		break;
	case SETTIACT_SETVIEW:
		create_sizeSettingWindow (CXPMAIL_MODE);
		break;
	}
}

static void toolmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case TOOLIACT_SEND:
		cxpmailtoolfunc_send ();
		break;
	case TOOLIACT_RECV:
		cxpmailtoolfunc_recv ();
		break;
	case TOOLIACT_SENDRECV:
		cxpmailtoolfunc_sendrecv ();
		break;
	}
}

static void messmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case MESSIACT_NEW:
		cxpmailmessfunc_new ();
		break;
	case MESSIACT_RE:
		cxpmailmessfunc_re ();
		break;
	case MESSIACT_FW:
		cxpmailmessfunc_fw ();
		break;
	}
}

static void helpmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case HELPIACT_HELP:
		cxpmailhelpfunc_help ();
		break;
	}
}

void cxpmail_menu_init ()
{
	GtkWidget *handle_box;
	GtkWidget *subitem;
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	int nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);

	handle_box = gtk_handle_box_new ();
	gtk_box_pack_start (GTK_BOX (cxpmail->vbox), handle_box, FALSE, FALSE,
			    0);
	gtk_widget_show (handle_box);

	accel_group = gtk_accel_group_new ();

	item_factory =
		gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				      accel_group);

	gtk_item_factory_create_items (item_factory, nmenu_items, menu_items,
				       NULL);

	gtk_accel_group_attach (accel_group, GTK_OBJECT (cxpmail->window));

	cxpmail->menubar =
		gtk_item_factory_get_widget (item_factory, "<main>");
	gtk_container_add (GTK_CONTAINER (handle_box), cxpmail->menubar);
	gtk_widget_show (cxpmail->menubar);

}
