/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static GtkWidget *modBoxWin;
static GtkWidget *beforeBoxName;
static GtkWidget *boxNameEntry;
static GtkWidget *setBtn;
static GtkWidget *canBtn;
static int boxNo;

static int setFunction (GtkWidget * widget, GtkWidget * win)
{
	char wbuff[2048];
	char cbuff[2048];
	char *ptr;
	char *boxName;
	int i, check;

	boxName = gtk_entry_get_text (GTK_ENTRY (boxNameEntry));
	if (boxName == (char *) NULL)
	{
		create_messageWin (cxpmail->window,
				   "ܥå̾ϤƲ");
		return (0);
	}

	if (strlen (boxName) <= 0)
	{
		create_messageWin (cxpmail->window,
				   "ܥå̾ϤƲ");
		return (0);
	}

	check = 0;
	for (i = 0; i < MAX_BOX_NUM; i++)
	{
		if (cxpmail->minfo.box[i] != (BoxInfo *) NULL)
		{
			if (cxpmail->minfo.box[i]->boxName != NULL)
			{
				if ((i != boxNo)
				    &&
				    (strcmp
				     (cxpmail->minfo.box[i]->boxName,
				      boxName) == 0))
				{
					check = 1;
					break;
				}
			}
		}
	}

	if (check > 0)
	{
		create_messageWin (cxpmail->window,
				   "Ʊ̾ΥܥåϿƤޤ");
		return (0);
	}

	/* ǥ쥯ȥ꤬̾Τѹ */
	sprintf (wbuff, "%s/.cxp/mail/%s", getenv ("HOME"),
		 cxpmail->minfo.box[boxNo]->boxName);
	sprintf (cbuff, "%s/.cxp/mail/%s", getenv ("HOME"), boxName);
	rename (wbuff, cbuff);

	/* إå󤬤̾Τѹ */
	sprintf (wbuff, "%s/.cxp/mail/%s.idx", getenv ("HOME"),
		 cxpmail->minfo.box[boxNo]->boxName);
	sprintf (cbuff, "%s/.cxp/mail/%s.idx", getenv ("HOME"), boxName);
	rename (wbuff, cbuff);

	sprintf (wbuff, "%s.idx", boxName);
	cxpmail->minfo.box[boxNo]->boxName = g_strdup (boxName);
	cxpmail->minfo.box[boxNo]->boxHeader = g_strdup (wbuff);

	/* ǡ򹹿 */
	setMailBoxInfo (&cxpmail->minfo);

	/* ǡɽ */
	cxpmail_base_view ();


	gtk_widget_destroy (win);
}

static int cancelFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (win);
}

int create_modBoxWin ()
{
	GtkWidget *hbox1;
	GtkWidget *vbox1;
	GtkWidget *label1;
	GtkWidget *hbox3;
	GtkWidget *vbox2;
	GtkWidget *label2;
	GtkWidget *label3;
	GtkWidget *vbox3;
	GtkWidget *hbox4;
	int x, y, w, h;
	int index;

	index = cxpmail->minfo.viewPoint;

	if (index < 0)
	{
		create_messageWin (cxpmail->window,
				   "ܥå򤵤Ƥޤ");
		return (0);
	}

	if (index >= 0 && index <= 4)
	{
		create_messageWin (cxpmail->window,
				   "Υܥå̾ΤѹǤޤ");
		return (0);
	}

	boxNo = index;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w * 0.5;
	y = h * 0.5;

	modBoxWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (modBoxWin), "modBoxWin", modBoxWin);
	gtk_window_set_title (GTK_WINDOW (modBoxWin), "ܥå̾ѹ");
	gtk_widget_set_usize (modBoxWin, 100, 100);
	gtk_window_set_default_size (GTK_WINDOW (modBoxWin), 300, 150);
	gtk_widget_set_uposition (modBoxWin, (x - 300 * 0.5),
				  (y - 150 * 0.5));
	gtk_widget_show (modBoxWin);


	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_container_add (GTK_CONTAINER (modBoxWin), hbox1);
	gtk_container_set_border_width (GTK_CONTAINER (hbox1), 5);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox1, TRUE, TRUE, 0);

	label1 = gtk_label_new ("ѹΥܥå̾ϤƲ");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "label1", label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox3, TRUE, TRUE, 0);

	vbox2 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "vbox2", vbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox3), vbox2, FALSE, TRUE, 0);

	label2 = gtk_label_new ("Υܥå̾");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "label2", label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox2), label2, FALSE, FALSE, 0);

	label3 = gtk_label_new ("ѹΥܥå̾");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "label3", label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (vbox2), label3, FALSE, FALSE, 0);

	vbox3 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox3);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "vbox3", vbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox3);
	gtk_box_pack_start (GTK_BOX (hbox3), vbox3, TRUE, TRUE, 0);

	beforeBoxName = gtk_label_new (cxpmail->minfo.box[index]->boxName);
	gtk_widget_ref (beforeBoxName);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "beforeBoxName",
				  beforeBoxName,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (beforeBoxName);
	gtk_box_pack_start (GTK_BOX (vbox3), beforeBoxName, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (beforeBoxName), GTK_JUSTIFY_LEFT);

	boxNameEntry = gtk_entry_new ();
	gtk_widget_ref (boxNameEntry);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "boxNameEntry",
				  boxNameEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (boxNameEntry);
	gtk_box_pack_start (GTK_BOX (vbox3), boxNameEntry, FALSE, FALSE, 0);

	hbox4 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox4);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "hbox4", hbox4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox4);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox4, FALSE, TRUE, 10);

	setBtn = gtk_button_new_with_label (" ѹ ");
	gtk_widget_ref (setBtn);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "setBtn", setBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (setBtn);
	gtk_box_pack_start (GTK_BOX (hbox4), setBtn, FALSE, FALSE, 0);

	canBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (canBtn);
	gtk_object_set_data_full (GTK_OBJECT (modBoxWin), "canBtn", canBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (canBtn);
	gtk_box_pack_start (GTK_BOX (hbox4), canBtn, FALSE, FALSE, 0);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (setBtn), "clicked",
			    (GtkSignalFunc) setFunction, modBoxWin);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (canBtn), "clicked",
			    (GtkSignalFunc) cancelFunction, modBoxWin);

	/* ܥå̾Τ */
	gtk_entry_set_text (GTK_ENTRY (boxNameEntry),
			    cxpmail->minfo.box[index]->boxName);

	return (0);
}
