/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

/*-- ͥåȥѥإå --*/
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>

extern CxpMail *cxpmail;

int cxpmail_net_open (char *hostname, char *portno)
{
	int sock;
	struct hostent *host;
	struct sockaddr_in sin;

	if (hostname == NULL)
	{
#ifdef DEBUG
		fprintf (stdout, "hostname is NULL\n");
#endif
		/* ۥ̾۾狼Ƥʤ */
		return (-1);
	}

	if ((host = gethostbyname (hostname)) == NULL)
	{
#ifdef DEBUG
		fprintf (stdout, "hostname is not define\n");
#endif
		/* ۥ̾۾狼Ƥʤ */
		return (-1);
	}

	if ((sock = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
	{
#ifdef DEBUG
		fprintf (stdout, "socket func error\n");
#endif
		/* åȥ顼 */
		return (-2);
	}

	if (portno == NULL)
	{
#ifdef DEBUG
		fprintf (stdout, "port no error\n");
#endif
		/* ݡֹ椬۾郎Ƥʤ */
		return (-3);
	}

	sin.sin_family = AF_INET;
	sin.sin_port = htons (atoi (portno));
	memcpy (&sin.sin_addr, host->h_addr_list[0], sizeof (sin.sin_addr));

	if (connect (sock, (struct sockaddr *) &sin, sizeof (sin)) < 0)
	{
#ifdef DEBUG
		fprintf (stdout, "connect error\n");
#endif
		/* ͥ󥨥顼 */
		return (-3);
	}

	return (sock);
}

int cxpmail_net_close (int sock)
{
	close (sock);
}

int cxpmail_net_send (int sock, char *data, int size)
{
	int ss;

	ss = write (sock, data, size);
	if (ss == size)
		return (ss);
	else
		return (-1);
}

int cxpmail_net_recv (int sock, char **data, int *size)
{
	char cc;
	int ss;
	int recvsize;
	char *ptr;

	ptr = (*data);

	recvsize = 0;
	while (1)
	{
		ss = read (sock, &cc, sizeof (char));
		if (ss <= 0)
			break;
		*ptr = cc;
		recvsize++;
		if (recvsize > 5)
		{
			if ((*(ptr - 4) == '\r')
			    && (*(ptr - 3) == '\n')
			    && (*(ptr - 2) == '.')
			    && (*(ptr - 1) == '\r') && (*(ptr) == '\n'))
			{
				recvsize -= 5;
				break;
			}
		}

		ptr++;
	}

	*size = recvsize;

	return (recvsize);
}

int cxpmail_net_reply (int sock, char *data, int *size)
{
	int ss;
	int retsize;
	int cc;
	int code;
	char *ptr;

	ptr = data;

	retsize = 0;
#ifdef DEBUG
	fprintf (stdout, "[");
#endif
	while (1)
	{
		ss = read (sock, &cc, sizeof (char));
#ifdef DEBUG
		fprintf (stdout, "%c", (char) cc);
#endif
		if ((char) cc == '\n' || (char) cc == '\0')
			break;
		retsize += ss;
		*ptr = cc;
		ptr++;
	}
#ifdef DEBUG
	fprintf (stdout, "]\n");
#endif

	*size = retsize;
	ptr = strchr (data, ' ');
	if (ptr == NULL)
	{
		ptr = strchr (data, '\n');
		if (ptr != NULL)
		{
			*ptr = (char) NULL;
			code = atoi (data);
		}
		else
		{
			return (-1);
		}
	}
	else
	{
		*ptr = (char) NULL;
		code = atoi (data);
	}

	return (code);
}

int cxpmail_net_reply_cmd (int sock, char *data, int *size)
{
	int ss;
	int retsize;
	int cc;
	int code;
	char *ptr;

	ptr = data;

	retsize = 0;
#ifdef DEBUG
	fprintf (stdout, "[");
#endif
	while (1)
	{
		ss = read (sock, &cc, sizeof (char));
#ifdef DEBUG
		fprintf (stdout, "%c", (char) cc);
#endif
		if ((char) cc == '\n' || (char) cc == '\0')
			break;
		retsize += ss;
		*ptr = cc;
		ptr++;
	}
#ifdef DEBUG
	fprintf (stdout, "]\n");
#endif

	*size = retsize;

	if (strncmp (data, "+OK", strlen ("+OK")) == 0)
		code = 0;
	else
		code = -1;

	return (code);
}

int _cxpmail_senddata_euc (char *src, int isize, char *dst, int *osize)
{
	FILE *fpi, *fpo;
	int size, nn;
	char *ptr;
	char filein[1024];
	char fileout[1024];
	char command[1024];

	/* Ϥ줿EUCǡJISǡѴ */
	/* Ȥꤢ nkf ѡŪˤϤϥꥸʥѹ */

	sprintf (filein, "/tmp/.cxpmail%06d_in", getpid ());
	sprintf (fileout, "/tmp/.cxpmail%06d_out", getpid ());
	if ((fpi = fopen (filein, "w")) == NULL)
		return (-1);
	fwrite (src, isize, 1, fpi);
	fclose (fpi);

	sprintf (command, "nkf -mj < %s > %s", filein, fileout);
	system (command);

	if ((fpo = fopen (fileout, "r")) == NULL)
	{
		remove (filein);
		remove (fileout);
		return (-1);
	}

	*osize = 0;
	ptr = dst;
	for (;;)
	{
		nn = fread (ptr, 1, 1, fpo);
		if (nn == 0)
			break;
		(*osize) += nn;
		ptr += nn;
	}
	fclose (fpo);

	remove (filein);
	remove (fileout);
}

int _cxpmail_senddata_eucMINE (char *src, int isize, char *dst, int *osize)
{
	FILE *fpi, *fpo;
	int size, nn;
	char *ptr;
	char filein[1024];
	char fileout[1024];
	char command[1024];

	/* Ϥ줿EUCǡJISǡѴ */
	/* Ȥꤢ nkf ѡŪˤϤϥꥸʥѹ */

	sprintf (filein, "/tmp/.cxpmail%06d_in", getpid ());
	sprintf (fileout, "/tmp/.cxpmail%06d_out", getpid ());
	if ((fpi = fopen (filein, "w")) == NULL)
		return (-1);
	fwrite (src, isize, 1, fpi);
	fclose (fpi);

	sprintf (command, "nkf -mjM < %s > %s", filein, fileout);
	system (command);

	if ((fpo = fopen (fileout, "r")) == NULL)
	{
		remove (filein);
		remove (fileout);
		return (-1);
	}

	*osize = 0;
	ptr = dst;
	for (;;)
	{
		nn = fread (ptr, 1, 1, fpo);
		if (nn == 0)
			break;
		(*osize) += nn;
		ptr += nn;
	}
	fclose (fpo);

	remove (filein);
	remove (fileout);
}

int cxpmail_senddata_euc (char *src, int isize, char *dst, int *osize)
{
	char *data;
	char *headdata;
	char *bodydata;
	int headsize;
	int bodysize;
	int i, k, step;

	data = (char *) malloc (isize + 1);
	if (data == (char *) NULL)
		return (-1);
	headdata = (char *) malloc (isize * 3);
	if (headdata == (char *) NULL)
	{
		free (data);
		return (-1);
	}
	bodydata = (char *) malloc (isize * 3);
	if (bodydata == (char *) NULL)
	{
		free (headdata);
		free (data);
		return (-1);
	}

	headsize = bodysize = 0;

	step = 0;
	for (i = 0; i < isize; i++)
	{
		data[i] = src[i];

		if (i + 3 < isize)
		{
			if ((src[i] == '\r')
			    && (src[i + 1] == '\n')
			    && (src[i + 2] == '\r') && (src[i + 3] == '\n'))
			{
				step = 1;
				_cxpmail_senddata_eucMINE (data, i, headdata,
							   &headsize);
				break;
			}
		}
	}

	if (step == 1)
	{
		for (k = i; k < isize; k++)
			data[k - i] = src[k];
		_cxpmail_senddata_euc (data, isize - i, bodydata, &bodysize);
	}
	else
	{
		for (k = i; k < isize; k++)
			data[k] = src[k];
		_cxpmail_senddata_eucMINE (data, isize, headdata, &headsize);
	}

	memcpy (dst, headdata, headsize);
	if (bodysize > 0)
	{
		memcpy (dst + headsize, bodydata, bodysize);
		*osize = headsize + bodysize;
	}
	else
	{
		*osize = headsize;
	}

	free (data);
	free (headdata);
	free (bodydata);
}

int cxpmail_recvdata_euc (char *src, int isize, char *dst, int *osize)
{
	FILE *fpi, *fpo;
	int nn;
	char *ptr;
	char filein[1024];
	char fileout[1024];
	char command[1024];

	/* Ϥ줿ǡEUCǡѴ */
	/* Ȥꤢ nkf ѡŪˤϤϥꥸʥѹ */

	sprintf (filein, "/tmp/.cxpmail%06d_in", getpid ());
	sprintf (fileout, "/tmp/.cxpmail%06d_out", getpid ());
	if ((fpi = fopen (filein, "w")) == NULL)
		return (-1);
	fwrite (src, isize, 1, fpi);
	fclose (fpi);

	sprintf (command, "nkf -me < %s > %s", filein, fileout);
	system (command);

	if ((fpo = fopen (fileout, "r")) == NULL)
	{
		remove (filein);
		remove (fileout);
		return (-1);
	}

	*osize = 0;
	ptr = dst;
	for (;;)
	{
		nn = fread (ptr, 1, 1, fpo);
		if (nn == 0)
			break;
		(*osize) += nn;
		ptr += nn;
	}
	fclose (fpo);

	remove (filein);
	remove (fileout);
}

int read_line (int fd, char *buff, int *size)
{
	int ss, recvsize;
	int i, step;
	char cc;
	char *ptr;

	step = 0;
	ptr = buff;
	*size = 0;
	recvsize = 0;
	while (1)
	{
		ss = read (fd, &cc, sizeof (char));
		if (ss <= 0)
			return (-1);
		ptr++;
		recvsize += ss;
		if (cc == '\n')
			break;
	}

	*size = recvsize;

	return (recvsize);
}
