/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

/* åȤ򥪡ץ󤹤 */
int cxpmail_pop3_open ()
{
	char data[1024];
	int size;
	int status;

	/* åȤ򥪡ץ󤷥ͥĥ */
	cxpmail->cinfo[cxpmail->cNo].sockPop3 =
		cxpmail_net_open (cxpmail->cinfo[cxpmail->cNo].pop3.hostname,
				  cxpmail->cinfo[cxpmail->cNo].pop3.portno);
	if (cxpmail->cinfo[cxpmail->cNo].sockPop3 < 0)
	{
#ifdef DEBUG
		fprintf (stdout,
			 "cxpmail_pop3_open: socket open error -> %d\n",
			 cxpmail->cinfo[cxpmail->cNo].sockPop3);
#endif
	/*-- åȥץ󥨥顼 ---*/
		return (-1);
	}

	memset (data, 0x00, sizeof (data));
	status = cxpmail_net_reply_cmd (cxpmail->cinfo[cxpmail->cNo].sockPop3,
					&data, &size);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_open: status -> %d\n", status);
	fprintf (stdout, "cxpmail_pop3_open: size -> %d\n", size);
#endif
	if (status == 0)
	{
	/*-- Ф³ϣ --*/
		return (0);
	}
	else
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_open: server connect error\n");
#endif
	/*-- Ф³Σ --*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-2);
	}
}

/* USER ޥɤ */
int cxpmail_pop3_user ()
{
	char data[1024];
	int size;
	int status;

	/* USER mynameޥɤ */
	sprintf (data, "USER %s\r\n", cxpmail->cinfo[cxpmail->cNo].login);
	size = strlen (data);

#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_user: data |%s", data);
	fprintf (stdout, "cxpmail_pop3_user: size [%d]\n", size);
#endif

	status = cxpmail_net_send (cxpmail->cinfo[cxpmail->cNo].sockPop3,
				   data, size);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_user: status -> %d\n", status);
#endif
	if (status <= 0)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_user: error \n");
#endif
	/*-- 顼 ---*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-1);
	}

#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_user: answer wait \n");
#endif

	/* Ԥ */
	memset (data, 0x00, sizeof (data));
	status = cxpmail_net_reply_cmd (cxpmail->cinfo[cxpmail->cNo].sockPop3,
					&data, &size);

#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_user: answer ok \n");
#endif

	if (status == 0)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_user: ok \n");
#endif
		return (0);
	}
	else
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_user: error \n");
#endif
	/*-- 顼 --*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-2);
	}
}

/* PASS ޥɤ */
int cxpmail_pop3_pass ()
{
	char data[1024];
	int size;
	int status;

	/* PASS passwdޥɤ */
	sprintf (data, "PASS %s\r\n", cxpmail->cinfo[cxpmail->cNo].passwd);
	size = strlen (data);

#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_pass: data |%s", data);
	fprintf (stdout, "cxpmail_pop3_pass: size [%d]\n", size);
#endif

	status = cxpmail_net_send (cxpmail->cinfo[cxpmail->cNo].sockPop3,
				   data, size);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_pass: status -> %d\n", status);
#endif
	if (status <= 0)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_pass: error \n");
#endif
	/*-- 顼 ---*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-1);
	}

#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_pass: answer wait \n");
#endif

	/* Ԥ */
	memset (data, 0x00, sizeof (data));
	status = cxpmail_net_reply_cmd (cxpmail->cinfo[cxpmail->cNo].sockPop3,
					&data, &size);

#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_pass: answer ok \n");
#endif

	if (status == 0)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_pass: ok \n");
#endif
		return (0);
	}
	else
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_pass: error \n");
#endif
	/*-- 顼 --*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-2);
	}
}

/* STAT ޥɤ */
int cxpmail_pop3_stat (int *messageNum, int *messageSize)
{
	char data[1024];
	char *ptr;
	int size;
	int status;

	*messageNum = 0;
	*messageSize = 0;

	/* STAT ޥɤ */
	sprintf (data, "STAT\r\n");
	size = strlen (data);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_stat: |%s", data);
#endif
	status = cxpmail_net_send (cxpmail->cinfo[cxpmail->cNo].sockPop3,
				   data, size);
	if (status <= 0)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_stat: error\n");
#endif
	/*-- 顼 ---*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-1);
	}

	/* Ԥ */
	memset (data, 0x00, sizeof (data));
	status = cxpmail_net_reply_cmd (cxpmail->cinfo[cxpmail->cNo].sockPop3,
					&data, &size);
	if (status == 0)
	{
		ptr = strchr (data, '\n');
		if (ptr != (char *) NULL)
			*ptr = 0;
		ptr = strchr (data, '\r');
		if (ptr != (char *) NULL)
			*ptr = 0;
		ptr = strrchr (data, ' ');
		if (ptr != (char *) NULL)
		{
			*ptr = 0;
			*messageSize = atoi (ptr + 1);
		}

		ptr = strchr (data, ' ');
		if (ptr != (char *) NULL)
		{
			*ptr = 0;
			*messageNum = atoi (ptr + 1);
		}

		return (0);
	}
	else
	{
	/*-- 顼 --*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-2);
	}
}

/* LIST ޥɤ */
int cxpmail_pop3_list (int messageNo, int *messageSize)
{
	char data[1024];
	int size;
	int status;
	char *ptr;

	*messageSize = 0;

	/* LIST NO ޥɤ */
	sprintf (data, "LIST %d\r\n", messageNo);
	size = strlen (data);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_list : |%s", data);
#endif
	status = cxpmail_net_send (cxpmail->cinfo[cxpmail->cNo].sockPop3,
				   data, size);
	if (status <= 0)
	{
	/*-- 顼 ---*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-1);
	}

	/* Ԥ */
	memset (data, 0x00, sizeof (data));
	status = cxpmail_net_reply_cmd (cxpmail->cinfo[cxpmail->cNo].sockPop3,
					&data, &size);
	if (status == 0)
	{
		ptr = strchr (data, '\n');
		if (ptr != (char *) NULL)
			*ptr = 0;
		ptr = strchr (data, '\r');
		if (ptr != (char *) NULL)
			*ptr = 0;
		ptr = strrchr (data, ' ');
		if (ptr != (char *) NULL)
		{
			*ptr = 0;
			*messageSize = atoi (ptr + 1);
		}
		else
		{
			return (-3);
		}

		return (0);
	}
	else
	{
	/*-- 顼 --*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-2);
	}
}

/* TOP ޥɤǥإå */
int cxpmail_pop3_top (int messageNo, MailInfo * info)
{
	/*  TOP ޥɤRFCͤǥץ󰷤ʤΤ */
	/* Ȥꤢʤؿˤ */
	/* ǽ */
	;
	;
	;
	;

	return (0);
}

/* RETR ޥɤ᡼ǡ */
int cxpmail_pop3_retr (int messageNo, char **messageData)
{
	char data[4096];
	char *ptr;
	int size, recvsize;
	int status;
	int i;

	/* RETR NO ޥɤ */
	sprintf (data, "RETR %d\r\n", messageNo);
	size = strlen (data);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_retr: data |%s", data);
#endif
	status = cxpmail_net_send (cxpmail->cinfo[cxpmail->cNo].sockPop3,
				   data, size);
	if (status <= 0)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_retr: status error %d\n",
			 status);
#endif
	/*-- 顼 ---*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-1);
	}

	/* Ԥ */
	status = cxpmail_net_reply_cmd (cxpmail->cinfo[cxpmail->cNo].sockPop3,
					&data, &size);
	if (status == 0)
	{
		status = cxpmail_net_recv (cxpmail->cinfo[cxpmail->cNo].
					   sockPop3, messageData, &recvsize);
		if (status < 0)
		{
		/*-- 顼 --*/
			cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].
					    sockPop3);
			return (-3);
		}

#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_retr: recv size %d\n", status);
		for (i = 0; i < status; i++)
			fprintf (stdout, "%c", *((*messageData) + i));
		fprintf (stdout, "\n");
#endif
		return (0);
	}
	else
	{

#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_retr: repry cmd error %d\n",
			 status);
#endif
	/*-- 顼 --*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-2);
	}

	return (0);
}

/* DELE ޥɤޡĤ */
int cxpmail_pop3_dele (int messageNo)
{
	char data[1024];
	int size;
	int status;

	/* DELE NO ޥɤ */
	sprintf (data, "DELE %d\r\n", messageNo);
	size = strlen (data);

#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_dele: data |%s", data);
	fprintf (stdout, "cxpmail_pop3_dele: size [%d]\n", size);
#endif

	status = cxpmail_net_send (cxpmail->cinfo[cxpmail->cNo].sockPop3,
				   data, size);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_dele: status -> %d\n", status);
#endif
	if (status <= 0)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_dele: error \n");
#endif
	/*-- 顼 ---*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-1);
	}

#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_dele: answer wait \n");
#endif

	/* Ԥ */
	status = cxpmail_net_reply_cmd (cxpmail->cinfo[cxpmail->cNo].sockPop3,
					&data, &size);

#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_dele: answer ok \n");
#endif

	if (status == 0)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_dele: ok \n");
#endif
		return (0);
	}
	else
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_pop3_dele: error \n");
#endif
	/*-- 顼 --*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-2);
	}
}

/* QUIT ޥɤ */
int cxpmail_pop3_quit ()
{
	char data[1024];
	int size;
	int status;

	/* QUIT ޥɤ */
	sprintf (data, "QUIT\r\n");
	size = strlen (data);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_pop3_quit: data |%s", data);
#endif
	status = cxpmail_net_send (cxpmail->cinfo[cxpmail->cNo].sockPop3,
				   data, size);
	if (status <= 0)
	{
	/*-- 顼 ---*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-1);
	}

	/* Ԥ */
	status = cxpmail_net_reply_cmd (cxpmail->cinfo[cxpmail->cNo].sockPop3,
					&data, &size);
	if (status == 0)
	{
		return (0);
	}
	else
	{
	/*-- 顼 --*/
		cxpmail_pop3_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
		return (-2);
	}

	return (0);
}

/* ͥǤ */
int cxpmail_pop3_close ()
{
	/* ͥǤ */
	cxpmail_net_close (cxpmail->cinfo[cxpmail->cNo].sockPop3);
	return (0);
}
