/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

/*  */
static int _cxpmail_native_send ()
{
	char working[1024];
	char buffer[1024];
	char emailName[1024];
	char mess[1024];
	int maxSize, minSize, nowSize;
	int size, limit, index, count;
	int status;
	int i, k, m, n;

	/* ȡ򻻽Ф */
	minSize = maxSize = nowSize = 0;
	for (i = 0; i < cxpmail->minfo.box[BOXID_SOUSIN]->count; i++)
	{
		maxSize += cxpmail->minfo.box[BOXID_SOUSIN]->mail[i]->size;
	}

	set_working_state (minSize, maxSize, nowSize);

	while (gtk_events_pending ())
		gtk_main_iteration ();

	/* ͥ󥪡ץ */
	status = cxpmail_smtp_open ();
	if (status != 0)
	{
		switch (status)
		{
		case -1:	/* åȥץ󥨥顼 */
			cxpmail->messEvent = MSID_SOCK_OPEN_ERR;
			break;
		case -2:	/* ³顼 */
			cxpmail->messEvent = MSID_SMTP_CNCT_ERR;
			break;
		default:	/* ʥ顼 */
			cxpmail->messEvent = MSID_UNKNOWN_ERR;
			break;
		}
		/* 󥰥Ĥ */
		destroy_working_window ();
		return (-1);
	}

	while (gtk_events_pending ())
		gtk_main_iteration ();

	/* HELOޥ */
	status = cxpmail_smtp_helo ();
	if (status != 0)
	{
		switch (status)
		{
		case -1:	/* HELO 顼 */
			cxpmail->messEvent = MSID_SMTP_START_ERR;
			break;
		case -2:	/* HELO 顼 */
			cxpmail->messEvent = MSID_SMTP_ANSWER_ERR;
			break;
		default:	/* ʥ顼 */
			cxpmail->messEvent = MSID_UNKNOWN_ERR;
			break;
		}
		/* 󥰥Ĥ */
		destroy_working_window ();
		return (-1);
	}

	while (gtk_events_pending ())
		gtk_main_iteration ();

	/* Ȣˤ᡼ʬ֤ */
	for (i = 0; i < cxpmail->minfo.box[BOXID_SOUSIN]->count; i++)
	{
		sprintf (working, "%d / %d Υ᡼Ƥޤ",
			 i + 1, cxpmail->minfo.box[BOXID_SOUSIN]->count);
		set_working_message (working);

		while (gtk_events_pending ())
			gtk_main_iteration ();

#ifdef DEBUG
		{
			int _ix;

			_ix = BOXID_SOUSIN;
			fprintf (stdout, "mail[%d]->no       = [%d]\n", i,
				 cxpmail->minfo.box[_ix]->mail[i]->no);
			fprintf (stdout, "mail[%d]->name     = [%s]\n", i,
				 (cxpmail->minfo.box[_ix]->mail[i]->name ==
				  (char *) NULL ? "" : cxpmail->minfo.
				  box[_ix]->mail[i]->name));
			fprintf (stdout, "mail[%d]->sendName = [%s]\n", i,
				 (cxpmail->minfo.box[_ix]->mail[i]->
				  sendName ==
				  (char *) NULL ? "" : cxpmail->minfo.
				  box[_ix]->mail[i]->sendName));
			fprintf (stdout, "mail[%d]->ccName   = [%s]\n", i,
				 (cxpmail->minfo.box[_ix]->mail[i]->ccName ==
				  (char *) NULL ? "" : cxpmail->minfo.
				  box[_ix]->mail[i]->ccName));
			fprintf (stdout, "mail[%d]->title    = [%s]\n", i,
				 (cxpmail->minfo.box[_ix]->mail[i]->title ==
				  (char *) NULL ? "" : cxpmail->minfo.
				  box[_ix]->mail[i]->title));
			fprintf (stdout, "mail[%d]->size     = [%d]\n", i,
				 cxpmail->minfo.box[_ix]->mail[i]->size);
			fprintf (stdout, "mail[%d]->date     = [%d]\n", i,
				 cxpmail->minfo.box[_ix]->mail[i]->date);
		}
#endif


		/* ԥɥ쥹 */
		if (cxpmail->my.email == (char *) NULL)
			sprintf (buffer, "%s", "UnKnown");
		else if (strlen (cxpmail->my.email) <= 0)
			sprintf (buffer, "%s", "UnKnown");
		else
			sprintf (buffer, "%s", cxpmail->my.email);

		memset (emailName, 0x00, sizeof (emailName));
		cxpmail_senddata_euc (buffer, strlen (buffer), &emailName[0],
				      &size);
		status = cxpmail_smtp_mail_from (emailName);
		if (status != 0)
		{
			switch (status)
			{
			case -1:	/* MAIL FROM: 顼 */
				cxpmail->messEvent = MSID_FROM_ADDR_NG;
				break;
			case -2:	/* MAIL FROM: 顼 */
				cxpmail->messEvent = MSID_FROM_ADDR_ANSERR;
				break;
			default:	/* ʥ顼 */
				cxpmail->messEvent = MSID_UNKNOWN_ERR;
				break;
			}
			/* 󥰥Ĥ */
			destroy_working_window ();
			return (-1);
		}

		while (gtk_events_pending ())
			gtk_main_iteration ();

		/* ϿƤ밸ʬ֤ */
		if (cxpmail->minfo.box[BOXID_SOUSIN]->mail[i]->sendName ==
		    (char *) NULL)
		{
#ifdef	DEBUG
			fprintf (stdout, "native_send: sendName is NULL\n");
#endif
			/* 󥰥Ĥ */
			destroy_working_window ();
			cxpmail->messEvent = MSID_TO_ADDR_NULL;
			return (-1);
		}
		else if (strlen
			 (cxpmail->minfo.box[BOXID_SOUSIN]->mail[i]->
			  sendName) <= 0)
		{
#ifdef	DEBUG
			fprintf (stdout,
				 "native_send: sendName is size ZERO\n");
#endif
			/* 󥰥Ĥ */
			destroy_working_window ();
			cxpmail->messEvent = MSID_TO_ADDR_NULL;
			return (-1);
		}
		else
		{

			limit = checkLimitCode (cxpmail->minfo.
						box[BOXID_SOUSIN]->mail[i]->
						sendName,
						strlen (cxpmail->minfo.
							box[BOXID_SOUSIN]->
							mail[i]->sendName),
						(char) ';');

			for (k = 0; k < (limit + 1); k++)
			{
				memset (emailName, 0x00, sizeof (emailName));
				memset (buffer, 0x00, sizeof (buffer));
				getLimitData (cxpmail->minfo.
					      box[BOXID_SOUSIN]->mail[i]->
					      sendName,
					      strlen (cxpmail->minfo.
						      box[BOXID_SOUSIN]->
						      mail[i]->sendName), ';',
					      k, &buffer[0]);

				if (strmatch ("*<*@*>*", buffer) == 0)
				{
					char __buffer[1024];
					char *__ptr1, *__ptr2;

					strcpy (__buffer, buffer);
					__ptr1 = (char *) strchr (__buffer,
								  '<');
					if (__ptr1 == (char *) NULL)
						break;
					__ptr2 = (char *) strrchr (__buffer,
								   '>');
					if (__ptr2 == (char *) NULL)
						break;
					*__ptr2 = 0;

					memset (buffer, 0x00,
						sizeof (buffer));
					strcpy (buffer, __ptr1 + 1);
				}
#ifdef DEBUG5
				fprintf (stdout,
					 "native send e-mail address : [%s]\n",
					 buffer);
#endif
				cxpmail_senddata_euc (buffer, strlen (buffer),
						      &emailName[0], &size);

				/* 褬ʤʤä齪λ */
				if (size <= 0)
					break;

				status = cxpmail_smtp_rcpt_to (emailName);
				if (status != 0)
				{
#ifdef	DEBUG
					fprintf (stdout,
						 "native_send: limit error (%d)\n",
						 status);
#endif
					switch (status)
					{
					case -1:	/* MAIL TO: 顼 */
						cxpmail->messEvent =
							MSID_TO_ADDR_ERR;
						break;
					case -2:	/* MAIL TO: 顼 */
						cxpmail->messEvent =
							MSID_TO_ADDR_ANSERR;
						break;
					default:	/* ʥ顼 */
						cxpmail->messEvent =
							MSID_UNKNOWN_ERR;
						break;
					}
					/* 󥰥Ĥ */
					destroy_working_window ();
					return (-1);
				}
			}
		}

		while (gtk_events_pending ())
			gtk_main_iteration ();


		/* DATAޥ */
		status = cxpmail_smtp_data ();
		if (status != 0)
		{
			switch (status)
			{
			case -1:	/* DATA 顼 */
				cxpmail->messEvent = MSID_DATA_START_ERR;
				break;
			case -2:	/* DATA 顼 */
				cxpmail->messEvent = MSID_DATA_START_ANSERR;
				break;
			default:	/* ʥ顼 */
				cxpmail->messEvent = MSID_UNKNOWN_ERR;
				break;
			}
			/* 󥰥Ĥ */
			destroy_working_window ();
			return (-1);
		}

		while (gtk_events_pending ())
			gtk_main_iteration ();

		/* ᡼ǡ */
		memset (buffer, 0x00, sizeof (buffer));
		memset (mess, 0x00, sizeof (mess));

#ifdef DEBUG
		fprintf (stdout, "i -> %d\n", i);
		fprintf (stdout,
			 "cxpmail->minfo.box[BOXID_SOUSIN]->mail[i]->size -> %d\n",
			 cxpmail->minfo.box[BOXID_SOUSIN]->mail[i]->size);
#endif

#if 1
		m = 0;
		for (k = 0;
		     k < cxpmail->minfo.box[BOXID_SOUSIN]->mail[i]->size; k++)
		{
			buffer[m] =
				cxpmail->minfo.box[BOXID_SOUSIN]->mail[i]->
				data[k];

			/* Ԥ1024ХȰʲǤʤSMTPͤǤϤͤ.. */
			if ((m >= 1000)
			    || ((k + 1) >=
				cxpmail->minfo.box[BOXID_SOUSIN]->mail[i]->
				size))
			{
				cxpmail_senddata_euc (buffer, strlen (buffer),
						      &mess[0], &size);
				status = cxpmail_smtp_message (mess, size);
				if (status != 0)
				{
					switch (status)
					{
					case -1:	/* å 顼 */
						cxpmail->messEvent =
							MSID_DATA_SEND_ERR;
						break;
					default:	/* ʥ顼 */
						cxpmail->messEvent =
							MSID_UNKNOWN_ERR;
						break;
					}
					return (-1);
				}

				while (gtk_events_pending ())
					gtk_main_iteration ();

				memset (buffer, 0x00, sizeof (buffer));
				memset (mess, 0x00, sizeof (mess));
				m = 0;
			}
			else
			{
				m++;
			}
		}
#endif
#if 0
		m = 0;
		for (k = 0;
		     k < cxpmail->minfo.box[BOXID_SOUSIN]->mail[i]->size; k++)
		{
			buffer[m] =
				cxpmail->minfo.box[BOXID_SOUSIN]->mail[i]->
				data[k];

			/* Ԥ1024ХȰʲǤʤSMTPͤǤϤͤ.. */
			if ((m >= 1000)
			    || ((k + 1) >=
				cxpmail->minfo.box[BOXID_SOUSIN]->mail[i]->
				size))
			{
				cxpmail_senddata_euc (buffer, strlen (buffer),
						      &mess[0], &size);
				status = cxpmail_smtp_message (mess, size);
				if (status != 0)
				{
					switch (status)
					{
					case -1:	/* å 顼 */
						cxpmail->messEvent =
							MSID_DATA_SEND_ERR;
						break;
					default:	/* ʥ顼 */
						cxpmail->messEvent =
							MSID_UNKNOWN_ERR;
						break;
					}
					return (-1);
				}

				while (gtk_events_pending ())
					gtk_main_iteration ();

				memset (buffer, 0x00, sizeof (buffer));
				memset (mess, 0x00, sizeof (mess));
				m = 0;
			}
			else
			{
				m++;
			}
		}
#endif

		/* ᡼뽪ꥳޥ */
		status = cxpmail_smtp_end ();
		if (status != 0)
		{
			switch (status)
			{
			case -1:	/* END 顼 */
				cxpmail->messEvent = MSID_DATA_END_ERR;
				break;
			case -2:	/* END 顼 */
				cxpmail->messEvent = MSID_DATA_END_ANSERR;
				break;
			default:	/* ʥ顼 */
				cxpmail->messEvent = MSID_UNKNOWN_ERR;
				break;
			}
			/* 󥰥Ĥ */
			destroy_working_window ();
			return (-1);
		}

		while (gtk_events_pending ())
			gtk_main_iteration ();

	}

#ifdef	DEBUG
	fprintf (stdout, "native_send: QUIT send start ...\n");
#endif

	while (gtk_events_pending ())
		gtk_main_iteration ();

	/* QUITޥ */
	status = cxpmail_smtp_quit ();
	if (status != 0)
	{
		switch (status)
		{
		case -1:	/* QUIT 顼 */
			cxpmail->messEvent = MSID_SMTP_CLOSE_ERR;
			break;
		case -2:	/* QUIT 顼 */
			cxpmail->messEvent = MSID_SMTP_CLOSE_ANSERR;
			break;
		default:	/* ʥ顼 */
			cxpmail->messEvent = MSID_UNKNOWN_ERR;
			break;
		}
		/* 󥰥Ĥ */
		destroy_working_window ();
		return (-1);
	}

	while (gtk_events_pending ())
		gtk_main_iteration ();

#ifdef	DEBUG
	fprintf (stdout, "native_send: QUIT send end ...\n");
#endif

#ifdef	DEBUG
	fprintf (stdout, "native_send: connection stop start ...\n");
#endif

	/* ͥλ */
	status = cxpmail_smtp_close ();
	if (status != 0)
	{
		/* ͥλ顼 */
		cxpmail->messEvent = MSID_SOCK_CLOSE_ERR;
		/* 󥰥Ĥ */
		destroy_working_window ();
		return (-1);
	}

	while (gtk_events_pending ())
		gtk_main_iteration ();

#ifdef	DEBUG
	fprintf (stdout, "native_send: connection stop stop ...\n");
#endif

	/* 󥰥Ĥ */
	destroy_working_window ();

#ifdef	DEBUG
	fprintf (stdout, "native_send: mail data SUMI move start ...\n");
#endif

	while (gtk_events_pending ())
		gtk_main_iteration ();

	/* ᡼ǡȢѤذư */
	for (index = 0; index < cxpmail->minfo.box[BOXID_SOUSIN]->count;
	     index++)
	{
		if (cxpmail_movemail (BOXID_SOUSIN, BOXID_SUMI, index) < 0)
		{
			cxpmail->messEvent = MSID_SOUSIN_MOVE_ERR;
		}
	}

#ifdef	DEBUG
	fprintf (stdout, "native_send: mail data SUMI move end ...\n");
#endif

#ifdef	DEBUG
	fprintf (stdout, "native_send: update mail header data start ...\n");
#endif

	/* ɤ߹ */
	getMailHeader (cxpmail->minfo.box[BOXID_SUMI]);
	getMailHeader (cxpmail->minfo.box[BOXID_SOUSIN]);

	while (gtk_events_pending ())
		gtk_main_iteration ();

#ifdef	DEBUG
	fprintf (stdout, "native_send: update mail header data end ...\n");
#endif

#if 0
	/* ɽ򹹿 */
	cxpmail->view = 1;	/*  */
#endif
	while (gtk_events_pending ())
		gtk_main_iteration ();

	return (0);
}

/* ¼ */
static int _cxpmail_native_recv ()
{
	char check[2048];
	char working[1024];
	int status;
	int totalNum, totalSize;
	int messageNo, messageSize;
	int index;
	char *messageData;
	int i, k, m;
	int mailNo, boxid;
	char *mailName, *sendName, *ccName, *titleName, *inre;
	int timNum;
	int deleteFlag;
	char *messId, *references;


	/* ͥ󥪡ץ */
	status = cxpmail_pop3_open ();
	if (status != 0)
	{
		switch (status)
		{
		case -1:	/* åȥץ󥨥顼 */
			cxpmail->messEvent = MSID_SOCK_OPEN_ERR;
			break;
		case -2:	/* ³顼 */
			cxpmail->messEvent = MSID_POP3_CNCT_ERR;
			break;
		default:	/* ʥ顼 */
			cxpmail->messEvent = MSID_UNKNOWN_ERR;
			break;
		}
		/* 󥰥Ĥ */
		destroy_working_window ();
		return (-1);
	}

	while (gtk_events_pending ())
		gtk_main_iteration ();

	sprintf (working, "桼̾ǧ");
	set_working_message (working);
	while (gtk_events_pending ())
		gtk_main_iteration ();

	/* USER  */
	status = cxpmail_pop3_user ();
	if (status != 0)
	{
		switch (status)
		{
		case -1:	/* USER顼 */
			cxpmail->messEvent = MSID_POP3_USER_ERR;
			break;
		case -2:	/* USERǧڥ顼 */
			cxpmail->messEvent = MSID_POP3_USER_ANSERR;
			break;
		default:	/* ʥ顼 */
			cxpmail->messEvent = MSID_UNKNOWN_ERR;
			break;
		}
		/* 󥰥Ĥ */
		destroy_working_window ();
		return (-1);
	}

	sprintf (working, "ѥɤ");
	set_working_message (working);

	while (gtk_events_pending ())
		gtk_main_iteration ();

	/* PASSWD  */
	status = cxpmail_pop3_pass ();
	if (status != 0)
	{
		switch (status)
		{
		case -1:	/* PASS顼 */
			cxpmail->messEvent = MSID_POP3_PASS_ERR;
			break;
		case -2:	/* PASSǧڥ顼 */
			cxpmail->messEvent = MSID_POP3_PASS_ANSERR;
			break;
		default:	/* ʥ顼 */
			cxpmail->messEvent = MSID_UNKNOWN_ERR;
			break;
		}
		/* 󥰥Ĥ */
		destroy_working_window ();
		return (-1);
	}

	sprintf (working, "᡼ǧ");
	set_working_message (working);
	while (gtk_events_pending ())
		gtk_main_iteration ();

	/* STAT  */
	status = cxpmail_pop3_stat (&totalNum, &totalSize);
	if (status != 0)
	{
		switch (status)
		{
		case -1:	/* STAT顼 */
			cxpmail->messEvent = MSID_INFO_GET_ERR;
			break;
		case -2:	/* STATǧڥ顼 */
			cxpmail->messEvent = MSID_INFO_GET_ANSERR;
			break;
		default:	/* ʥ顼 */
			cxpmail->messEvent = MSID_UNKNOWN_ERR;
			break;
		}
		/* 󥰥Ĥ */
		destroy_working_window ();
		return (-1);
	}

	while (gtk_events_pending ())
		gtk_main_iteration ();

#ifdef	DEBUG
	fprintf (stdout, "POP3 total num  -> %d\n", totalNum);
	fprintf (stdout, "POP3 total size -> %d\n", totalSize);
#endif

	/* ᡼ʬ֤ */
	for (i = 0; i < totalNum; i++)
	{
		messageNo = i + 1;

		sprintf (working, "%d / %d Υ᡼Ƥޤ", i + 1,
			 totalNum);
		set_working_message (working);
		while (gtk_events_pending ())
			gtk_main_iteration ();

		/* ʬΥ᡼륵 */
		status = cxpmail_pop3_list (messageNo, &messageSize);
		if (status != 0)
		{
			switch (status)
			{
			case -1:	/* LIST顼 */
				cxpmail->messEvent = MSID_INFO_GET_ERR;
				break;
			case -2:	/* LIST顼 */
				cxpmail->messEvent = MSID_INFO_GET_ANSERR;
				break;
			default:	/* ʥ顼 */
				cxpmail->messEvent = MSID_UNKNOWN_ERR;
				break;
			}
			/* 󥰥Ĥ */
			destroy_working_window ();
			return (-1);
		}
		while (gtk_events_pending ())
			gtk_main_iteration ();

#ifdef	DEBUG
		fprintf (stdout, "retr message malloc size -----> %d\n",
			 messageSize);
		fflush (stdout);
#endif

		messageData = (char *) malloc (messageSize + 32);
		if (messageData == (char *) NULL)
		{
			cxpmail->messEvent = MSID_INFO_AREA_ERR;

			/* 󥰥Ĥ */
			destroy_working_window ();
			return (-1);
		}

		/* ʬΥ᡼ǡ */
		status = cxpmail_pop3_retr (messageNo, &messageData);
		if (status != 0)
		{
			switch (status)
			{
			case -1:	/* RETR顼 */
				cxpmail->messEvent = MSID_DATA_GET_ERR;
				break;
			case -2:	/* RETR׵ᥨ顼 */
				cxpmail->messEvent = MSID_DATA_GET_ANSERR;
				break;
			case -3:	/* RETR顼 */
				cxpmail->messEvent = MSID_DATA_RETR_ERR;
				break;
			default:	/* ʥ顼 */
				cxpmail->messEvent = MSID_UNKNOWN_ERR;
				break;
			}
			/* 󥰥Ĥ */
			destroy_working_window ();
			return (-1);
		}
		while (gtk_events_pending ())
			gtk_main_iteration ();


		/* ᡼ǡǿ᡼ֹȯԤ */
		mailNo = getMailNo ();

		/* ᡼ֹȯԤ᡼ǡإåФ */
		/*       */
		/*       */
		/*    ȥ */
		/*     */
		recvMailHeaderInfo (messageData, messageSize,
				    &mailName, &sendName, &ccName, &titleName,
				    &inre, &timNum);

		deleteFlag = 0;

		/* Υ᡼ʤкΤ */
		if (cxpmail->my.ndayDelete == 1)
		{
			time_t checkTime;

			/* ߤλ */
			checkTime = time (0);

#ifdef	DEBUG6
			fprintf (stdout,
				 "N᡼å checkTime -> %d timNum -> %d\n",
				 checkTime, timNum);
#endif

			/* ߤλʤк褦˥ե饰ꤹ */
			if ((checkTime - cxpmail->my.nday * 24 * 60 * 60) >
			    timNum)
			{
#ifdef	DEBUG6
				fprintf (stdout,
					 "Υ᡼Ϻޤ titleName [%s]\n",
					 titleName);
#endif
				deleteFlag = 1;
			}
		}
		while (gtk_events_pending ())
			gtk_main_iteration ();

		/* Ʊ᡼ϼʤΤ */
		if (cxpmail->my.sameMail == 1)
		{
			int checkStatus;

#ifdef	DEBUG6
			fprintf (stdout, "Ʊ᡼뤬뤫å\n");
#endif

			k = -1;
			checkStatus = 0;
			/* åɣĤǤϤʤԡȥ롤ǥå */
			if ((sendName != (char *) NULL)
			    && (titleName != (char *) NULL) && (timNum != 0))
			{
				/* ᡼ǡå */
				for (k = 0; k < MAX_BOX_NUM; k++)
				{
					/* ѤȽ񤭽񤱰ʳΥܥåå */
					if (k == BOXID_SUMI
					    || k == BOXID_KAKIKAKE)
						continue;

					if (cxpmail->minfo.box[k] !=
					    (BoxInfo *) NULL)
					{
						if (cxpmail->minfo.box[k]->
						    boxName != NULL)
						{
							for (m = 0;
							     m <
							     cxpmail->minfo.
							     box[k]->count;
							     m++)
							{
								if ((strcmp
								     (cxpmail->
								      minfo.
								      box[k]->
								      mail
								      [m]->
								      name,
								      mailName)
								     == 0)
								    &&
								    (strcmp
								     (cxpmail->
								      minfo.
								      box[k]->
								      mail
								      [m]->
								      title,
								      titleName)
								     == 0)
								    &&
								    (cxpmail->
								     minfo.
								     box[k]->
								     mail[m]->
								     date ==
								     timNum))
								{
									checkStatus
										=
										1;
									break;
								}
							}
							if (checkStatus == 1)
								break;
						}
					}
					if (checkStatus == 1)
						break;
				}
			}

#ifdef	DEBUG6
			if (checkStatus == 1)
			{
				fprintf (stdout,
					 "Ʊ᡼뤬ޤ\n");
				if (k >= 0)
				{
					fprintf (stdout, "mailName  [%s]\n",
						 mailName);
					fprintf (stdout, "titleName [%s]\n",
						 titleName);
					fprintf (stdout, "timNum    [%d]\n",
						 timNum);
				}
			}
			else
			{
				fprintf (stdout,
					 "Ʊ᡼ϤޤǤ\n");
			}
#endif

			/* Ʊ᡼Ǥнʤ */
			if (checkStatus == 1)
			{
				/* Ʊ᡼Ǻե饰ꤵƤϺ */
				if (deleteFlag == 1)
				{
					/* ޡդ */
					status = cxpmail_pop3_dele
						(messageNo);
					if (status != 0)
					{
						switch (status)
						{
						case -1:	/* DEL顼 */
							cxpmail->messEvent =
								MSID_DELE_ERR;
							break;
						case -2:	/* DEL׵ᥨ顼 */
							cxpmail->messEvent =
								MSID_DELE_ANSERR;
							break;
						default:	/* ʥ顼 */
							cxpmail->messEvent =
								MSID_UNKNOWN_ERR;
							break;
						}
						/* 󥰥Ĥ */
						destroy_working_window ();
						return (-1);
					}
				}

				/* Υ᡼νԤ */
				continue;
			}
		}
		while (gtk_events_pending ())
			gtk_main_iteration ();

		/* إå󤫤鿶ʬ¹Ԥ */
		boxid = BOXID_JYUSIN;
		status = 0;
		for (k = 0; k < cxpmail->fdata.count; k++)
		{
			switch (cxpmail->fdata.furi[k].state)
			{
			case 0:	/*  */
				sprintf (check, "*%s*",
					 cxpmail->fdata.furi[k].message);
				if (strmatch (check, mailName) == 0)
				{
					boxid = cxpmail->fdata.furi[k].boxid;
					status = 1;
				}
				break;
			case 1:	/* ̾ */
				sprintf (check, "*%s*",
					 cxpmail->fdata.furi[k].message);
				if (strmatch (check, titleName) == 0)
				{
					boxid = cxpmail->fdata.furi[k].boxid;
					status = 1;
				}
				break;
			default:	/* ʳ */
				break;
			}
			if (status == 1)
				break;
		}

		/* إåȢ¸ */
		if (cxpmail->minfo.box[boxid] == (BoxInfo *) NULL)
		{
			/* ܥåʤϼȢ */
			boxid = BOXID_JYUSIN;
		}

		index = cxpmail->minfo.box[boxid]->count;
		if (cxpmail->minfo.box[boxid]->mail[index] == NULL)
		{
			cxpmail->minfo.box[boxid]->mail[index] =
				(MailInfo *) malloc (sizeof (MailInfo));
			if (cxpmail->minfo.box[boxid]->mail[index] ==
			    (MailInfo *) NULL)
			{
				cxpmail->messEvent = MSID_DATA_AREA_ERR;
				break;
			}
		}
		memset (cxpmail->minfo.box[boxid]->mail[index], 0x00,
			sizeof (MailInfo));
		cxpmail->minfo.box[boxid]->mail[index]->no = mailNo;
		cxpmail->minfo.box[boxid]->mail[index]->name =
			g_strdup (mailName);
		cxpmail->minfo.box[boxid]->mail[index]->sendName =
			g_strdup (sendName);
		cxpmail->minfo.box[boxid]->mail[index]->ccName =
			g_strdup (ccName);
		cxpmail->minfo.box[boxid]->mail[index]->title =
			g_strdup (titleName);
		cxpmail->minfo.box[boxid]->mail[index]->size = messageSize;
		cxpmail->minfo.box[boxid]->mail[index]->date = timNum;
		cxpmail->minfo.box[boxid]->mail[index]->data =
			malloc (messageSize);
		if (cxpmail->minfo.box[boxid]->mail[index]->data ==
		    (char *) NULL)
		{
			cxpmail->messEvent = MSID_DATA_AREA_ERR;
			break;
		}
		else
		{
			memcpy (cxpmail->minfo.box[boxid]->mail[index]->data,
				messageData, messageSize);
			cxpmail->minfo.box[boxid]->count++;
		}

		g_free (messageData);

		/* ȢΥǡ¸ */
		setMailData (cxpmail->minfo.box[boxid],
			     cxpmail->minfo.box[boxid]->mail[index]);
		/* ȢΥإå¸ */
		setMailHeader (boxid);


		/* ɽ򹹿 */
		cxpmail->view = 1;	/*  */
		while (gtk_events_pending ())
			gtk_main_iteration ();


		/* ꤬ϣ꤬ϼ᡼ */
		if (cxpmail->my.mailDelete == 0 || deleteFlag == 1)
		{

			/* ˼ޡĤ */
			status = cxpmail_pop3_dele (messageNo);
			if (status != 0)
			{
				switch (status)
				{
				case -1:	/* DEL顼 */
					cxpmail->messEvent = MSID_DELE_ERR;
					break;
				case -2:	/* DEL׵ᥨ顼 */
					cxpmail->messEvent = MSID_DELE_ANSERR;
					break;
				default:	/* ʥ顼 */
					cxpmail->messEvent = MSID_UNKNOWN_ERR;
					break;
				}
				/* 󥰥Ĥ */
				destroy_working_window ();
				return (-1);
			}
			while (gtk_events_pending ())
				gtk_main_iteration ();
		}

	}

	sprintf (working, "᡼륵ФȤ³");
	set_working_message (working);
	while (gtk_events_pending ())
		gtk_main_iteration ();

	/* QUIT  */
	status = cxpmail_pop3_quit ();
	if (status != 0)
	{
		switch (status)
		{
		case -1:	/* QUIT顼 */
			cxpmail->messEvent = MSID_POP3_CLOSE_ERR;
			break;
		case -2:	/* QUITǧڥ顼 */
			cxpmail->messEvent = MSID_POP3_CLOSE_ANSERR;
			break;
		default:	/* ʥ顼 */
			cxpmail->messEvent = MSID_UNKNOWN_ERR;
			break;
		}
		/* 󥰥Ĥ */
		destroy_working_window ();
		return (-1);
	}
	while (gtk_events_pending ())
		gtk_main_iteration ();

	/* ͥ */
	cxpmail_pop3_close ();

	/* 󥰥Ĥ */
	destroy_working_window ();
	while (gtk_events_pending ())
		gtk_main_iteration ();

#if 0
	/* ɽ򹹿 */
	cxpmail->view = 1;	/*  */
#endif

	return (0);
}


int cxpmail_native_send ()
{
	int i;

	for (i = 0; i < cxpmail->cinfoMaxNum; i++)
	{
		cxpmail->cNo = i;
		_cxpmail_native_send ();

		/* ɽ򹹿 */
		cxpmail->view = 1;	/*  */
	}
	cxpmail->cNo = 0;
}

int cxpmail_native_recv ()
{
	int i;

	for (i = 0; i < cxpmail->cinfoMaxNum; i++)
	{
		cxpmail->cNo = i;
		_cxpmail_native_recv ();

		/* ɽ򹹿 */
		cxpmail->view = 1;	/*  */
	}
	cxpmail->cNo = 0;
}
