/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static int cancelFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (win);
}

int create_showWin ()
{
	GtkWidget *showWin;
	GtkWidget *showText;
	GtkWidget *canBtn;
	GtkWidget *vbox1;
	GtkWidget *hbox2;
	GtkWidget *scrolledwindow1;
	GtkWidget *hbox1;
	char filename[2048];
	int index, number, count;

	int x, y, w, h;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w * 0.5;
	y = h * 0.5;

	index = cxpmail->minfo.viewPoint;
	if (index < 0)
	{
		create_messageWin (cxpmail->window,
				   "ܥå򤵤Ƥޤ");
		return (0);
	}

	number = cxpmail->select_title - 1;
	if (number < 0)
	{
		create_messageWin (cxpmail->window,
				   "᡼뤬򤵤Ƥޤ");
		return (0);
	}

	sprintf (filename, "%s/.cxp/mail/%s/mail%d.dat",
		 getenv ("HOME"),
		 cxpmail->minfo.box[index]->boxName,
		 cxpmail->minfo.box[index]->mail[number]->no);
	if (access (filename, F_OK))
	{
		create_messageWin (cxpmail->window,
				   "Υ᡼ˤϥǡޤ");
		return (0);
	}

	if (cxpmail->minfo.box[index]->mail[number]->data == (char *) NULL)
	{
		create_messageWin (cxpmail->window,
				   "Υ᡼ˤϥǡޤ");
		return (0);
	}


	showWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (showWin), "showWin", showWin);
	gtk_window_set_title (GTK_WINDOW (showWin), "ܺɽ");
	gtk_widget_set_usize (showWin, 100, 100);
	gtk_window_set_default_size (GTK_WINDOW (showWin), 500, 500);
	gtk_widget_set_uposition (showWin, (x - 500 * 0.5), (y - 500 * 0.5));
	gtk_widget_show (showWin);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (showWin), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (showWin), vbox1);
	gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (showWin), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 5);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (showWin), "scrolledwindow1",
				  scrolledwindow1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (hbox2), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
					GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	showText = gtk_text_new (NULL, NULL);
	gtk_widget_ref (showText);
	gtk_object_set_data_full (GTK_OBJECT (showWin), "showText", showText,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (showText);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), showText);

	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (showWin), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 10);

	canBtn = gtk_button_new_with_label (" Ĥ ");
	gtk_widget_ref (canBtn);
	gtk_object_set_data_full (GTK_OBJECT (showWin), "canBtn", canBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (canBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), canBtn, FALSE, FALSE, 0);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (canBtn), "clicked",
			    (GtkSignalFunc) cancelFunction, showWin);


	gtk_text_freeze (GTK_TEXT (showText));
	gtk_text_set_point (GTK_TEXT (showText), 0);
	gtk_text_forward_delete (GTK_TEXT (showText),
				 gtk_text_get_length (GTK_TEXT (showText)));

	gtk_text_set_point (GTK_TEXT (showText), 0);
	gtk_text_insert (GTK_TEXT (showText), cxpmail->font, NULL, NULL,
			 cxpmail->minfo.box[index]->mail[number]->data,
			 cxpmail->minfo.box[index]->mail[number]->size);
	gtk_text_set_point (GTK_TEXT (showText), 0);
	gtk_text_thaw (GTK_TEXT (showText));


	return (0);
}
