/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

int cxpmail_smtp_open ()
{
	char data[1024];
	int size;
	int status;
	int *sock;
	char *hostname, *portno;

	if (cxpmail->cinfo[cxpmail->cNo].proxyFlag == 0)
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockSmtp;
		hostname = cxpmail->cinfo[cxpmail->cNo].smtp.hostname;
		portno = cxpmail->cinfo[cxpmail->cNo].smtp.portno;
	}
	else
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockProxy;
		hostname = cxpmail->cinfo[cxpmail->cNo].proxy.hostname;
		portno = cxpmail->cinfo[cxpmail->cNo].proxy.portno;
	}

	/* åȤ򥪡ץ󤷥ͥĥ */
	*sock = cxpmail_net_open (hostname, portno);
	if (*sock < 0)
	{
#ifdef DEBUG
		fprintf (stdout,
			 "cxpmail_smtp_open: socket open error -> %d\n",
			 *sock);
#endif
	/*-- åȥץ󥨥顼 ---*/
		return (-1);
	}

	status = cxpmail_net_reply (*sock, &data, &size);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_smtp_open: status -> %d\n", status);
	fprintf (stdout, "cxpmail_smtp_open: size -> %d\n", size);
#endif
	if (status == 220)
	{
	/*-- Ф³ϣ --*/
		return (0);
	}
	else
	{
	/*-- Ф³Σ --*/
		cxpmail_smtp_close (*sock);
		return (-2);
	}
}

int cxpmail_smtp_helo ()
{
	char data[1024];
	int size;
	int status;
	int *sock;
	char *hostname;

	if (cxpmail->cinfo[cxpmail->cNo].proxyFlag == 0)
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockSmtp;
		hostname = cxpmail->cinfo[cxpmail->cNo].smtp.hostname;
	}
	else
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockProxy;
		hostname = cxpmail->cinfo[cxpmail->cNo].proxy.hostname;
	}

	/* HELO host.smp.co.jpޥɤ */
	sprintf (data, "HELO %s\r\n", hostname);
	size = strlen (data);

#ifdef DEBUG
	fprintf (stdout, "cxpmail_smtp_helo: data |%s", data);
	fprintf (stdout, "cxpmail_smtp_helo: size [%d]\n", size);
#endif
	status = cxpmail_net_send (*sock, data, size);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_smtp_helo: status -> %d\n", status);
#endif
	if (status <= 0)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_smtp_helo: error \n");
#endif
	/*-- 顼 ---*/
		cxpmail_smtp_close (*sock);
		return (-1);
	}

#ifdef DEBUG
	fprintf (stdout, "cxpmail_smtp_helo: answer wait \n");
#endif

	/* Ԥ */
	status = cxpmail_net_reply (*sock, &data, &size);

#ifdef DEBUG
	fprintf (stdout, "cxpmail_smtp_helo: answer ok \n");
#endif

	if (status == 250)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_smtp_helo: ok \n");
#endif
		return (0);
	}
	else
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_smtp_helo: error \n");
#endif
	/*-- 顼 --*/
		cxpmail_smtp_close (*sock);
		return (-2);
	}
}

int cxpmail_smtp_mail_from (char *email)
{
	char data[1024];
	int size;
	int status;
	int *sock;

	if (cxpmail->cinfo[cxpmail->cNo].proxyFlag == 0)
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockSmtp;
	}
	else
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockProxy;
	}

	/* MAIL FROM: <xxxx@smp.co.jp> ޥɤ */
	sprintf (data, "MAIL FROM: <%s>\r\n", email);
	size = strlen (data);
#ifdef DEBUG3
	fprintf (stdout, "cxpmail_smtp_mail_from: |%s", data);
#endif
	status = cxpmail_net_send (*sock, data, size);
	if (status <= 0)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_smtp_mail_from: send error\n");
#endif
	/*-- 顼 ---*/
		cxpmail_smtp_close (*sock);
		return (-1);
	}

#ifdef DEBUG
	fprintf (stdout, "cxpmail_smtp_mail_from: answer wait\n");
#endif

	/* Ԥ */
	status = cxpmail_net_reply (*sock, &data, &size);
	if (status == 250)
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_smtp_mail_from: answer ok (%d)\n",
			 status);
#endif
		return (0);
	}
	else
	{
#ifdef DEBUG
		fprintf (stdout, "cxpmail_smtp_mail_from: answer ng (%d)\n",
			 status);
#endif
	/*-- 顼 --*/
		cxpmail_smtp_close (*sock);
		return (-2);
	}
}

int cxpmail_smtp_rcpt_to (char *email)
{
	char data[1024];
	int size;
	int status;
	int *sock;

	if (cxpmail->cinfo[cxpmail->cNo].proxyFlag == 0)
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockSmtp;
	}
	else
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockProxy;
	}

	/* RCPT TO: <yyyy@smp.co.jp> ޥɤ */
	sprintf (data, "RCPT TO: <%s>\r\n", email);
	size = strlen (data);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_smtp_rcpt_to: data |%s", data);
#endif
	status = cxpmail_net_send (*sock, data, size);
	if (status <= 0)
	{
	/*-- 顼 ---*/
		cxpmail_smtp_close (*sock);
		return (-1);
	}

	/* Ԥ */
	status = cxpmail_net_reply (*sock, &data, &size);
	if (status == 250)
	{
		return (0);
	}
	else
	{
	/*-- 顼 --*/
		cxpmail_smtp_close (*sock);
		return (-2);
	}
}

int cxpmail_smtp_data ()
{
	char data[1024];
	int size;
	int status;
	int *sock;

	if (cxpmail->cinfo[cxpmail->cNo].proxyFlag == 0)
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockSmtp;
	}
	else
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockProxy;
	}

	/* DATA ޥɤ */
	sprintf (data, "DATA\r\n");
	size = strlen (data);
	status = cxpmail_net_send (*sock, data, size);
	if (status <= 0)
	{
	/*-- 顼 ---*/
		cxpmail_smtp_close (*sock);
		return (-1);
	}

	/* Ԥ */
	status = cxpmail_net_reply (*sock, &data, &size);
	if (status == 354)
	{
		return (0);
	}
	else
	{
	/*-- 顼 --*/
		cxpmail_smtp_close (*sock);
		return (-2);
	}
}

int cxpmail_smtp_message (char *mess, int msize)
{
	char data[1024];
	int size;
	int status;
	int *sock;

	if (cxpmail->cinfo[cxpmail->cNo].proxyFlag == 0)
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockSmtp;
	}
	else
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockProxy;
	}

	/* å */
	sprintf (data, "%*.*s\r\n", msize, msize, mess);
	size = strlen (data);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_smtp_message: |%s", data);
#endif
	status = cxpmail_net_send (*sock, data, size);
	if (status <= 0)
	{
	/*-- 顼 ---*/
		cxpmail_smtp_close (*sock);
		return (-1);
	}

	return (0);
}

int cxpmail_smtp_end ()
{
	char data[1024];
	int size;
	int status;
	int *sock;

	if (cxpmail->cinfo[cxpmail->cNo].proxyFlag == 0)
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockSmtp;
	}
	else
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockProxy;
	}

	/* CR/LF.CR/LF ޥɤ */
	sprintf (data, "\r\n.\r\n");
	size = 5;
	status = cxpmail_net_send (*sock, data, size);
	if (status <= 0)
	{
	/*-- 顼 ---*/
		cxpmail_smtp_close (*sock);
		return (-1);
	}

	/* Ԥ */
	status = cxpmail_net_reply (*sock, &data, &size);
	if (status == 250)
	{
		return (0);
	}
	else
	{
	/*-- 顼 --*/
		cxpmail_smtp_close (*sock);
		return (-2);
	}

	return (0);
}

int cxpmail_smtp_quit ()
{
	char data[1024];
	int size;
	int status;
	int *sock;

	if (cxpmail->cinfo[cxpmail->cNo].proxyFlag == 0)
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockSmtp;
	}
	else
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockProxy;
	}

	/* QUIT ޥɤ */
	sprintf (data, "QUIT\r\n");
	size = strlen (data);
#ifdef DEBUG
	fprintf (stdout, "cxpmail_smtp_quit: |%s", data);
#endif
	status = cxpmail_net_send (*sock, data, size);
	if (status <= 0)
	{
	/*-- 顼 ---*/
		cxpmail_smtp_close (*sock);
		return (-1);
	}

	/* Ԥ */
	status = cxpmail_net_reply (*sock, &data, &size);
	if (status == 221)
	{
		return (0);
	}
	else
	{
	/*-- 顼 --*/
		cxpmail_smtp_close (*sock);
		return (-2);
	}

	return (0);
}

int cxpmail_smtp_close ()
{
	int *sock;

	if (cxpmail->cinfo[cxpmail->cNo].proxyFlag == 0)
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockSmtp;
	}
	else
	{
		sock = &cxpmail->cinfo[cxpmail->cNo].sockProxy;
	}

	/* ͥǤ */
	cxpmail_net_close (*sock);
	return (0);
}
