/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

/*
 * name sort function
 */
static void quicksort_name (MailInfo * dat[], int first, int last)
{
	int i, j;
	MailInfo x, t;

	if (dat[(first + last) / 2]->data != (char *) NULL)
	{
		free (dat[(first + last) / 2]->data);
		dat[(first + last) / 2]->data = (char *) NULL;
	}
	memcpy (&x, dat[(first + last) / 2], sizeof (MailInfo));
	i = first;
	j = last;
	for (;;)
	{
		if (cxpmail->sortno == 0)
		{
			while (strcmp (x.name, dat[i]->name) > 0)
				i++;
			while (strcmp (dat[j]->name, x.name) > 0)
				j--;
		}
		else
		{
			while (strcmp (x.name, dat[i]->name) < 0)
				i++;
			while (strcmp (dat[j]->name, x.name) < 0)
				j--;
		}
		if (i >= j)
			break;

		if (dat[i]->data != (char *) NULL)
		{
			free (dat[i]->data);
			dat[i]->data = (char *) NULL;
		}
		if (dat[j]->data != (char *) NULL)
		{
			free (dat[j]->data);
			dat[j]->data = (char *) NULL;
		}

		memcpy (&t, dat[i], sizeof (MailInfo));
		memcpy (dat[i], dat[j], sizeof (MailInfo));
		memcpy (dat[j], &t, sizeof (MailInfo));
		i++;
		j--;
	}

	if (first < i - 1)
		quicksort_name (dat, first, i - 1);
	if (j + 1 < last)
		quicksort_name (dat, j + 1, last);
}

/*
 * title sort function
 */
static void quicksort_title (MailInfo * dat[], int first, int last)
{
	int i, j;
	MailInfo x, t;

	if (dat[(first + last) / 2]->data != (char *) NULL)
	{
		free (dat[(first + last) / 2]->data);
		dat[(first + last) / 2]->data = (char *) NULL;
	}

	memcpy (&x, dat[(first + last) / 2], sizeof (MailInfo));
	i = first;
	j = last;
	for (;;)
	{
		if (cxpmail->sortno == 2)
		{
			while (strcmp (x.title, dat[i]->title) > 0)
				i++;
			while (strcmp (dat[j]->title, x.title) > 0)
				j--;
		}
		else
		{
			while (strcmp (x.title, dat[i]->title) < 0)
				i++;
			while (strcmp (dat[j]->title, x.title) < 0)
				j--;
		}
		if (i >= j)
			break;

		if (dat[i]->data != (char *) NULL)
		{
			free (dat[i]->data);
			dat[i]->data = (char *) NULL;
		}
		if (dat[j]->data != (char *) NULL)
		{
			free (dat[j]->data);
			dat[j]->data = (char *) NULL;
		}

		memcpy (&t, dat[i], sizeof (MailInfo));
		memcpy (dat[i], dat[j], sizeof (MailInfo));
		memcpy (dat[j], &t, sizeof (MailInfo));
		i++;
		j--;
	}

	if (first < i - 1)
		quicksort_title (dat, first, i - 1);
	if (j + 1 < last)
		quicksort_title (dat, j + 1, last);
}

/*
 * size sort function
 */
static void quicksort_size (MailInfo * dat[], int first, int last)
{
	int i, j;
	MailInfo x, t;

	if (dat[(first + last) / 2]->data != (char *) NULL)
	{
		free (dat[(first + last) / 2]->data);
		dat[(first + last) / 2]->data = (char *) NULL;
	}

	memcpy (&x, dat[(first + last) / 2], sizeof (MailInfo));
	i = first;
	j = last;
	for (;;)
	{
		if (cxpmail->sortno == 4)
		{
			while (dat[i]->size < x.size)
				i++;
			while (x.size < dat[j]->size)
				j--;
		}
		else
		{
			while (dat[i]->size > x.size)
				i++;
			while (x.size > dat[j]->size)
				j--;
		}
		if (i >= j)
			break;

		if (dat[i]->data != (char *) NULL)
		{
			free (dat[i]->data);
			dat[i]->data = (char *) NULL;
		}
		if (dat[j]->data != (char *) NULL)
		{
			free (dat[j]->data);
			dat[j]->data = (char *) NULL;
		}

		memcpy (&t, dat[i], sizeof (MailInfo));
		memcpy (dat[i], dat[j], sizeof (MailInfo));
		memcpy (dat[j], &t, sizeof (MailInfo));
		i++;
		j--;
	}

	if (first < i - 1)
		quicksort_size (dat, first, i - 1);
	if (j + 1 < last)
		quicksort_size (dat, j + 1, last);
}

/*
 * date sort function
 */
static void quicksort_date (MailInfo * dat[], int first, int last)
{
	int i, j;
	MailInfo x, t;

	if (dat[(first + last) / 2]->data != (char *) NULL)
	{
		free (dat[(first + last) / 2]->data);
		dat[(first + last) / 2]->data = (char *) NULL;
	}

	memcpy (&x, dat[(first + last) / 2], sizeof (MailInfo));
	i = first;
	j = last;
	for (;;)
	{
		if (cxpmail->sortno == 6)
		{
			while (dat[i]->date < x.date)
				i++;
			while (x.date < dat[j]->date)
				j--;
		}
		else
		{
			while (dat[i]->date > x.date)
				i++;
			while (x.date > dat[j]->date)
				j--;
		}
		if (i >= j)
			break;

		if (dat[i]->data != (char *) NULL)
		{
			free (dat[i]->data);
			dat[i]->data = (char *) NULL;
		}
		if (dat[j]->data != (char *) NULL)
		{
			free (dat[j]->data);
			dat[j]->data = (char *) NULL;
		}

		memcpy (&t, dat[i], sizeof (MailInfo));
		memcpy (dat[i], dat[j], sizeof (MailInfo));
		memcpy (dat[j], &t, sizeof (MailInfo));
		i++;
		j--;
	}

	if (first < i - 1)
		quicksort_date (dat, first, i - 1);
	if (j + 1 < last)
		quicksort_date (dat, j + 1, last);
}

/*
 * sort function
 *     sort by quick sort.
 *
 * sortno : 0 : name sort abc...
 *          1 : name sort zyx...
 *          2 : title sort abc...
 *          3 : title sort zyx...
 *          4 : size sort 1,2,3,...
 *          5 : size sort 10,9,8,...
 *          6 : date sort 1999,2000,...
 *          7 : date sort 2000,1999,...
 *
 */
int sortTitleInfo (BoxInfo * box, int sortno)
{
	int i;

	if (box->count <= 1)
		return (0);

	switch (sortno)
	{
	case 0:		/* name sort abc...     */
	case 1:		/* name sort zyx...     */
		quicksort_name (box->mail, 0, box->count - 1);
		break;
	case 2:		/* title sort abc...     */
	case 3:		/* title sort zyx...     */
		quicksort_title (box->mail, 0, box->count - 1);
		break;
	case 4:		/* size sort 1,2,3,...      */
	case 5:		/* size sort 10,9,8,...     */
		quicksort_size (box->mail, 0, box->count - 1);
		break;
	case 6:		/* date sort 1999,2000,...  */
	case 7:		/* date sort 2000,1999,...  */
		quicksort_date (box->mail, 0, box->count - 1);
		break;
	default:
		return (-1);
	}

	return (0);
}
