/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static void filemenu_response ();
static void cxpmail_create ();
static void cxpmailtext_send ();
static void cxpmailtext_wait ();

#define FILEIACT_SEND		0x0101
#define FILEIACT_WAIT		0x0102
#define FILEIACT_CANCEL		0x0103

#define FILEMENU_BASE		"/ե"
#define FILEMENU_SEND		"/ե/Ȣ"
#define FILEMENU_WAIT		"/ե/񤭤"
#define FILEMENU_CANCEL		"/ե/ä"
#define FILEMENU_EXIT		"/ե/Ĥ"

static GtkItemFactoryEntry menu_items[] = {
	{FILEMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{FILEMENU_SEND, "<control>S", filemenu_response, FILEIACT_SEND, NULL},
	{FILEMENU_WAIT, "<control>W", filemenu_response, FILEIACT_WAIT, NULL},
	{FILEMENU_CANCEL, "<control>Q", filemenu_response, FILEIACT_CANCEL,
	 NULL},
};

static GtkItemFactoryEntry menu_items_view[] = {
	{FILEMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{FILEMENU_EXIT, "<control>Q", filemenu_response, FILEIACT_CANCEL,
	 NULL},
};

static char *cmd_toolbar_title[4] = {
	"Ȣ",
	"񤭤",
};

static char *cmd_toolbar_tooltip[4] = {
	"Υ᡼Ȣޤ",
	"Υ᡼αˤ٤˽񤭤ޤ",
};


static void cmd_toolbar_function0 (GtkWidget * widget, CxpMailClient * client)
{
	cxpmailtext_send (client);
}

static void cmd_toolbar_function1 (GtkWidget * widget, CxpMailClient * client)
{
	cxpmailtext_wait (client);
}

static void cxpmailtext_send (CxpMailClient * client)
{
	int checkindex;
	int count;
	int index;
	int maxlength;
	int msize;
	int mailNo;
	int i, k;
	char *mdata;
	char *sendNameEntry;
	char *ccNameEntry;
	char *TitleEntry;
	char *ptr;
	char *messptr;
	time_t tim;

	sendNameEntry = gtk_entry_get_text (GTK_ENTRY (client->send_entry));
	ccNameEntry = gtk_entry_get_text (GTK_ENTRY (client->cc_entry));
	TitleEntry = gtk_entry_get_text (GTK_ENTRY (client->title_entry));

	if (strlen (sendNameEntry) <= 0)
	{
		create_messageWin (cxpmail->window,
				   "褬ޤ󡣰ꤷƲ");
		return;
	}

	gtk_text_set_point (GTK_TEXT (client->mess_text), 0);

	ptr = gtk_editable_get_chars (GTK_EDITABLE (client->mess_text), 0,
				      -1);
	maxlength = strlen (ptr);

#ifdef	DEBUG
	fprintf (stdout, "maxlength ==> %d\n", maxlength);
	fprintf (stdout, "data ==> |%*.*s\n", maxlength, maxlength, ptr);
	fflush (stdout);
#endif

	msize = make_maildata (client, &mdata, sendNameEntry, TitleEntry, ptr,
			       maxlength);

#ifdef	DEBUG
	fprintf (stdout, "mail size -> %d\n", msize);
#endif

	free (ptr);

	if (msize < 0)
	{
		/* ᡼ѥǡ顼 */
		switch (msize)
		{
		case -1:	/* ʤ */
			create_messageWin (cxpmail->window,
					   "褬ޤ󡣰ꤷƲ");
			break;
		case -2:	/* MALLOC顼 */
			create_messageWin (cxpmail->window,
					   "᡼ѥǡ˼Ԥޤ(malloc error)");
			break;
		default:
			create_messageWin (cxpmail->window,
					   "᡼ѥǡ˼Ԥޤ");
			break;
		}
		free (mdata);
		return;
	}

	tim = time (0);

#if 1

	/* 񤭤Ʊ᡼ǡ¸ߤ뤫å */
	count = cxpmail->minfo.box[BOXID_KAKIKAKE]->count;
	checkindex = -1;
	for (i = 0; i < count; i++)
	{
		if (client->mailNo ==
		    cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[i]->no)
		{
			checkindex = i;
			break;
		}
	}

	/* Ȣ */
	index = cxpmail->minfo.box[BOXID_SOUSIN]->count;
	cxpmail->minfo.box[BOXID_SOUSIN]->mail[index] =
		(MailInfo *) malloc (sizeof (MailInfo));
	memset (cxpmail->minfo.box[BOXID_SOUSIN]->mail[index], 0x00,
		sizeof (MailInfo));

	/* ᡼ֹĴ٤ */
	mailNo = getMailNo ();

	/* ⤷פ᡼뤬񤭤ˤˤϽ񤭤Υ᡼ǡ */
	if (checkindex >= 0)
	{
		/* ¸Υ᡼ֹ */
		mailNo = cxpmail->minfo.box[BOXID_KAKIKAKE]->
			mail[checkindex]->no;

		/* 񤭤Υǡ */
		delMailData (&cxpmail->minfo.box[BOXID_KAKIKAKE],
			     cxpmail->minfo.box[BOXID_KAKIKAKE]->
			     mail[checkindex]);

		/* 񤭤Υإå */
		cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[checkindex]->no = 0;
		setMailHeader (BOXID_KAKIKAKE);

		/* ɤ߹ */
		getMailHeader (cxpmail->minfo.box[BOXID_KAKIKAKE]);
	}

#else

	/* Ȣ */
	index = cxpmail->minfo.box[BOXID_SOUSIN]->count;
	cxpmail->minfo.box[BOXID_SOUSIN]->mail[index] =
		(MailInfo *) malloc (sizeof (MailInfo));
	memset (cxpmail->minfo.box[BOXID_SOUSIN]->mail[index], 0x00,
		sizeof (MailInfo));

	/* ᡼ֹĴ٤ */
	mailNo = getMailNo ();
#endif
	cxpmail->minfo.box[BOXID_SOUSIN]->mail[index]->no = mailNo;
	cxpmail->minfo.box[BOXID_SOUSIN]->mail[index]->name =
		g_strdup (sendNameEntry);
	cxpmail->minfo.box[BOXID_SOUSIN]->mail[index]->sendName =
		g_strdup (sendNameEntry);
	cxpmail->minfo.box[BOXID_SOUSIN]->mail[index]->ccName =
		g_strdup (ccNameEntry);
	cxpmail->minfo.box[BOXID_SOUSIN]->mail[index]->title =
		g_strdup (TitleEntry);
	cxpmail->minfo.box[BOXID_SOUSIN]->mail[index]->size = msize;
	cxpmail->minfo.box[BOXID_SOUSIN]->mail[index]->date = tim;
	cxpmail->minfo.box[BOXID_SOUSIN]->mail[index]->data = malloc (msize);

	if (cxpmail->minfo.box[BOXID_SOUSIN]->mail[index]->data ==
	    (char *) NULL)
	{
		create_messageWin (cxpmail->window,
				   "᡼˼Ԥޤ");
		free (mdata);
		return;
	}
	memcpy (cxpmail->minfo.box[BOXID_SOUSIN]->mail[index]->data, mdata,
		msize);
	free (mdata);
	cxpmail->minfo.box[BOXID_SOUSIN]->count++;

	/* ȢΥإå򹹿 */
	setMailHeader (BOXID_SOUSIN);

	/* ȢΥǡ򹹿 */
	setMailData (cxpmail->minfo.box[BOXID_SOUSIN],
		     cxpmail->minfo.box[BOXID_SOUSIN]->mail[index]);

	cxpmail_base_view ();
	cxpmail_title_view ();
	cxpmail_view_view ();

	gtk_widget_destroy (client->window);
}

static void cxpmailtext_wait (CxpMailClient * client)
{
	int i;
	int index, count, maxlength;
	int mailNo, msize;
	char *sendNameEntry, *ccNameEntry, *TitleEntry;
	char *messptr, *ptr, *mdata;
	time_t tim;

	sendNameEntry = gtk_entry_get_text (GTK_ENTRY (client->send_entry));
	ccNameEntry = gtk_entry_get_text (GTK_ENTRY (client->cc_entry));
	TitleEntry = gtk_entry_get_text (GTK_ENTRY (client->title_entry));

	gtk_text_set_point (GTK_TEXT (client->mess_text), 0);
	ptr = gtk_editable_get_chars (GTK_EDITABLE (client->mess_text), 0,
				      -1);
	maxlength = strlen (ptr);

	if (maxlength <= 0)
	{
		create_messageWin (cxpmail->window,
				   "ʸΤʤ᡼Ͻ񤭤Ǥޤ");
		return;
	}
	if ((strlen (sendNameEntry) <= 0)
	    && (strlen (ccNameEntry) <= 0)
	    && (strlen (TitleEntry) <= 0) && (maxlength <= 0))
	{
		create_messageWin (cxpmail->window,
				   "ǡʤ᡼Ͻ񤭤Ǥޤ");
		return;
	}

	msize = make_maildata (client, &mdata, sendNameEntry, TitleEntry, ptr,
			       maxlength);
	free (ptr);

	if (msize < 0)
	{
		/* ᡼ѥǡ顼 */
		switch (msize)
		{
		case -2:	/* MALLOC顼 */
			create_messageWin (cxpmail->window,
					   "᡼ѥǡ˼Ԥޤ(malloc error)");
			break;
		default:
			create_messageWin (cxpmail->window,
					   "᡼ѥǡ˼Ԥޤ");
			break;
		}
		free (mdata);
		return;
	}

	tim = time (0);

	if (client->mode == MAIL_MOD_MODE)
	{
		/* ν񤭤򹹿 */
		count = cxpmail->minfo.box[BOXID_KAKIKAKE]->count;
		index = -1;
		for (i = 0; i < count; i++)
		{
			if (client->mailNo ==
			    cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[i]->no)
			{
				index = i;
				break;
			}
		}
		if (index >= 0)
		{
			if (cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
			    data != (char *) NULL)
			{
				free (cxpmail->minfo.box[BOXID_KAKIKAKE]->
				      mail[index]->data);
				cxpmail->minfo.box[BOXID_KAKIKAKE]->
					mail[index]->data = (char *) NULL;
			}

			memset (cxpmail->minfo.box[BOXID_KAKIKAKE]->
				mail[index], 0x00, sizeof (MailInfo));
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->no =
				client->mailNo;
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				name = g_strdup (sendNameEntry);
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				sendName = g_strdup (sendNameEntry);
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				ccName = g_strdup (ccNameEntry);
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				title = g_strdup (TitleEntry);
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				size = msize;
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				date = tim;
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				data = malloc (msize);
			if (cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
			    data == (char *) NULL)
			{
				create_messageWin (cxpmail->window,
						   "᡼˼Ԥޤ");
				free (mdata);
				return;
			}
			memcpy (cxpmail->minfo.box[BOXID_KAKIKAKE]->
				mail[index]->data, mdata, msize);
			free (mdata);
		}
		else
		{
			/* 񤭤 */
			mailNo = getMailNo ();
			index = cxpmail->minfo.box[BOXID_KAKIKAKE]->count;
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index] =
				(MailInfo *) malloc (sizeof (MailInfo));
			memset (cxpmail->minfo.box[BOXID_KAKIKAKE]->
				mail[index], 0x00, sizeof (MailInfo));
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->no =
				mailNo;
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				name = g_strdup (sendNameEntry);
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				sendName = g_strdup (sendNameEntry);
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				ccName = g_strdup (ccNameEntry);
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				title = g_strdup (TitleEntry);
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				size = msize;
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				date = tim;
			cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
				data = malloc (msize);
			if (cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->
			    data == (char *) NULL)
			{
				create_messageWin (cxpmail->window,
						   "᡼˼Ԥޤ");
				free (mdata);
				return;
			}
			memcpy (cxpmail->minfo.box[BOXID_KAKIKAKE]->
				mail[index]->data, mdata, msize);
			free (mdata);
			cxpmail->minfo.box[BOXID_KAKIKAKE]->count++;
		}
	}
	else
	{
		/* 񤭤 */
		mailNo = getMailNo ();
		index = cxpmail->minfo.box[BOXID_KAKIKAKE]->count;
		cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index] =
			(MailInfo *) malloc (sizeof (MailInfo));
		memset (cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index], 0x00,
			sizeof (MailInfo));
		cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->no = mailNo;
		cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->name =
			g_strdup (sendNameEntry);
		cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->sendName =
			g_strdup (sendNameEntry);
		cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->ccName =
			g_strdup (ccNameEntry);
		cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->title =
			g_strdup (TitleEntry);
		cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->size = msize;
		cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->date = tim;
		cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->data =
			malloc (msize);
		if (cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->data ==
		    (char *) NULL)
		{
			create_messageWin (cxpmail->window,
					   "᡼˼Ԥޤ");
			free (mdata);
			return;
		}
		memcpy (cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]->data,
			mdata, msize);
		free (mdata);
		cxpmail->minfo.box[BOXID_KAKIKAKE]->count++;

	}

	/* 񤭤Υإå򹹿 */
	setMailHeader (BOXID_KAKIKAKE);

	/* 񤭤Υǡ򹹿 */
	setMailData (cxpmail->minfo.box[BOXID_KAKIKAKE],
		     cxpmail->minfo.box[BOXID_KAKIKAKE]->mail[index]);

	cxpmail_base_view ();
	cxpmail_title_view ();
	cxpmail_view_view ();

	gtk_widget_destroy (client->window);
}

static void cxpmailtext_cancel (CxpMailClient * client)
{
	gtk_widget_destroy (client->window);
}

static void filemenu_response (CxpMailClient * client, guint action,
			       GtkWidget * widget)
{
	switch (action)
	{
	case FILEIACT_SEND:
		cxpmailtext_send (client);
		break;
	case FILEIACT_WAIT:
		cxpmailtext_wait (client);
		break;
	case FILEIACT_CANCEL:
		cxpmailtext_cancel (client);
		break;
	}
}


void sendSelectCallBack (GtkWidget * widget, CxpMailClient * client)
{

#ifdef DEBUG
	fprintf (stdout, "client->sendNum ==> %d\n", client->sendNum);
	fprintf (stdout, "client->ccNum   ==> %d\n", client->ccNum);
#endif

	cxpmail_addrselwin (client);
}

void ccSelectCallBack (GtkWidget * widget, CxpMailClient * client)
{
	cxpmail_addrselwin (client);
}

/* ᡼ */
void cxpmail_new ()
{
	cxpmail_create (MAIL_NEW_MODE);
}

/* 񤭤ѹǥ᡼ */
void cxpmail_mod ()
{
	cxpmail_create (MAIL_MOD_MODE);
}

/* ֿ⡼ɤǥ᡼ */
void cxpmail_reply ()
{
	cxpmail_create (MAIL_RE_MODE);
}

/* ž⡼ɤǥ᡼ */
void cxpmail_fw ()
{
	cxpmail_create (MAIL_FW_MODE);
}

/* ɽ⡼ɡѹػߡˤǥ᡼ɽ */
void cxpmail_disp ()
{
	cxpmail_create (MAIL_VIEW_MODE);
}

char *getEmailByData (char *data)
{
	char *buff;
	char *ptr;
	int size;
	int i, k, set;

	if (data == (char *) NULL)
		return ((char *) NULL);

	if (strlen (data) <= 0)
		return ((char *) "");

	size = strlen (data);
	buff = malloc (size + 1);
	if (buff == (char *) NULL)
		return ((char *) "");

	memset (buff, 0x00, size + 1);


	/* ǡ E-MAILɥ쥹Τߤ;Ϣ뤵֤ */
	if (strmatch ("*<*>*", data) == 0)
	{
		/* <*>Υɥ쥹 */
		k = 0;
		set = 0;
		for (i = 0; i < size; i++)
		{
			if (data[i] == '>')
			{
				set = 0;
			}
			if (set == 1)
			{
				buff[k] = data[i];
				k++;
			}
			if (data[i] == '<')
			{
				set = 1;
				if (k > 0)
				{
					buff[k] = ';';
					k++;
				}
			}
		}
	}
	else
	{
		k = 0;
		for (i = 0; i < size; i++)
		{
			if (data[i] == ' ')
				break;

			if (data[i] == '\t')
				break;

			buff[k] = data[i];
			k++;
		}
	}

	return (buff);

}

static void cxpmail_create (int mode)
{
	CxpMailClient *client;
	GtkWidget *vboxTool;
	GtkWidget *separator;
	GtkWidget *send_box;
	GtkWidget *send_label;
	GtkWidget *send_select;
	GtkWidget *title_box;
	GtkWidget *title_label;
	GtkWidget *cc_box;
	GtkWidget *cc_label;
	GtkWidget *cc_select;
	GtkWidget *table;
	GtkWidget *vscrollbar;
	GtkWidget *vbox;
	GtkWidget *btn_box;
	GtkWidget *ok_btn;
	GtkWidget *cancel_btn;
	GtkWidget *cmd_handle_box;
	GtkWidget *cmd_toolbar;
	GtkWidget *menu_handle_box;
	GtkWidget *menubar;
	GtkWidget *subitem;
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	GtkStyle *style;
	GtkWidget *pixmapwid;
	GdkBitmap *mask;
	GdkPixmap *pixmap;
	GtkWidget *item;
	int nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
	int nmenu_items_view =
		sizeof (menu_items_view) / sizeof (menu_items_view[0]);
	int i, x, y, w, h, k;
	int index, number, dataSize, dstSize, size;
	char *data, *dataptr, *ptr;
	char *mailName, *sendName, *ccName, *titleName, *inreName;
	time_t timNum;

	client = (CxpMailClient *) malloc (sizeof (CxpMailClient));
	memset (client, 0x00, sizeof (CxpMailClient));

	/* ɽ̤¸ */
	client->mode = mode;

#ifdef	DEBUG3
	fprintf (stdout, "client->mode -> [%d]\n", mode);
#endif

#if 0
	gdk_window_get_origin (cxpmail->window->window, &x, &y);
	gdk_window_get_size (cxpmail->window->window, &w, &h);
#else
	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;
#endif

	client->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	switch (mode)
	{
	case MAIL_VIEW_MODE:
		gtk_window_set_title (GTK_WINDOW (client->window),
				      "᡼ɽ");
		break;
	case MAIL_NEW_MODE:
		gtk_window_set_title (GTK_WINDOW (client->window),
				      "᡼");
		break;
	case MAIL_MOD_MODE:
		gtk_window_set_title (GTK_WINDOW (client->window),
				      "᡼ѹ");
		break;
	case MAIL_RE_MODE:
		gtk_window_set_title (GTK_WINDOW (client->window),
				      "ֿ᡼");
		break;
	case MAIL_FW_MODE:
		gtk_window_set_title (GTK_WINDOW (client->window),
				      "ž᡼");
		break;
	}

	gtk_widget_set_usize (client->window, 100, 100);
	gtk_window_set_default_size (GTK_WINDOW (client->window), 500, 500);

#if 0
	gtk_widget_set_uposition (client->window,
				  (x + (w / 2)) - (420 / 2),
				  (y + (h / 2)) - (440 / 2));
#else
	gtk_widget_set_uposition (client->window, (x - 500 * 0.5),
				  (y - 500 * 0.5));
#endif
	gtk_widget_show (client->window);


	vbox = gtk_vbox_new (FALSE, 2);
	gtk_container_add (GTK_CONTAINER (client->window), vbox);
	gtk_widget_show (vbox);

    /*--- menu ---*/
	menu_handle_box = gtk_handle_box_new ();
	gtk_box_pack_start (GTK_BOX (vbox), menu_handle_box, FALSE, FALSE, 0);
	gtk_widget_show (menu_handle_box);

	accel_group = gtk_accel_group_new ();
	item_factory =
		gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				      accel_group);

	switch (mode)
	{
	case MAIL_VIEW_MODE:
		gtk_item_factory_create_items (item_factory,
					       nmenu_items_view,
					       menu_items_view,
					       (gpointer) client);
		break;
	case MAIL_NEW_MODE:
	case MAIL_MOD_MODE:
	case MAIL_RE_MODE:
	case MAIL_FW_MODE:
		gtk_item_factory_create_items (item_factory,
					       nmenu_items, menu_items,
					       (gpointer) client);
		break;
	}
	gtk_accel_group_attach (accel_group, GTK_OBJECT (client->window));

	menubar = gtk_item_factory_get_widget (item_factory, "<main>");
	gtk_container_add (GTK_CONTAINER (menu_handle_box), menubar);
	gtk_widget_show (menubar);

    /*-- topcmd ---*/
	switch (mode)
	{
	case MAIL_VIEW_MODE:
		break;
	case MAIL_NEW_MODE:
	case MAIL_MOD_MODE:
	case MAIL_RE_MODE:
	case MAIL_FW_MODE:
		cmd_handle_box = gtk_handle_box_new ();
		gtk_box_pack_start (GTK_BOX (vbox), cmd_handle_box, FALSE,
				    TRUE, 0);
		gtk_widget_show (cmd_handle_box);

		vboxTool = gtk_vbox_new (FALSE, 0);
		gtk_container_add (GTK_CONTAINER (cmd_handle_box), vboxTool);
		gtk_widget_show (vboxTool);

		separator = gtk_hseparator_new ();
		gtk_box_pack_start (GTK_BOX (vboxTool), separator, FALSE,
				    TRUE, 0);
		gtk_widget_show (separator);

		cmd_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL,
					       GTK_TOOLBAR_BOTH);
		gtk_box_pack_start (GTK_BOX (vboxTool), cmd_toolbar, FALSE,
				    FALSE, 0);
		gtk_toolbar_set_button_relief (GTK_TOOLBAR (cmd_toolbar),
					       GTK_RELIEF_NONE);
		gtk_widget_show (cmd_toolbar);

		separator = gtk_hseparator_new ();
		gtk_box_pack_start (GTK_BOX (vboxTool), separator, FALSE,
				    TRUE, 0);
		gtk_widget_show (separator);

		style = gtk_widget_get_style (client->window);

		for (i = 0; i < 2; i++)
		{
			pixmap = gdk_pixmap_create_from_xpm (client->window->
							     window, &mask,
							     &style->
							     bg
							     [GTK_STATE_NORMAL],
							     cxpmail->base.
							     mailt[i]);
			pixmapwid = gtk_pixmap_new (pixmap, mask);

			switch (i)
			{
			case 0:
				item = gtk_toolbar_append_item (GTK_TOOLBAR
								(cmd_toolbar),
								cmd_toolbar_title
								[i],
								cmd_toolbar_tooltip
								[i], NULL,
								pixmapwid,
								cmd_toolbar_function0,
								(gpointer)
								client);
				break;
			case 1:
				item = gtk_toolbar_append_item (GTK_TOOLBAR
								(cmd_toolbar),
								cmd_toolbar_title
								[i],
								cmd_toolbar_tooltip
								[i], NULL,
								pixmapwid,
								cmd_toolbar_function1,
								(gpointer)
								client);
				break;
			}
		}
		break;
	}


    /*--- send ---*/
	send_box = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_start (GTK_BOX (vbox), send_box, FALSE, TRUE, 1);
	gtk_widget_show (send_box);

	send_label = gtk_label_new ("衡");
	gtk_box_pack_start (GTK_BOX (send_box), send_label, FALSE, FALSE, 3);
	gtk_widget_show (send_label);

	client->send_entry = gtk_entry_new_with_max_length (4096);
	gtk_box_pack_start (GTK_BOX (send_box), client->send_entry, TRUE,
			    TRUE, 3);
	gtk_widget_show (client->send_entry);

	switch (mode)
	{
	case MAIL_VIEW_MODE:
		break;
	case MAIL_NEW_MODE:
	case MAIL_MOD_MODE:
	case MAIL_RE_MODE:
	case MAIL_FW_MODE:
		gtk_entry_set_editable (GTK_ENTRY (client->send_entry), 1);
		send_select = gtk_button_new_with_label ("...");
		gtk_signal_connect (GTK_OBJECT (send_select), "clicked",
				    (GtkSignalFunc) sendSelectCallBack,
				    (gpointer) client);
		gtk_box_pack_end (GTK_BOX (send_box), send_select, FALSE,
				  FALSE, 3);
		gtk_widget_show (send_select);
		break;
	}

    /*--- cc ---*/
	cc_box = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_start (GTK_BOX (vbox), cc_box, FALSE, TRUE, 1);
	gtk_widget_show (cc_box);

	cc_label = gtk_label_new ("ãá");
	gtk_box_pack_start (GTK_BOX (cc_box), cc_label, FALSE, FALSE, 3);
	gtk_widget_show (cc_label);

	client->cc_entry = gtk_entry_new_with_max_length (4096);
	gtk_box_pack_start (GTK_BOX (cc_box), client->cc_entry, TRUE, TRUE,
			    3);
	gtk_widget_show (client->cc_entry);

	switch (mode)
	{
	case MAIL_VIEW_MODE:
		break;
	case MAIL_NEW_MODE:
	case MAIL_MOD_MODE:
	case MAIL_RE_MODE:
	case MAIL_FW_MODE:
		gtk_entry_set_editable (GTK_ENTRY (client->cc_entry), 1);
		cc_select = gtk_button_new_with_label ("...");
		gtk_signal_connect (GTK_OBJECT (cc_select), "clicked",
				    (GtkSignalFunc) ccSelectCallBack,
				    (gpointer) client);
		gtk_box_pack_end (GTK_BOX (cc_box), cc_select, FALSE, FALSE,
				  3);
		gtk_widget_show (cc_select);
		break;
	}

    /*--- title ---*/
	title_box = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_start (GTK_BOX (vbox), title_box, FALSE, TRUE, 1);
	gtk_widget_show (title_box);

	title_label = gtk_label_new ("ȥ롧");
	gtk_box_pack_start (GTK_BOX (title_box), title_label, FALSE, FALSE,
			    3);
	gtk_widget_show (title_label);

	client->title_entry = gtk_entry_new_with_max_length (1024);
	gtk_box_pack_start (GTK_BOX (title_box), client->title_entry, TRUE,
			    TRUE, 3);
	gtk_widget_show (client->title_entry);

    /*--- text ---*/
	table = gtk_table_new (2, 2, FALSE);
	gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
	gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
	gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 5);
	gtk_widget_show (table);

	client->mess_text = gtk_text_new (NULL, NULL);
	gtk_text_set_editable (GTK_TEXT (client->mess_text), TRUE);
	gtk_table_attach (GTK_TABLE (table), client->mess_text, 0, 1, 0, 1,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show (client->mess_text);

	vscrollbar = gtk_vscrollbar_new (GTK_TEXT (client->mess_text)->vadj);
	gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
			  GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show (vscrollbar);
	gtk_widget_realize (client->mess_text);

	/* ɽ */
	switch (mode)
	{
	case MAIL_VIEW_MODE:
		gtk_entry_set_editable (GTK_ENTRY (client->send_entry), 0);
		gtk_entry_set_editable (GTK_ENTRY (client->cc_entry), 0);
		gtk_entry_set_editable (GTK_ENTRY (client->title_entry), 0);
		gtk_text_set_editable (GTK_TEXT (client->mess_text), 0);
		break;
	case MAIL_NEW_MODE:
	case MAIL_MOD_MODE:
	case MAIL_RE_MODE:
	case MAIL_FW_MODE:
		gtk_entry_set_editable (GTK_ENTRY (client->send_entry), 1);
		gtk_entry_set_editable (GTK_ENTRY (client->cc_entry), 1);
		gtk_entry_set_editable (GTK_ENTRY (client->title_entry), 1);
		gtk_text_set_editable (GTK_TEXT (client->mess_text), 1);
		break;
	}

	/* ɽ */
	gtk_text_freeze (GTK_TEXT (client->mess_text));

	/* ǡ */
	gtk_text_set_point (GTK_TEXT (client->mess_text), 0);
	gtk_text_forward_delete (GTK_TEXT (client->mess_text),
				 gtk_text_get_length (GTK_TEXT
						      (client->mess_text)));
	gtk_text_set_point (GTK_TEXT (client->mess_text), 0);

	index = cxpmail->minfo.viewPoint;
	number = cxpmail->select_title;

	if (index >= 0 && number > 0)
	{
		if (cxpmail->minfo.box[index]->mail[number - 1]->data ==
		    (char *) NULL)
		{
			getMailData (cxpmail->minfo.box[index],
				     &(cxpmail->minfo.box[index]->
				       mail[number - 1]));
		}
		recvMailHeaderInfo (cxpmail->minfo.box[index]->
				    mail[number - 1]->data,
				    cxpmail->minfo.box[index]->mail[number -
								    1]->size,
				    &mailName, &sendName, &ccName, &titleName,
				    &inreName, &timNum);
	}
	else
	{
		mailName = (char *) NULL;
		sendName = (char *) NULL;
		ccName = (char *) NULL;
		titleName = (char *) NULL;
		inreName = (char *) NULL;
		timNum = (time_t) 0;
	}

#ifdef DEBUG3
	fprintf (stdout, "index     -> [%d]\n", index);
	fprintf (stdout, "number    -> [%d]\n", number);
	fprintf (stdout, "mailName  -> [%s]\n", mailName);
	fprintf (stdout, "sendName  -> [%s]\n", sendName);
	fprintf (stdout, "ccName    -> [%s]\n", ccName);
	fprintf (stdout, "titleName -> [%s]\n", titleName);
	fprintf (stdout, "inreName  -> [%s]\n", inreName);
	fprintf (stdout, "timNum    -> [%d]\n", timNum);
#endif

	/* ǡ */
	switch (mode)
	{
	case MAIL_NEW_MODE:	/* ⡼ɡƶ */
		break;

	case MAIL_VIEW_MODE:	/* ɽ⡼ɡѹԲ */

		client->mailNo =
			cxpmail->minfo.box[index]->mail[number - 1]->no;

		/*  */
		if (sendName == NULL)
		{
			gtk_entry_set_text (GTK_ENTRY (client->send_entry),
					    "");
		}
		else if (strlen (sendName) <= 0)
		{
			gtk_entry_set_text (GTK_ENTRY (client->send_entry),
					    "");
		}
		else
		{
			gtk_entry_set_text (GTK_ENTRY (client->send_entry),
					    sendName);
		}

		/* ãä */
		if (ccName == NULL)
		{
			gtk_entry_set_text (GTK_ENTRY (client->cc_entry), "");
		}
		else if (strlen (ccName) <= 0)
		{
			gtk_entry_set_text (GTK_ENTRY (client->cc_entry), "");
		}
		else
		{
			gtk_entry_set_text (GTK_ENTRY (client->cc_entry),
					    ccName);
		}

		/* ȥ */
		if (titleName == NULL)
		{
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    "");
		}
		else if (strlen (titleName) <= 0)
		{
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    "");
		}
		else
		{
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    titleName);
		}


		/* ǡ */
		data = (char *) getNativeMailData (&dataSize,
						   cxpmail->minfo.box[index]->
						   mail[number - 1]->data,
						   cxpmail->minfo.box[index]->
						   mail[number - 1]->size);
		if (dataSize > 0)
		{
			dataptr = malloc (dataSize);
			if (dataptr != (char *) NULL)
			{
				cxpmail_recvdata_euc (data, dataSize, dataptr,
						      &dstSize);

				gtk_text_set_point (GTK_TEXT
						    (client->mess_text), 0);
				gtk_text_insert (GTK_TEXT (client->mess_text),
						 cxpmail->font, NULL, NULL,
						 dataptr, dstSize);
				gtk_text_set_point (GTK_TEXT
						    (client->mess_text), 0);
				free (dataptr);
			}
			free (data);
		}

		break;

	case MAIL_MOD_MODE:	/* 񤭤κ⡼ */

		client->mailNo =
			cxpmail->minfo.box[index]->mail[number - 1]->no;

		/*  */
		if (sendName == NULL)
		{
			gtk_entry_set_text (GTK_ENTRY (client->send_entry),
					    "");
		}
		else if (strlen (sendName) <= 0)
		{
			gtk_entry_set_text (GTK_ENTRY (client->send_entry),
					    "");
		}
		else
		{
			gtk_entry_set_text (GTK_ENTRY (client->send_entry),
					    getEmailByData (sendName));
		}

		/* ãä */
		if (ccName == NULL)
		{
			gtk_entry_set_text (GTK_ENTRY (client->cc_entry), "");
		}
		else if (strlen (ccName) <= 0)
		{
			gtk_entry_set_text (GTK_ENTRY (client->cc_entry), "");
		}
		else
		{
			gtk_entry_set_text (GTK_ENTRY (client->cc_entry),
					    getEmailByData (ccName));
		}

		/* ȥ */
		if (titleName == NULL)
		{
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    "");
		}
		else if (strlen (titleName) <= 0)
		{
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    "");
		}
		else
		{
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    titleName);
		}


		/* ǡ */
		data = (char *) getNativeMailData (&dataSize,
						   cxpmail->minfo.box[index]->
						   mail[number - 1]->data,
						   cxpmail->minfo.box[index]->
						   mail[number - 1]->size);
		if (dataSize > 0)
		{
			dataptr = malloc (dataSize);
			if (dataptr != (char *) NULL)
			{
				cxpmail_recvdata_euc (data, dataSize, dataptr,
						      &dstSize);

				gtk_text_set_point (GTK_TEXT
						    (client->mess_text), 0);
				gtk_text_insert (GTK_TEXT (client->mess_text),
						 cxpmail->font, NULL, NULL,
						 dataptr, dstSize);
				gtk_text_set_point (GTK_TEXT
						    (client->mess_text), 0);
				free (dataptr);
			}
			free (data);
		}

		break;

	case MAIL_RE_MODE:	/* ֿ⡼ɡ */

		/*  */
		if (inreName == NULL)
		{
			if (mailName == NULL)
			{
				gtk_entry_set_text (GTK_ENTRY
						    (client->send_entry), "");
			}
			else if (strlen (mailName) <= 0)
			{
				gtk_entry_set_text (GTK_ENTRY
						    (client->send_entry), "");
			}
			else
			{
				gtk_entry_set_text (GTK_ENTRY
						    (client->send_entry),
						    getEmailByData
						    (mailName));
			}
		}
		else if (strlen (inreName) <= 0)
		{
			if (mailName == NULL)
			{
				gtk_entry_set_text (GTK_ENTRY
						    (client->send_entry), "");
			}
			else if (strlen (mailName) <= 0)
			{
				gtk_entry_set_text (GTK_ENTRY
						    (client->send_entry), "");
			}
			else
			{
				gtk_entry_set_text (GTK_ENTRY
						    (client->send_entry),
						    getEmailByData
						    (mailName));
			}
		}
		else
		{
			gtk_entry_set_text (GTK_ENTRY (client->send_entry),
					    getEmailByData (inreName));
		}


		/* ãä */
		gtk_entry_set_text (GTK_ENTRY (client->cc_entry), "");

		/* ȥ */
		if (titleName == NULL)
		{
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    "");
		}
		else if (strlen (titleName) <= 0)
		{
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    "");
		}
		else
		{
			size = strlen (titleName);
			ptr = malloc (size + 4);
			if (ptr == (char *) NULL)
			{
				create_messageWin (cxpmail->window,
						   "ֿǡ˼Ԥޤ");
				return;
			}

			memset (ptr, 0x00, size + 4);
			sprintf (ptr, "Re:%s", titleName);
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    ptr);
			free (ptr);
		}


		/* ǡ */
		data = (char *) getNativeMailData (&dataSize,
						   cxpmail->minfo.box[index]->
						   mail[number - 1]->data,
						   cxpmail->minfo.box[index]->
						   mail[number - 1]->size);
		if (dataSize > 0)
		{
			dataptr = malloc (dataSize);
			if (dataptr != (char *) NULL)
			{
				cxpmail_recvdata_euc (data, dataSize, dataptr,
						      &dstSize);

				gtk_text_set_point (GTK_TEXT
						    (client->mess_text), 0);

				ptr = malloc (dstSize + 1);
				if (ptr == (char *) NULL)
				{
					create_messageWin (cxpmail->window,
							   "ֿǡ˼Ԥޤ");
					return;
				}
				memset (ptr, 0x00, dstSize + 1);
				k = 0;

				for (i = 0; i < dstSize; i++)
				{
					if (*(dataptr + i) == '\n')
					{
						ptr[k] = '\n';
						k++;

						gtk_text_insert (GTK_TEXT
								 (client->
								  mess_text),
								 cxpmail->
								 font, NULL,
								 NULL, ">",
								 1);
						gtk_text_insert (GTK_TEXT
								 (client->
								  mess_text),
								 cxpmail->
								 font, NULL,
								 NULL, ptr,
								 k);
						memset (ptr, 0x00,
							dstSize + 1);
						k = 0;
					}
					else
					{
						ptr[k] = *(dataptr + i);
						k++;
					}
				}

				if (k > 0)
				{
					gtk_text_insert (GTK_TEXT
							 (client->mess_text),
							 cxpmail->font, NULL,
							 NULL, ">", 1);
					gtk_text_insert (GTK_TEXT
							 (client->mess_text),
							 cxpmail->font, NULL,
							 NULL, ptr, k);
				}
				free (ptr);
				gtk_text_set_point (GTK_TEXT
						    (client->mess_text), 0);
				free (dataptr);
			}
			free (data);
		}

		break;

	case MAIL_FW_MODE:	/* ž⡼ */

		/*  */
		gtk_entry_set_text (GTK_ENTRY (client->send_entry), "");

		/* ãä */
		gtk_entry_set_text (GTK_ENTRY (client->cc_entry), "");

		/* ȥ */
		if (titleName == NULL)
		{
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    "");
		}
		else if (strlen (titleName) <= 0)
		{
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    "");
		}
		else
		{
			size = strlen (titleName);
			ptr = malloc (size + 4);
			if (ptr == (char *) NULL)
			{
				create_messageWin (cxpmail->window,
						   "žǡ˼Ԥޤ");
				return;
			}

			memset (ptr, 0x00, size + 4);
			sprintf (ptr, "Fw:%s", titleName);
			gtk_entry_set_text (GTK_ENTRY (client->title_entry),
					    ptr);
			free (ptr);
		}


		/* ǡ */
		data = (char *) getNativeMailData (&dataSize,
						   cxpmail->minfo.box[index]->
						   mail[number - 1]->data,
						   cxpmail->minfo.box[index]->
						   mail[number - 1]->size);
		if (dataSize > 0)
		{
			dataptr = malloc (dataSize);
			if (dataptr != (char *) NULL)
			{
				cxpmail_recvdata_euc (data, dataSize, dataptr,
						      &dstSize);

				gtk_text_set_point (GTK_TEXT
						    (client->mess_text), 0);
				gtk_text_insert (GTK_TEXT (client->mess_text),
						 cxpmail->font, NULL, NULL,
						 dataptr, dstSize);
				gtk_text_set_point (GTK_TEXT
						    (client->mess_text), 0);
				free (dataptr);
			}
			free (data);
		}

		break;

	}

	/* ɽ */
	gtk_text_thaw (GTK_TEXT (client->mess_text));

}
