/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static char *listtitle[5] = { " ",
	"",
	"ȥ",
	"",
	""
};

static char *listtitle_change[6] = { "",
	"",
	"",
	"",
	"",
	""
};


#define	SUBMENU_NEWMAIL		"᡼"
#define	SUBMENU_REMAIL		"ֿ"
#define	SUBMENU_FWMAIL		"ž"
#define	SUBMENU_DELMAIL		"᡼"
#define	SUBMENU_VIEW		"ܺɽ"
#define	SUBMENU_MOVEMAIL	"ܥåذư"

static void submenu_response (gchar * string)
{
	if (strcmp (string, SUBMENU_NEWMAIL) == 0)
	{
		cxpmailmessfunc_new ();
	}
	else if (strcmp (string, SUBMENU_REMAIL) == 0)
	{
		cxpmailmessfunc_re ();
	}
	else if (strcmp (string, SUBMENU_FWMAIL) == 0)
	{
		cxpmailmessfunc_fw ();
	}
	else if (strcmp (string, SUBMENU_DELMAIL) == 0)
	{
		cxpmaileditfunc_delmail ();
	}
	else if (strcmp (string, SUBMENU_VIEW) == 0)
	{
		cxpmailviewfunc_syousai ();
	}
	else if (strcmp (string, SUBMENU_MOVEMAIL) == 0)
	{
		cxpmaileditfunc_movemail ();
	}
}

static void nameSortCallback (GtkWidget * widget, gpointer data)
{
	if (cxpmail->sortno == 0)
		cxpmail->sortno = 1;
	else
		cxpmail->sortno = 0;

	cxpmail_title_view ();
	cxpmail_view_view ();
}
static void titleSortCallback (GtkWidget * widget, gpointer data)
{
	if (cxpmail->sortno == 2)
		cxpmail->sortno = 3;
	else
		cxpmail->sortno = 2;

	cxpmail_title_view ();
	cxpmail_view_view ();
}
static void sizeSortCallback (GtkWidget * widget, gpointer data)
{
	if (cxpmail->sortno == 4)
		cxpmail->sortno = 5;
	else
		cxpmail->sortno = 4;

	cxpmail_title_view ();
	cxpmail_view_view ();
}
static void dateSortCallback (GtkWidget * widget, gpointer data)
{
	if (cxpmail->sortno == 6)
		cxpmail->sortno = 7;
	else
		cxpmail->sortno = 6;

	cxpmail_title_view ();
	cxpmail_view_view ();
}


static int listselection (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
	int index;

	if (row < 0)
		return (0);

#ifdef	DEBUG6
	fprintf (stdout, " listselection row -> [%d]\n", row);
#endif

	if (cxpmail->select_title != (row + 1))
	{
		cxpmail->select_title = row + 1;

		cxpmail_view_view ();
	}
	return (0);
}

static int listunselection (GtkWidget * clist, gint row, gint column,
			    GdkEventButton * event, gpointer data)
{
	int index;
	int maxCount;

	if (row < 0)
		return (0);

#ifdef	DEBUG6
	fprintf (stdout, " listunselection row -> [%d]\n", row);
#endif

	index = cxpmail->minfo.viewPoint;
	if (cxpmail->minfo.box[index] != (BoxInfo *) NULL)
	{
		maxCount = cxpmail->minfo.box[index]->count;
		if (maxCount > row)
		{
			if (cxpmail->minfo.box[index]->mail[row]->data !=
			    (char *) NULL)
			{
				free (cxpmail->minfo.box[index]->mail[row]->
				      data);
				cxpmail->minfo.box[index]->mail[row]->data =
					(char *) NULL;
			}
		}
	}

	return (0);
}

static int listbuttonpress (GtkWidget * widget, GdkEvent * event)
{
	GdkEventButton *bevent = (GdkEventButton *) event;
	GdkEventKey *kevent = (GdkEventKey *) event;
	GtkWidget *lmenu;
	GtkWidget *lmenuitem;
	int row, column;
	int index, maxCount;
	static time_t checkTime;
	static int checkRow;
	static time_t oldTime;
	static int oldRow;
	static int KeyPressCntl = 0;
	static int KeyPressShift = 0;

	if (event->type == GDK_KEY_PRESS)
	{
#ifdef	DEBUG
		fprintf (stdout, "GDK_KEY_PRESS ..\n");
		fprintf (stdout, "GDK_KEY_PRESS ... [0x%04x]\n",
			 kevent->keyval);
#endif

		if (kevent->keyval == GDK_Control_L
		    || kevent->keyval == GDK_Control_R)
			KeyPressCntl = 1;
		if (kevent->keyval == GDK_Shift_L
		    || kevent->keyval == GDK_Shift_R)
			KeyPressShift = 1;

		if (kevent->keyval == GDK_Delete)	/* DEL */
		{
			if (cxpmail->select_title > 0)
			{
				/* Ʋ줿ȡϢ³ǣñ̤Ǻ¹ */
				if ((cxpmail->keyPressStatus == 0)
				    || (((cxpmail->keyPressStatus + 1) % 10)
					== 0))
				{
					/* ¹ */
					cxpmaileditfunc_delmail ();
				}
			}
		}

		cxpmail->keyPressStatus++;
	}
	if (event->type == GDK_KEY_RELEASE)
	{
#ifdef	DEBUG
		fprintf (stdout, "GDK_KEY_RELEASE ..\n");
		fprintf (stdout, "GDK_KEY_RELEASE ... [0x%04x]\n",
			 kevent->keyval);
#endif
		if (kevent->keyval == GDK_Control_L
		    || kevent->keyval == GDK_Control_R)
			KeyPressCntl = 0;
		if (kevent->keyval == GDK_Shift_L
		    || kevent->keyval == GDK_Shift_R)
			KeyPressShift = 0;


		cxpmail->keyPressStatus = 0;
	}
	if (event->type == GDK_BUTTON_PRESS)
	{
#ifdef	DEBUG
		fprintf (stdout, "GDK_BUTTON_PRESS ..\n");
#endif
		if (bevent->button != 3)
		{
			if (bevent->button == 1)
			{
#ifdef	DEBUG
				fprintf (stdout,
					 "GDK_BUTTON_PRESS  button 1 ..\n");
#endif
				index = cxpmail->minfo.viewPoint;
				maxCount = cxpmail->minfo.box[index]->count;

				gtk_clist_get_selection_info (GTK_CLIST
							      (cxpmail->
							       list_title),
							      bevent->x,
							      bevent->y, &row,
							      &column);

#ifdef	DEBUG
				fprintf (stdout,
					 "GDK_BUTTON_PRESS  row -> %d maxCount -> %d\n",
					 row, maxCount);
#endif

				if (row >= 0 && row < maxCount)
				{
#if 0
					cxpmail->select_title = row + 1;
#endif
					checkRow = row + 1;
					checkTime = time (0);
#ifdef	DEBUG
					fprintf (stdout,
						 "GDK_BUTTON_PRESS  checkTime [%ld] oldTime [%ld]\n",
						 checkTime, oldTime);
					fprintf (stdout,
						 "GDK_BUTTON_PRESS  checkRow [%d] oldRow [%d]\n",
						 checkRow, oldRow);
#endif
					if (checkTime != oldTime
					    || checkRow != oldRow)
					{
						oldTime = checkTime;
						oldRow = checkRow;
					}
					else
					{
						oldTime = checkTime - 1;
						oldRow = checkRow;

						cxpmail->select_title =
							row + 1;

						if (index == BOXID_KAKIKAKE)
						{
							/* 񤭤ʤѹ⡼ɤǵư */
#ifdef DEBUG
							fprintf (stdout,
								 "cxpmail_mod start ...\n");
#endif
							cxpmail_mod ();
						}
						else
						{
							/* 񤭤Ȣʳʤ顢ɽ⡼ɤǵư */
#ifdef DEBUG
							fprintf (stdout,
								 "cxpmail_disp start ...\n");
#endif
							cxpmail_disp ();
						}
					}
				}
			}
		}
		else
		{
			index = cxpmail->minfo.viewPoint;
			maxCount = cxpmail->minfo.box[index]->count;

			gtk_clist_get_selection_info (GTK_CLIST
						      (cxpmail->list_title),
						      bevent->x, bevent->y,
						      &row, &column);

			/* ˥塼 */
			lmenu = gtk_menu_new ();

			lmenuitem =
				gtk_menu_item_new_with_label
				(SUBMENU_NEWMAIL);
			gtk_menu_append (GTK_MENU (lmenu), lmenuitem);
			gtk_signal_connect_object (GTK_OBJECT (lmenuitem),
						   "activate",
						   GTK_SIGNAL_FUNC
						   (submenu_response),
						   (gpointer)
						   g_strdup
						   (SUBMENU_NEWMAIL));
			gtk_widget_show (lmenuitem);

			if (row >= 0 && row < maxCount)
			{
				cxpmail->select_title = row + 1;
				gtk_clist_select_row (GTK_CLIST
						      (cxpmail->list_title),
						      row, 0);

				lmenuitem =
					gtk_menu_item_new_with_label
					(SUBMENU_REMAIL);
				gtk_menu_append (GTK_MENU (lmenu), lmenuitem);
				gtk_signal_connect_object (GTK_OBJECT
							   (lmenuitem),
							   "activate",
							   GTK_SIGNAL_FUNC
							   (submenu_response),
							   (gpointer)
							   g_strdup
							   (SUBMENU_REMAIL));
				gtk_widget_show (lmenuitem);

				lmenuitem =
					gtk_menu_item_new_with_label
					(SUBMENU_FWMAIL);
				gtk_menu_append (GTK_MENU (lmenu), lmenuitem);
				gtk_signal_connect_object (GTK_OBJECT
							   (lmenuitem),
							   "activate",
							   GTK_SIGNAL_FUNC
							   (submenu_response),
							   (gpointer)
							   g_strdup
							   (SUBMENU_FWMAIL));
				gtk_widget_show (lmenuitem);

				lmenuitem =
					gtk_menu_item_new_with_label
					(SUBMENU_DELMAIL);
				gtk_menu_append (GTK_MENU (lmenu), lmenuitem);
				gtk_signal_connect_object (GTK_OBJECT
							   (lmenuitem),
							   "activate",
							   GTK_SIGNAL_FUNC
							   (submenu_response),
							   (gpointer)
							   g_strdup
							   (SUBMENU_DELMAIL));
				gtk_widget_show (lmenuitem);

				lmenuitem =
					gtk_menu_item_new_with_label
					(SUBMENU_VIEW);
				gtk_menu_append (GTK_MENU (lmenu), lmenuitem);
				gtk_signal_connect_object (GTK_OBJECT
							   (lmenuitem),
							   "activate",
							   GTK_SIGNAL_FUNC
							   (submenu_response),
							   (gpointer)
							   g_strdup
							   (SUBMENU_VIEW));
				gtk_widget_show (lmenuitem);

				lmenuitem =
					gtk_menu_item_new_with_label
					(SUBMENU_MOVEMAIL);
				gtk_menu_append (GTK_MENU (lmenu), lmenuitem);
				gtk_signal_connect_object (GTK_OBJECT
							   (lmenuitem),
							   "activate",
							   GTK_SIGNAL_FUNC
							   (submenu_response),
							   (gpointer)
							   g_strdup
							   (SUBMENU_MOVEMAIL));
				gtk_widget_show (lmenuitem);

				cxpmail_view_view ();
			}

			/* ˥塼ݥåץå */
			gtk_menu_popup (GTK_MENU (lmenu), NULL, NULL, NULL,
					NULL, bevent->button, bevent->time);

			return TRUE;
		}
	}

	return (0);
}

int cxpmail_title_init ()
{

	/* Clist Τ뤿Υɥɥ */
	cxpmail->swin_title = gtk_scrolled_window_new (NULL, NULL);

	/* ʿӿľΥСɽ褦 */
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
					(cxpmail->swin_title),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_show (cxpmail->swin_title);

	cxpmail->list_title = gtk_clist_new_with_titles (5, listtitle);
	gtk_widget_set_usize (cxpmail->list_title, 250, 150);
	gtk_clist_set_selection_mode (GTK_CLIST (cxpmail->list_title),
				      GTK_SELECTION_BROWSE);

	gtk_signal_connect (GTK_OBJECT (cxpmail->list_title), "select_row",
			    GTK_SIGNAL_FUNC (listselection), NULL);

	gtk_signal_connect (GTK_OBJECT (cxpmail->list_title), "unselect_row",
			    GTK_SIGNAL_FUNC (listunselection), NULL);

	gtk_signal_connect (GTK_OBJECT (cxpmail->list_title), "event",
			    GTK_SIGNAL_FUNC (listbuttonpress), NULL);

	gtk_signal_connect (GTK_OBJECT
			    (GTK_CLIST (cxpmail->list_title)->column[1].
			     button), "clicked",
			    GTK_SIGNAL_FUNC (nameSortCallback),
			    (gpointer) NULL);
	gtk_signal_connect (GTK_OBJECT
			    (GTK_CLIST (cxpmail->list_title)->column[2].
			     button), "clicked",
			    GTK_SIGNAL_FUNC (titleSortCallback),
			    (gpointer) NULL);
	gtk_signal_connect (GTK_OBJECT
			    (GTK_CLIST (cxpmail->list_title)->column[3].
			     button), "clicked",
			    GTK_SIGNAL_FUNC (sizeSortCallback),
			    (gpointer) NULL);
	gtk_signal_connect (GTK_OBJECT
			    (GTK_CLIST (cxpmail->list_title)->column[4].
			     button), "clicked",
			    GTK_SIGNAL_FUNC (dateSortCallback),
			    (gpointer) NULL);

#if 0
	gtk_clist_column_title_passive (GTK_CLIST (cxpmail->list_title), 0);
	gtk_clist_column_title_passive (GTK_CLIST (cxpmail->list_title), 1);
	gtk_clist_column_title_passive (GTK_CLIST (cxpmail->list_title), 2);
	gtk_clist_column_title_passive (GTK_CLIST (cxpmail->list_title), 3);
	gtk_clist_column_title_passive (GTK_CLIST (cxpmail->list_title), 4);
#endif

	gtk_clist_set_column_width (GTK_CLIST (cxpmail->list_title), 0, 10);
	gtk_clist_set_column_width (GTK_CLIST (cxpmail->list_title), 1, 150);
	gtk_clist_set_column_width (GTK_CLIST (cxpmail->list_title), 2, 230);
	gtk_clist_set_column_width (GTK_CLIST (cxpmail->list_title), 3, 70);
	gtk_clist_set_column_width (GTK_CLIST (cxpmail->list_title), 4, 100);

	gtk_clist_set_column_justification (GTK_CLIST (cxpmail->list_title),
					    3, GTK_JUSTIFY_RIGHT);

	gtk_container_add (GTK_CONTAINER (cxpmail->swin_title),
			   cxpmail->list_title);
	gtk_widget_show (cxpmail->list_title);

	gtk_paned_add1 (GTK_PANED (cxpmail->vpanel), cxpmail->swin_title);

}

char *getName (char *name)
{
	static char cname[4096];
	char *cptr;
	char *ptr1, *ptr2;

	cptr = g_strdup (name);
	memset (cname, 0x00, sizeof (cname));

	if (strmatch ("*(*)*", cptr) == 0)
	{
		/* ̤ʸͥ褵 */
		ptr2 = strrchr (cptr, ')');
		if (ptr2 != (char *) NULL)
			*ptr2 = (char) NULL;
		ptr1 = strchr (cptr, '(');
		if (ptr1 != (char *) NULL)
		{
			strcpy (cname, ptr1 + 1);
		}
		else
		{
			strcpy (cname, cptr);
		}
	}
	else if (strmatch ("*\"*\"*", cptr) == 0)
	{
		/* ""ʸͥ褵 */
		ptr2 = strrchr (cptr, '"');
		if (ptr2 != (char *) NULL)
			*ptr2 = (char) NULL;
		ptr1 = strchr (cptr, '"');
		if (ptr1 != (char *) NULL)
		{
			strcpy (cname, ptr1 + 1);
		}
		else
		{
			strcpy (cname, cptr);
		}
	}
	else if (strmatch ("*<*>*", cptr) == 0)
	{
		/* <>ʳʸͥ褵 */
		ptr2 = strrchr (cptr, '<');
		if (ptr2 != (char *) NULL)
			*ptr2 = (char) NULL;
		if (strlen (cptr) <= 0)
			strcpy (cname, name);
		else
			strcpy (cname, cptr);
	}
	else
	{
		/* 嵭ʳϤΤޤ */
		strcpy (cname, cptr);
	}

	return (cname);
}

int cxpmail_title_view ()
{
	static int saveViewPoint = -1;
	int saveNumber;
	char *titlename[6];
	char name[256];
	char size[64];
	char date[256];
	int i, maxCount, index, number;
	struct tm *ltim;

	index = cxpmail->minfo.viewPoint;

	if (cxpmail->minfo.box[index] == (BoxInfo *) NULL)
		return (0);

	maxCount = cxpmail->minfo.box[index]->count;
	number = cxpmail->select_title;

	saveNumber = -1;
	if (saveViewPoint != -1)
	{
		if (saveViewPoint == index)
		{
			saveNumber =
				cxpmail->minfo.box[index]->mail[number -
								1]->no;
		}
	}
	saveViewPoint = index;

	/*  */
	sortTitleInfo (cxpmail->minfo.box[index], cxpmail->sortno);

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (cxpmail->list_title));

	/* ȥѹ */
	if (index <= 4)
	{
		gtk_clist_set_column_title (GTK_CLIST (cxpmail->list_title),
					    1, listtitle_change[index]);
	}
	else
	{
		gtk_clist_set_column_title (GTK_CLIST (cxpmail->list_title),
					    1, listtitle_change[5]);
	}

	gtk_clist_clear (GTK_CLIST (cxpmail->list_title));


#ifdef DEBUG
	fprintf (stdout, "index -> %d\n", index);
	fprintf (stdout, "maxCount -> %d\n", maxCount);
#endif

	for (i = 0; i < maxCount; i++)
	{

		sprintf (size, "%s",
			 (char *) getSize (cxpmail->minfo.box[index]->
					   mail[i]->size));

		ltim = (struct tm *)
			localtime (&
				   (cxpmail->minfo.box[index]->mail[i]->
				    date));
		sprintf (date, "%04dǯ%2d%2d %2d%2dʬ%2d",
			 ltim->tm_year + 1900, ltim->tm_mon + 1,
			 ltim->tm_mday, ltim->tm_hour, ltim->tm_min,
			 ltim->tm_sec);

		sprintf (name, "%s",
			 (char *) getName (cxpmail->minfo.box[index]->
					   mail[i]->name));

		titlename[0] = g_strdup (" ");
		titlename[1] = g_strdup (name);
		titlename[2] =
			g_strdup (cxpmail->minfo.box[index]->mail[i]->title);
		titlename[3] = g_strdup (size);
		titlename[4] = g_strdup (date);

		gtk_clist_append (GTK_CLIST (cxpmail->list_title), titlename);

		if (cxpmail->minfo.box[index]->mail[i]->mode == 0)
			gtk_clist_set_row_style (GTK_CLIST
						 (cxpmail->list_title), i,
						 cxpmail->styleBold);
		else
			gtk_clist_set_row_style (GTK_CLIST
						 (cxpmail->list_title), i,
						 cxpmail->styleNormal);
	}

#ifdef DEBUG
	fprintf (stdout, "saveNumber ==========> %d\n", saveNumber);
#endif

	if (saveNumber >= 0)
	{
		/* ֹ椫֤򻻽Ф */
		for (i = 0; i < maxCount; i++)
		{
#ifdef DEBUG
			fprintf (stdout,
				 "===== mail->no (%d) saveNumber (%d)\n",
				 cxpmail->minfo.box[index]->mail[i]->no,
				 saveNumber);
#endif
			if (cxpmail->minfo.box[index]->mail[i]->no ==
			    saveNumber)
				break;
		}

#ifdef DEBUG
		fprintf (stdout, "viewNumber ==========> %d\n", i);
#endif

		/* Ʊ֤ɽ */
		gtk_clist_select_row (GTK_CLIST (cxpmail->list_title), i, 0);
		if (i == 0)
		{
			gtk_clist_moveto (GTK_CLIST (cxpmail->list_title),
					  i, 0, (gfloat) 0, (gfloat) 0.0);
		}
		else
		{
			gtk_clist_moveto (GTK_CLIST (cxpmail->list_title),
					  i, 0, (gfloat) 0.5, (gfloat) 0.0);
		}

	}

	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (cxpmail->list_title));

}
