/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static char *mail_toolbar_title[12] = {
	"᡼",
	"",
	"",
	"",
	"ֿ",
	"ž",
	"",
	"ܺɽ",
	"ɥ쥹Ģ",
};

static char *mail_toolbar_tooltip[12] = {
	"᡼ޤ",
	"Ȣˤ᡼ޤ",
	"Фˤ᡼ޤ",
	"ȼƱ˼¹Ԥޤ",
	"пֿͤ᡼ޤ",
	"᡼žޤ",
	"򤵤Ƥ᡼ޤ",
	"򤵤Ƥ᡼ξܺپɽޤ",
	"ɥ쥹Ģưޤ",
};

static void mail_toolbar_function0 (GtkWidget * widget, gpointer data)
{
	cxpmailmessfunc_new ();
}

static void mail_toolbar_function1 (GtkWidget * widget, gpointer data)
{
	cxpmailtoolfunc_send ();
}

static void mail_toolbar_function2 (GtkWidget * widget, gpointer data)
{
	cxpmailtoolfunc_recv ();
}

static void mail_toolbar_function3 (GtkWidget * widget, gpointer data)
{
	cxpmailtoolfunc_send ();
	cxpmailtoolfunc_recv ();
}

static void mail_toolbar_function4 (GtkWidget * widget, gpointer data)
{
	cxpmailmessfunc_re ();
}

static void mail_toolbar_function5 (GtkWidget * widget, gpointer data)
{
	cxpmailmessfunc_fw ();
}

static void mail_toolbar_function6 (GtkWidget * widget, gpointer data)
{
	cxpmaileditfunc_delmail ();
}

static void mail_toolbar_function7 (GtkWidget * widget, gpointer data)
{
	cxpmailviewfunc_syousai ();
}

static void mail_toolbar_function8 (GtkWidget * widget, gpointer data)
{
	system ("cxpaddr &");
}

void cxpmail_tool_init ()
{
	GtkWidget *mail_handle_box;
	GtkWidget *mail_toolbar;
	GtkWidget *vbox;
	GtkWidget *separator;
	GtkWidget *menu_handle_box;
	GtkStyle *style;
	GtkWidget *pixmapwid;
	GdkBitmap *mask;
	GdkPixmap *pixmap;
	GtkWidget *item;
	int i;


	mail_handle_box = gtk_handle_box_new ();
	gtk_box_pack_start (GTK_BOX (cxpmail->vbox), mail_handle_box, FALSE,
			    TRUE, 0);
	gtk_widget_show (mail_handle_box);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (mail_handle_box), vbox);
	gtk_widget_show (vbox);

	separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
	gtk_widget_show (separator);

	mail_toolbar =
		gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL,
				 GTK_TOOLBAR_BOTH);
	gtk_box_pack_start (GTK_BOX (vbox), mail_toolbar, FALSE, FALSE, 0);
	gtk_toolbar_set_button_relief (GTK_TOOLBAR (mail_toolbar),
				       GTK_RELIEF_NONE);
	gtk_widget_show (mail_toolbar);

	separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
	gtk_widget_show (separator);

	style = gtk_widget_get_style (cxpmail->window);

	for (i = 0; i < 9; i++)
	{
		pixmap = gdk_pixmap_create_from_xpm (cxpmail->window->window,
						     &mask,
						     &style->
						     bg[GTK_STATE_NORMAL],
						     cxpmail->base.mail[i]);
		pixmapwid = gtk_pixmap_new (pixmap, mask);

		switch (i)
		{
		case 0:
			item = gtk_toolbar_append_item (GTK_TOOLBAR
							(mail_toolbar),
							mail_toolbar_title[i],
							mail_toolbar_tooltip
							[i], NULL, pixmapwid,
							mail_toolbar_function0,
							(gpointer) NULL);
			break;
		case 1:
			item = gtk_toolbar_append_item (GTK_TOOLBAR
							(mail_toolbar),
							mail_toolbar_title[i],
							mail_toolbar_tooltip
							[i], NULL, pixmapwid,
							mail_toolbar_function1,
							(gpointer) NULL);
			break;
		case 2:
			item = gtk_toolbar_append_item (GTK_TOOLBAR
							(mail_toolbar),
							mail_toolbar_title[i],
							mail_toolbar_tooltip
							[i], NULL, pixmapwid,
							mail_toolbar_function2,
							(gpointer) NULL);
			break;
		case 3:
			item = gtk_toolbar_append_item (GTK_TOOLBAR
							(mail_toolbar),
							mail_toolbar_title[i],
							mail_toolbar_tooltip
							[i], NULL, pixmapwid,
							mail_toolbar_function3,
							(gpointer) NULL);
			break;
		case 4:
			item = gtk_toolbar_append_item (GTK_TOOLBAR
							(mail_toolbar),
							mail_toolbar_title[i],
							mail_toolbar_tooltip
							[i], NULL, pixmapwid,
							mail_toolbar_function4,
							(gpointer) NULL);
			break;
		case 5:
			item = gtk_toolbar_append_item (GTK_TOOLBAR
							(mail_toolbar),
							mail_toolbar_title[i],
							mail_toolbar_tooltip
							[i], NULL, pixmapwid,
							mail_toolbar_function5,
							(gpointer) NULL);
			break;
		case 6:
			item = gtk_toolbar_append_item (GTK_TOOLBAR
							(mail_toolbar),
							mail_toolbar_title[i],
							mail_toolbar_tooltip
							[i], NULL, pixmapwid,
							mail_toolbar_function6,
							(gpointer) NULL);
			break;
		case 7:
			item = gtk_toolbar_append_item (GTK_TOOLBAR
							(mail_toolbar),
							mail_toolbar_title[i],
							mail_toolbar_tooltip
							[i], NULL, pixmapwid,
							mail_toolbar_function7,
							(gpointer) NULL);
			break;
		case 8:
			item = gtk_toolbar_append_item (GTK_TOOLBAR
							(mail_toolbar),
							mail_toolbar_title[i],
							mail_toolbar_tooltip
							[i], NULL, pixmapwid,
							mail_toolbar_function8,
							(gpointer) NULL);
			break;
		}
	}

}
