/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

extern CxpMail *cxpmail;

static int viewUserWin ();

static char *listtitle[2] = { "Ͽ̾",
	""
};


static int cinfoMaxNum;
static ConnectInfo cinfo[MAX_CONNECT_INFO];

static GtkWidget *userWin;
static GtkWidget *login_entry;
static GtkWidget *passwd_entry;
static GtkWidget *pop3NameEntry;
static GtkWidget *pop3PortEntry;
static GtkWidget *smtpNameEntry;
static GtkWidget *smtpPortEntry;
static GtkWidget *proxyCheckBtn;
static GtkWidget *proxyNameEntry;
static GtkWidget *proxyPortEntry;
static GtkWidget *userList;
static GtkWidget *addBtn;
static GtkWidget *modBtn;
static GtkWidget *delBtn;
static GtkWidget *setBtn;
static GtkWidget *canBtn;

static int selectNo;

static int listselection (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return (0);

	selectNo = row;

	/* 򤷤ǡɽ */
	gtk_entry_set_text (GTK_ENTRY (login_entry), cinfo[selectNo].login);
	gtk_entry_set_text (GTK_ENTRY (passwd_entry), cinfo[selectNo].passwd);
	gtk_entry_set_text (GTK_ENTRY (pop3NameEntry),
			    cinfo[selectNo].pop3.hostname);
	gtk_entry_set_text (GTK_ENTRY (pop3PortEntry),
			    cinfo[selectNo].pop3.portno);
	gtk_entry_set_text (GTK_ENTRY (smtpNameEntry),
			    cinfo[selectNo].smtp.hostname);
	gtk_entry_set_text (GTK_ENTRY (smtpPortEntry),
			    cinfo[selectNo].smtp.portno);
	gtk_entry_set_text (GTK_ENTRY (proxyNameEntry),
			    cinfo[selectNo].proxy.hostname);
	gtk_entry_set_text (GTK_ENTRY (proxyPortEntry),
			    cinfo[selectNo].proxy.portno);

	if (cinfo[selectNo].proxyFlag == 0)
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (proxyCheckBtn), 0);
		gtk_widget_set_sensitive (pop3NameEntry, TRUE);
		gtk_widget_set_sensitive (pop3PortEntry, TRUE);
		gtk_widget_set_sensitive (smtpNameEntry, TRUE);
		gtk_widget_set_sensitive (smtpPortEntry, TRUE);
		gtk_widget_set_sensitive (proxyNameEntry, FALSE);
		gtk_widget_set_sensitive (proxyPortEntry, FALSE);
	}
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (proxyCheckBtn), 1);
		gtk_widget_set_sensitive (pop3NameEntry, FALSE);
		gtk_widget_set_sensitive (pop3PortEntry, FALSE);
		gtk_widget_set_sensitive (smtpNameEntry, FALSE);
		gtk_widget_set_sensitive (smtpPortEntry, FALSE);
		gtk_widget_set_sensitive (proxyNameEntry, TRUE);
		gtk_widget_set_sensitive (proxyPortEntry, TRUE);
	}

	/* 򤷤ѹסֺפ򲡤褦 */
	/* ɲáפ򲡤ʤ褦ꤹ롣 */
	gtk_widget_set_sensitive (addBtn, FALSE);
	gtk_widget_set_sensitive (modBtn, TRUE);
	gtk_widget_set_sensitive (delBtn, TRUE);

#ifdef	DEBUG3
	fprintf (stdout, "listselection selectNo -> (%d)\n", selectNo);
#endif
}

static int listunselection (GtkWidget * clist, gint row, gint column,
			    GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return (0);

	selectNo = -1;

	/* ˤ */
	gtk_entry_set_text (GTK_ENTRY (login_entry), "");
	gtk_entry_set_text (GTK_ENTRY (passwd_entry), "");
	gtk_entry_set_text (GTK_ENTRY (pop3NameEntry), "");
	gtk_entry_set_text (GTK_ENTRY (pop3PortEntry), "110");
	gtk_entry_set_text (GTK_ENTRY (smtpNameEntry), "");
	gtk_entry_set_text (GTK_ENTRY (smtpPortEntry), "25");
	gtk_entry_set_text (GTK_ENTRY (proxyNameEntry), "");
	gtk_entry_set_text (GTK_ENTRY (proxyPortEntry), "8080");

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (proxyCheckBtn), 0);
	gtk_widget_set_sensitive (pop3NameEntry, TRUE);
	gtk_widget_set_sensitive (pop3PortEntry, TRUE);
	gtk_widget_set_sensitive (smtpNameEntry, TRUE);
	gtk_widget_set_sensitive (smtpPortEntry, TRUE);
	gtk_widget_set_sensitive (proxyNameEntry, FALSE);
	gtk_widget_set_sensitive (proxyPortEntry, FALSE);

	/* 줿ɲáפ򲡤褦 */
	/* ѹסֺפ򲡤ʤ褦ꤹ롣 */
	gtk_widget_set_sensitive (addBtn, TRUE);
	gtk_widget_set_sensitive (modBtn, FALSE);
	gtk_widget_set_sensitive (delBtn, FALSE);

#ifdef	DEBUG3
	fprintf (stdout, "listunselection selectNo -> (%d)\n", selectNo);
#endif
}

static void proxyChkBtnCallBack (GtkWidget * widget, gpointer data)
{
	if (GTK_TOGGLE_BUTTON (proxyCheckBtn)->active)
	{
	/*-- ON --*/
		gtk_widget_set_sensitive (pop3NameEntry, FALSE);
		gtk_widget_set_sensitive (pop3PortEntry, FALSE);
		gtk_widget_set_sensitive (smtpNameEntry, FALSE);
		gtk_widget_set_sensitive (smtpPortEntry, FALSE);
		gtk_widget_set_sensitive (proxyNameEntry, TRUE);
		gtk_widget_set_sensitive (proxyPortEntry, TRUE);
	}
	else
	{
	/*-- OFF --*/
		gtk_widget_set_sensitive (pop3NameEntry, TRUE);
		gtk_widget_set_sensitive (pop3PortEntry, TRUE);
		gtk_widget_set_sensitive (smtpNameEntry, TRUE);
		gtk_widget_set_sensitive (smtpPortEntry, TRUE);
		gtk_widget_set_sensitive (proxyNameEntry, FALSE);
		gtk_widget_set_sensitive (proxyPortEntry, FALSE);
	}
}

int checkData ()
{
	char *data;
	int check;
	int status;


	if (GTK_TOGGLE_BUTTON (proxyCheckBtn)->active)
		check = 1;
	else
		check = 0;


	/* ֤å */
	status = 0;
	if ((data = gtk_entry_get_text (GTK_ENTRY (login_entry))) == NULL)
		status = 1;
	else if (strlen (data) <= 0)
		status = 1;

	if ((data = gtk_entry_get_text (GTK_ENTRY (passwd_entry))) == NULL)
		status = 1;
	else if (strlen (data) <= 0)
		status = 1;

	if (check == 0)
	{
		if ((data =
		     gtk_entry_get_text (GTK_ENTRY (pop3NameEntry))) == NULL)
			status = 1;
		else if (strlen (data) <= 0)
			status = 1;

		if ((data =
		     gtk_entry_get_text (GTK_ENTRY (pop3PortEntry))) == NULL)
			status = 1;
		else if (strlen (data) <= 0)
			status = 1;

		if ((data =
		     gtk_entry_get_text (GTK_ENTRY (smtpNameEntry))) == NULL)
			status = 1;
		else if (strlen (data) <= 0)
			status = 1;

		if ((data =
		     gtk_entry_get_text (GTK_ENTRY (smtpPortEntry))) == NULL)
			status = 1;
		else if (strlen (data) <= 0)
			status = 1;
	}
	else
	{
		if ((data =
		     gtk_entry_get_text (GTK_ENTRY (proxyNameEntry))) == NULL)
			status = 1;
		else if (strlen (data) <= 0)
			status = 1;
		if ((data =
		     gtk_entry_get_text (GTK_ENTRY (proxyPortEntry))) == NULL)
			status = 1;
		else if (strlen (data) <= 0)
			status = 1;
	}

	return (status);
}


static int addFunction (GtkWidget * widget, GtkWidget * win)
{
	char *listname[2];
	char *data;
	int i;
	int status;
	int check;

	i = cinfoMaxNum;

	if (cinfoMaxNum + 1 > MAX_CONNECT_INFO)
	{
		create_messageWin (userWin,
				   "ȤϺ磳ޤǤǤ");
		return (0);
	}

	status = checkData ();
	if (status != 0)
	{
		create_messageWin (userWin,
				   "ϤƤʤս꤬١ɲäǤޤ");
		return (0);
	}

	if (GTK_TOGGLE_BUTTON (proxyCheckBtn)->active)
		check = 1;
	else
		check = 0;


	/* ɲä */
	if ((data = gtk_entry_get_text (GTK_ENTRY (login_entry))) == NULL)
		cinfo[i].login = (char *) NULL;
	else
		cinfo[i].login = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (passwd_entry))) == NULL)
		cinfo[i].passwd = (char *) NULL;
	else
		cinfo[i].passwd = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (pop3NameEntry))) == NULL)
		cinfo[i].pop3.hostname = (char *) NULL;
	else
		cinfo[i].pop3.hostname = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (pop3PortEntry))) == NULL)
		cinfo[i].pop3.portno = (char *) NULL;
	else
		cinfo[i].pop3.portno = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (smtpNameEntry))) == NULL)
		cinfo[i].smtp.hostname = (char *) NULL;
	else
		cinfo[i].smtp.hostname = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (smtpPortEntry))) == NULL)
		cinfo[i].smtp.portno = (char *) NULL;
	else
		cinfo[i].smtp.portno = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (proxyNameEntry))) == NULL)
		cinfo[i].proxy.hostname = (char *) NULL;
	else
		cinfo[i].proxy.hostname = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (proxyPortEntry))) == NULL)
		cinfo[i].proxy.portno = (char *) NULL;
	else
		cinfo[i].proxy.portno = g_strdup (data);

	cinfo[i].proxyFlag = check;

	cinfoMaxNum++;

	/* ꥹȤɲ */
	listname[0] = g_strdup (cinfo[i].login);
	gtk_clist_append (GTK_CLIST (userList), listname);
	gtk_clist_select_row (GTK_CLIST (userList), i, 0);

	return (0);
}

static int modFunction (GtkWidget * widget, GtkWidget * win)
{
	char *data;
	int i;
	int status;
	int check;

	i = selectNo;

	status = checkData ();
	if (status != 0)
	{
		create_messageWin (userWin,
				   "ϤƤʤս꤬١ѹǤޤ");
		return (0);
	}

	if (GTK_TOGGLE_BUTTON (proxyCheckBtn)->active)
		check = 1;
	else
		check = 0;


	/* ɲä */
	if ((data = gtk_entry_get_text (GTK_ENTRY (login_entry))) == NULL)
		cinfo[i].login = (char *) NULL;
	else
		cinfo[i].login = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (passwd_entry))) == NULL)
		cinfo[i].passwd = (char *) NULL;
	else
		cinfo[i].passwd = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (pop3NameEntry))) == NULL)
		cinfo[i].pop3.hostname = (char *) NULL;
	else
		cinfo[i].pop3.hostname = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (pop3PortEntry))) == NULL)
		cinfo[i].pop3.portno = (char *) NULL;
	else
		cinfo[i].pop3.portno = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (smtpNameEntry))) == NULL)
		cinfo[i].smtp.hostname = (char *) NULL;
	else
		cinfo[i].smtp.hostname = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (smtpPortEntry))) == NULL)
		cinfo[i].smtp.portno = (char *) NULL;
	else
		cinfo[i].smtp.portno = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (proxyNameEntry))) == NULL)
		cinfo[i].proxy.hostname = (char *) NULL;
	else
		cinfo[i].proxy.hostname = g_strdup (data);

	if ((data = gtk_entry_get_text (GTK_ENTRY (proxyPortEntry))) == NULL)
		cinfo[i].proxy.portno = (char *) NULL;
	else
		cinfo[i].proxy.portno = g_strdup (data);

	cinfo[i].proxyFlag = check;

	/* ꥹȤѹ */
	gtk_clist_set_text (GTK_CLIST (userList), i, 0, cinfo[i].login);
	gtk_clist_select_row (GTK_CLIST (userList), i, 0);

	return (0);
}

static int delFunction (GtkWidget * widget, GtkWidget * win)
{
	int i, k;

	i = selectNo;

	if (selectNo < 0)
	{
		create_messageWin (userWin,
				   "٤ˤϥȤ򤷤Ʋ");
		return (0);
	}


	for (k = i; k < cinfoMaxNum - 1; k++)
	{
		cinfo[k].login = g_strdup (cinfo[k + 1].login);
		cinfo[k].passwd = g_strdup (cinfo[k + 1].passwd);
		cinfo[k].pop3.hostname =
			g_strdup (cinfo[k + 1].pop3.hostname);
		cinfo[k].pop3.portno = g_strdup (cinfo[k + 1].pop3.portno);
		cinfo[k].smtp.hostname =
			g_strdup (cinfo[k + 1].smtp.hostname);
		cinfo[k].smtp.portno = g_strdup (cinfo[k + 1].smtp.portno);
		cinfo[k].proxy.hostname =
			g_strdup (cinfo[k + 1].proxy.hostname);
		cinfo[k].proxy.portno = g_strdup (cinfo[k + 1].proxy.portno);
		cinfo[k].proxyFlag = cinfo[k + 1].proxyFlag;
	}
	cinfo[k].login = (char *) NULL;
	cinfo[k].passwd = (char *) NULL;
	cinfo[k].pop3.hostname = (char *) NULL;
	cinfo[k].pop3.portno = (char *) NULL;
	cinfo[k].smtp.hostname = (char *) NULL;
	cinfo[k].smtp.portno = (char *) NULL;
	cinfo[k].proxy.hostname = (char *) NULL;
	cinfo[k].proxy.portno = (char *) NULL;
	cinfo[k].proxyFlag = 0;

	cinfoMaxNum--;
	if (cinfoMaxNum < 0)
		cinfoMaxNum = 0;

	gtk_clist_remove (GTK_CLIST (userList), selectNo);

	return (0);
}

static int setFunction (GtkWidget * widget, GtkWidget * win)
{
	int i;

	if (cinfoMaxNum <= 0)
	{
		create_messageWin (userWin,
				   "Ⱦ󤬣Ĥ⤢ޤϿƲ");
		return (0);
	}

	cxpmail->cinfoMaxNum = cinfoMaxNum;
	for (i = 0; i < cxpmail->cinfoMaxNum; i++)
	{
		cxpmail->cinfo[i].login = g_strdup (cinfo[i].login);
		cxpmail->cinfo[i].passwd = g_strdup (cinfo[i].passwd);
		cxpmail->cinfo[i].pop3.hostname =
			g_strdup (cinfo[i].pop3.hostname);
		cxpmail->cinfo[i].pop3.portno =
			g_strdup (cinfo[i].pop3.portno);
		cxpmail->cinfo[i].smtp.hostname =
			g_strdup (cinfo[i].smtp.hostname);
		cxpmail->cinfo[i].smtp.portno =
			g_strdup (cinfo[i].smtp.portno);
		cxpmail->cinfo[i].proxy.hostname =
			g_strdup (cinfo[i].proxy.hostname);
		cxpmail->cinfo[i].proxy.portno =
			g_strdup (cinfo[i].proxy.portno);
		cxpmail->cinfo[i].proxyFlag = cinfo[i].proxyFlag;
	}

	setNetConfig (&cxpmail->cinfoMaxNum, &cxpmail->cinfo, &cxpmail->my);

	gtk_widget_destroy (win);
}

static int cancelFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (win);
}

int create_userWin ()
{
	GtkWidget *vbox1;
	GtkWidget *label1;
	GtkWidget *hbox2;
	GtkWidget *hbox8;
	GtkWidget *vbox3;
	GtkWidget *label7;
	GtkWidget *label8;
	GtkWidget *label9;
	GtkWidget *label10;
	GtkWidget *label11;
	GtkWidget *label12;
	GtkWidget *vbox4;
	GtkWidget *hbox9;
	GtkWidget *label13;
	GtkWidget *hbox10;
	GtkWidget *label14;
	GtkWidget *hbox11;
	GtkWidget *label15;
	GtkWidget *vbox2;
	GtkWidget *hbox1;
	GtkWidget *swin;
	int x, y, w, h;
	int i;

	selectNo = -1;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	userWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (userWin), "userWin", userWin);
	gtk_window_set_title (GTK_WINDOW (userWin), "");
	gtk_widget_set_usize (userWin, 600, 240);
	gtk_window_set_default_size (GTK_WINDOW (userWin), 640, 240);

	gtk_widget_set_uposition (userWin, (x - 640 * 0.5), (y - 240 * 0.5));

	gtk_widget_show (userWin);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (userWin), vbox1);

	label1 = gtk_label_new ("");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "label1", label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 5);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 2);
	gtk_container_set_border_width (GTK_CONTAINER (hbox2), 5);

	hbox8 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox8);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "hbox8", hbox8,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox8);
	gtk_box_pack_start (GTK_BOX (hbox2), hbox8, FALSE, TRUE, 0);

	vbox3 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox3);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "vbox3", vbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox3);
	gtk_box_pack_start (GTK_BOX (hbox8), vbox3, FALSE, TRUE, 0);

	label7 = gtk_label_new ("̾");
	gtk_widget_ref (label7);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "label7", label7,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label7);
	gtk_box_pack_start (GTK_BOX (vbox3), label7, FALSE, FALSE, 0);

	label8 = gtk_label_new ("ѥɡ");
	gtk_widget_ref (label8);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "label8", label8,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label8);
	gtk_box_pack_start (GTK_BOX (vbox3), label8, FALSE, FALSE, 0);

	label9 = gtk_label_new ("POP3̾");
	gtk_widget_ref (label9);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "label9", label9,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label9);
	gtk_box_pack_start (GTK_BOX (vbox3), label9, FALSE, FALSE, 0);

	label10 = gtk_label_new ("SMTP̾");
	gtk_widget_ref (label10);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "label10", label10,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label10);
	gtk_box_pack_start (GTK_BOX (vbox3), label10, FALSE, FALSE, 0);

	label11 = gtk_label_new ("  ");
	gtk_widget_ref (label11);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "label11", label11,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label11);
	gtk_box_pack_start (GTK_BOX (vbox3), label11, FALSE, FALSE, 0);

	label12 = gtk_label_new ("Proxy̾");
	gtk_widget_ref (label12);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "label12", label12,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label12);
	gtk_box_pack_start (GTK_BOX (vbox3), label12, FALSE, FALSE, 0);

	vbox4 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox4);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "vbox4", vbox4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox4);
	gtk_box_pack_start (GTK_BOX (hbox8), vbox4, FALSE, TRUE, 0);

	login_entry = gtk_entry_new ();
	gtk_widget_ref (login_entry);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "login_entry",
				  login_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (login_entry);
	gtk_box_pack_start (GTK_BOX (vbox4), login_entry, TRUE, TRUE, 0);

	passwd_entry = gtk_entry_new ();
	gtk_widget_ref (passwd_entry);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "passwd_entry",
				  passwd_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (passwd_entry);
	gtk_box_pack_start (GTK_BOX (vbox4), passwd_entry, TRUE, TRUE, 0);

	hbox9 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox9);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "hbox9", hbox9,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox9);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox9, FALSE, FALSE, 0);

	pop3NameEntry = gtk_entry_new ();
	gtk_widget_ref (pop3NameEntry);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "pop3NameEntry",
				  pop3NameEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pop3NameEntry);
	gtk_box_pack_start (GTK_BOX (hbox9), pop3NameEntry, TRUE, TRUE, 0);
	gtk_widget_set_usize (pop3NameEntry, 150, -2);

	label13 = gtk_label_new ("ݡֹ");
	gtk_widget_ref (label13);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "label13", label13,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label13);
	gtk_box_pack_start (GTK_BOX (hbox9), label13, FALSE, FALSE, 3);

	pop3PortEntry = gtk_entry_new_with_max_length (6);
	gtk_widget_ref (pop3PortEntry);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "pop3PortEntry",
				  pop3PortEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pop3PortEntry);
	gtk_box_pack_start (GTK_BOX (hbox9), pop3PortEntry, FALSE, TRUE, 0);
	gtk_widget_set_usize (pop3PortEntry, 40, -2);
	gtk_entry_set_text (GTK_ENTRY (pop3PortEntry), "110");

	hbox10 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox10);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "hbox10", hbox10,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox10);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox10, FALSE, FALSE, 0);

	smtpNameEntry = gtk_entry_new ();
	gtk_widget_ref (smtpNameEntry);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "smtpNameEntry",
				  smtpNameEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (smtpNameEntry);
	gtk_box_pack_start (GTK_BOX (hbox10), smtpNameEntry, TRUE, TRUE, 0);
	gtk_widget_set_usize (smtpNameEntry, 150, -2);

	label14 = gtk_label_new ("ݡֹ");
	gtk_widget_ref (label14);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "label14", label14,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label14);
	gtk_box_pack_start (GTK_BOX (hbox10), label14, FALSE, FALSE, 3);

	smtpPortEntry = gtk_entry_new_with_max_length (6);
	gtk_widget_ref (smtpPortEntry);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "smtpPortEntry",
				  smtpPortEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (smtpPortEntry);
	gtk_box_pack_start (GTK_BOX (hbox10), smtpPortEntry, FALSE, TRUE, 0);
	gtk_widget_set_usize (smtpPortEntry, 40, -2);
	gtk_entry_set_text (GTK_ENTRY (smtpPortEntry), "25");

	proxyCheckBtn =
		gtk_check_button_new_with_label ("Proxyзͳ³");
	gtk_widget_ref (proxyCheckBtn);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "proxyCheckBtn",
				  proxyCheckBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (proxyCheckBtn);
	gtk_box_pack_start (GTK_BOX (vbox4), proxyCheckBtn, TRUE, FALSE, 0);

	hbox11 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox11);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "hbox11", hbox11,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox11);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox11, FALSE, FALSE, 0);

	proxyNameEntry = gtk_entry_new ();
	gtk_widget_ref (proxyNameEntry);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "proxyNameEntry",
				  proxyNameEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (proxyNameEntry);
	gtk_box_pack_start (GTK_BOX (hbox11), proxyNameEntry, TRUE, TRUE, 0);
	gtk_widget_set_usize (proxyNameEntry, 150, -2);

	label15 = gtk_label_new ("ݡֹ");
	gtk_widget_ref (label15);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "label15", label15,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label15);
	gtk_box_pack_start (GTK_BOX (hbox11), label15, FALSE, FALSE, 3);

	proxyPortEntry = gtk_entry_new_with_max_length (6);
	gtk_widget_ref (proxyPortEntry);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "proxyPortEntry",
				  proxyPortEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (proxyPortEntry);
	gtk_box_pack_start (GTK_BOX (hbox11), proxyPortEntry, FALSE, TRUE, 0);
	gtk_widget_set_usize (proxyPortEntry, 40, -2);
	gtk_entry_set_text (GTK_ENTRY (proxyPortEntry), "8080");

	vbox2 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "vbox2", vbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox2), vbox2, FALSE, TRUE, 10);

	addBtn = gtk_button_new_with_label (" ɲ ");
	gtk_widget_ref (addBtn);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "addBtn", addBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (addBtn);
	gtk_box_pack_start (GTK_BOX (vbox2), addBtn, FALSE, FALSE, 0);

	modBtn = gtk_button_new_with_label (" ѹ ");
	gtk_widget_ref (modBtn);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "modBtn", modBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (modBtn);
	gtk_box_pack_start (GTK_BOX (vbox2), modBtn, FALSE, FALSE, 0);

	delBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (delBtn);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "delBtn", delBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (delBtn);
	gtk_box_pack_start (GTK_BOX (vbox2), delBtn, FALSE, FALSE, 0);

	swin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_show (swin);
	userList = gtk_clist_new_with_titles (1, listtitle);
	gtk_widget_set_usize (userList, 250, 150);
	gtk_clist_set_selection_mode (GTK_CLIST (userList),
				      GTK_SELECTION_SINGLE);
	gtk_signal_connect (GTK_OBJECT (userList), "select_row",
			    GTK_SIGNAL_FUNC (listselection), NULL);
	gtk_signal_connect (GTK_OBJECT (userList), "unselect_row",
			    GTK_SIGNAL_FUNC (listunselection), NULL);
	gtk_container_add (GTK_CONTAINER (swin), userList);
	gtk_widget_show (userList);
	gtk_box_pack_start (GTK_BOX (hbox2), swin, TRUE, TRUE, 0);

	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox1), 10);

	setBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (setBtn);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "setBtn", setBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (setBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), setBtn, FALSE, FALSE, 0);

	canBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (canBtn);
	gtk_object_set_data_full (GTK_OBJECT (userWin), "canBtn", canBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (canBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), canBtn, FALSE, FALSE, 0);


	/* åܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (proxyCheckBtn), "toggled",
				   (GtkSignalFunc) proxyChkBtnCallBack, NULL);

	/* ɲåХå */
	gtk_signal_connect (GTK_OBJECT (addBtn), "clicked",
			    (GtkSignalFunc) addFunction, userWin);

	/* ѹХå */
	gtk_signal_connect (GTK_OBJECT (modBtn), "clicked",
			    (GtkSignalFunc) modFunction, userWin);

	/* Хå */
	gtk_signal_connect (GTK_OBJECT (delBtn), "clicked",
			    (GtkSignalFunc) delFunction, userWin);


	/* ꥳХå */
	gtk_signal_connect (GTK_OBJECT (setBtn), "clicked",
			    (GtkSignalFunc) setFunction, userWin);

	/* åХå */
	gtk_signal_connect (GTK_OBJECT (canBtn), "clicked",
			    (GtkSignalFunc) cancelFunction, userWin);

	/* ѥɤɬ*****ɽˤ */
	gtk_entry_set_visibility (GTK_ENTRY (passwd_entry), FALSE);

	cinfoMaxNum = 0;
	memset (cinfo, 0x00, sizeof (ConnectInfo) * MAX_CONNECT_INFO);

	cinfoMaxNum = cxpmail->cinfoMaxNum;
	for (i = 0; i < cxpmail->cinfoMaxNum; i++)
	{
		cinfo[i].login = g_strdup (cxpmail->cinfo[i].login);
		cinfo[i].passwd = g_strdup (cxpmail->cinfo[i].passwd);
		cinfo[i].pop3.hostname =
			g_strdup (cxpmail->cinfo[i].pop3.hostname);
		cinfo[i].pop3.portno =
			g_strdup (cxpmail->cinfo[i].pop3.portno);
		cinfo[i].smtp.hostname =
			g_strdup (cxpmail->cinfo[i].smtp.hostname);
		cinfo[i].smtp.portno =
			g_strdup (cxpmail->cinfo[i].smtp.portno);
		cinfo[i].proxy.hostname =
			g_strdup (cxpmail->cinfo[i].proxy.hostname);
		cinfo[i].proxy.portno =
			g_strdup (cxpmail->cinfo[i].proxy.portno);
		cinfo[i].proxyFlag = cxpmail->cinfo[i].proxyFlag;
	}

	/* ɲáפ򲡤褦ˡѹסֺפ򲡤ʤ褦 */
	gtk_widget_set_sensitive (addBtn, TRUE);
	gtk_widget_set_sensitive (modBtn, FALSE);
	gtk_widget_set_sensitive (delBtn, FALSE);


	viewUserWin ();
}

static int viewUserWin ()
{
	int i;
	char *listname[2];

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (userList));

	/* ꥹȥꥢ */
	gtk_clist_clear (GTK_CLIST (userList));

	for (i = 0; i < cinfoMaxNum; i++)
	{
		listname[0] = g_strdup (cinfo[i].login);
		gtk_clist_append (GTK_CLIST (userList), listname);
	}

	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (userList));

}
