/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmail.h"

static GtkWidget *workingWin = (GtkWidget *) NULL;
static GtkWidget *messageLabel;
static GtkWidget *progState;
static GtkWidget *canBtn;
static char _workingMessage[1024];
static int _workingTimer;

static gint modifyWorkingWindow (gpointer data)
{
	static char _BackupMessage[1024];

	if (workingWin != (GtkWidget *) NULL)
	{
		if (strcmp (_workingMessage, _BackupMessage) != 0)
		{
			gtk_label_set_text (GTK_LABEL (messageLabel),
					    _workingMessage);
			strcpy (_BackupMessage, _workingMessage);
		}
	}
	else
	{
		gtk_timeout_remove (_workingTimer);
		_workingTimer = 0;
	}

	return TRUE;
}

static int cancelFunction (GtkWidget * widget, gpointer data)
{
	gtk_widget_destroy (workingWin);
	workingWin = (GtkWidget *) NULL;
}

int create_working (GtkWidget * owner, char *title, char *message)
{
	GtkWidget *hbox1;
	GtkWidget *vbox1;
	GtkWidget *hbox2;
	int x, y, w, h;

	if (workingWin != (GtkWidget *) NULL)
	{
		destroy_working_window ();
	}

	_workingTimer = 0;
	memset (_workingMessage, 0x00, sizeof (_workingMessage));

#if 0
	gdk_window_get_origin (owner->window, &x, &y);
	gdk_window_get_size (owner->window, &w, &h);
#else
	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;
#endif

	workingWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (workingWin), "workingWin",
			     workingWin);
	gtk_window_set_title (GTK_WINDOW (workingWin), title);
	gtk_widget_set_usize (workingWin, 100, 100);
	gtk_window_set_default_size (GTK_WINDOW (workingWin), 400, 120);

#if 0
	gtk_widget_set_uposition (workingWin,
				  (x + (w / 2)) - (400 / 2),
				  (y + (h / 2)) - (120 / 2));
#else
	gtk_widget_set_uposition (workingWin, (x - 400 * 0.5),
				  (y - 240 * 0.5));
#endif

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (workingWin), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_container_add (GTK_CONTAINER (workingWin), hbox1);
	gtk_container_set_border_width (GTK_CONTAINER (hbox1), 10);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (workingWin), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox1, TRUE, TRUE, 0);

	messageLabel = gtk_label_new (message);
	gtk_widget_ref (messageLabel);
	gtk_object_set_data_full (GTK_OBJECT (workingWin), "messageLabel",
				  messageLabel,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (messageLabel);
	gtk_box_pack_start (GTK_BOX (vbox1), messageLabel, FALSE, FALSE, 10);

#if 0
	progState = gtk_progress_bar_new ();
	gtk_widget_ref (progState);
	gtk_object_set_data_full (GTK_OBJECT (workingWin), "progState",
				  progState,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (progState);
	gtk_box_pack_start (GTK_BOX (vbox1), progState, FALSE, FALSE, 0);
	gtk_progress_configure (GTK_PROGRESS (progState), 100, 100, 100);
	gtk_progress_set_show_text (GTK_PROGRESS (progState), TRUE);
#endif

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (workingWin), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 8);

	canBtn = gtk_button_new_with_label (" Ĥ ");
	gtk_widget_ref (canBtn);
	gtk_object_set_data_full (GTK_OBJECT (workingWin), "canBtn", canBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect (GTK_OBJECT (canBtn), "clicked",
			    (GtkSignalFunc) cancelFunction, NULL);

	gtk_widget_show (canBtn);
	gtk_box_pack_start (GTK_BOX (hbox2), canBtn, TRUE, FALSE, 0);

	gtk_widget_show (workingWin);

	_workingTimer =
		gtk_timeout_add (100, (GtkFunction) modifyWorkingWindow,
				 workingWin);

}

/* åꤹ */
int set_working_message (char *message)
{
	if (workingWin != (GtkWidget *) NULL)
	{
		strcpy (_workingMessage, message);
	}
}

/* ץ쥹ơꤹ */
int set_working_state (int minState, int maxState, int nowState)
{
	;
}

/* ɥĤ */
int destroy_working_window ()
{

	if (workingWin != (GtkWidget *) NULL)
		gtk_widget_destroy (workingWin);

	workingWin = (GtkWidget *) NULL;
}
