/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmanager.h"

CxpManager *cxpmanager;

pthread_mutex_t lockFlag;

extern int cxpmanager_deviceconf ();
extern int cxpmanager_calenconf ();

main (int argc, char *argv[])
{
	pthread_t threadid_device;
	pthread_t threadid_calen;
	int sockno;

#ifdef	DEBUG8
	fprintf (stdout, "cxpmanager start ...\n");
#endif

	/* 饤ȤȤƥСȤ³ߤ */
	sockno = cxpsocket_cliconnect ();

#ifdef	DEBUG8
	fprintf (stdout, "sockno => %d\n", sockno);
#endif

	if (sockno > 0)
	{
#ifdef	DEBUG8
		fprintf (stdout, "CxpmanagerưƤ...\n");
#endif
		/* ³ǤϥФ˵ưƤΤǽλ */
		cxpsocket_cliclose (sockno);
		exit (0);
	}

	CxpBasePathInit ();

	cxpmanager = (CxpManager *) g_malloc (sizeof (CxpManager));
	memset (cxpmanager, 0x00, sizeof (CxpManager));

	/* ưɣĤμ */
	cxpmanager->uid = getuid ();
	cxpmanager->gid = getgid ();
	cxpmanager->pid = getpid ();

	/* ١ɤ߹ */
	getBaseConfig (&cxpmanager->base);

	/* ǥХɤ߹ */
	getDeviceConfig (&cxpmanager->devinf);

	/* åɽ */
	pthread_mutex_init (&lockFlag, NULL);


	/* ǥХ󹹿򥹥åɤư */
	pthread_create (&threadid_device, (const pthread_attr_t *) NULL,
			(void *) cxpmanager_deviceconf, NULL);

	/* 塼򥹥åɤư */
	pthread_create (&threadid_calen, (const pthread_attr_t *) NULL,
			(void *) cxpmanager_calenconf, NULL);


	/* ᥤγ */
	cxpsocket_serverstart ();

#ifdef	DEBUG8
	fprintf (stdout, "cxpmanager stop ...\n");
#endif

	exit (0);
}
