/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmanager.h"

extern CxpManager *cxpmanager;

int cxpmanager_calenconf ()
{
	time_t savetime_sch;
	time_t savetime_todo;
	struct stat fileinfo;
	Day *dayInfo;
	char filename[1024];
	char kindbuff[1024];
	char message[2048];
	int year, month, day, hour, min;
	int i, m, d, h, ken;
	int status;

	savetime_sch = (time_t) 0;
	savetime_todo = (time_t) 0;

	/*  */
	memset (&cxpmanager->view, 0x00, sizeof (ViewData));
	memset (&cxpmanager->sch, 0x00, sizeof (Year));
	memset (&cxpmanager->todo, 0x00, sizeof (Todo));

	cxpmanager->chkdata_num = 0;
	memset (&cxpmanager->chkdata, 0x00,
		sizeof (ScduInfo) * MAX_CHECKSCD_NUM);
	cxpmanager->chktodo_num = 0;
	memset (&cxpmanager->chktodo, 0x00,
		sizeof (ScduInfo) * MAX_CHECKTODO_NUM);

	while (1)
	{
		/* Ū˥塼åƤɤ߹ */
		sleep (20);

		/* ߤǯʬä */
		cxpmanager_getsystemdate (&year, &month, &day, &hour, &min);

		/* 塼 */
		sprintf (filename, "%s/.cxp/schedule/view.dat",
			 getenv ("HOME"));
		if (!access (filename, F_OK))
		{

			/* ̾ɤ߹ */
			memset (&cxpmanager->view, 0x00, sizeof (ViewData));
			getCalenDataView (&cxpmanager->view);

			/* ƥ塼뤬Ƥ뤫å */
			status = 0;
			for (i = 0; i < cxpmanager->view.kensu; i++)
			{
				switch (cxpmanager->view.view[i].kind)
				{
				default:
				case 0:
					sprintf (kindbuff, "mine");
					break;
				case 1:
					sprintf (kindbuff, "work");
					break;
				case 2:
					sprintf (kindbuff, "taste");
					break;
				case 3:
					sprintf (kindbuff, "play");
					break;
				case 4:
					sprintf (kindbuff, "other");
					break;
				}
				sprintf (filename,
					 "%s/.cxp/schedule/%s/%s/%04d.dat",
					 getenv ("HOME"), kindbuff,
					 cxpmanager->view.view[i].title,
					 year);
				stat (filename, &fileinfo);
				if (fileinfo.st_mtime > savetime_sch)
				{
					savetime_sch = fileinfo.st_mtime;
					status++;
				}
			}

			/* 깹ƤϽ */
			if (status > 0)
			{
#ifdef	DEBUG10
				fprintf (stdout,
					 "塼뤬ޤ %4d/%2d/%2d %2d:%2d\n",
					 year, month, day, hour, min);
#endif
				ken = 0;
				cxpmanager->chkdata_num = 0;
				memset (&cxpmanager->chkdata, 0x00,
					sizeof (ScduInfo) * MAX_CHECKSCD_NUM);

				/* ɤ߹ե뤫餽줾ǯξߤη */
				/* γƥ塼ꥹȤΥ顼ꤵƤǡ */
				for (i = 0; i < cxpmanager->view.kensu; i++)
				{
					memset (&cxpmanager->sch, 0x00,
						sizeof (Year));
					getCalenDataSchedule (year,
							      &cxpmanager->
							      view.view[i],
							      &cxpmanager->
							      sch);

					for (m = month - 1;
					     m < MAX_CALEN_MONTH; m++)
						for (d = 0; d < MAX_CALEN_DAY;
						     d++)
						{
							dayInfo =
								(Day *) &
								cxpmanager->
								sch.month[m].
								day[d];
							for (h = 0;
							     h <
							     dayInfo->kensu;
							     h++)
							{

#ifdef	DEBUG10
								fprintf (stdout, "    dayInfo->info[%d].alarm.mode => %d\n", h, dayInfo->info[h].alarm.mode);
#endif
								if (dayInfo->
								    info[h].
								    alarm.
								    mode == 1)
								{
									cxpmanager->
										chkdata
										[ken].
										title
										=
										g_strdup
										(dayInfo->
										 info
										 [h].
										 title);
									cxpmanager->
										chkdata
										[ken].
										alarm.
										year
										=
										dayInfo->
										info
										[h].
										alarm.
										year;
									cxpmanager->
										chkdata
										[ken].
										alarm.
										month
										=
										dayInfo->
										info
										[h].
										alarm.
										month;
									cxpmanager->
										chkdata
										[ken].
										alarm.
										day
										=
										dayInfo->
										info
										[h].
										alarm.
										day;
									cxpmanager->
										chkdata
										[ken].
										alarm.
										hour
										=
										dayInfo->
										info
										[h].
										alarm.
										hour;
									cxpmanager->
										chkdata
										[ken].
										alarm.
										min
										=
										dayInfo->
										info
										[h].
										alarm.
										min;
									ken++;
									if (ken + 1 >= MAX_CHECKSCD_NUM)
										break;
								}
							}
							if (ken + 1 >=
							    MAX_CHECKSCD_NUM)
								break;
						}
					if (ken + 1 >= MAX_CHECKSCD_NUM)
						break;
				}

				cxpmanager->chkdata_num = ken;
			}
		}


		/* ToDo */
		sprintf (filename, "%s/.cxp/todo/todo.dat", getenv ("HOME"));
		if (!access (filename, F_OK))
		{
			/* ե뤬¸ߤˤϹ֤å */
			status = 0;
			sprintf (filename, "%s/.cxp/todo/todo.dat",
				 getenv ("HOME"));
			stat (filename, &fileinfo);
			if (fileinfo.st_mtime > savetime_todo)
			{
				savetime_todo = fileinfo.st_mtime;
				status++;
			}

			/* ե뤬Ƥˤɤ߹ */
			if (status > 0)
			{
#ifdef	DEBUG10
				fprintf (stdout,
					 "ToDoޤ %4d/%2d/%2d %2d:%2d\n",
					 year, month, day, hour, min);
#endif
				memset (&cxpmanager->todo, 0x00,
					sizeof (Todo));
				/* ToDoǡɤ߹ */
				getCalenDataTodo (&cxpmanager->todo);

				ken = 0;
				cxpmanager->chktodo_num = 0;
				memset (&cxpmanager->chktodo, 0x00,
					sizeof (ScduInfo) *
					MAX_CHECKTODO_NUM);
				for (i = 0; i < cxpmanager->todo.kensu; i++)
				{
					/* ɤ߹ǡ鸽ߤǯΥǡǥ顼 */
					/* ꤵƤǡΤ߼ */

					if (cxpmanager->todo.item[i].alarm.
					    mode == 1)
					{
						cxpmanager->chktodo[ken].
							title =
							g_strdup (cxpmanager->
								  todo.
								  item[i].
								  data);
						cxpmanager->chktodo[ken].
							alarm.year =
							cxpmanager->todo.
							item[i].alarm.year;
						cxpmanager->chktodo[ken].
							alarm.month =
							cxpmanager->todo.
							item[i].alarm.month;
						cxpmanager->chktodo[ken].
							alarm.day =
							cxpmanager->todo.
							item[i].alarm.day;
						cxpmanager->chktodo[ken].
							alarm.hour =
							cxpmanager->todo.
							item[i].alarm.hour;
						cxpmanager->chktodo[ken].
							alarm.min =
							cxpmanager->todo.
							item[i].alarm.min;
						ken++;
					}
				}
				cxpmanager->chktodo_num = ken;
			}
		}

#ifdef	DEBUG10
		fprintf (stdout, "cxpmanager->chkdata_num => %d\n",
			 cxpmanager->chkdata_num);
		fprintf (stdout, "cxpmanager->chktodo_num => %d\n",
			 cxpmanager->chktodo_num);
		fprintf (stdout, "current time %04d/%02d/%02d %02d:%02d\n",
			 year, month, day, hour, min);
#endif

		/* 嵭Υ塼ڤToDoꥹȤ鸽ߤǯʬפƤ */
		/* Хåɽ */
		status = 0;
		for (i = 0; i < cxpmanager->chkdata_num; i++)
		{

#ifdef	DEBUG10
			fprintf (stdout,
				 "    data => %04d/%02d/%02d %02d:%02d title => [%s]\n",
				 cxpmanager->chkdata[i].alarm.year,
				 cxpmanager->chkdata[i].alarm.month,
				 cxpmanager->chkdata[i].alarm.day,
				 cxpmanager->chkdata[i].alarm.hour,
				 cxpmanager->chkdata[i].alarm.min,
				 cxpmanager->chkdata[i].title);
#endif
			if ((cxpmanager->chkdata[i].alarm.year == year)
			    && (cxpmanager->chkdata[i].alarm.month == month)
			    && (cxpmanager->chkdata[i].alarm.day == day)
			    && (cxpmanager->chkdata[i].alarm.hour == hour)
			    && (cxpmanager->chkdata[i].alarm.min == min))
			{
				sprintf (message,
					 "cxpmessage -bell -autoexit \"%s\" &",
					 cxpmanager->chkdata[i].title);
				system (message);

				status++;
			}
		}
		for (i = 0; i < cxpmanager->chktodo_num; i++)
		{
			if ((cxpmanager->chktodo[i].alarm.year == year)
			    && (cxpmanager->chktodo[i].alarm.month == month)
			    && (cxpmanager->chktodo[i].alarm.day == day)
			    && (cxpmanager->chktodo[i].alarm.hour == hour)
			    && (cxpmanager->chktodo[i].alarm.min == min))
			{
				sprintf (message,
					 "cxpmessage -bell -autoexit \"%s\" &",
					 cxpmanager->chktodo[i].title);
				system (message);

				status++;
			}
		}

		if (status > 0)
		{
			/* Ǥåɽǥ쥤 */
			sleep (41);
		}
	}
}
