/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmanager.h"

extern CxpManager *cxpmanager;

static int SettingDeviceInfomation ();

int cxpmanager_deviceconf ()
{
	DeviceInfo devinf;
	char userdevice[1024];
	struct stat checkinfo;
	int i;

#ifdef	DEBUG8
	fprintf (stdout, "cxpmanager_deviceconf start ...\n");
#endif

	sprintf (userdevice, "%s/.cxp/lib/device.cfg",
		 (char *) getenv ("HOME"));

	/* Υץˤϸ¤Ϳ */
	setuid (0);
	setgid (0);

#ifdef	DEBUG8
	fprintf (stdout, "ǥХμ...\n");
#endif

	/* ȰۤʤϥǥХե˵ܤƤǥХ */
	/* ѡߥåѹ */
	getDeviceConfig (&devinf);

#ifdef	DEBUG8
	fprintf (stdout, "ǥХѹ...\n");
#endif
	for (i = 0; i < devinf.device_kensu; i++)
	{
		/* üեΤߥѡߥåѹ */
		if (access (devinf.device[i].path, F_OK))
			continue;

		/* ǥХեξ */
		stat (devinf.device[i].path, &checkinfo);

		if (S_ISCHR (checkinfo.st_mode)
		    || S_ISBLK (checkinfo.st_mode))
		{
#ifdef	DEBUG8
			fprintf (stdout, "Υեüե[%s]\n",
				 devinf.device[i].path);
#endif
			/* ǥХΥѡߥåѹ */
			SettingDeviceInfomation (devinf.device[i].path);
		}
	}

#ifdef	DEBUG8
	fprintf (stdout, "cxpmanager_deviceconf end ...\n");
#endif

}

static int SettingDeviceInfomation (char *devname)
{
	int i;
	int status;
	mode_t modedata;

	if (!access (devname, F_OK))
	{
		/* ǥХν񤭹ߵĤƤΥ桼Ϳ */
		/* äȤ襤... */
		/* ̤ˡˤϢ... */

/********************************************************************
S_IRUSR (S_IREAD)  00400 ͭ(owner)ˤɤ߼(read)
S_IWUSR (S_IWRITE) 00200 ͭԤˤ񤭹(write)
S_IXUSR (S_IEXEC)  00100 ͭԤˤ¹(execute)/(search)
S_IRGRP            00040 롼פˤɤ߼
S_IWGRP            00020 롼פˤ񤭹
S_IXGRP            00010 롼פˤ¹/
S_IROTH            00004 ¾(others)ˤɤ߼
S_IWOTH            00002 ¾ͤˤ񤭹
S_IXOTH            00001 ¾ͤˤ¹/
********************************************************************/

		modedata =
			S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH |
			S_IWOTH;

		/* ⡼ɤѹ */
		status = chmod (devname, modedata);

	}
}
