/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmessage.h"

CxpMessage *cxpmessage;

extern int cxpmessageTimer ();

int main (int argc, char *argv[])
{
	int i;
	int bellFlag;
	int sleepFlag;
	int autoExitFlag;
	char *message;

	bellFlag = 0;
	sleepFlag = 0;
	autoExitFlag = 0;
	message = (char *) NULL;

	for (i = 1; i < argc; i++)
	{
		if (strcmp (argv[i], "-bell") == 0)
		{
			bellFlag = 1;
			continue;
		}

		if (strcmp (argv[i], "-sleep") == 0)
		{
			if (i + 1 >= argc)
			{
				exit (0);
			}
			sleepFlag = atoi (argv[i + 1]);
			i++;
			continue;
		}

		if (strcmp (argv[i], "-autoexit") == 0)
		{
			autoExitFlag = 1;
			continue;
		}

		if (strncmp (argv[i], "-", 1) == 0)
		{
			exit (0);
		}

		message = argv[i];
	}

	if (sleepFlag > 0)
		sleep (sleepFlag);

	if (bellFlag > 0)
	{
		/* ٥Ĥ餹 */
		;
		;
		;		/* ν v2.0.0 Ȥ߹ */
		;
		;
	}

	CxpBasePathInit ();

	/* ޥ͡㵯ư */
	cxp_manager_start ();

	cxpmessage = (CxpMessage *) g_malloc (sizeof (CxpMessage));

	/* ꥢ */
	memset (cxpmessage, 0x00, sizeof (CxpMessage));

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	/* åɽ */
	message_view (message);

	if (autoExitFlag > 0)
	{
		/* äΥॢ */
		gtk_timeout_add (1000, (GtkFunction) cxpmessageTimer,
				 cxpmessage->window);
	}

	gtk_main ();
	exit (0);
}
