/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpmessage.h"

extern CxpMessage *cxpmessage;

extern int cxpmessageExitFunc ();

int message_view (char *message)
{
	GtkWidget *window;
	GtkWidget *vbox1;
	GtkWidget *messageLabel;
	GtkWidget *hbox3;
	GtkWidget *calBtn;
	int x, y, w, h;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	cxpmessage->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (cxpmessage->window), "window",
			     cxpmessage->window);
	gtk_widget_set_usize (cxpmessage->window, 440, 100);
	gtk_window_set_title (GTK_WINDOW (cxpmessage->window), "å");
	gtk_signal_connect (GTK_OBJECT (cxpmessage->window), "destroy",
			    GTK_SIGNAL_FUNC (cxpmessageExitFunc), NULL);
	gtk_widget_set_uposition (cxpmessage->window, (x - 440 * 0.5),
				  (y - 100 * 0.5));

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxpmessage->window), "vbox1",
				  vbox1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (cxpmessage->window), vbox1);

	if (message == (char *) NULL)
		messageLabel = gtk_label_new ("cxpmessage ʸ ");
	else if (strlen (message) <= 0)
		messageLabel = gtk_label_new ("cxpmessage ʸ ");
	else
		messageLabel = gtk_label_new (message);

	gtk_widget_ref (messageLabel);
	gtk_object_set_data_full (GTK_OBJECT (cxpmessage->window),
				  "messageLabel", messageLabel,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (messageLabel);
	gtk_box_pack_start (GTK_BOX (vbox1), messageLabel, TRUE, TRUE, 0);
	gtk_label_set_line_wrap (GTK_LABEL (messageLabel), TRUE);

	hbox3 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (cxpmessage->window), "hbox3",
				  hbox3, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, TRUE, 5);

	calBtn = gtk_button_new_with_label (" Ĥ ");
	gtk_widget_ref (calBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpmessage->window), "calBtn",
				  calBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (calBtn);
	gtk_box_pack_start (GTK_BOX (hbox3), calBtn, FALSE, FALSE, 0);

	gtk_signal_connect (GTK_OBJECT (calBtn), "clicked",
			    (GtkSignalFunc) cxpmessageExitFunc, NULL);

	gtk_widget_show (cxpmessage->window);
}
