/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

CxpNote *cxpnote;

extern void cxpnote_closefunc ();

static int colorFlag;
static int largeFlag;

int exitfunc ()
{
	int x, y, w, h;
	int xymode, whmode;

#if 0				/* window˲ƤΤGtkWindow */
	gdk_window_get_position (cxpnote->window->window, &x, &y);
	gdk_window_get_size (cxpnote->window->window, &w, &h);
	setGeometryInfo (CXPNOTE_MODE, x, y, w, h);
#endif

	getGeometryInfo (CXPNOTE_MODE, &xymode, &whmode, &x, &y, &w, &h);
	if (xymode == 0)	/* ΰ */
	{
		x = cxpnote->window->allocation.x;
		y = cxpnote->window->allocation.y;
	}
	if (whmode == 0)	/* Υ */
	{
		w = cxpnote->window->allocation.width;
		h = cxpnote->window->allocation.height;
	}
	setGeometryInfo (CXPNOTE_MODE, xymode, whmode, x, y, w, h);

	gtk_main_quit ();
}

static GList *extract_filenames (const gchar * str)
{
	GList *l;

	l = NULL;
	while (*str)
	{
		const gchar *ltop;

		while (isspace (*str))
			str++;
		ltop = str;
		while ((*str != 0) && (*str != '\n') && (*str != '\r'))
			str++;
		if ((str - ltop > 5) && (strncmp (ltop, "file:", 5) == 0))
		{
			ltop += 5;
			l = g_list_prepend (l, g_strndup (ltop, str - ltop));
		}
		while ((*str == '\n') || (*str == '\r'))
			str++;
	}
	return l;
}

static void cxpnote_dnd_received (GtkWidget * widget,
				  GdkDragContext * context, gint x, gint y,
				  GtkSelectionData * data, guint info,
				  guint time)
{
	gint succeed_to_open;
	GList *filenames, *p;

	if (data->length <= 0 || data->format != 8)
	{
		gtk_drag_finish (context, FALSE, FALSE, time);
	}
	else
	{
		filenames = extract_filenames ((gchar *) (data->data));
		if (filenames)
		{
			strncpy (cxpnote->filename, (gchar *) filenames->data,
				 sizeof (cxpnote->filename));
			gtk_text_freeze (GTK_TEXT (cxpnote->text));
			gtk_text_set_point (GTK_TEXT (cxpnote->text), 0);
			gtk_text_forward_delete (GTK_TEXT (cxpnote->text),
						 gtk_text_get_length (GTK_TEXT
								      (cxpnote->
								       text)));
			cxpnoteFileOpen ();
			gtk_text_set_point (GTK_TEXT (cxpnote->text), 0);
			gtk_text_thaw (GTK_TEXT (cxpnote->text));
		}
		g_list_foreach (filenames, (GFunc) g_free, NULL);
		g_list_free (filenames);
		gtk_drag_finish (context, TRUE, FALSE, time);
		return;
	}
}


void cxp_noteinit (filename)
     char *filename;
{
	FILE *fp;
	char workname[1024];
	GdkColormap *cmap;
	GdkColor colour;
	GdkFont *fixed_font;
	int x, y, w, h;
	int xymode, whmode;
	FILE *infile;
	static const GtkTargetEntry acceptable_types[] = {
		{"text/uri-list", 0, 0},
	};


	/* ưץμ */
	cxpnote->pid = getpid ();

	/* ưɣĤμ */
	cxpnote->uid = getuid ();
	cxpnote->gid = getgid ();

	/* ե饰 */
	cxpnote->color = colorFlag;

	/* ץ */
	cxpnote->option = largeFlag;

	/* ե̾¸ */
	strcpy (cxpnote->filename, filename);

	/* ١ɤ߹ */
	getBaseConfig (&cxpnote->base);

	/* եȾɤ߹ */
	getFontConfig (&cxpnote->fontInfo);

	/* μ */
	getStyleConfig (&(cxpnote->styleIndex), &(cxpnote->style));

	/* μ */
	getGeometryInfo (CXPNOTE_MODE, &xymode, &whmode, &x, &y, &w, &h);


	/* ᥤ󥦥ɥκ */
	cxpnote->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (cxpnote->window), "destroy",
			    GTK_SIGNAL_FUNC (exitfunc), NULL);

	/* GNOMEץ꤫Υɥåɥå by Masahiro Sakai(start) */
	gtk_drag_dest_set (cxpnote->window, GTK_DEST_DEFAULT_ALL,
			   acceptable_types,
			   sizeof (acceptable_types) /
			   sizeof (acceptable_types[0]), GDK_ACTION_COPY);
	gtk_signal_connect (GTK_OBJECT (cxpnote->window),
			    "drag_data_received",
			    GTK_SIGNAL_FUNC (cxpnote_dnd_received), NULL);
	/* GNOMEץ꤫Υɥåɥå  by Masahiro Sakai(end) */


	sprintf (workname, "Cxpnote [%s]", cxpnote->filename);
	gtk_window_set_title (GTK_WINDOW (cxpnote->window), workname);

	gtk_widget_set_usize (cxpnote->window, 400, 300);

	if ((xymode == 0) || (xymode == 1))
	{
		if (x != -1 && y != -1)
		{
			/* ΰ */
			if (x >= gdk_root_parent.width)
				x = gdk_root_parent.width / 2;
			if (y >= gdk_root_parent.height)
				y = gdk_root_parent.height / 2;

			gtk_widget_set_uposition (cxpnote->window, x, y);
		}
	}

	if ((whmode == 0) || (whmode == 1))
	{
		if (w != -1 && h != -1)
		{
			if (w >= gdk_root_parent.width)
				w = gdk_root_parent.width;
			if (h >= gdk_root_parent.height)
				h = gdk_root_parent.height;

			gtk_window_set_default_size (GTK_WINDOW
						     (cxpnote->window), w, h);
		}
	}

	if (cxpnote->option)
	{
		/* 粽 */
		gtk_window_set_default_size (GTK_WINDOW (cxpnote->window),
					     gdk_root_parent.width - 10,
					     gdk_root_parent.height - 50);
		gtk_widget_set_uposition (cxpnote->window, 0, 0);
	}
	gtk_window_set_policy (GTK_WINDOW (cxpnote->window), TRUE, TRUE,
			       FALSE);

#if 0
	gtk_signal_connect (GTK_OBJECT (cxpnote->window), "destroy",
			    GTK_SIGNAL_FUNC (cxpnote_closefunc), NULL);
#endif
	gtk_container_border_width (GTK_CONTAINER (cxpnote->window), 0);

	/* VBOX */
	cxpnote->vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (cxpnote->window), cxpnote->vbox);
	gtk_widget_show (cxpnote->vbox);

	/* ˥塼κ */
	cxpnote_menu_init ();

	/* ȥåץκ */
	cxpnote_topcmd_init ();

	/* ƥȤκ */
	cxpnote_text_init ();

#ifdef	DEBUG
	if (0)
	{
		int x;

		fprintf (stdout, " kensu -> [%d]\n", cxpnote->fontInfo.kensu);
		fflush (stdout);
		for (x = 0; x < cxpnote->fontInfo.kensu; x++)
		{
			fprintf (stdout, "fn[%d][%s]\n", x,
				 cxpnote->fontInfo.font[x].font_alpha);
			fprintf (stdout, "fn[%d][%s]\n", x,
				 cxpnote->fontInfo.font[x].font_kanji);
			fprintf (stdout, "fn[%d][%s]\n", x,
				 cxpnote->fontInfo.font[x].font_kana);
		}
	}
#endif

	/* եȤ */
	{
		char fontbuff[1025];

		if (cxpnote->fontInfo.kensu > 0)
		{
			cxpnote->fontIndex = 0;
			sprintf (fontbuff, "%s,%s,%s",
				 cxpnote->fontInfo.font[0].font_alpha,
				 cxpnote->fontInfo.font[0].font_kanji,
				 cxpnote->fontInfo.font[0].font_kana);
		}
		else
		{
			cxpnote->fontIndex = -1;
			sprintf (fontbuff, "%s,%s,%s",
				 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-iso8859-1",
				 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-jisx0208.1983-0",
				 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-jisx0201.1976-0");
		}
		cxpnote->font = gdk_fontset_load (fontbuff);
	}

	/* ƥȤɤ߹ */
	cxpnoteFileOpen ();

	gtk_widget_show (cxpnote->window);
}

void cxpnote_main (filename, argc, argv)
     char *filename;
     int argc;
     char *argv[];
{
	int npid;

#ifndef	DEBUG
	npid = fork ();
	if (npid == 0)
	{
#endif
		gtk_set_locale ();
		gtk_init (&argc, &argv);

		cxp_noteinit (filename);

		gtk_main ();
#ifndef	DEBUG
		exit (0);
	}
#endif
}

int main (int argc, char *argv[])
{
	int i;
	int filenum;
	char checkname[1024];

	CxpBasePathInit ();

	/* ޥ͡㵯ư */
	cxp_manager_start ();

	cxpnote = (CxpNote *) g_malloc (sizeof (CxpNote));

	if (!getcwd (cxpnote->pwdbuff, MAX_DIR_LENGTH))
		strcpy (cxpnote->pwdbuff, "/");

	filenum = 0;
	colorFlag = 0;
	largeFlag = 0;

	/* ե뤬ꤵƤ餽Υեɤ߹ */
	if (argc > 1)
	{
		for (i = 1; i < argc; i++)
		{
			if (strcmp (argv[i], "-color") == 0)
			{
				colorFlag = 1;
			}
			else if (strcmp (argv[i], "-big") == 0)
			{
				largeFlag = 1;
			}
			else
				filenum++;
		}
	}

	if (filenum >= 1)
	{
		for (i = 1; i < argc; i++)
		{
			if ((strcmp (argv[i], "-color") == 0)
			    || (strcmp (argv[i], "-big") == 0))
			{
				;
			}
			else
			{
				if (*argv[i] == '/')
					strcpy (checkname, argv[i]);
				else
				{
					if (strcmp (cxpnote->pwdbuff, "/") ==
					    0)
						sprintf (checkname, "%s%s",
							 cxpnote->pwdbuff,
							 argv[i]);
					else
						sprintf (checkname, "%s/%s",
							 cxpnote->pwdbuff,
							 argv[i]);
				}
				cxpnote_main (checkname, argc, argv);
			}
		}
	}
	else
	{
		/* ե */
		cxpnote_main ("NewFile", argc, argv);
	}

	exit (0);
}
