/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpNote *cxpnote;

extern void messageView ();

static void (*_local_function) ();

void messdialog_ok (GtkWidget * widget, gpointer data)
{
	gtk_grab_remove (widget);

	/* ؿ¹ */
	(*_local_function) ();

	/* ɥϥɤ */
	gtk_widget_hide (widget);
}

void messdialog_cancel (GtkWidget * widget, gpointer data)
{
	/* ɥϥɤ */
	gtk_grab_remove (widget);
	gtk_widget_hide (widget);
}

/* åɽ */
void messageView (title, ok, can, list1, list2, function)
     char *title;
     char *ok;
     char *can;
     char *list1;
     char *list2;
     void (*function) ();
{
	GtkWidget *dialog;
	GtkWidget *label[5];
	GtkWidget *button1;
	GtkWidget *button2;
	int x, y, w, h;

	gdk_window_get_origin (cxpnote->window->window, &x, &y);
	gdk_window_get_size (cxpnote->window->window, &w, &h);

	dialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (dialog), title);

	gtk_widget_set_usize (dialog, 300, 140);
	gtk_widget_set_uposition (dialog, (x + (w / 2)) - (300 / 2),
				  (y + (h / 2)) - (100 / 2));
	gtk_grab_add (dialog);
	gtk_widget_show (dialog);


	if (strlen (list2) > 0)
	{
		label[0] = gtk_label_new (list1);
		gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
				    label[0], TRUE, TRUE, 10);
		gtk_widget_show (label[0]);

		label[1] = gtk_label_new (list2);
		gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
				    label[1], TRUE, TRUE, 0);
		gtk_widget_show (label[1]);

	}
	else
	{

		label[0] = gtk_label_new (list1);
		gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
				    label[0], TRUE, TRUE, 20);
		gtk_widget_show (label[0]);
	}

	if (strlen (ok) > 0)
	{
		button1 = gtk_button_new_with_label (ok);
		gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
					   (GtkSignalFunc) messdialog_ok,
					   GTK_OBJECT (dialog));

		_local_function = function;

		gtk_box_pack_start (GTK_BOX
				    (GTK_DIALOG (dialog)->action_area),
				    button1, FALSE, TRUE, 20);
		gtk_widget_show (button1);
	}

	button2 = gtk_button_new_with_label (can);
	gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
				   (GtkSignalFunc) messdialog_cancel,
				   GTK_OBJECT (dialog));
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
			    button2, FALSE, TRUE, 20);
	gtk_widget_show (button2);

}
